Ext.define("AggregateAddAllComponentsp.view.FormPanel", {
	extend: "utilities.innerScrollContainer",
	alias: "widget.formPanel",
	id: "formpanel",
	requires:['utilities.CustomGrid'],
	title:titleText,
	margin: '10 10 10 0',
	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id:'resultGrid',
			hidden:true,
			margin: 10,
			flex:0.5,
			title:added_comp_title,
			store:Ext.create('Ext.data.Store',{
				fields:['componentType', 'nickname'],
				data:[]
			}),
			autoScroll: true,
			scroll: true,
			columns:[
				{
					text: aggreagate_component_type,
					flex: 1,
					sortable:false,
					draggable : false,
					menuDisabled : true,
					dataIndex: 'componentType'
				},
				{
					text: nick_name,
					flex: 1,
					sortable:false,
					draggable : false,
					menuDisabled : true,
					dataIndex: 'nickname'
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id:'erro_resultGrid',
			flex:0.5,
			title:not_added_comp_title,
			hidden:true,
			margin: 10,
			autoScroll: true,
			scroll: true,
			store:Ext.create('Ext.data.Store',{
				fields:['component', 'Error'],
				data:[]
			}),
			columns:[
				{
					header: component_name,
					flex: 1,
					sortable:false,
					draggable : false,
					menuDisabled : true,
					dataIndex: 'component',
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdCls += 'x-grid-cell-row-checker';
						return value;
					}
				},
				{
					header: error_description,
					flex: 1,
					sortable:false,
					draggable : false,
					menuDisabled : true,
					dataIndex: 'Error',
					renderer : function(val)
					{
						var value="";
						var sub="";
						var temp="";
						var
						value =val.substring(0,73)+"<br>"
						sub= val.substring(73,150)+"<br>";
						temp= val.substring(150);
						value += sub;
						value+=temp;
						return value;
					}
				}
			]
		},
		{
			xtype: 'container',
			id:'errorMessage_container',
			hidden: true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 15,
			items: [
				{
					xtype: 'label',
					name:'errorMessage',
					id:'errorMessage',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">Some errors.</div></td></tr></table></td></tr></table>'
				}
			]
		}
	],

	tools : [
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'backbutton',
			iconCls:'iconBack',
			text :Back
		}
	]
});



