Ext.define('AggregateComponent.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Components','TestMeasures'],
	requires:['AggregateComponent.view.Components','AggregateComponent.view.TestMeasures'],
	refs:[
		{selector:'components', ref:'components'},
		{selector:'components #backButton', ref:'backbutton'},
		{selector:'components #homeBack', ref:'homeBack'},
		{selector:'testmeasures', ref:'testmeasures'}
	],
	init:function(){
		ctrler = this;

		this.rowBodyTrSelector = '.x-grid-rowbody-tr';
		this.rowBodyHiddenCls = 'x-grid-row-body-hidden';
		this.rowCollapsedCls = 'x-grid-row-collapsed';
		this.recordsExpanded = {};
		this.isViewExpaned = false;
		this.isViewExpaned2 = false;

		this.buildMainData()
		this.control({
			'components':
			{
				'afterrender': this.afterMainRender
			},
			'components combo[id="category"]':
			{
				'select':this.categorySelection
			},
			'components combo[id="compTypes"]':
			{
				'select':this.compTypeSelection
			},
			'components checkbox[id="activeCompType"]':
			{
				'change':this.showActiveCompTypes
			},
			//'components [id="componentListGrid"]':
			//{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			//},
			'components trigger[id="searchBox"]':
			{
				'change': this.searchComponent
			},
			'components button[id="addNewButton"]':
			{
				'click':this.addNewComponent
			},
			'changeip button[id="backButton"]':
			{
				'click':this.goBack
			},
			'components button[id="showAll"]':
			{
				'click':this.showAllPreUsers
			},
			'components button[id="testsAndMeasures"]':
			{
				'click':this.showTestsAndMeasures
			},
			'testmeasures button[id="showAll_popup"]':
			{
				'click':this.showHideMeasures
			},
			'components #backButton':
			{
				'click': this.forwardURI
			},
			'components #homeBack':
			{
				'click': this.homeBack
			}
		});
	},
	showTestsAndMeasures : function(obj)
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : publicJsonCopy.popupTitle,
			id:'userElementsWindow',
			width: 750,
			scroll:false,
			autoScroll:false,
			height: 400,
			padding:'5 10 10 10',
			border : false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					me.updateTestMeasuresPopup();
				}
			}
		}).show();
	},
	forwardURI : function()
	{
		var requestURI = window.parent.reqfrom;
		var username = window.parent.username;
		if (requestURI != undefined && requestURI == 'modifyuser')
		{
			if (username != null && username != undefined)
			{
				window.parent.location.href = "/final/admin/EgChangeUserProfile.jsp?qctr=1&username="+encodeURIComponent(username);
			}
			else
			{
				window.parent.location.href = "/final/admin/EgChangeUserProfile.jsp";
			}
		}
	},
	updateTestMeasuresPopup : function()
	{
		var testMeasuresPopupContainerObj = Ext.getCmp('userElementsWindow');
		testMeasuresPopupContainerObj.removeAll();
		if (publicJsonCopy.compTypeSelected)
		{
			testMeasuresPopupContainerObj.add({xtype : 'testmeasures'});
			Ext.getCmp('measuresGrid').getStore().loadRawData(publicJsonCopy.measuresGridDataList);
			Ext.getCmp('testmeasures').setTitle(publicJsonCopy.popupTitle);
			Ext.getCmp('totalAggTests').update('<span class="font_bold">&nbsp;'+publicJsonCopy.totalAggTests+'</span>');
			//Ext.getCmp('totalAggTests').setFieldLabel(publicJsonCopy.totalAggTests);

		}
		else
		{
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>"+intnlLabel5+"</div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 130,
				style:{'text-align':'center'},
				html : message
			}
			testMeasuresPopupContainerObj.add(tmpPanel);
		}
	},
	showHideMeasures : function(obj)
	{
		var thisGrid = Ext.getCmp('measuresGrid').getStore();
		if (obj.status == 'hidden')
		{
			obj.status = 'shown';
			obj.setText(intnlLabel13);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.expandRow(i,Ext.getCmp('measuresGrid'));
			}
		}
		else
		{
			obj.status = 'hidden';
			obj.setText(intnlLabel12);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('measuresGrid'));
			}
		}
		this.getTestmeasures().doLayout();
	},
	showAllPreUsers : function(obj)
	{
		var thisGrid = Ext.getCmp('componentListGrid').getStore();
		if (obj.status == 'hidden')
		{
			obj.status = 'shown';
			obj.setText(intnlLabel11);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.expandRow(i,Ext.getCmp('componentListGrid'));
			}
		}
		else
		{
			obj.status = 'hidden';
			obj.setText(intnlLabel10);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('componentListGrid'));
			}
		}
		this.getComponents().doLayout();
	},
	expandRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (row.hasCls(this.rowCollapsedCls)) {
			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = true;
			thisGrid.view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},
	collapseRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (!row.hasCls(this.rowCollapsedCls)) {
			row.addCls(this.rowCollapsedCls);
			nextBd.addCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = false;
			thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
		}
	},
	nickTable : function(value)
	{
		var nickArray = value.split(',');
		var htmlTable = "<table border='1' bordercolor='#E6EBF5' cellpadding='1' >";
		for (var i = 0 ;i < nickArray.length;i++)
		{
			htmlTable = htmlTable + "<tr><td height='20' width='500'>"+nickArray[i] +"</td></tr>";
		}
		htmlTable = htmlTable + "</table>";
		return htmlTable;
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'AggregateComponent/data/EgDispServerJson.jsp?',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		Ext.getCmp('category').getStore().clearFilter(true);
		Ext.getCmp('category').getStore().loadRawData(publicJSON['category']);
		Ext.getCmp('category').setValue(publicJSON['selectedServerGroup']);
		Ext.getCmp('compTypes').getStore().clearFilter(true);
		Ext.getCmp('compTypes').getStore().loadRawData(publicJSON['componentTypes']);
		Ext.getCmp('compTypes').setValue(publicJSON['selectedCompType']);
		Ext.getCmp('activeCompType').setValue(publicJSON['showManagedCompTypes']);
		Ext.getCmp('componentListGrid').hide();
		//Ext.getCmp('noCompsAlert').hide();
		//Ext.getCmp('selectCompTypeAlert').hide();
		/*if(publicJSON.showOraclAlert)
		{
			Ext.getCmp('oraNoSidAlert').show();
			Ext.getCmp('oraNoSidInfo').show();
			Ext.getCmp('oraNoSidInfo').getStore().loadRawData(publicJSON.oraGridData);
		}*/
		this.loadComps(categoryChosen,compTypeChosen);
		var requestURI = window.parent.reqfrom;
		if (requestURI != undefined && requestURI == 'modifyuser')
		{
			this.getBackbutton().show();
		}
		else
		{
			this.getBackbutton().hide();
			if(showOverviewBackButton=='true')
			{
				Ext.getCmp('homeBack').show();
			}
			else
			{
				Ext.getCmp('homeBack').hide();
			}
		}
	},
	loadComps: function(selectedCategory,selectedCType)
	{
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		Ext.getCmp('category').setValue(selectedCategory);
		Ext.getCmp('compTypes').setValue(selectedCType);
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType;
		this.getData(url);
		publicJsonCopy = jsonDataHolder;
		var serversFound = jsonDataHolder.serversFound;
		var gridObj = Ext.getCmp('componentListGrid');
		if(serversFound)
		{
			gridObj.show();
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
		}
		else
		{
			gridObj.getStore().removeAll();
			Ext.get('noCompAlrtDiv').update(srcNotFnd);
		}
		if (selectedCType != '-1')
		{
			Ext.getCmp('searchBox').enable();
			Ext.getCmp('testsAndMeasures').enable();
			Ext.getCmp('showAll').enable();
		}
		else
		{
			Ext.getCmp('searchBox').disable();
			Ext.getCmp('testsAndMeasures').disable();
			Ext.getCmp('showAll').disable();
		}
	},
	categorySelection : function()
	{
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?selectedServerGroup='+selectedCategory+'&activeCompTypes='+activeCType;//+'&server='+selectedCType;
		this.getData(url);
		var comboObj = Ext.getCmp('compTypes').getStore();
		comboObj.removeAll();
		comboObj.clearFilter(true);
		comboObj.loadRawData(jsonDataHolder.componentTypes);
		Ext.getCmp('compTypes').setValue("-1");
		var gridObj = Ext.getCmp('componentListGrid');
		gridObj.getStore().removeAll();
		gridObj.hide();
	},
	compTypeSelection : function()
	{
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		var gridObj = Ext.getCmp('componentListGrid');
		if (selectedCType == '-1')
		{
			gridObj.hide();
			return false;
		}

		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType;
		this.getData(url);
		publicJsonCopy = jsonDataHolder;
		var serversFound = jsonDataHolder.serversFound;
		gridObj.show();
		if(serversFound)
		{
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
			Ext.getCmp('showAll').enable();
		}
		else
		{
			gridObj.getStore().removeAll();
			Ext.getCmp('showAll').disable();
		}
		if (selectedCType != '-1')
		{
			Ext.getCmp('searchBox').enable();
			Ext.getCmp('testsAndMeasures').enable();
		}
		else
		{
			Ext.getCmp('searchBox').disable();
			Ext.getCmp('testsAndMeasures').disable();
		}
	},
	showActiveCompTypes : function()
	{
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCType;
		this.getData(url);
		var comboObj = Ext.getCmp('compTypes').getStore();
		comboObj.removeAll();
		comboObj.clearFilter(true);
		comboObj.loadRawData(jsonDataHolder.componentTypes);
		Ext.getCmp('compTypes').setValue(jsonDataHolder.selectedCompType);

		var comboObj2 = Ext.getCmp('category').getStore();
		comboObj2.removeAll();
		comboObj2.clearFilter(true);
		comboObj2.loadRawData(jsonDataHolder.category);
		Ext.getCmp('category').setValue(jsonDataHolder.selectedServerGroup);

		var serversFound = jsonDataHolder.serversFound;
		var gridObj = Ext.getCmp('componentListGrid');
		if(serversFound)
		{
			gridObj.show();
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
		}
		else
		{
			gridObj.getStore().removeAll();
			gridObj.hide();
		}
	},
	searchComponent : function()
	{
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCType;
		if (searchStr != '')
		{
			url+='&searchStr='+searchStr;
		}
		if (searchStr == "" || searchStr .length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		this.getData(url);
		var serversFound = jsonDataHolder.serversFound;
		var gridObj = Ext.getCmp('componentListGrid');
		if(serversFound)
		{
			gridObj.show();
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
			Ext.getCmp('showAll').enable();
		}
		else
		{
			gridObj.getStore().removeAll();
			Ext.get('noCompAlrtDiv').update(srcNotFnd);
			Ext.getCmp('showAll').disable();
		}
	},
	getData: function(urlStr)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	modifyComponent: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		var url = "aggNewServer.jsp?isAggregateLink=false&server="+compName+"&serverType="+selectedCType+"&modifyserver=true&siteSupport=false&treeViewSrc=null&serverGategory="+selectedCategory+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType+'&reqfrom='+reqfrom;
		window.location.href = url;
	},
	unmanageComponent: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		parent.window.location.href = "/final/admin/aggConfigEnv.jsp?srvtype="+selectedCType+"&component="+compName+"&backButNeed=yes&reqfrom=EgDispServer&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
	},
	deleteComponent: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		parent.window.location.href = "/final/admin/aggConfigEnv.jsp?srvtype="+selectedCType+"&component="+compName+"&backButNeed=yes&reqfrom=EgDispServer&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
	},
	addNewComponent: function()
	{
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		if (selectedCType == '-1')
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : alertMsg36,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var url = "/final/admin/aggNewServer.jsp?server=new&serverType="+selectedCType+"&from=addnew&isAggregateLink=false&treeViewSrc=null&serverGategory="+selectedCategory+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType+'&reqfrom='+reqfrom;
		window.location.href = url;
	},
	homeBack: function()
	{
		parent.window.location.href = "/final/admin/EgAdminOperations.jsp?fromWizard="+fromWizard;
	},
	goBack: function()
	{
		this.goBackFromIPChange(jsonDataHolder.hiddenVals.selCategory,jsonDataHolder.hiddenVals.servertype);
	},
	goBackFromIPChange : function(selectedCategory, selectedCType)
	{
		var viewportObj = Ext.getCmp('componentview');
		viewportObj.removeAll();
		viewportObj.add({
			xtype : 'components'
		});

		if (selectedCategory == null || selectedCategory == '')
		{
			selectedCategory = "-1";
		}
		if (selectedCType == null || selectedCType == '')
		{
			selectedCType = "-1";
		}
		Ext.getCmp('category').setValue(selectedCategory);
		Ext.getCmp('compTypes').setValue(selectedCType);
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var url = 'AggregateComponent/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType;
		this.getData(url);
		var serversFound = jsonDataHolder.serversFound;
		var gridObj = Ext.getCmp('componentListGrid');
		if(serversFound)
		{
			gridObj.show();
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
		}
		else
		{
			gridObj.getStore().removeAll();
			Ext.get('noCompAlrtDiv').update(srcNotFnd);
		}
		if (selectedCType != '-1')
		{
			Ext.getCmp('searchBox').enable();
			Ext.getCmp('testsAndMeasures').enable();
		}
		else
		{
			Ext.getCmp('searchBox').disable();
			Ext.getCmp('testsAndMeasures').disable();
		}
	}
});



