Ext.define('AggregateComponent.view.Components', {
	extend: 'Ext.form.Panel',
	alias: 'widget.components',
	id: 'components',

	ui:'simplePanel simplePanelHeaderBorder',

	//cls:'outerpanel',
	margin :'8 8 0 0',
	//frame:true,
	title: homeTitle,
	//header:{cls:'textUpper'},

	requires: [
		'Ext.ux.RowExpander',
		'Ext.grid.*'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools:[
		{
			xtype:'button',
			id : 'backButton',
			text: label_Back,
			cls:'backbutton',
			iconCls:'iconBack',
			hidden:true
		},
		{
			xtype : 'button',
			text : label_Back,
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'homeBack',
			hidden : true
		}
	],

	/*dockedItems:[
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDesc+'.</center>',
				}
			]
		}
	],*/

	items: [
		{
			xtype: 'container',
			layout: 'hbox',
			margin: '5 10 5 5',
			items:[
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'button',
					id:'addNewButton',
					cls:'button20',
					text: addButtonText
				}
			]
		},
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			items:[
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				padding:10,
				cls:'formOuter',
				margin: '10 10 10 10',
				items: [
					{
						xtype: 'scrollcombo',
						fieldLabel: label_Category,
						labelAlign: 'top',
						labelSeparator: ' ',
						width: 200,
						cls:'dropdown',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						id:'category',
						name:'category',
						//editable:false
					},
					{
						xtype: 'scrollcombo',
						fieldLabel: label_CompTyep,
						labelAlign: 'top',
						labelSeparator: ' ',
						width: 250,
						cls:'dropdown',
						margin: '0 0 0 20',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						id:'compTypes',
						name:'compTypes',
						//editable:false
					},
					{
						xtype: 'checkbox',
						boxLabel: label_ShowCompTypeOnly,
						checked: false,
						cls:'checkbt',
						id:'activeCompType',
						margin: '20 0 0 20'
					}
				]
			}]
		},
		{
			xtype: 'customgrid',
			id:'componentListGrid',
			store: new Ext.data.Store({
				fields: ['Compname', 'HostIP', 'Monitoring'],
				data : []
			}),
			cls:'gridSkin',
			autoScroll: true,
			scroll: true,
			flex: 1,
			plugins: [
				{
					ptype: 'rowexpander',
					rowBodyTpl: [
						'<div style:"width:80%">{HostIP}</div>'
					]
				}
			],
			tbar: [
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					id:'searchBox',
					cls:'whitedropdown_search',
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						ctrler.searchComponent();
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					disabled: true
				},
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
						{
							xtype: 'button',
							id:'testsAndMeasures',
							cls:'button20',
							text: testsAndMeasures,
							disabled: true
						},
						{
							xtype: 'button',
							text: intnlLabel10,
							isModified : 'false',
							cls:'button20',
							id: 'showAll',
							status : 'hidden'
						}
					]
				}
			],
			emptyText: LoadAlert1,
			viewConfig: {
				deferEmptyText: false
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: label_Component,
						dataIndex: 'Compname',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconModify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.modifyComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconUnmanage',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.unmanageComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Unmanage' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconDelete',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.deleteComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			margin: 10
		}
	],
	listeners: {
		close: function() 
		{
			if (!Ext.isEmpty(compGlanceCompType))
			{
				window.parent.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+compGlanceCompType;
			}
			else
			{
				window.parent.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
			}
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDesc+'.',
				cls: "adminInfoTooltip"
			});
		}
	}

});



