Ext.define('AggregateDisplayTests.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormItems'],
	refs:[
		{selector:'FormItems', ref:'FormItems'},
	],
	init:function(){
		appCtn = this;
		this.control({
			'displayaggtests':
			{
				'afterrender': this.afterMainRender
			},
			'displayaggtests button[id="addnewtest"]':
			{
				'click': this.addNewTest
			},
			'displayaggtests [name="searchbox"]':
			{
				'change': this.egTitleSearch
			}
		});
	},
	afterMainRender : function()
	{
		Ext.Ajax.request({
			url : '/final/admin/AggregateDisplayTests/data/aggDisplayTestsJson.jsp?'+queryString,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if(publicJSON['gridheader'] != null && publicJSON['gridheader'] != 'undefined')
				{
					Ext.getCmp("searchbox").show();
					//Ext.getCmp("notestspanel").hide();
					Ext.getCmp("test_name_grid").show();
					Ext.getCmp('test_name_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
					Ext.getCmp("searchbox").setDisabled(false);
				}
				else
				{
					Ext.getCmp("test_name_grid").show();
					//Ext.getCmp("notestspanel").show();
					Ext.getCmp('test_name_grid').getStore().removeAll();
					//Ext.get('noCompAlrtDiv').update(srcNotFnd);
					//Ext.getCmp('showAll').disable();
				}
			},
			failure : function(response)
			{
				Ext.Msg.alert(pageTitle,failed_to_load);
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	addNewTest: function()
	{
		window.location.href="/final/admin/aggAddTest.jsp?showBackButton=true&operation=addMeasures";
	},
	getAssociatedServersForAggTest : function(aggtest)
	{
		window.location.href="/final/admin/aggShowComponentTypes.jsp?fromPage=aggDisplayTests&agg_test_name="+aggtest;
	},
	modifyAggTest : function(s_test)
	{
		window.location.href="/final/admin/aggAddTest.jsp?showBackButton=true&operation=modifyMeasures&aggtest="+s_test;
	},
	deleteAggTest : function(test,displayname)
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: delete_test_alert+displayname+'?',
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(buttonText) {
				if(buttonText == "yes")
				{
					var homepage = Ext.getCmp('viewPortId');
					myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					myMask.show();
					window.location.href="/final/admin/aggDeleteTest.jsp?test="+test;
				}
				else if(buttonText=="no"){}
			}
		});
	},
	egTitleSearch : function()
	{
		var thisURL = '';
		var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
		if(egTitleSearchStr==null || egTitleSearchStr=="")
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
			thisURL = '/final/admin/AggregateDisplayTests/data/aggDisplayTestsJson.jsp';
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
			thisURL = '/final/admin/AggregateDisplayTests/data/aggDisplayTestsJson.jsp?egTitleSearchStr='+encodeURI(egTitleSearchStr);
		}
		Ext.Ajax.request({
			url : thisURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if(publicJSON['gridheader'] != null && publicJSON['gridheader'] != 'undefined')
				{
					Ext.getCmp("searchbox").show();
					//Ext.getCmp("notestspanel").hide();
					Ext.getCmp("test_name_grid").show();
					Ext.getCmp('test_name_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
					Ext.getCmp("test_name_grid").show();
					//Ext.getCmp("notestspanel").hide();
				}
				else
				{
					/*Ext.getCmp("notestspanel").update("<div style='margin:20% auto auto auto'><table border='0' width='100%'><tr><td align='center' valign='middle'><div class='iconExclamation'></div><div class='commonErrorMsgText'>"+publicJSON['message']['text']+"</div></td></tr></table></div>");
					Ext.getCmp("notestspanel").show();
					Ext.getCmp("test_name_grid").hide();*/

					Ext.getCmp('test_name_grid').getStore().removeAll();
					Ext.get('noCompAlrtDiv').update(srcNotFnd);
				}
			},
			failure : function(response)
			{
				Ext.Msg.alert(pageTitle,failed_to_load);
			}
		});
	}
});