Ext.define('AggregateDisplayTests.view.FormItems', {
	//extend:'Ext.form.Panel',
	extend:'utilities.innerScrollContainer',
	alias:'widget.displayaggtests',
	id: 'formitems',
	cls:'outerpanel',
	margin :'8 8 0 8',
	title: pageTitle,
	header:{cls:'textUpper'},

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	dockedItems:[
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDescc+'.'+'</center>'
				}
			]
		}
	],

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id:"test_name_grid",
			hidden:true,
			margin: 10,
			flex: 1,
			autoScroll: true,
			store:Ext.create('Ext.data.Store',{
				fields:['agg_test_name','hidden_agg_test_name'],
				data:[]
			}),
			emptyText: LoadAlert1,
			viewConfig: {
				deferEmptyText: false
			},
			columns: {
				defaults:
				{
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: grid_column_name,
						dataIndex: 'agg_test_name',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						id: 'AssociateOver',
						iconCls:'iconAddServer',
						sortable: false,
						border:false,
						handler: function(grid, rowIndex, colIndex) {
							var rec = grid.getStore().getAt(rowIndex);
							appCtn.getAssociatedServersForAggTest(rec.get('hidden_agg_test_name'));
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Associated Servers' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						id: 'EditOver',
						iconCls:'iconModify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var rec = grid.getStore().getAt(rowIndex);
							appCtn.modifyAggTest(rec.get('hidden_agg_test_name'));
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						id: 'DeleteOver',
						iconCls: 'iconDelete',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var rec = grid.getStore().getAt(rowIndex);
							appCtn.deleteAggTest(rec.get('hidden_agg_test_name'),rec.get('agg_test_name'));
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					name:'searchbox',
					id:'searchbox',
					hidden:true,
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						appCnt.egTitleSearch();
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					disabled: true,
					cls:'whitedropdown_search'
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							text: add_new_agg_test,
							name:'addnewtest',
							id:'addnewtest',
							cls:'button20'
						}
					]
				}
			]
		}
	]

});



