Ext.define('AggregateInfraComponents.view.Main',{
	//extend:'Ext.form.Panel',
	extend:'utilities.innerScrollContainer',
	alias:'widget.main',
	layout:'auto',
	cls: 'outerpanel',
	margin:'8 8 0 8',
	title : pageTitle,

	requires : [
		'AggregateInfraComponents.view.ComponentNameSummary',
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	tools:[
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [{
				xtype: 'button',
				iconCls: 'iconPdf',
				id: 'save',
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
					afterrender:function(){
						Ext.create("Ext.tip.ToolTip",{
							target:this.id,
							anchor:"top",
							cls:"yellowTip",
							trackMouse:true,
							html:"Save"
						});
					}
				}
			}]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [{
				xtype: 'button',
				iconCls: 'iconPrinter',
				id: 'print',
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
					afterrender:function(){
						Ext.create("Ext.tip.ToolTip",{
							target:this.id,
							anchor:"top",
							cls:"yellowTip",
							trackMouse:true,
							html:"Print"
						});
					}
				}
			}]
		},
		{xtype:'tbseparator'},
		{
			xtype:'container',
			margin:'0 1px 0 1px',
			items:[
				{
					xtype:'button',
					id: 'saveCSV',
					iconCls:'iconCsv',
					style:{
						background:'none',border:'0px'
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"CSV"
							});
						}
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype : 'button',
			text : backText,
			id : 'eGBackURI',
			cls:'backbutton',
			iconCls:'iconBack'
		}
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems:[
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDiscription+'.</center>'
			}
		]
	}],

	items:[
		{
			xtype:'container',
			id : 'componentControls',
			layout : {
				type : 'hbox',
				pack : 'center',
			},
			margin: 10,
			defaults : {
				labelAlign: 'top',
				labelSeparator: ' ',
			},
			items : [
				{
					xtype: 'displayfield',
					fieldLabel:intnlLabel1,
					value: ea_criteriaTmp,
					width: 80,
				},
				{
					xtype:'scrollcombo',
					id: 'componentType',
					name: 'componentType',
					cls: 'dropdown',
					editable : false,
					fieldLabel :intnlLabel4,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					width: 250,
					margin : '0 0 0 20'
				},
			]
		},
		{
			xtype : 'componentnamesummary',
			margin : 10,
			flex: 1
		}
	]
})



