Ext.define('AggregateItInfrastructure.controller.Main',{
	extend: 'Ext.app.Controller',
	views:[	
			'Main',
			'ComponentGroupedSummaryGrid',
			'ComponentNameSummary',
			'ComponentTypeGroupedSummary',
			'ResultPanel',
			'Print',
			'EgInfraDownloader'
	],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'componentgroupedsummarygrid', ref:'componentgroupedsummarygrid'},
	],
	init:function()
	{
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.initInfraStructureView
			},
			'main combo[id="ea_criteria"]':
			{
				'select':this.viewOnChange
			},
			'main combo[id="viewAs"]':
			{
				'select':this.groupOnChange
			},
			'main combo[id="ea_userOption"]':
			{
				'select':this.userOptionOnchange
			},
			'main button[id="print"]':
			{
				'click': this.printPage
			},
			'main button[id="save"]':
			{
				'click': this.savePdf
			},
			'main button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			}
		})
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	printPage : function()
	{
		var printPage = "/final/admin/aggComponentDetailsPrint.jsp?showOnly=aggregate&print=printpage";
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	saveInCSVFormat : function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+user_language;
	},
	savePdf : function()
	{
		var getSaveObj = Ext.widget('savepdf');
		getSaveObj.savePDF(pdfURLString);
	},
	userOptionOnchange : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue();
		var ea_criteria = Ext.getCmp('ea_criteria').getValue();
		var viewAsSelected = Ext.getCmp('viewAs').getValue();
		var tmpURI = "AggregateItInfrastructure/data/EgItInfrastructureJson.jsp?showOnly=aggregate&ea_criteria="+ea_criteria+"&viewAs="+viewAsSelected+"&ea_userOption="+selectedValue;
		me.updateInfraData(tmpURI);
		if (viewAsSelected == "categoryWise")
		{
			me.showGroupedComponentSummary();
		}
		else if (viewAsSelected == "componentNameWise")
		{
			me.showComponentSummary();
		}
		else
		{
			me.showComponentTypeSummary();
		}
	},
	viewOnChange : function(obj)
	{
		var showResultGrid = false;
		var me = this;
		var selectedValue = obj.getValue();
		var ea_userOptionObj = Ext.getCmp('ea_userOption');
		var viewAsSelected = Ext.getCmp('viewAs').getValue();
		var tmpURI = "AggregateItInfrastructure/data/EgItInfrastructureJson.jsp?showOnly=aggregate&";
		if (selectedValue.toLowerCase() != "component")
		{
			tmpURI = tmpURI +"ea_criteria="+selectedValue+"&viewAs="+viewAsSelected;
			me.updateInfraData(tmpURI);
			var  ea_userOption = publicJSON['ea_userOption'];
			var  selectedEAUserDisplay = publicJSON['selectedEAUserDisplay'];
			var  selectedEAUserOption = publicJSON['selectedEAUserOption'];
			var  isServiceEnabled = publicJSON['isServiceEnabled'];
			var  isSegmentEnabled = publicJSON['isSegmentEnabled'];
			ea_userOptionObj.getStore().loadRawData(ea_userOption);
			ea_userOptionObj.setValue(selectedEAUserOption);
			ea_userOptionObj.show();
			showResultGrid = true;
			Ext.getCmp('viewAs').show();
			ea_userOptionObj.setFieldLabel(selectedEAUserDisplay);
			if (selectedValue.toLowerCase() == "service")
			{
				if (isServiceEnabled == false)
				{
					showResultGrid = false;
					var  Service = publicJSON['Service'];
					Ext.getCmp('viewAs').hide();
					var infraContainerObj = Ext.getCmp('infraContainer');
					infraContainerObj.removeAll();
					var emptyResultPanel = {
						xtype:'component',
						border :  false,
						style:{'text-align':'center'},
						padding : 160,
						html: '<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">'+Service+'</div><div>'
					};
					infraContainerObj.add(emptyResultPanel);
					this.getMain().doLayout();
				}
			}
			else if (selectedValue.toLowerCase() == "segment")
			{
				if (isSegmentEnabled == false)
				{
					showResultGrid = false;
					var  Segment = publicJSON['Segment'];
					Ext.getCmp('viewAs').hide();
					var infraContainerObj = Ext.getCmp('infraContainer');
					infraContainerObj.removeAll();
					var emptyResultPanel = {
						xtype:'component',
						border : false,
						style:{'text-align':'center'},
						padding : 160,
						html: '<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">'+Segment+'</div>'
					};
					infraContainerObj.add(emptyResultPanel);
					this.getMain().doLayout();
				}
			}
		}
		else
		{
			Ext.getCmp('viewAs').show();
			ea_userOptionObj.hide();
			tmpURI = tmpURI +"ea_criteria="+selectedValue+"&viewAs="+viewAsSelected;
			me.updateInfraData(tmpURI);
			showResultGrid = true;
		}

		if (showResultGrid == true)
		{
			if (viewAsSelected == "categoryWise")
			{
				me.enableInfrastructureTools(false,false,true);
				me.showGroupedComponentSummary();
			}
			else if (viewAsSelected == "componentNameWise")
			{
				me.enableInfrastructureTools(false,false,false);
				me.showComponentSummary();
			}
			else
			{
				me.enableInfrastructureTools(false,false,true);
				me.showComponentTypeSummary();
			}
		}
		else
		{
			me.disableAllTools();
		}
	},
	groupOnChange : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue();
		var ea_criteria = Ext.getCmp('ea_criteria').getValue();
		var saveCSVObj = Ext.getCmp('saveCSV');
		var tmpURI = "AggregateItInfrastructure/data/EgItInfrastructureJson.jsp?ea_criteria="+ea_criteria+"&viewAs="+selectedValue+"&date="+new Date().getTime();
		if (selectedValue == "categoryWise")
		{
			me.updateInfraData(tmpURI);
			me.showGroupedComponentSummary();
			me.enableInfrastructureTools(false,false,true);
		}
		else if (selectedValue == "componentNameWise")
		{
			me.updateInfraData(tmpURI);
			me.showComponentSummary();
			me.enableInfrastructureTools(false,false,false);
		}
		else
		{
			me.updateInfraData(tmpURI);
			me.showComponentTypeSummary();
			me.enableInfrastructureTools(false,false,true);
		}
	},
	initInfraStructureView: function()
	{
		var showResultGrid = true;
		var me = this;
		var viewControlsObj = Ext.getCmp('viewControls');
		var categoryWiseGrid = publicJSON['categoryWise'];
		var hasManagedComponents = publicJSON['hasManagedComponents'];
		if (hasManagedComponents == true)
		{
			viewControlsObj.show();
			var  ea_criteria = publicJSON['ea_criteria'];
			var  selectedEACriteria = publicJSON['selectedEACriteria'];
			var  viewAs = publicJSON['viewAs'];
			var  categorySelected = publicJSON['categorySelected'];
			var ea_criteriaObj = Ext.getCmp('ea_criteria');
			var ea_userOptionObj = Ext.getCmp('ea_userOption');
			var viewAsObj = Ext.getCmp('viewAs');
			ea_criteriaObj.getStore().loadRawData(ea_criteria);
			ea_criteriaObj.setValue(selectedEACriteria);
			viewAsObj.getStore().loadRawData(viewAs);
			viewAsObj.setValue(categorySelected);
			viewAsObj.show();
			if (selectedEACriteria.toLowerCase() != "component")
			{
				var  ea_userOption = publicJSON['ea_userOption'];
				var  selectedEAUserOption = publicJSON['selectedEAUserOption'];
				var  selectedEAUserDisplay = publicJSON['selectedEAUserDisplay'];
				ea_userOptionObj.show();
				ea_userOptionObj.setFieldLabel(selectedEAUserDisplay);
				ea_userOptionObj.getStore().loadRawData(ea_userOption);
				ea_userOptionObj.setValue(selectedEAUserOption);
				var  isServiceEnabled = publicJSON['isServiceEnabled'];
				var  isSegmentEnabled = publicJSON['isSegmentEnabled'];
				if (selectedEACriteria.toLowerCase() == "service")
				{
					if (isServiceEnabled == false)
					{
						showResultGrid = false;
						var  Service = publicJSON['Service'];
						Ext.getCmp('viewAs').hide();
						var infraContainerObj = Ext.getCmp('infraContainer');
						infraContainerObj.removeAll();
						var emptyResultPanel = {
							xtype:'component',
							border : false,
							style:{'text-align':'center'},
							padding : 160,
							html: '<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">'+Service+'</div><div>'
						};
						infraContainerObj.add(emptyResultPanel);
						this.getMain().doLayout();
					}
				}
				else if (selectedEACriteria.toLowerCase() == "segment")
				{
					if (isSegmentEnabled == false)
					{
						showResultGrid = false;
						var  Segment = publicJSON['Segment'];
						Ext.getCmp('viewAs').hide();
						var infraContainerObj = Ext.getCmp('infraContainer');
						infraContainerObj.removeAll();
						var emptyResultPanel = {
							xtype:'component',
							border : false,
							style:{'text-align':'center'},
							padding : 160,
							html: '<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">'+Segment+'</div>'
						};
						infraContainerObj.add(emptyResultPanel);
						this.getMain().doLayout();
					}
				}
			}

			if (showResultGrid == true)
			{
				if (categorySelected == "categoryWise")
				{
					me.enableInfrastructureTools(false,false,true);
					me.showGroupedComponentSummary();
				}
				else if (categorySelected == "componentNameWise")
				{
					me.enableInfrastructureTools(false,false,false);
					me.showComponentSummary();
				}
				else
				{
					me.enableInfrastructureTools(false,false,true);
					me.showComponentTypeSummary();
				}
			}
			else
			{
				me.disableAllTools();
			}
		}
		else
		{
			viewControlsObj.hide();
			var infraContainerObj = Ext.getCmp('infraContainer');
			infraContainerObj.removeAll();
			infraContainerObj.add({ xtype : 'resultpanel',border : false});
			this.getMain().doLayout();
			this.disableAllTools();
		}
	},
	disableAllTools : function()
	{
		Ext.getCmp('save').setDisabled(true);
		Ext.getCmp('print').setDisabled(true);
		Ext.getCmp('saveCSV').setDisabled(true);
	},
	enableInfrastructureTools : function(isSave,isPrint,isCSV)
	{
		Ext.getCmp('save').setDisabled(isSave);
		Ext.getCmp('print').setDisabled(isPrint);
		Ext.getCmp('saveCSV').setDisabled(isCSV);
	},
	enableAllTools : function()
	{
		Ext.getCmp('save').setDisabled(false);
		Ext.getCmp('print').setDisabled(false);
		Ext.getCmp('saveCSV').setDisabled(false);
	},
	showComponentSummary : function()
	{
		var infraContainerObj = Ext.getCmp('infraContainer');
		infraContainerObj.removeAll();
		infraContainerObj.add({ xtype : 'componentnamesummary'});
		var componentnamesummaryObj = Ext.getCmp('componentnamesummary');
		var showcomponentNameWise = publicJSON['showcomponentNameWise'];
		componentnamesummaryObj.getStore().loadRawData(showcomponentNameWise);
		componentnamesummaryObj.setTitle('<span class="font_bold">'+ publicJSON['componentCount']+'</span>');
		var gridCols = publicJSON['gridCols'];
		var col = 0;
		for (var key in gridCols)
		{
			componentnamesummaryObj.columns[col++].setText(gridCols[key]);
		}
		this.getMain().doLayout();
	},
	showGroupedComponentSummary : function()
	{
		var infraContainerObj = Ext.getCmp('infraContainer');
		infraContainerObj.removeAll();
		infraContainerObj.add({ xtype : 'componentgroupedsummarygrid'});
		var  categoryWiseGrid = publicJSON['categoryWise'];
		var componentgroupedsummarygridObj = Ext.getCmp('componentgroupedsummarygrid');
		componentgroupedsummarygridObj.getStore().loadRawData(categoryWiseGrid);
		componentgroupedsummarygridObj.setTitle('<span class="font_bold">'+ publicJSON['componentCount']+'</span>');
		this.getMain().doLayout();
	},
	showComponentTypeSummary : function()
	{
		var infraContainerObj = Ext.getCmp('infraContainer');
		infraContainerObj.removeAll();
		infraContainerObj.add({ xtype : 'componenttypegroupedsummary'});
		var  componenentTypeWise = publicJSON['componenentTypeWise'];
		var componenttypegroupedsummaryObj = Ext.getCmp('componenttypegroupedsummary');
		componenttypegroupedsummaryObj.getStore().loadRawData(componenentTypeWise);
		componenttypegroupedsummaryObj.setTitle('<span class="font_bold">'+ publicJSON['componentCount']+'</span>');
		this.getMain().doLayout();
	},
	updateInfraData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	}
});

function loadURL(compType)
{
	var ea_criteria = Ext.getCmp('ea_criteria').getValue();
	var viewAs = Ext.getCmp('viewAs').getValue();
	var tmpURI = "aggInfraComponents.jsp?showOnly=aggregate&componentType="+encodeURIComponent(compType)+"&ea_criteria="+ea_criteria+"&viewAs="+viewAs+"&urlFrom=EgItInfraComponentTypes";
	if (ea_criteria.toLowerCase() != 'component')
	{
		var ea_userOption = Ext.getCmp('ea_userOption').getValue();
		tmpURI = tmpURI + "&ea_userOption="+ea_userOption;
	}
	window.location.href= tmpURI;
}

function loadURL1(compType,compName)
{
	var ea_criteria = Ext.getCmp('ea_criteria').getValue();
	var viewAs = Ext.getCmp('viewAs').getValue();
	var tmpURI = "aggInfraCompDetails.jsp?showOnly=aggregate&componentType="+encodeURIComponent(compType)+"&componentName="+encodeURIComponent(compName)+"&ea_criteria="+ea_criteria+"&viewAs="+viewAs+"&urlFrom=EgItInfraComponents";
	if (ea_criteria.toLowerCase() != 'component')
	{
		var ea_userOption = Ext.getCmp('ea_userOption').getValue();
		tmpURI = tmpURI + "&ea_userOption="+ea_userOption;
	}
	window.location.href= tmpURI;
}
