Ext.define('AggregateItInfrastructure.view.ComponentNameSummary', {
	extend: 'Ext.grid.Panel',
	alias:'widget.componentnamesummary',
	id:'componentnamesummary',
	store: new Ext.data.Store({
		fields: ['Nick Name', 'HostName_OR_IP','OS','SystemName','componenetType','port','SID'],
		data: []
	}),
	flex: 1,
	autoScroll : true,
	cls:'gridSkin',
	title: 'Total managed aggregate components',
	columns : [
		{
			header: 'Nick Name',
			sortable: true,
			dataIndex: 'Nick Name',
			flex : 1,
			renderer : function(val)
			{
				var tmpArr = val.split("#$#");
				var tmpTag = '<a id="mouse" href=\'javascript:loadURL1("'+tmpArr[0]+'","'+tmpArr[1]+'")\' target="main" class="eg_monlink">'+tmpArr[2]+'</a>';
				return tmpTag;
			}
		},
		{
			header: 'Host IP/Name',
			sortable: true,
			dataIndex: 'HostName_OR_IP',
			flex : 1,
			hidden:true
		},
		{
			header: 'Operating System',
			sortable: true,
			dataIndex: 'OS',
			flex : 1,
			hidden:true
		},
		{
			header: 'System Name',
			sortable: true,
			dataIndex: 'SystemName',
			flex : 1,
			hidden:true
		},
		{
			header: 'Component Type',
			sortable: false,
			dataIndex: 'componenetType',
			flex : 1,
			renderer : function(val)
			{
				var resultVal;
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					resultVal = tmpTable;
				}
				else
				{
					resultVal = val;
				}
				return resultVal;
			}
		},
		{
			header: 'Port',
			sortable: false,
			dataIndex: 'port',
			wdith : 30,
			hidden:true,
			renderer : function(val)
			{
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					return tmpTable;
				}
				else
				{
					return val;
				}
			}
		},
		{
			header: 'SID',
			sortable: false,
			dataIndex: 'SID',
			wdith : 30,
			hidden:true,
			renderer : function(val)
			{
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					return tmpTable;
				}
				else
				{
					return val;
				}
			}
		}
	]
});



