Ext.define('AggregateItInfrastructure.view.ComponentTypeGroupedSummary', {
	extend: 'Ext.grid.Panel',
	alias:'widget.componenttypegroupedsummary',
	id:'componenttypegroupedsummary',
	requires: [
		'Ext.grid.feature.Grouping',
		'Ext.grid.*'
	],
	store: new Ext.data.Store({
		fields: ['col_1','col_2','col_3','componentType'],
		groupField: 'componentType',
		data: []
	}),
	flex: 1,
	autoScroll : true,
	cls:'gridSkin',
	collapsible: false,
	title: 'Total managed components',
	resizable: false,
	features: [{
		ftype: 'grouping',
		id : 'componentTypeGrouping',
		//groupHeaderTpl: '{name}',
		groupHeaderTpl: [
			'{name:this.formatServerName}',
			{
				formatServerName: function(name) {
					var serArr = name.split("#$#");
					return serArr[0] + " ("+serArr[1]+")";
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false,
	}],
	tools: [
		{
			xtype: 'button',
			id : 'te',
			name : 'te',
			iconCls: 'iconExpandAll',
			hidden:true,
			style: {
				background: 'none',
				border: '0px'
			},
			listeners: {
				'click':function(obj){
					this.hide();
					Ext.getCmp('tc').show();
					var thisGrid = Ext.getCmp('componenttypegroupedsummary');
					var groupingFeature = thisGrid.view.getFeature('componentTypeGrouping');
					groupingFeature.expandAll();
				}
			}
		},
		{
			xtype:'button',
			id :'tc',
			name :'tc',
			iconCls: 'iconCollapseAll',
			hidden:false,
			style: {
				background: 'none',
				border: '0px'
			},
			listeners:{
				'click':function(obj){
					this.hide();
					Ext.getCmp('te').show();
					var thisGrid = Ext.getCmp('componenttypegroupedsummary');
					var groupingFeature = thisGrid.view.getFeature('componentTypeGrouping');
					groupingFeature.collapseAll();
				}
			}
		}
	],
	columns : [
		{
			header: '',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'col_1',
			flex : 1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpArr = val.split("#$#");
					var tmpTag = '<a id="mouse" href=\'javascript:loadURL1("'+tmpArr[0]+'","'+tmpArr[1]+'")\' target="main" class="eg_monlink">'+tmpArr[2]+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		},
		{
			header: '',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'col_2',
			flex : 1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpArr = val.split("#$#");
					var tmpTag = '<a id="mouse" href=\'javascript:loadURL1("'+tmpArr[0]+'","'+tmpArr[1]+'")\' target="main" class="eg_monlink">'+tmpArr[2]+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		},
		{
			header: '',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'col_3',
			flex : 1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpArr = val.split("#$#");
					var tmpTag = '<a id="mouse" href=\'javascript:loadURL1("'+tmpArr[0]+'","'+tmpArr[1]+'")\' target="main" class="eg_monlink">'+tmpArr[2]+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		}
	],
	hideHeaders : true
});



