
Ext.define('AggregateManageUnmanageSystems.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'egconfigenvformcontainer', ref:'egconfigenvformcontainer'},
	],
	init:function()
	{
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.loadSystems
			},
			'egconfigenvformcontainer combo[id="nickname"]':
			{
				'select':this.changeOnSystems
			},
			'egconfigenvformcontainer button[id="Update"]':
			{
				'click':this.updateComponentDetails
			},
			'main button[id="backButton"]':
			{
				'click': this.loadEgConfigManagementApp
			},
		})
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url: 'AggregateManageUnmanageSystems/data/ManageServersJson.jsp?showOnly=aggregate_types',
			method: 'POST',
			async : false,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			}
		});
	},
	changeOnSystems : function(obj)
	{
		var me = this;
		var selectedNickName = obj.getValue();
		var componentDetails = Ext.getCmp('componentDetails');
		if (selectedNickName == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel14);
			componentDetails.getStore().removeAll();
			return;
		}
		var url = "AggregateManageUnmanageSystems/data/ManageServersJson.jsp?showOnly=aggregate_types&nick="+encodeURIComponent(selectedNickName)+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url: url,
			method: 'POST',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				me.loadSystemComponents();
			},
			failure: function(response)
			{
			}
		});
	},
	loadSystemComponents : function()
	{
		var componentDetails = Ext.getCmp('componentDetails');
		componentDetails.getStore().removeAll();
		componentDetails.fromField.store.removeAll();
		componentDetails.toField.store.removeAll();
		componentDetails.fromField.store.add(publicJSON.managedComponentsArr);
		componentDetails.toField.store.add(publicJSON.discoveredComponents);
	},
	loadSystems : function()
	{
		var systemObj = Ext.getCmp('nickname');
		systemObj.getStore().loadRawData(publicJSON.nickNameArr);
		systemObj.setValue("-1");
	},
	updateComponentDetails : function()
	{
		var me = this;
		var nickname = Ext.getCmp('nickname').getValue();
		if (nickname == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel14);
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating please wait...'});
		myMask.show();
		var componentDetails = Ext.getCmp('componentDetails');
		me.setAvailableConfigs();
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: 'AggregateManageUnmanageSystems/data/EgenvpJson.jsp?showOnly=aggregate_types&nickName='+nickname+"&date="+new Date().getTime(),
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						var tmpObj = resultObj.result;
						Ext.Msg.alert(tmpObj.title,tmpObj.message1);
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						Ext.Msg.alert(tmpObj.title,errorText);
					}
					me.loadManagedSysetems();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	setAvailableConfigs : function()
	{
		Ext.getCmp("managedComponents").setValue("");
		Ext.getCmp("unmanagedComponents").setValue("");

		var tmpStore = Ext.getCmp('componentDetails');
		var unmanagedComponentsArr = new Array();
		var managedComponentsArr = new Array();
		var unmnglen = tmpStore.toField.store.getCount();
		var mnglen = tmpStore.fromField.store.getCount();
		var unmanagedList = tmpStore.toField.store;
		var managedList = tmpStore.fromField.store;

		for(var z = 0;z<unmnglen;z++)
		{
			var tmpVal = unmanagedList.getAt(z).get('valueField');
			unmanagedComponentsArr[z] = tmpVal;
		}

		for(var y = 0;y<mnglen;y++)
		{
			var tmpVal = managedList.getAt(y).get('valueField');
			managedComponentsArr[y] = tmpVal;
		}
		Ext.getCmp("managedComponents").setValue(managedComponentsArr);
		Ext.getCmp("unmanagedComponents").setValue(unmanagedComponentsArr);
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table" style="width:90%"><table cellspacing="0" width="100%" cellpadding="5" border="1" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class="x-grid-cell"><div class="x-grid-cell-inner">'
		+errorTitle+' : '+pageIntnl14+'</div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	loadManagedSysetems : function()
	{
		var me = this;
		var nickname = Ext.getCmp('nickname').getValue();
		var url = "AggregateManageUnmanageSystems/data/ManageServersJson.jsp?showOnly=aggregate_types&nick="+encodeURIComponent(nickname)+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url: url,
			method: 'POST',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				var componentDetails = Ext.getCmp('componentDetails');
				componentDetails.getStore().removeAll();
				componentDetails.fromField.store.removeAll();
				componentDetails.toField.store.removeAll();
				componentDetails.fromField.store.add(publicJSON.managedComponentsArr);
				componentDetails.toField.store.add(publicJSON.discoveredComponents);

				Ext.getCmp('nickname').getStore().loadRawData(publicJSON.nickNameArr);

				if (Ext.getCmp('nickname').getStore().findExact("valueField",nickname) != -1)
				{
					Ext.getCmp('nickname').setValue(nickname);
				}
				else
				{
					Ext.getCmp('nickname').setValue("-1");
				}
			}
		});
	},
	loadEgConfigManagementApp : function()
	{
		window.location.href = "aggConfigEnv.jsp?showOnly=aggregate_types";
	}
});