Ext.define('AggregateManageUnmanageSystems.view.EgConfigEnvFormContainer',{
	extend:'Ext.panel.Panel',
	alias:'widget.egconfigenvformcontainer',
	id : 'egconfigenvformcontainer',

	requires:[
		'Ext.ux.OptGroup.OptGroupItemSelector',
		'Ext.ux.OptGroup.OptGroupMultiSelect',
		'utilities.ScrollCombo'
	],

	border :false,
	autoScroll : false,
	scroll : false,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	dockedItems:[
	{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDiscription+'.</center>'
				}
			]
	}],

	items:[
	{
			xtype: 'container',
			layout: {
				type : 'hbox',
				pack: 'center'
			},
			margin: '10 0 15 0',
			items:[
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					width: 350,
					labelSeparator:'',
					editable : true,
					editable : false,
					labelAlign : 'left',
					fieldLabel:'Host / Nick Name',
					name: 'nickname',
					id: 'nickname',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					listConfig : {
						tpl: Ext.create('Ext.XTemplate',
							'<tpl for=".">',
							'<div class="x-boundlist-item">{displayField}</div>','</tpl>'
						)
					}
				}
			]
		},
		{
			xtype: 'container',
			id : 'searchFieldContainer',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			hidden: true,
			items: [
				{
					xtype: 'container',
					width: 435,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'managedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							//cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCtn.searchComponent("managed",this.getValue());
							},
							listeners :
							{
								change : function(obj)
								{
									appCtn.searchComponent("managed",obj.getValue());
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCtn.searchComponent("managed",field.getValue());
									}
								}
							}
						}
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 435,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'unmanagedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							//cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCtn.searchComponent("unmanaged",this.getValue());
							},
							listeners :
							{
								change : function(obj)
								{
									appCtn.searchComponent("unmanaged",obj.getValue());
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCtn.searchComponent("unmanaged",field.getValue());
									}
								}
							}
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type : 'hbox',
				pack: 'center',
				align : 'stretch'
			},
			flex: 1,
			items : [
				{
					xtype: 'optgroupitemselector',
					id: 'componentDetails',
					name: 'componentDetails',
					cls: 'multiselect',
					buttons: ['add', 'remove'],
					buttonsText: {
						add: "Unmanage",
						remove: "Manage",
					},
					toTitle:intnlLabel4,
					fromTitle:intnlLabel5,
					multiSelect: true,
					height: 380,
					width: 900,
					displayField: 'displayField',
					valueField: 'valueField',
					groupField : 'groupField',
					store: Ext.create('Ext.data.Store', {
						fields: ['valueField', 'displayField','groupField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type : 'hbox',
				pack: 'center'
			},
			margin: '20 0 20 0',
			items:[
				{
					xtype : 'button',
					text: intnlLabel7,
					width : 80,
					cls: 'button20',
					id: 'Update'
				}
			]
		}
	]

});



