Ext.define('AggregateNewComponent.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AddNewComponent','IntermediateView'],
	requires:['AggregateNewComponent.view.AddNewComponent','AggregateNewComponent.view.IntermediateView'],
	refs:[
		{selector:'addnewcomponent', ref:'addnewcomponent'},
		{selector:'intermediateview', ref:'intermediateview'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'addnewcomponent':
			{
				'boxready': this.afterMainRender
			},
			'addnewcomponent combo[id="addCategory"]':
			{
				'select':this.categorySelection
			},
			'addnewcomponent combo[id="stype"]':
			{
				'select':this.compTypesSelection
			},
			'addnewcomponent button[id="addButton"]':
			{
				'click':this.addComponent
			},
			'intermediateview button[id="hostCheckBack"]':
			{
				'click':this.hostCheckBack
			},
			'addnewcomponent button[id="backButton"]':
			{
				'click':this.addNewBack
			},
			'addnewcomponent combobox[id="type_name"]':
			{
				'select':this.populate_type_members
			},
			'addnewcomponent combobox[id="type_members"]':
			{
				'select':this.showRestrictedCompTypes
			},
			'addnewcomponent combobox[id="exAggComonents"]':
			{
				'select':this.changeAggComponent
			}
		});
	},
	changeAggComponent : function()
	{
		window.location.href = "/final/admin/aggNewServer.jsp?server="+encodeURIComponent(Ext.getCmp('exAggComonents').getValue())+"&serverType="+encodeURIComponent(encodeURIComponent(Ext.getCmp('stype').getValue()))+"&modifyserver=true&elementType="+s_elementType+"&elementName="+s_elementName+"&operation=modify&serverGategory="+Ext.getCmp('addCategory').getValue();
	},
	populate_type_members : function()
	{
		if(firstTime)
		{
			Ext.Msg.confirm(pageTitle,confirmation1,function(btn)
			{
				if(btn == 'yes')
				{
					ctrler.getTypeMembers();
					firstTime = false;
				}
				else
				{
					Ext.getCmp('type_name').setValue(Ext.isEmpty(publicJSON.defaultElementType) ? '-1' : publicJSON.defaultElementType);
				}
			});
			return;
		}
		ctrler.getTypeMembers();
	},
	getTypeMembers : function()
	{
		Ext.getCmp('itemselectHosts').fromField.store.removeAll();
		Ext.getCmp('itemselectHosts').toField.store.removeAll();
		var s_filter_by = Ext.getCmp('type_name').getValue();
		if(s_filter_by=='-1')
		{
			Ext.getCmp('type_members').hide();
			Ext.Ajax.request(
			{
				url: 'AggregateNewComponent/data/remoteScriptingHelper.jsp?_method=getAllComponentsWithMapping&pcount=1&p0='+publicJSON.normalServerType+'&from=add_or_modify_component_page',
				method: 'POST',
				async:false,
				timeout: 300000,
				success: function( response )
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						jsonDataHolder_vladimir = Ext.decode(response.responseText);
						if(jsonDataHolder_vladimir.availableComponentsFound)
						{
							var myToField = Ext.getCmp('itemselectHosts').toField;
							myToField.store.add(jsonDataHolder_vladimir['availableComponents']);
							myToField.boundList.getSelectionModel().selectAll();
						}
					}
				}
			});
		}
		else
		{
			Ext.getCmp('type_members').show();
			if(s_filter_by=='Group')
			{
				Ext.getCmp('type_members').getStore().loadRawData(publicJSON['groupNamesArray']);
				Ext.getCmp('type_members').setValue("-1");
				Ext.getCmp('type_members').setFieldLabel(list_of_groups);
			}
			else if(s_filter_by=='Segment')
			{
				Ext.getCmp('type_members').getStore().loadRawData(publicJSON.segmentNamesArray);
				Ext.getCmp('type_members').setValue("-1");
				Ext.getCmp('type_members').setFieldLabel(list_of_segments);
			}
			else if(s_filter_by=='Service')
			{
				Ext.getCmp('type_members').getStore().loadRawData(publicJSON.serviceNamesArray);
				Ext.getCmp('type_members').setValue("-1");
				Ext.getCmp('type_members').setFieldLabel(list_of_services);
			}
			else if(s_filter_by=='Zone')
			{
				Ext.getCmp('type_members').getStore().loadRawData(publicJSON.zoneNamesArray);
				Ext.getCmp('type_members').setValue("-1");
				Ext.getCmp('type_members').setFieldLabel(list_of_zones);
			}
		}
	},
	showRestrictedCompTypes : function()
	{
		if(firstTime) 
		{
			Ext.Msg.confirm(pageTitle,confirmation1,function(btn)
			{
				if(btn == 'yes')
				{
					ctrler.getFilterMembers();
					firstTime = false;
				}
				else
				{
					Ext.getCmp('type_members').setValue(publicJSON.defaultElementName);
				}
			});
			return;
		}
		ctrler.getFilterMembers();
	},
	getFilterMembers: function()
	{
		Ext.getCmp('itemselectHosts').fromField.store.removeAll();
		Ext.getCmp('itemselectHosts').toField.store.removeAll();
		var element_name = Ext.getCmp('type_name').getValue();
		var element_value = Ext.getCmp('type_members').getValue();
		if(element_value=="-1") {
			return;
		}
		var remoteUrl='';
		if(currentAction=='modify')
		{
			var str = element_name+'@'+element_value+'@'+publicJSON.aggComponent;
			remoteUrl='_method=modifyAggComponent&pcount=1&p0='+str+'&from=add_or_modify_component_page';
		}
		else
		{
			var str = element_name+'@'+element_value+'@'+publicJSON.normalServerType;
			remoteUrl='_method=getAllComponents&pcount=1&p0='+str+'&from=add_or_modify_component_page';
		}
		Ext.Ajax.request(
		{
			url: 'AggregateNewComponent/data/remoteScriptingHelper.jsp?'+remoteUrl,
			method: 'POST',
			async:false,
			timeout: 300000,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					jsonDataHolder_vladimir = Ext.decode(response.responseText);
					if(currentAction=='modify')
					{
						if(jsonDataHolder_vladimir.associatedComponentsFound)
						{
							var myFromField = Ext.getCmp('itemselectHosts').fromField;
							myFromField.store.add(jsonDataHolder_vladimir['associatedComponents']);
						}
						if(jsonDataHolder_vladimir.availableComponentsFound)
						{
							var myToField = Ext.getCmp('itemselectHosts').toField;
							myToField.store.add(jsonDataHolder_vladimir['availableComponents']);
						}
					}
					else
					{
						if(jsonDataHolder_vladimir.availableComponentsFound)
						{
							var myToField = Ext.getCmp('itemselectHosts').toField;
							myToField.store.add(jsonDataHolder_vladimir['availableComponents']);
							myToField.boundList.getSelectionModel().selectAll();
						}
					}
				}
			}
		});
	},
	buildMainData: function()
	{
		if (reqfrom == 'comp_mng_umng' || reqfrom == 'discovery_mng_umng' || reqfrom == 'comp_add_modify' || reqfrom == 'comp_add_mod_new')
		{
			serverType = homepage_server;
			server = homepage_nickport;
		}
		var urlStr = 'AggregateNewComponent/data/EgNewServerJson.jsp?serverType='+encodeURIComponent(serverType)+'&selectedServerGroup='+serverCategory;

		if (currentAction == 'add')
		{
			urlStr += '&server=new';
		}
		else if (currentAction == 'manage')
		{
			urlStr = "AggregateNewComponent/data/EgNewServerJson.jsp?"+qryStr;
		}
		else
		{
			urlStr += '&server='+encodeURIComponent(server);
		}
		if(s_elementType.length>0 && s_elementName.length>0)
		{
			urlStr += '&elementType='+s_elementType+'&elementName='+s_elementName+'&operation='+s_operation;
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			timeout: 300000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		jsonDataCache = publicJSON;
	},
	getData: function(urlStr)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			timeout: 300000,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	afterMainRender : function()
	{
		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title : publicJSON.AlertTitle,
				msg : publicJSON.AlertMsg,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
						Ext.getCmp('addCategory').setValue('-1');
						Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
						Ext.getCmp('stype').setValue('-1');
						Ext.getCmp('addPageContainer').hide();
						Ext.getCmp('addPageComponentContainer').hide();
						Ext.getCmp('buttonContainer').hide();
						return;
					}
				}
			});
		}

		if (publicJSON.serverType == '-1')
		{
			Ext.getCmp('addPageContainer').hide();
			Ext.getCmp('addPageComponentContainer').hide();
			Ext.getCmp('buttonContainer').hide();
			return;
		}
		else
		{
			Ext.getCmp('addPageContainer').show();
			Ext.getCmp('addPageComponentContainer').show();
			Ext.getCmp('buttonContainer').show();
		}

		Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
		Ext.getCmp('addCategory').setValue(publicJSON.selectedServerGroup);
		Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
		Ext.getCmp('stype').setValue(publicJSON.serverType);
		Ext.getCmp('remoteAgent').getStore().loadRawData(publicJSON.remoteAgentsList);
		Ext.getCmp('remoteAgent').setValue(publicJSON.remoteAgentSelected);

		Ext.getCmp('extAgents').getStore().loadRawData(publicJSON.externalAgents);
		Ext.getCmp('extAgents').setValue(publicJSON.externalAgentsSelected);

		if(publicJSON.remoteMonitoring)
		{
			Ext.getCmp('extAgents').hide();
			Ext.getCmp('remoteAgent').show();
		}
		else
		{
			Ext.getCmp('extAgents').show();
			Ext.getCmp('remoteAgent').hide();
		}
		if(currentAction == 'add')
		{
			if(publicJSON.filterByArrayFound)
			{
				if(s_operation=='add')
				{
					Ext.getCmp('type_name').hide();
					Ext.getCmp('type_members').hide();
					Ext.getCmp('displayComponent').show();
					Ext.getCmp('displayComponent').setFieldLabel(publicJSON.displayComponentLabel);
					Ext.getCmp('displayComponent').setValue(s_elementName);
					if(s_elementType !='group')
					{
						Ext.getCmp('anchorCompRG').show();
						Ext.getCmp('anchorCompRG').setFieldLabel(publicJSON.anchorCompRGLabel);
						Ext.getCmp('anchorCompRG').setValue({'anchorComp': 'no'});
					}
					if(s_elementType=='zone' || s_elementType=='Zone')
					{
						Ext.getCmp('memberComponentRG').show();
						Ext.getCmp('memberComponentRG').setFieldLabel(publicJSON.memberComponentRGLabel);
						Ext.getCmp('memberComponentRG').setValue({'memberComponent': 'no'});
					}
				}
				else
				{
					Ext.getCmp('type_name').show();
					Ext.getCmp('type_name').getStore().loadRawData(publicJSON.filterByArray);
					Ext.getCmp('type_name').setValue('-1');
				}
			}
		}
		else if (currentAction == 'modify')
		{
			Ext.getCmp('hostip').setValue('0.0.0.0');
			Ext.getCmp('hostname').setValue(publicJSON.hostname);
			Ext.getCmp('addButton').setText(label_Update);

			Ext.getCmp('addCategory').setReadOnly(true);
			Ext.getCmp('stype').setReadOnly(true);
			if(publicJSON.modifyAnchorComponent)
			{
				//Ext.getCmp('hostname').hide();
				Ext.getCmp('exAggComonents').show();
				Ext.getCmp('exAggComonents').getStore().loadRawData(publicJSON.aggComponentTypeList);
				Ext.getCmp('exAggComonents').setValue(publicJSON.aggComponentTypeSelected);

				var s_nick_name_port = publicJSON.aggComponentTypeSelected;
				Ext.getCmp('exAggComonents').setValue(s_nick_name_port);
				Ext.getCmp('hostname').setValue(s_nick_name_port.substring(0,s_nick_name_port.indexOf(':')));

				Ext.getCmp('type_name').hide();
				Ext.getCmp('type_members').hide();
				Ext.getCmp('displayComponent').show();
				Ext.getCmp('displayComponent').setFieldLabel(publicJSON.displayComponentLabel);
				Ext.getCmp('displayComponent').setValue(publicJSON.elementName);

				if(publicJSON.elementType !='group')
				{
					Ext.getCmp('anchorCompRG').show();
					Ext.getCmp('anchorCompRG').setFieldLabel(publicJSON.anchorCompRGLabel);
					if(publicJSON.isAnchorComponent)
					{
						Ext.getCmp('anchorCompRG').setValue({'anchorComp': 'yes'});
					}
					else
					{
						Ext.getCmp('anchorCompRG').setValue({'anchorComp': 'no'});
					}
				}
				if(publicJSON.elementType =='zone')
				{
					Ext.getCmp('memberComponentRG').show();
					Ext.getCmp('memberComponentRG').setFieldLabel(publicJSON.memberComponentRGLabel);
					if(publicJSON.isAlreadyMemberOfZone)
					{
						Ext.getCmp('memberComponentRG').setValue({'memberComponent': 'yes'});
					}
					else
					{
						Ext.getCmp('memberComponentRG').setValue({'memberComponent': 'no'});
					}
				}
			}
			else if(publicJSON.filterByElement)
			{
				Ext.getCmp('type_name').show();
				Ext.getCmp('type_name').getStore().loadRawData(publicJSON.filterByArray);
				Ext.getCmp('type_name').setValue('-1');

				Ext.getCmp('type_members').show();
				Ext.getCmp('type_name').setValue(publicJSON.defaultElementType);
				if(publicJSON.defaultElementType=='Group')
				{
					Ext.getCmp('type_members').getStore().loadRawData(publicJSON.groupNamesArray);
					Ext.getCmp('type_members').setValue(publicJSON.defaultElementName);
					Ext.getCmp('type_members').setFieldLabel(list_of_groups);
				}
				else if(publicJSON.defaultElementType=='Segment')
				{
					Ext.getCmp('type_members').getStore().loadRawData(publicJSON.segmentNamesArray);
					Ext.getCmp('type_members').setValue(publicJSON.defaultElementName);
					Ext.getCmp('type_members').setFieldLabel(list_of_segments);
				}
				else if(publicJSON.defaultElementType=='Service')
				{
					Ext.getCmp('type_members').getStore().loadRawData(publicJSON.serviceNamesArray);
					Ext.getCmp('type_members').setValue(publicJSON.defaultElementName);
					Ext.getCmp('type_members').setFieldLabel(list_of_services);
				}
				else if(publicJSON.defaultElementType=='Zone')
				{
					Ext.getCmp('type_members').getStore().loadRawData(publicJSON.zoneNamesArray);
					Ext.getCmp('type_members').setValue(publicJSON.defaultElementName);
					Ext.getCmp('type_members').setFieldLabel(list_of_zones);
				}
			}
			else if(publicJSON.filterByArrayFound)
			{
				Ext.getCmp('type_name').show();
				Ext.getCmp('type_name').getStore().loadRawData(publicJSON.filterByArray);
				Ext.getCmp('type_name').setValue('-1');
			}
		}
		if(publicJSON.associatedComponentsFound)
		{
			var myFromField = Ext.getCmp('itemselectHosts').fromField;
			myFromField.store.add(publicJSON['associatedComponents']);
		}
		if(publicJSON.availableComponentsFound)
		{
			var myToField = Ext.getCmp('itemselectHosts').toField;
			myToField.store.add(publicJSON['availableComponents']);
		}

		if (!Ext.isEmpty(compGlanceCompType))
		{
			Ext.getCmp('backButton').hide();
			Ext.getCmp('addnewcomponent').tools.close.toolEl.dom.hidden = false;
		}
		else
		{
			Ext.getCmp('backButton').show();
			if (Ext.getCmp('addnewcomponent').tools.close)
			{
				Ext.getCmp('addnewcomponent').tools.close.toolEl.dom.hidden = true;
			}
		}
	},
	addNewBack: function()
	{
		if (reqfrom=='comp_mng_umng')
		{
			window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			return;
		}
		else if (reqfrom == 'discovery_mng_umng')
		{
			window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			return;
		}
		else if (reqfrom == 'comp_add_modify')
		{
			window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			return;
		}
		else if (reqfrom == 'comp_add_mod_new')
		{
			window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
			return;
		}

		if(backHref.indexOf('EgAggregateTree.jsp')>-1)
		{
			if (backHref.endsWith('Tree.jsp'))
			{
				backHref +="?fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			}
			else
			{
				backHref +="&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			}
			parent.window.location.href = backHref;
		}
		else
		{
			if(backHref.indexOf('aggDispServer.jsp?')>-1)
			{
				window.location.href = backHref.substring(0,backHref.indexOf('?')+1)+'&category='+Ext.getCmp('addCategory').getValue()+'&comptype='+Ext.getCmp('stype').getValue()+"&fromWizard="+fromWizard+"&compGlanceCompType="+compGlanceCompType;
			}
			else
			{
				if (backHref.endsWith('Tree.jsp'))
				{
					backHref +="?fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
				}
				else
				{
					backHref +="&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
				}
				window.location.href = backHref;
			}
		}
	},
	categorySelection: function ()
	{
		var selectedCategory = Ext.getCmp('addCategory').getValue();
		var url = 'AggregateNewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory;
		this.getData(url);
		var comboObj = Ext.getCmp('stype').getStore();
		comboObj.removeAll();
		comboObj.loadRawData(publicJSON.componentTypes);
		Ext.getCmp('stype').setValue("-1");

		Ext.getCmp('addPageContainer').hide();
		Ext.getCmp('addPageComponentContainer').hide();
		Ext.getCmp('buttonContainer').hide();
	},
	compTypesSelection: function ()
	{
		var selectedCType = Ext.getCmp('stype').getValue();
		if (selectedCType == -1)
		{
			Ext.getCmp('addPageContainer').hide();
			Ext.getCmp('addPageComponentContainer').hide();
			Ext.getCmp('buttonContainer').hide();
			Ext.Msg.alert(addButtonText,alertMsg32);
			return;
		}
		var selectedCategory = Ext.getCmp('addCategory').getValue();
		window.location.href = '/final/admin/aggNewServer.jsp?server=new&serverType='+encodeURIComponent(selectedCType)+'&from=addnew&isAggregateLink=true&treeViewSrc=null&serverGategory='+selectedCategory+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
	},
	addComponent : function()
	{
		var me = this;
		if(currentAction == 'modify')
		{
			var allExtAgents = publicJSON.hiddenVals.allExtAgents;
			var allRemAgents = publicJSON.hiddenVals.allRemAgents;
			var existName = publicJSON.hostname;
			var compNickObj = Ext.getCmp('hostname');
			var compNickVal = Ext.getCmp('hostname').getValue();
			if(!checkblank(compNickVal))
			{
				Ext.Msg.alert(pageTitle,alertMsg22,function(button){
					if (button == "ok")
					{
						compNickObj.focus(true);
					}
				});
				return false;
			}
			if(compNickVal != "" && this.contains2(allExtAgents, compNickVal))
			{
				Ext.Msg.alert(pageTitle,alertMsg38,function(button){
					if (button == "ok")
					{
						compNickObj.focus(true);
					}
				});
				return false;
			}
			else if(compNickVal != "" && this.contains2(allRemAgents, compNickVal))
			{
				Ext.Msg.alert(pageTitle,alertMsg39,function(button){
					if (button == "ok")
					{
						compNickObj.focus(true);
					}
				});
				return false;
			}
			else if (compNickVal != existName)
			{
				Ext.Msg.show({
					title:pageTitle,
					msg:alertMsg36,
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn:function(buttonText){
					if (buttonText == "yes")
					{
						me.addComponent1();
					}
				}});
				return false;
			}
			else
			{
				this.addComponent1();
			}
		}
		else
		{
			this.addComponent1();
		}
	},
	addComponent1 : function()
	{
		var isValid = this.addComponentValidation();
		if (!isValid)
		{
			return;
		}
		// Setting associated components to a hidden field - starts
		var tmpStore = Ext.getCmp('itemselectHosts');
		var tmpStore = Ext.getCmp('itemselectHosts');
		var associatedComponentsCount = tmpStore.fromField.store.getCount();
		var associatedComponentsList = tmpStore.fromField.store;
		var selectedAssociatedComponents = '';
		for(var m=0;m<associatedComponentsCount;m++)
		{
			selectedAssociatedComponents += ',' + associatedComponentsList.getAt(m).get('valueField');
		}
		if(selectedAssociatedComponents.length==0)
		{
			Ext.Msg.alert(pageTitle,associated_comps_alert);
			return;
		}
		// Setting associated components to a hidden field - ends

		var selCType = Ext.getCmp('stype').getValue();

		var mainObj = this;
		var hiddenParams = publicJSON.hiddenVals;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		if(!Ext.getCmp('type_name').isDisabled() && !Ext.getCmp('type_members').isDisabled())
		{
			var s_type_name = Ext.getCmp('type_name').getValue();
			if(s_type_name != null && s_type_name != 'undefined' && s_type_name != '-1')
			{
				var s_type_members = Ext.getCmp('type_members').getValue();
				if(s_type_members != null && s_type_members != 'undefined' && s_type_members != '-1')
				{
					me.add({
						xtype: 'hidden',
						name: 'type_name',
						value: s_type_name
					});
					me.add({
						xtype: 'hidden',
						name: 'type_members',
						value: s_type_members
					});
				}
			}
		}
		me.add({
			xtype: 'hidden',
			name: 'servertype',
			value: Ext.getCmp('stype').getValue()
		});
		me.add({
			xtype: 'hidden',
			name: 'isExistingAggType',
			value: publicJSON.isExistingAggType
		});
		me.add({
			xtype: 'hidden',
			name: 'fassociate',
			value: selectedAssociatedComponents.substring(1)
		});
		me.add({
			xtype: 'hidden',
			name: 'selectedCategory',
			value: Ext.getCmp('addCategory').getValue()
		});
		var elementModify = 'no';
		if(Ext.getCmp('displayComponent').isVisible())
		{
			t_elementType = publicJSON.elementType;
			t_elementName = publicJSON.elementName;
			if(s_elementType.length>0 && s_elementName.length>0 && currentAction == 'add')
			{
				t_elementType = s_elementType;
				t_elementName = s_elementName;
			}
			me.add({
				xtype: 'hidden',
				name: 'elementType',
				value: t_elementType
			});
			me.add({
				xtype: 'hidden',
				name: 'elementName',
				value: t_elementName
			});
			elementModify = "yes";
		}
		var urlStr = "/final/admin/AggregateNewComponent/data/EgHostCheckJson.jsp?strPass=&from=addNew&server=new&isAggregateType=true";
		if (currentAction == 'modify')
		{
			urlStr = "/final/admin/AggregateNewComponent/data/EgHostCheckJson.jsp?isAggregateType=true&modifyserver=true&elementModify="+elementModify;
		}
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'... '+plsWait+'.'});
		tmpMask.show();
		this.getAddnewcomponent().submit({
			url: urlStr,
			method: 'POST',
			timeout: 300,
			success: function(form, action){
				tmpMask.hide();
				var resObj  = action.response.responseText;
				publicJSON = Ext.decode(resObj);
				var requestStatus = publicJSON.requestStatus;

				if (requestStatus=='failed')
				{
					if(publicJSON.error_type=='alert')
					{
						Ext.Msg.show({
							title:publicJSON.error_Info.error_Title,
							msg: alertMsg33+'<br>'+publicJSON.error_Info.error_Msg_1+'<br>'+publicJSON.error_Info.error_Msg_2,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						publicJSON = jsonDataCache;
					}
					else if (publicJSON.error_type=='radio')
					{
						var mainContainerObj = Ext.getCmp('newcomponentview');
						mainContainerObj.removeAll();
						mainContainerObj.add({
							xtype : 'intermediateview'
						});
						Ext.getCmp('intermediategrid').setTitle(publicJSON.main_Msg_Title);
						Ext.getCmp('intermediategrid').getStore().loadRawData(publicJSON.gridData);

						var radio1Obj = Ext.getCmp('radioOne');
						var radio2Obj = Ext.getCmp('radioTwo');
						Ext.getCmp('radioOpts').setFieldLabel(publicJSON.radio_Msg_Title);
						radio1Obj.boxLabelEl.update(publicJSON.radio1_Msg);
						radio2Obj.boxLabelEl.update(publicJSON.radio2_Msg);

						radio1Obj.inputValue = publicJSON.radio1_value;
						radio2Obj.enable();
						if (publicJSON.radio2_enable == 'disabled')
						{
							radio2Obj.disable();
						}

						if (publicJSON.radio1_checked)
						{
							radio1Obj.setValue(true);
						}
					}
					else if (publicJSON.error_type=='confirmNickSuggestion')
					{
						Ext.Msg.show({
							title: publicJSON.error_Info.error_Title,
							msg: alertMsg33+'.<br>'+publicJSON.error_Info.error_Msg_1+'<br>'+publicJSON.error_Info.error_Msg_2,
							buttons: Ext.Msg.YESNO,
							icon: 'iconConfirmation',
							fn: function(response) {
								if(response == 'yes') 
								{
									var forwardURL = publicJSON.error_Info.forward_URL;
									var oldIP = publicJSON.error_Info.IP;
									var oldNick = publicJSON.error_Info.nickName;
									var hiddenParams = publicJSON.hiddenValues;
									var me = Ext.getCmp('hiddenContnr');
									me.removeAll();
									Ext.suspendLayouts();
									for (var param in hiddenParams) {
										var paramVal = hiddenParams[param];
										if (param == 'hostip')
										{
											paramVal = oldIP;
										}
										else if (param == 'hostname')
										{
											paramVal = oldNick;
										}
										me.add({
											xtype: 'hidden',
											name: param,
											value: paramVal
										});
									}
									Ext.resumeLayouts(true);
									forwardURL ="/final/admin/NewComponent/data/"+forwardURL;
									mainObj.forwardGivenURL(forwardURL);
								}
								else
								{
									Ext.getCmp('hostname').focus();
									var selectedCType = encodeURIComponent(selCType);
									var selectedCategory = Ext.getCmp('addCategory').getValue();
									selectedCategory = encodeURIComponent(selectedCategory);
									var url = 'NewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory+"&server=new&serverType="+selectedCType;
									ctrler.getData(url,true);
								}
							}
						});
					}
				}
				else if (requestStatus=='success')
				{
					if (publicJSON.forward)
					{
						var forwardURL = publicJSON.forward_URL;
						var hiddenParams = publicJSON.hiddenValues;
						var me = Ext.getCmp('hiddenContnr');
						me.removeAll();
						for (var param in hiddenParams) {
								me.add({
									xtype: 'hidden',
									name: param,
									value: hiddenParams[param]
								});
						}

						forwardURL ="/final/admin/AggregateNewComponent/data/"+forwardURL;
						mainObj.forwardGivenURL(forwardURL);
					}
				}
			},
			failure: function(form, action)
			{
				 // if result page doest not contain success:true, this method fires
				 tmpMask.hide();
				 switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
				}
			}
		});
	},
	forwardGivenURL : function(forwardURL)
	{
		var resMsg = alertMsg34;
		if (currentAction == 'modify')
		{
			resMsg = alertMsg35;
		}
		var thisCtrl = this;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'... '+plsWait+'.'});
		tmpMask.show();
		this.getAddnewcomponent().submit({
				url: forwardURL,
				method: 'POST',
				//standardSubmit:true,
				timeout: 300,
				success: function(form, action){
				tmpMask.hide();
				var resObj  = action.response.responseText;
				var publicJSON = Ext.decode(resObj);
				var requestStatus = publicJSON['requestStatus'];
				if(requestStatus == 'success')
				{
					Ext.Msg.show({
						title:compnonetLabel,
						msg: resMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								var cType = publicJSON.compType;
								var sCat = publicJSON.selectedCategory;
								if(reqfrom == 'agg_show_types')
								{
									location.href = backHref;
								}
								else if (reqfrom != 'comp_mng_umng' && reqfrom != 'discovery_mng_umng' && reqfrom != 'comp_add_modify' && reqfrom != 'comp_add_mod_new')
								{
									if (!Ext.isEmpty(fromWizard) && fromWizard.startsWith('componentsGlance_'))
									{
										window.parent.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+encodeURIComponent(compGlanceCompType);
									}
									else
									{
										var url = '/final/admin/aggDispServer.jsp?category='+sCat+'&comptype='+cType+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
										window.location.href = url;
									}
								}
							}
						}
					});
				}
				else if (requestStatus == 'failed')
				{
					var resObj  = action.response.responseText;
					var publicJSON = Ext.decode(resObj);
					var requestStatus = publicJSON['requestStatus'];
					Ext.Msg.show({
						title:publicJSON.Error_Title,
						msg: alertMsg33 + '<br>' + publicJSON.Error_Info.Error_Msg_1 + '<br>' + publicJSON.Error_Info.Error_Msg_2,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								var url = '/final/admin/aggDispServer.jsp?category=-1&comptype=-1';
								window.location.href = url+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
							}
						}
					});

				}
			},
			failure: function(form, action)
			{
				 // if result page doest not contain success:true, this method fires
				tmpMask.hide();
				 switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
				}
			}
		});
	},
	addComponentValidation : function()
	{
		var compNickObj = Ext.getCmp('hostname');
		var compNickVal = Ext.getCmp('hostname').getValue();
		var compType = Ext.getCmp('stype').getValue();

		if(!checkblank(compNickVal))
		{
			Ext.Msg.alert(pageTitle,alertMsg22,function(button){
				if (button == "ok")
				{
					compNickObj.focus(true);
				}
			});
			return false;
		}
		else if(!checkspace(compNickVal))
		{
			compNickObj.focus(true);
			return false;
		}
		else if(!checkspecial(compNickVal,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?")) //removed slash(/) for AWS_EC2_Region component
		{
			compNickObj.focus(true)
			return false;
		}
		else if(isAllowHostName=='true' && !this.checkForHostType(compNickVal))
		{
			Ext.Msg.alert(pageTitle,alertMsg20 + alertMsg21,function(button){
					if (button == "ok")
					{
						compNickObj.focus(true);
					}
				});
			return false;
		}
		else if (!this.checkForHostType(compNickVal))
		{
			Ext.Msg.alert(pageTitle,alertMsg20 + alertMsg21,function(button){
					if (button == "ok")
					{
						compNickObj.focus(true);
					}
				});
			return false;
		}
		else if(isDoubleByteMgr=="false" && !validateSingleByte(compNickVal))
		{
			Ext.Msg.alert(pageTitle,alertMsg1,function(button){
				if (button == "ok")
				{
					compNickObj.focus(true);
				}
			});
			return false;
		}
		else if(isDoubleByteMgr=='false' && !this.checkdots(compNickVal))
		{
			compNickObj.focus(true);
			return;
		}
		else if(isDoubleByteMgr=='false' && compNickVal.toLowerCase() == compType.toLowerCase())
		{
			Ext.Msg.alert(pageTitle,alertMsg26,function(button){
				if (button == "ok")
				{
					compNickObj.focus(true);
				}
			});
			return false;
		}
		else
		{
			return true;
		}
	},
	checkdots : function(fieldvalue)
	{
		var val = fieldvalue;
		if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
		{
			Ext.Msg.alert(pageTitle,alertMsg30);
			return false;
		}
		else
		{
			for(var k=0;k < val.length;k++)
			{
				if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
				{
					Ext.Msg.alert(pageTitle,alertMsg31);
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	},
	validateHostName : function()
	{
		var allExtAgents = publicJSON.hiddenVals.allExtAgents;
		var allRemAgents = publicJSON.hiddenVals.allRemAgents;
		var name = Ext.getCmp('hostname').getValue();
		var isExtAgentExist = false;
		var isRmtAgentExist = false;
		if(name != "" && this.contains2(allExtAgents, name))
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : alertMsg38,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			isExtAgentExist = true;
		}
		if(name != "" && this.contains2(allRemAgents, name))
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : alertMsg39,
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			isRmtAgentExist = true;
		}
		if (isExtAgentExist || isRmtAgentExist)
			return false;
		else
			return true;
	},
	contains2 : function(largeStr, smallStr)
	{
		var string = largeStr;
		var contains = false;
		var prevIndex = 0;
		var index = string.indexOf(',');
		while (index > -1)
		{
			var substring = string.substring(prevIndex, index);
			if (substring.toLowerCase() == smallStr.toLowerCase())
			{
				contains = true;
				break;
			}
			else
			{
				prevIndex = index;
				string = string.substring(1, string.length);
				index = string.indexOf(',');
			}
		}

		if (string.toLowerCase() == smallStr.toLowerCase())
		{
			contains = true;
		}

		return contains;
	},
	checkForHostType : function(compType)
	{
		var servers = publicJSON.servTypes;
		for (var s=0; s<servers.length;s++)
		{
			if(servers[s] == compType)
			{
				return false;
			}
		}
		return true;
	},
	hostCheckBack : function()
	{
		var URL ="/final/admin/aggNewServer.jsp?"+addCompURL+"&fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
		window.location.href = URL;
	}
});



