Ext.define('AggregateShowDetails.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AggShowDetails'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		appController = this;
		
		this.rowBodyTrSelector = '.x-grid-rowbody-tr';
		this.rowBodyHiddenCls = 'x-grid-row-body-hidden';
		this.rowCollapsedCls = 'x-grid-row-collapsed';
		this.recordsExpanded = {};
		this.isViewExpaned2 = false;

		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="comboResult"]':
			{
				'select': this.ComboBoxOnchange
			},
			'main button[id="showAll"]':
			{
				'click':this.showAllPreUsers
			}
		});
	},
	showAllPreUsers : function(obj)
	{
		var thisGrid = Ext.getCmp('resultGrid').getStore();
		if (obj.status == 'hidden')
		{
			obj.status = 'shown';
			obj.setText(intnlLabel11);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.expandRow(i,Ext.getCmp('resultGrid'));
			}
		}
		else
		{
			obj.status = 'hidden';
			obj.setText(intnlLabel10);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('resultGrid'));
			}
		}
		this.getMain().doLayout();
	},
	expandRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (row.hasCls(this.rowCollapsedCls)) {
			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = true;
			thisGrid.view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},
	collapseRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (!row.hasCls(this.rowCollapsedCls)) {
			row.addCls(this.rowCollapsedCls);
			nextBd.addCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = false;
			thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
		}
	},
	afterMainRender: function()
	{
		Ext.getCmp('resultGrid').hide();
		Ext.getCmp('compSelection').hide();
		var param = "elementType="+selElement;
		Ext.Ajax.request(
		{
			url: requestURL,
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					publicJSON = Ext.decode(response.responseText);
					if(publicJSON.totalComponents==0)
					{
						Ext.getCmp('imagemsg').update("<div style='margin:2% auto auto auto'><table border='0' width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+publicJSON.errorMessage+"</div></td></tr></table></div>");
						Ext.getCmp('imagemsg').show();
					}
					else
					{
						Ext.getCmp('compSelection').show();
						Ext.getCmp('resultGrid').show();
						Ext.getCmp('imagemsg').hide();
					}

					Ext.getCmp('comboResult').setFieldLabel(publicJSON['displayName']);
					Ext.getCmp('comboResult').getStore().suspendEvents(true);
					Ext.getCmp('comboResult').getStore().loadRawData(publicJSON['comboboxDataList']);
					Ext.getCmp('comboResult').getStore().resumeEvents();
					Ext.getCmp('comboResult').select(publicJSON['elementName']);
					Ext.getCmp('resultGrid').getStore().suspendEvents(true);
					Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridDataList']);
					Ext.getCmp('resultGrid').getStore().resumeEvents();
					Ext.getCmp('resultGrid').setTitle(publicJSON['gridTitle']);
				}
			}
		});
	},
	ComboBoxOnchange: function()
	{
		Ext.getCmp('showAll').setText(intnlLabel10);
		Ext.getCmp('resultGrid').hide();
		Ext.getCmp('compSelection').hide();
		var selComboValue = Ext.getCmp('comboResult').getValue();
		var param = "elementType="+selElement+"&name="+selComboValue;
		Ext.Ajax.request(
		{
			url: onChangeURL,
			method:'GET',
			params: param,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					publicJSON = Ext.decode(response.responseText);
					Ext.getCmp('compSelection').show();
					Ext.getCmp('resultGrid').show();
					Ext.getCmp('imagemsg').hide();
					Ext.getCmp('comboResult').setFieldLabel(publicJSON['displayName']);
					Ext.getCmp('comboResult').getStore().suspendEvents(true);
					Ext.getCmp('comboResult').getStore().loadRawData(publicJSON['comboboxDataList']);
					Ext.getCmp('comboResult').getStore().resumeEvents();
					Ext.getCmp('comboResult').select(publicJSON['elementName']);
					Ext.getCmp('resultGrid').getStore().suspendEvents(true);
					Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridDataList']);
					Ext.getCmp('resultGrid').getStore().resumeEvents();
					Ext.getCmp('resultGrid').setTitle(publicJSON['gridTitle']);
				}
			}
		});
	}
});
