Ext.define('AggregateShowTypes.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormPanel'],
	
	refs:[
		{selector:'formPanel', ref:'formPanel'}
	],

	init:function(){
		appCnt = this;
		
		this.rowBodyTrSelector = '.x-grid-rowbody-tr';
		this.rowBodyHiddenCls = 'x-grid-row-body-hidden';
		this.rowCollapsedCls = 'x-grid-row-collapsed';
		this.recordsExpanded = {};
		this.isViewExpaned = false;
		this.isViewExpaned2 = false;

		this.control({
				'formPanel':
				{
					'afterrender': this.afterMainRender,
				},
				'formPanel button[id="addAllButton"]':
				{
					'click': this.callAddAll
				},
				'formPanel button[id="backbutton"]' :
				{
					'click': this.back
				},
				'formPanel trigger[name="searchBox"]':
				{
					'change': this.egTitleSearch
				},
				'formPanel button[id="showAll"]':
				{
					'click':this.showAllPreUsers
				}
			});
		},
		showAllPreUsers : function(obj)
		{
			var thisGrid = Ext.getCmp('resultGrid').getStore();
			if (obj.status == 'hidden')
			{
				obj.status = 'shown';
				obj.setText(intnlLabel11);
				for (var i = 0;i<thisGrid.getCount();i++)
				{
					this.expandRow(i,Ext.getCmp('resultGrid'));
				}
			}
			else
			{
				obj.status = 'hidden';
				obj.setText(intnlLabel10);
				for (var i = 0;i<thisGrid.getCount();i++)
				{
					this.collapseRow(i,Ext.getCmp('resultGrid'));
				}
			}
			this.getFormPanel().doLayout();
		},
		expandRow: function(rowIdx,thisGrid) {
			var rowNode = thisGrid.view.getNode(rowIdx);
			row = Ext.get(rowNode);
			nextBd = Ext.get(row).down(this.rowBodyTrSelector);
			record = thisGrid.view.getRecord(rowNode);
			if (row.hasCls(this.rowCollapsedCls)) {
				row.removeCls(this.rowCollapsedCls);
				nextBd.removeCls(this.rowBodyHiddenCls);
				this.recordsExpanded[record.internalId] = true;
				thisGrid.view.fireEvent('expandbody', rowNode, record, nextBd.dom);
			}
		},
		collapseRow: function(rowIdx,thisGrid) {
			var rowNode = thisGrid.view.getNode(rowIdx);
			row = Ext.get(rowNode);
			nextBd = Ext.get(row).down(this.rowBodyTrSelector);
			record = thisGrid.view.getRecord(rowNode);
			if (!row.hasCls(this.rowCollapsedCls)) {
				row.addCls(this.rowCollapsedCls);
				nextBd.addCls(this.rowBodyHiddenCls);
				this.recordsExpanded[record.internalId] = false;
				thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
			}
		},
		afterMainRender: function()
		{
			Ext.getCmp('showAll').setText(intnlLabel10);
			Ext.Ajax.request(
			{
				url:'/final/admin/AggregateShowTypes/data/aggShowTypesJSON.jsp',
				params : 'operation='+operation+'&element='+element+'&name='+name,
				method:'POST',
				async:false,
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						Ext.getCmp('searchBox').enable();
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						Ext.getCmp('resultGrid').show();
						Ext.getCmp('addAllButton').show();
						Ext.getCmp('noAssociation').hide()
						var resultsData = publicJSON['gridValues'];
						Ext.getCmp('resultGrid').getStore().loadRawData(resultsData);
					}
				}
			});
		},
		callAddAll: function()
		{
			addAll();
		},
		back: function()
		{
			window.location.href="aggDispServer.jsp?qctr=0&reqfrom=navlink&isAggregateLink=true?fromWizard="+fromWizard+'&compGlanceCompType='+compGlanceCompType;
		},
		egTitleSearch: function()
		{
			var searchStr = Ext.getCmp('searchBox').getValue();
			if (searchStr == "" || searchStr .length == 0)
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');
			}
			//var visible = Ext.getCmp('no_search_found').isVisible();
			if(searchStr !=null)
			{
				Ext.Ajax.request({
				url: 'AggregateShowTypes/data/aggShowTypesJSON.jsp?operation='+operation+'&egTitleSearchStr='+searchStr,
				method: 'POST',
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}

					var value = publicJSON['gridValues'];
					if(value != null && value.length > 0)
					{
						Ext.getCmp('resultGrid').show();
						Ext.getCmp('addAllButton').show();
						//Ext.getCmp('no_search_found').hide();
						Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridValues']);
						Ext.getCmp('showAll').enable();
					}
					else
					{
						Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridValues']);
						var gridcount =Ext.getCmp('resultGrid').getStore().getCount();
						if(gridcount == 0)
						{
							//Ext.getCmp('resultGrid').hide();
							Ext.getCmp('addAllButton').hide();
							//Ext.getCmp('no_search_found').show();
							Ext.getCmp('resultGrid').getStore().removeAll();
							Ext.get('noCompAlrtDiv').update(srcNotFnd);
							Ext.get('noCompAlrtDiv').update(srcNotFnd);
							Ext.getCmp('showAll').disable();
						}
					}
				}});
			}
		},
		nickTable : function(value)
		{
			var totalData = value.split('#');
			var countCol = 0;
			var j=1;
			var htmlTable = "<table border='1' bordercolor='#E6EBF5' cellpadding='1' ><tr>";
			if(totalData.length>2)
			{
				var count = totalData.length -1;
				for (var i = 0 ;i < count;i++)
				{
					var finalData = totalData[i].split('@');
					if(totalData[i] !="" && count == 2)
					{
						if(finalData[0].indexOf("(") > -1)
						{
							htmlTable = htmlTable + "<td height='20' title='"+finalData[2]+"' width='225' height='20'><a class='eg_monlink' href='"+finalData[1]+"' ><b>"+"&nbsp;"+finalData[0].substring(0,finalData[0].indexOf("("))+"</b></a></td>";
						}
						else
						{
							htmlTable = htmlTable + "<td height='20' title='"+finalData[2]+"' width='225' height='20'><a class='eg_monlink' href='"+finalData[1]+"' >"+"&nbsp;"+finalData[0]+"</a></td>";
						}
					}
					else
					{
						countCol++;
						if(countCol == 3)
						{
							htmlTable = htmlTable + "<td height='20' title='"+finalData[2]+"' width='150' height='20'><a class='eg_monlink' href='"+finalData[1]+"' >"+"&nbsp;"+finalData[0]+"</a></td></tr><tr>";
							countCol = 0;
						}
						else
						{
							if(finalData[0].indexOf("(") > -1)
							{
								htmlTable = htmlTable + "<td height='20' title='"+finalData[2]+"' width='150' height='20'><a class='eg_monlink' href='"+finalData[1]+"' ><b>"+"&nbsp;"+finalData[0].substring(0,finalData[0].indexOf("("))+"</b></a></td>";
							}
							else
							{
								htmlTable = htmlTable + "<td height='20' title='"+finalData[2]+"' width='150' height='20'><a class='eg_monlink' href='"+finalData[1]+"' >"+"&nbsp;"+finalData[0]+"</a></td>";
							}
						}
					}
				}
				if(countCol == 2)
				{
					htmlTable = htmlTable + "<td width='150'>&nbsp;</td>";
				}
				else if(countCol == 1)
				{
					htmlTable = htmlTable + "<td>&nbsp;</td>";
					htmlTable = htmlTable + "<td>&nbsp;</td>";
				}
				htmlTable = htmlTable + "</tr></table>";
				return htmlTable;
			}
			else
			{
				if(value.indexOf('#')>0 && value.indexOf('@')>0)
				{
					var val_array= new Array();
					val_array = value.split('@');
					if(val_array[0].indexOf("(") > -1)
					{
						htmlTable = htmlTable + "<td width='450' height='20'><a class='eg_monlink' href='"+val_array[1]+"' title='"+val_array[2].substring(0,val_array[2].indexOf('#'))+"'><b>"+"&nbsp;"+val_array[0].substring(0,val_array[0].indexOf("("))+"</b></a></td></tr></table>";
						return htmlTable;
					}
					else
					{
						htmlTable = htmlTable + "<td width='450' height='20'><a class='eg_monlink' href='"+val_array[1]+"' title='"+val_array[2].substring(0,val_array[2].indexOf('#'))+"'>"+"&nbsp;"+val_array[0]+"</a></td></tr></table>";
						return htmlTable;
					}
				}
				else
				{
					return value;
				}
			}
		}
});
function addAll()
{
	var max_allowed_0_msg='';
	var count = 0;
	var max_allowed = 0;
	if(publicJSON['allowed_count'] != null && publicJSON['allowed_count'] != 'undefined')
	{
		max_allowed = parseInt(publicJSON['allowed_count']);
		max_allowed_0_msg = publicJSON['allowed_count_0_msg'];
	}
	var selectedObj = Ext.getCmp('resultGrid').getSelectionModel();
	var gridStore = Ext.getCmp('resultGrid').getStore();
	var component_types = "";
	for(var i=0;i<gridStore.getCount();i++)
	{
		if(selectedObj.isSelected(gridStore.getAt(i)) )
		{
			count++;
			if(component_types.length==0) {
				component_types = gridStore.getAt(i).get('agg_type');
			}
			else {
				component_types += "," + gridStore.getAt(i).get('agg_type');
			}
		}
	}
	if(max_allowed!=-1 && count>max_allowed)
	{
		if(max_allowed==0)
		{
			Ext.MessageBox.alert(infoTitle,max_allowed_0_msg);
		}
		else if(max_allowed==1)
		{
			Ext.MessageBox.alert(infoTitle,licence_allow_onlyone);
		}
		else
		{
			Ext.MessageBox.alert(infoTitle,countExceed + ' ' + (count-max_allowed));
		}
	}
	else if(component_types.length>0)
	{
		Ext.getCmp('selected_server_types').setValue(component_types);
		var formObj = Ext.getCmp("formpanel").getForm();
		if(formObj.isValid())
		{
			formObj.submit({
				url:'/final/admin/aggAddAll.jsp',
				method: 'POST',
				standardSubmit: true,
				success: function(form, action){
				}
			})
		}
		else
		{
			Ext.MessageBox.alert(infoTitle,invalid_form);
		}
	}
	else
	{
		Ext.MessageBox.alert(infoTitle,notSelectd);
	}
}
