Ext.define("AggregateShowTypes.view.FormPanel", {
	extend:'Ext.form.Panel',
	//extend:'utilities.innerScrollContainer',
	alias: "widget.formPanel",
	margin:'8 8 0 0',

	ui:'simplePanel simplePanelHeaderBorder',

	//cls: 'outerpanel',
	id: "formpanel",
	title:homeTitle,
	//header:{cls:'textUpper'},

	requires: [
		'Ext.ux.RowExpander',
		'utilities.ScrollCombo',
		'Ext.grid.*',
		'utilities.CustomGrid'
	],

	layout: {
		type:'vbox',
		align:'stretch'
	},

	/*dockedItems:[
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDesc+'.</center>'
				}
			]
		}
	],*/

	items: [
		{
			xtype: 'customgrid',
			id:'resultGrid',
			cls:'gridSkin',
			title:gridTitle,
			store:Ext.create('Ext.data.Store',{
				fields:['agg_type','componentType', 'nickname', 'action', 'isShow'],
				data:[]
			}),
			autoScroll: true,
			scroll: true,
			flex: 1,
			selModel: Ext.create('Ext.selection.CheckboxModel',{
				renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
					var baseCSSPrefix = Ext.baseCSSPrefix;
					metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
					return '<div class="' + baseCSSPrefix + 'grid-row-checker" role="presentation">&#160;</div>';
				},
			}),
			plugins: [
				{
					ptype: 'rowexpander',
					rowBodyTpl: [
						'{nickname}'
					]
				}
			],
			emptyText: LoadAlert1,
			viewConfig: {
				deferEmptyText: false
			},
			columns:[
				{
					dataIndex: 'agg_type',
					hidden:true,
				},
				{
					text: component_type,
					dataIndex: 'componentType',
					flex: 1,
					sortable:false,
					draggable : false,
					menuDisabled : true,
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdCls += 'x-grid-cell-row-checker';
						return value;
					}
				},
				{
					xtype: 'actioncolumn',
					cls: 'tasks-icon-column-header tasks-edit-column-header x-gns-grid-padding',
					width: 36,
					iconCls:'iconModify',
					//icon: '../../../../resources/images/edit_task.png',
					//iconCls: 'x-hidden',
					//tooltip: 'Modify',
					sortable:false,
					draggable : false,
					menuDisabled : true,
					border:false,
					handler: function(grid, rowIndex, colIndex) {
						var rec = grid.getStore().getAt(rowIndex);
						var URL=rec.get('action');
						var temp = URL.split("@");
						if(rec.get('isShow').indexOf('true&m')==0)
						{
							if(temp[0].lastIndexOf('.jsp') == temp[0].length - 4)
							{
								temp[0] +="?fromWizard="+fromWizard;
							}
							else
							{
								temp[0] +="&fromWizard="+fromWizard;
							}

							if (!Ext.isEmpty(compGlanceCompType))
							{
								temp[0] +='&compGlanceCompType='+compGlanceCompType;
							}

							window.location.href=temp[0];
						}
					},
					defaultRenderer: function(v, meta, record, rowIdx, colIdx, store, view)
					{
						var agg_component_created_for_this_type = 'no';
						if(store.getAt(rowIdx).get('isShow').indexOf('true&m')==0)
						{
							agg_component_created_for_this_type = 'yes';
						}
						var me = this,
						prefix = Ext.baseCSSPrefix,
						scope = me.origScope || me,
						items = me.items,
						len = items.length,
						i = 0,
						item, ret, disabled, tooltip;
						ret = Ext.isFunction(me.origRenderer) ? me.origRenderer.apply(scope, arguments) || '' : '';
						meta.tdCls += ' ' + Ext.baseCSSPrefix + 'action-col-cell x-gns-grid-padding';
						meta.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						for (; i < len; i++)
						{
							item = items[i];
							if(agg_component_created_for_this_type=='yes')
							{
								disabled = item.disabled || (item.isDisabled ? item.isDisabled.call(item.scope || scope, view, rowIdx, colIdx, item, record) : false);
							}
							else
							{
								disabled = true;
							}
							tooltip = disabled ? null : (item.tooltip || (item.getTip ? item.getTip.apply(item.scope || scope, arguments) : null));
							if (!item.hasActionConfiguration)
							{
								item.stopSelection = me.stopSelection;
								item.disable = Ext.Function.bind(me.disableAction, me, [i], 0);
								item.enable = Ext.Function.bind(me.enableAction, me, [i], 0);
								item.hasActionConfiguration = true;
							}
							ret += '<img role="button" alt="' + (item.altText || me.altText) + '" src="' + (item.icon || Ext.BLANK_IMAGE_URL) +
								'" class="' + prefix + 'action-col-icon ' + prefix + 'action-col-' + String(i) + ' ' + (disabled ? prefix + 'item-disabled' : ' ') +
								' ' + (Ext.isFunction(item.getClass) ? item.getClass.apply(item.scope || scope, arguments) : (item.iconCls || me.iconCls || '')) + '"' +
								(tooltip ? ' data-qtip="' + tooltip + '"' : '') + ' />';
						}
						return ret;
					}
				},
				{
					xtype: 'actioncolumn',
					cls: 'tasks-icon-column-header tasks-edit-column-header x-gns-grid-padding',
					width: 36,
					id: 'EditOver',
					iconCls:'iconAddServer',
					//icon: '../../../../resources/images/edit_task.png',
					//iconCls: 'x-hidden',
					//tooltip: 'Add',
					sortable:false,
					draggable : false,
					menuDisabled : true,
					handler: function(grid, rowIndex, colIndex)
					{
						var rec = grid.getStore().getAt(rowIndex);
						var URL=rec.get('action');
						var temp = URL.split("@");

						if(temp[1].lastIndexOf('.jsp') == temp[1].length - 4)
						{
							temp[1] +="?fromWizard="+fromWizard;
						}
						else
						{
							temp[1] +="&fromWizard="+fromWizard;
						}

						if (!Ext.isEmpty(compGlanceCompType))
						{
							temp[1] +='&compGlanceCompType='+compGlanceCompType;
						}
						window.location.href=temp[1];
					},
					defaultRenderer: function(v, meta, record, rowIdx, colIdx, store, view)
					{
						var me = this,
						prefix = Ext.baseCSSPrefix,
						scope = me.origScope || me,
						items = me.items,
						len = items.length,
						i = 0,
						item, ret, disabled, tooltip;
						ret = Ext.isFunction(me.origRenderer) ? me.origRenderer.apply(scope, arguments) || '' : '';
						meta.tdCls += ' ' + Ext.baseCSSPrefix + 'action-col-cell x-gns-grid-padding';
						meta.tdAttr = "data-qtip='Add' data-qclass='yellowTip'";
						for (; i < len; i++)
						{
							item = items[i];
							disabled = item.disabled || (item.isDisabled ? item.isDisabled.call(item.scope || scope, view, rowIdx, colIdx, item, record) : false);
							tooltip = disabled ? null : (item.tooltip || (item.getTip ? item.getTip.apply(item.scope || scope, arguments) : null));
							if (!item.hasActionConfiguration)
							{
								item.stopSelection = me.stopSelection;
								item.disable = Ext.Function.bind(me.disableAction, me, [i], 0);
								item.enable = Ext.Function.bind(me.enableAction, me, [i], 0);
								item.hasActionConfiguration = true;
							}
							ret += '<img role="button" alt="' + (item.altText || me.altText) + '" src="' + (item.icon || Ext.BLANK_IMAGE_URL) +
								'" class="' + prefix + 'action-col-icon ' + prefix + 'action-col-' + String(i) + ' ' + (disabled ? prefix + 'item-disabled' : ' ') +
								' ' + (Ext.isFunction(item.getClass) ? item.getClass.apply(item.scope || scope, arguments) : (item.iconCls || me.iconCls || '')) + '"' +
								(tooltip ? ' data-qtip="' + tooltip + '"' : '') + ' />';
						}
						return ret;
					}
				},
				{
					xtype: 'actioncolumn',
					cls: 'tasks-icon-column-header tasks-delete-column-header x-gns-grid-padding',
					width: 36,
					id: 'DeleteOver',
					iconCls:'iconUnmanage',
					//icon: '../../../../resources/images/delete.png',
					//iconCls: 'x-hidden',
					//tooltip: 'UnManage',
					sortable:false,
					draggable : false,
					menuDisabled : true,
					handler: function(grid, rowIndex, colIndex)
					{
						var rec = grid.getStore().getAt(rowIndex);
						var URL=rec.get('action');
						var temp = URL.split("@");
						if(rec.get('isShow').indexOf('true&m')==0)
						{
							if(temp[2].lastIndexOf('.jsp') == temp[2].length - 4)
							{
								temp[2] +="?fromWizard="+fromWizard;
							}
							else
							{
								temp[2] +="&fromWizard="+fromWizard;
							}

							if (!Ext.isEmpty(compGlanceCompType))
							{
								temp[2] +='&compGlanceCompType='+compGlanceCompType;
							}

							parent.window.location.href=temp[2];
						}
					},
					defaultRenderer: function(v, meta, record, rowIdx, colIdx, store, view)
					{
						var agg_component_created_for_this_type = 'no';
						if(store.getAt(rowIdx).get('isShow').indexOf('true&m')==0)
						{
							agg_component_created_for_this_type = 'yes';
						}
						var me = this,
						prefix = Ext.baseCSSPrefix,
						scope = me.origScope || me,
						items = me.items,
						len = items.length,
						i = 0,
						item, ret, disabled, tooltip;
						ret = Ext.isFunction(me.origRenderer) ? me.origRenderer.apply(scope, arguments) || '' : '';
						meta.tdCls += ' ' + Ext.baseCSSPrefix + 'action-col-cell x-gns-grid-padding';
						meta.tdAttr = "data-qtip='Unmanage' data-qclass='yellowTip'";
						for (; i < len; i++)
						{
							item = items[i];
							if(agg_component_created_for_this_type=='yes')
							{
								disabled = item.disabled || (item.isDisabled ? item.isDisabled.call(item.scope || scope, view, rowIdx, colIdx, item, record) : false);
							}
							else
							{
								disabled = true;
							}
							tooltip = disabled ? null : (item.tooltip || (item.getTip ? item.getTip.apply(item.scope || scope, arguments) : null));

							if (!item.hasActionConfiguration)
							{
								item.stopSelection = me.stopSelection;
								item.disable = Ext.Function.bind(me.disableAction, me, [i], 0);
								item.enable = Ext.Function.bind(me.enableAction, me, [i], 0);
								item.hasActionConfiguration = true;
							}
							ret += '<img role="button" alt="' + (item.altText || me.altText) + '" src="' + (item.icon || Ext.BLANK_IMAGE_URL) +
								'" class="' + prefix + 'action-col-icon ' + prefix + 'action-col-' + String(i) + ' ' + (disabled ? prefix + 'item-disabled' : ' ') +
								' ' + (Ext.isFunction(item.getClass) ? item.getClass.apply(item.scope || scope, arguments) : (item.iconCls || me.iconCls || '')) + '"' +
								(tooltip ? ' data-qtip="' + tooltip + '"' : '') + ' />';
						}
						return ret;
					}
				}
			],
			margin: 10,
			tools: [
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					id:'searchBox',
					margin:0,
					name:'searchBox',
					cls:'whitedropdown_search',
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						appCnt.egTitleSearch();
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					disabled: true
				},

				{
					xtype: 'button',
					text: intnlLabel10,
					isModified : 'false',
					cls:'button20',
					style:{'margin-left':'10px'},
					id: 'showAll',
					status : 'hidden'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype:'button',
					id:'addAllButton',
					text:addAllButton,
					cls:'button20',
					margin:'0 0 10 0'
				}
			]
		},
		/*{
			xtype:'label',
			hidden:true,
			id:'no_search_found',
			style:{fontSize: '12px','text-align':'center'},
			html:"<div style='margin:25% auto auto auto'><table border='0' width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+noSearchComponentFound+"</div></td></tr></table></div>"
		},*/
		{
			xtype:'label',
			hidden:true,
			id:'noAssociation',
			style:{fontSize: '12px','text-align':'center',fontWeight:'bold'},
			html:"<div style='margin:25% auto auto auto'><table border='0' width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+noAssociationFound+"</div></td></tr></table></div>"
		},
		{
			xtype:'hidden',
			name:'selected_server_types',
			id:'selected_server_types'
		}
	],
	listeners: {
		close: function() 
		{
			if (!Ext.isEmpty(compGlanceCompType))
			{
				window.parent.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+compGlanceCompType;
			}
			else
			{
				window.parent.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
			}
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDesc+'.',
				cls: "adminInfoTooltip"
			});
		}
		
	},
	tools : [
		{
			xtype : 'button',
			id : 'backbutton',
			cls:'backbutton',
			iconCls:'iconBack',
			text : 'Back',
			hidden: true
		}
	]

});



