<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgAggregateInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("text/html;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	String agg_test_name = request.getParameter("agg_test_name");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	Vector aggComponentTypes = aggregateInfo.getAggregateTypes();
	ArrayList serverList = new ArrayList();
	MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
	if(aggComponentTypes != null && aggComponentTypes.size()>0)
	{
		for(int i=0;i<aggComponentTypes.size();i++)
		{
			String aggComponentType = (String)aggComponentTypes.get(i);
			String[] tests = specsInfo.getDefaultTestsForServer(aggComponentType);
			if(agg_test_name != null && (agg_test_name=agg_test_name.trim()).length()>0)
			{
				if(tests != null && tests.length>0 && Arrays.asList(tests).contains(agg_test_name))
				{
					String[] components = discInfo.getAllServersOfType(aggComponentType);
					if(components !=null && components.length > 0)
					{
						serverList.add(aggComponentType);
					}
				}
			}
		}
		if(serverList.size()>0)
		{
			serverList = sorter.getSortedCompTypeList(serverList);
		}
	}
	int componentTypesCount = serverList.size();
	if(componentTypesCount > 0)
	{
		JSONArray upperRowDataArray = new JSONArray();
		JSONObject upperRowData = new JSONObject();

		String array[] = {"upper_measures_name1","upper_measures_name2","upper_measures_name3"};

		EgName nameObj = null;
		for(int j=0;j<componentTypesCount;j=j+3)
		{
			int i=0;
			for (int k=j;k<j+3;k++)
			{
				if(k < componentTypesCount)
				{
					nameObj = (EgName)serverList.get(k);
					String localizedName = nameObj.getLocalName();
					String strCompDisplay = localizedName;
					upperRowData.put(array[i++],strCompDisplay);
				}
				else
				{
					upperRowData.put(array[i++],"");
				}
			}
			upperRowDataArray.add(upperRowData);
		}
		rootJson.put("upperRowDataArray",upperRowDataArray);
		JSONObject header = new JSONObject();
		header.put("headername",_mapping.getTextDescription("admin.test.Associated Aggregate Component Types for test") + " "+_mapping.getTestDescription(agg_test_name));
		rootJson.put("gridheader",header);
	}
	else
	{
		JSONObject messageText = new JSONObject();
		messageText.put("text",_mapping.getTestDescription(agg_test_name)+" " +_mapping.getTextDescription("admin.server.test is not yet associated to aggregate component type"));
		rootJson.put("message",messageText);
	}
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>



