Ext.define('AggregateTests.controller.Main',{
	extend:'Ext.app.Controller',
	requires:["AggregateTests.view.Description","AggregateTests.view.DynamicGrid"],
	views:['FormItems','PercentFormItems'],
	refs:[
		{selector:'FormItems', ref:'FormItems'},
		{selector:'PercentFormItems', ref:'PercentFormItems'},
		{selector:'defaultthresholds', ref:'defaultthresholds'},
		{selector:'configurethresholds', ref:'configurethresholds'}
	],
	init:function(){
		me = this,
		this.control({
			'aggtestform':
			{
				'afterrender': this.afterMainRender
			},
			'aggtestform combo[id="component_types"]':
			{
				'select': this.changeComponentType
			},
			'aggtestform combo[id="test"]':
			{
				'select': this.reloadPage
			},
			'aggtestform combo[id="aggTest"]':
			{
				'select': this.reloadAggPage
			},
			'aggtestform combo[id="allowedId"]':
			{
				'select': this.showHideGridColumn
			},
			'aggtestform button[id="addMeasures"]':
			{
				'click': this.update_intermediate
			},
			'aggtestform button[id="modifyMeasures"]':
			{
				'click': this.update_intermediate
			},
			'aggtestform button[id="deleteMeasures"]':
			{
				'click': this.update_intermediate
			},
			'aggtestform button[id="appendMeasures"]':
			{
				'click': this.update_intermediate
			},
			'aggtestform button[id="backButton"]':
			{
				'click': this.goback
			},
			'aggtestform button[id="showAll"]':
			{
				'click':this.showPopup
			},
			'defaultthresholds':
			{
				'afterrender': this.gotoDefaultThresholdPage
			},
			'defaultthresholds [id="measureGrid"]':
			{
				itemmouseenter: this.showModifyTool,
				itemmouseleave: this.hideModifyTool
			},
			//'defaultthresholds [id="noMeasureGrid"]':
			//{
				//'itemmouseenter': this.showModifyTool,
				//'itemmouseleave': this.hideModifyTool
			//},
			'defaultthresholds [id="noMeasureGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'defaultthresholds button[id="fromDefaultBackBtn"]':
			{
				'click': this.goback,
			},
			'defaultthresholds button[id="submitBtn"]':
			{
				'click': this.submitData,
			},
			'configurethresholds':
			{
				'boxready': this.configureMainRender,
			},
			'configurethresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			},
			'configurethresholds button[id="configureBackBtn"]':
			{
				'click': this.configureThresholdsPageBack,
			},
			'configurethresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurethresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurethresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurethresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurethresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurethresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'configurethresholds checkbox[id="minStaticCheck"]':
			{
				'change': this.minStaticCheckChange,
			},
			'configurethresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurethresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurethresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurethresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			},
			'percentformitems button[id="updatePctMeasures"]':
			{
				'click': this.update
			}
		});
	},
	defaultThreshBack : function()
	{
		var aggTestName = publicJson['testName'];
		window.location.href = '/final/admin/aggShowComponentTypes.jsp?agg_test_name='+aggTestName;
	},
	goback: function()
	{
		window.location.href="/final/admin/aggDisplayTests.jsp";
	},
	afterMainRender : function()
	{
		Ext.Ajax.request({
			url : '/final/admin/AggregateTests/data/aggAddTestJson.jsp?'+queryString,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				operation = publicJSON['parameters']['s_operation'];
				if(operation=="addMeasures")
				{
					var gobj = Ext.getCmp('upper_measures_grid');
					gobj.columns[4].setVisible(false);
					gobj.columns[5].setVisible(false);
					gobj.columns[6].setVisible(false);
					gobj.columns[7].setVisible(false);
					gobj.columns[8].setVisible(false);
					if(current_testfor == "managedtests") {
						Ext.getCmp('managedcomponents').setValue(true);
					}
					else {
						Ext.getCmp('allcomponents').setValue(true);
					}
					Ext.getCmp("addtestcontainer").show();
					Ext.getCmp("addMeasures").show();
					Ext.getCmp("addMeasures").setText(publicJSON['labels']['Include']);
					Ext.getCmp("modifyMeasures").hide();
					Ext.getCmp("deleteMeasures").hide();
					Ext.getCmp("modifytestcontainer").hide();

					Ext.getCmp("testforId").setFieldLabel(publicJSON['labels']['Aggregate']);
					Ext.getCmp("managedcomponents").boxLabelEl.update(publicJSON['labels']['Managed_Components']);
					Ext.getCmp("allcomponents").boxLabelEl.update(publicJSON['labels']['All_Components']);

					Ext.getCmp("component_types").show();
					Ext.getCmp("component_types").clearValue();
					Ext.getCmp("component_types").setFieldLabel(publicJSON['labels']['Filter_by_component_type']);
					Ext.getCmp('component_types').getStore().clearFilter(true);
					Ext.getCmp('component_types').getStore().loadRawData(publicJSON['component_types']);
					var selected_component_type = publicJSON['parameters']['s_component_type'];
					if(selected_component_type != null && selected_component_type != 'undefined' && selected_component_type != '-1')
					{
						Ext.getCmp('component_types').setValue(selected_component_type);
						Ext.getCmp("test").show();
					}
					else
					{
						Ext.getCmp('component_types').setValue("-1");
						Ext.getCmp("test").hide();
					}

					Ext.getCmp("test").clearValue();
					Ext.getCmp("test").setFieldLabel(publicJSON['labels']['Test_to_be_aggregated']);
					Ext.getCmp('test').getStore().clearFilter(true);
					Ext.getCmp('test').getStore().loadRawData(publicJSON['tests']);
					Ext.getCmp('test').setValue("-1");

					var selected_test_name = publicJSON['parameters']['s_test'];
					if(selected_test_name == null || selected_test_name == 'undefined' || selected_test_name == '-1')
					{
						Ext.getCmp('test').setValue("-1");
					}
					else
					{
						Ext.getCmp('test').setValue(selected_test_name);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('aggTestDispName').setFieldLabel(publicJSON['labels']['Aggregate_test_display_name']);
						Ext.getCmp('allowedId').show();
						Ext.getCmp('aggTestDispName').setValue(publicJSON['displayaggname']['displayname']);
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('upper_measures_button_container').show();
						Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Available_measures_for']);
						s_aggTest = publicJSON['new_aggTest']['s_aggTest'];
						var mygrid = Ext.getCmp('upper_measures_grid');
						mygrid.columns[7].setVisible(false);
						var agg_fun_column = mygrid.query('gridcolumn')[3];
						if(publicJSON.condition_fn_found_in_upper_grid)
						{
							agg_fun_column.flex = 1;
						}
						else
						{
							if(agg_fun_column.flex)
							{
								delete agg_fun_column.flex;
							}
							agg_fun_column.setWidth(200);
						}
						mygrid.doLayout();
					}
				}
				else
				{
					Ext.getCmp("addMeasures").hide();

					Ext.getCmp("modifyMeasures").show();
					Ext.getCmp("modifyMeasures").setText(publicJSON['labels']['Modify']);

					Ext.getCmp("deleteMeasures").show();
					Ext.getCmp("deleteMeasures").setText(publicJSON['labels']['Exclude']);

					Ext.getCmp("addtestcontainer").hide();
					Ext.getCmp("modifytestcontainer").show();

					Ext.getCmp("aggTest").setFieldLabel(publicJSON['labels']['Aggregate_test_name']);

					Ext.getCmp("aggTest").clearValue();
					Ext.getCmp('aggTest').getStore().loadRawData(publicJSON['aggTests']);
					Ext.getCmp('aggTest').setValue(s_aggTest);
					Ext.getCmp('modify_aggTestDispName').setFieldLabel(publicJSON['labels']['Aggregate_test_display_name']);
					Ext.getCmp('modify_aggTestDispName').setValue(publicJSON.modify_displayaggname);
					var m_radio_obj = Ext.getCmp('modify_allowedId');
					m_radio_obj.setVisible(true);
					if(publicJSON.descriptorAggregation=='false')
						m_radio_obj.items.items[0].setValue(true);
					else
						m_radio_obj.items.items[1].setValue(true);
					Ext.getCmp('upper_measures_grid').show();
					Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Included_measures_for']);
					var gridColumns = publicJSON['gridColumns'];
					for(var key in gridColumns)
					{
						if(key == 0 || key == 4)
							continue;
						Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
					}
					Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
					Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
					Ext.getCmp('upper_measures_button_container').show();

					var mygrid = Ext.getCmp('upper_measures_grid');
					if(publicJSON.descriptorAggregation=='true') {
						mygrid.columns[7].setVisible(true);
					}
					else {
						mygrid.columns[7].setVisible(false);
					}
					measures_exist = new Array();
					var existingMeasures = publicJSON['existingMeasures'];
					for(var key in existingMeasures)
					{
						measures_exist.push(existingMeasures[key]);
					}
					var mygrid = Ext.getCmp('upper_measures_grid');
					var agg_fun_column = mygrid.query('gridcolumn')[3];
					if(publicJSON.condition_fn_found_in_upper_grid)
					{
						mygrid.columns[4].setVisible(true);
						mygrid.columns[5].setVisible(true);
						mygrid.columns[6].setVisible(true);
						//mygrid.columns[7].setVisible(true);// don't change
						mygrid.columns[8].setVisible(true);
						agg_fun_column.flex = 1;
					}
					else
					{
						mygrid.columns[4].setVisible(false);
						mygrid.columns[5].setVisible(false);
						mygrid.columns[6].setVisible(false);
						mygrid.columns[7].setVisible(false);
						mygrid.columns[8].setVisible(false);
						if(agg_fun_column.flex) {
							delete agg_fun_column.flex;
						}
						agg_fun_column.setWidth(200);
					}
					mygrid.doLayout();
					Ext.getCmp('upper_measures_grid').getView().refresh();

					if(publicJSON['lowerRowDataArray'] != null && publicJSON['lowerRowDataArray'] != 'undefined')
					{
						Ext.getCmp('lower_measures_grid').show();
						Ext.getCmp('lower_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('lower_measures_grid').getStore().loadRawData(publicJSON['lowerRowDataArray']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('lower_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('lower_measures_grid').show();
						Ext.getCmp('lower_measures_button_container').show();
						Ext.getCmp('lower_measures_grid').setTitle(publicJSON['labels']['Excluded_measures_for']);
						Ext.getCmp("appendMeasures").setText(publicJSON['labels']['Include']);
						var mygrid = Ext.getCmp('lower_measures_grid');
						if(publicJSON.descriptorAggregation=='true') {
							mygrid.columns[7].setVisible(true);
						}
						else {
							mygrid.columns[7].setVisible(false);
						}
						var agg_fun_column = mygrid.query('gridcolumn')[3];
						if(publicJSON.condition_fn_found_in_lower_grid)
						{
							mygrid.columns[4].setVisible(true);
							mygrid.columns[5].setVisible(true);
							mygrid.columns[6].setVisible(true);
							//mygrid.columns[7].setVisible(true);// don't change
							mygrid.columns[8].setVisible(true);
							agg_fun_column.flex = 1;
						}
						else
						{
							mygrid.columns[4].setVisible(false);
							mygrid.columns[5].setVisible(false);
							mygrid.columns[6].setVisible(false);
							mygrid.columns[7].setVisible(false);
							mygrid.columns[8].setVisible(false);
							if(agg_fun_column.flex) {
								delete agg_fun_column.flex;
							}
							agg_fun_column.setWidth(200);
						}
						mygrid.doLayout();
						Ext.getCmp('lower_measures_grid').getView().refresh();
					}
					else
					{
						Ext.getCmp('lower_measures_grid').hide();
						Ext.getCmp('lower_measures_button_container').hide();
					}
					s_test = publicJSON['s_test']['s_ind_test'];
					superMeasureMap = null;
					pctMeasureNamesArray=null;
					if(publicJSON['superMeasureMap'] != null)
					{
						superMeasureMap=publicJSON['superMeasureMap'];
						pctMeasureNamesArray=publicJSON['pctMeasureNamesArray'];
					}
				}
			},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageLabel,"Could not load aggAddTestJson.jsp");
			}
		});
	},
	reloadPage : function()
	{
		var s_component_type = Ext.getCmp('component_types').getValue();
		var s_test = Ext.getCmp('test').getValue();
		if(s_test != null && s_test == "-1") {
			queryString = "operation=addMeasures&s_test=-1&testfor="+current_testfor+"&s_component_type="+s_component_type;
		}
		else {
			queryString = "operation=addMeasures&s_test=" +s_test+"&testfor="+current_testfor+"&s_component_type="+s_component_type;
		}
		Ext.Ajax.request({
			url : '/final/admin/AggregateTests/data/aggAddTestJson.jsp?'+queryString,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				operation = publicJSON['parameters']['s_operation'];
				if(operation=="addMeasures")
				{
					if(current_testfor == "managedtests") {
						Ext.getCmp('managedcomponents').setValue(true);
					}
					else {
						Ext.getCmp('allcomponents').setValue(true);
					}
					Ext.getCmp("addtestcontainer").show();
					Ext.getCmp("addMeasures").show();
					Ext.getCmp("addMeasures").setText(publicJSON['labels']['Include']);
					Ext.getCmp("modifyMeasures").hide();
					Ext.getCmp("deleteMeasures").hide();
					Ext.getCmp("modifytestcontainer").hide();

					Ext.getCmp("testforId").setFieldLabel(publicJSON['labels']['Aggregate']);
					Ext.getCmp("managedcomponents").boxLabelEl.update(publicJSON['labels']['Managed_Components']);
					Ext.getCmp("allcomponents").boxLabelEl.update(publicJSON['labels']['All_Components']);

					Ext.getCmp("component_types").show();
					Ext.getCmp("component_types").clearValue();
					Ext.getCmp("component_types").setFieldLabel(publicJSON['labels']['Filter_by_component_type']);
					Ext.getCmp('component_types').getStore().clearFilter(true);
					Ext.getCmp('component_types').getStore().loadRawData(publicJSON['component_types']);
					var selected_component_type = publicJSON['parameters']['s_component_type'];
					if(selected_component_type != null && selected_component_type != 'undefined' && selected_component_type != '-1')
					{
						Ext.getCmp('component_types').setValue(selected_component_type);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('upper_measures_grid').show();
					}
					else
					{
						Ext.getCmp('component_types').setValue("-1");
						Ext.getCmp('aggTestDispName').hide();
						Ext.getCmp('allowedId').hide();
						Ext.getCmp('upper_measures_grid').hide();
					}

					Ext.getCmp("test").clearValue();
					Ext.getCmp("test").setFieldLabel(publicJSON['labels']['Test_to_be_aggregated']);
					Ext.getCmp('test').getStore().clearFilter(true);
					Ext.getCmp('test').getStore().loadRawData(publicJSON['tests']);
					Ext.getCmp('test').setValue("-1");

					var selected_test_name = publicJSON['parameters']['s_test'];
					if(selected_test_name == null || selected_test_name == 'undefined' || selected_test_name == '-1')
					{
						Ext.getCmp('test').setValue("-1");
						Ext.getCmp('aggTestDispName').hide();
						Ext.getCmp('allowedId').hide();
						Ext.getCmp('upper_measures_grid').hide();
						Ext.getCmp('upper_measures_button_container').hide();
					}
					else
					{
						Ext.getCmp('test').setValue(selected_test_name);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('aggTestDispName').setFieldLabel(publicJSON['labels']['Aggregate_test_display_name']);
						Ext.getCmp('allowedId').show();
						Ext.getCmp('upper_measures_button_container').show();
						Ext.getCmp('allowedId').setValue({'descriptorAggregation': 'false'});// by default, aggregate test is descriptor based

						Ext.getCmp('aggTestDispName').setValue(publicJSON['displayaggname']['displayname']);
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Available_measures_for']);
						s_aggTest = publicJSON['new_aggTest']['s_aggTest'];
						var mygrid = Ext.getCmp('upper_measures_grid');
						mygrid.columns[7].setVisible(false);
						/* code starts for setting width for Aggregate Function column of grid */
						var agg_fun_column = mygrid.query('gridcolumn')[3];
						if(publicJSON.condition_fn_found_in_upper_grid)
						{
							agg_fun_column.flex = 1;
						}
						else
						{
							if(agg_fun_column.flex)
							{
								delete agg_fun_column.flex;
							}
							agg_fun_column.setWidth(200);
						}
						mygrid.doLayout();
						/* code ends for setting width for Aggregate Function column of grid */
					}
				}
			},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageLabel,"Could not load aggAddTestJson.jsp");
			}
		});
	},
	reloadAggPage : function()
	{
		s_aggTest = Ext.getCmp('aggTest').getValue();
		if(s_aggTest == null || s_aggTest == "-1")
		{
			Ext.getCmp('upper_measures_grid').hide();
			Ext.getCmp('upper_measures_button_container').hide();
			Ext.getCmp('lower_measures_grid').hide();
			Ext.getCmp('lower_measures_button_container').hide();
		}
		else
		{
			queryString = "operation=modifyMeasures&aggtest="+s_aggTest;
			Ext.Ajax.request({
				url : '/final/admin/AggregateTests/data/aggAddTestJson.jsp?'+queryString,
				method: 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					operation = publicJSON['parameters']['s_operation'];
					if(operation=="modifyMeasures")
					{
						Ext.getCmp("addMeasures").hide();

						Ext.getCmp("modifyMeasures").show();
						Ext.getCmp("modifyMeasures").setText(publicJSON['labels']['Modify']);

						Ext.getCmp("deleteMeasures").show();
						Ext.getCmp("deleteMeasures").setText(publicJSON['labels']['Exclude']);

						Ext.getCmp("addtestcontainer").hide();
						Ext.getCmp("modifytestcontainer").show();

						Ext.getCmp("aggTest").setFieldLabel(publicJSON['labels']['Aggregate_test_name']);

						Ext.getCmp("aggTest").clearValue();
						Ext.getCmp('aggTest').getStore().loadRawData(publicJSON['aggTests']);
						Ext.getCmp('aggTest').setValue(s_aggTest);
						Ext.getCmp('modify_aggTestDispName').setFieldLabel(publicJSON['labels']['Aggregate_test_display_name']);
						Ext.getCmp('modify_aggTestDispName').setValue(publicJSON.modify_displayaggname);
						var m_radio_obj = Ext.getCmp('modify_allowedId');
						m_radio_obj.setVisible(true);
						if(publicJSON.descriptorAggregation=='false')
							m_radio_obj.items.items[0].setValue(true);
						else
							m_radio_obj.items.items[1].setValue(true);
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Included_measures_for']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
						Ext.getCmp('upper_measures_button_container').show();

						var upper_grid_shown = true;
						var lower_grid_shown = false;
						var mygrid = Ext.getCmp('upper_measures_grid');
						if(publicJSON.descriptorAggregation=='true') {
							mygrid.columns[7].setVisible(true);
						}
						else {
							mygrid.columns[7].setVisible(false);
						}
						/* code starts for setting width for Aggregate Function column of grid */
						var agg_fun_column = mygrid.query('gridcolumn')[3];
						if(publicJSON.condition_fn_found_in_upper_grid)
						{
							agg_fun_column.flex = 1;
						}
						else
						{
							if(agg_fun_column.flex)
							{
								delete agg_fun_column.flex;
							}
							agg_fun_column.setWidth(200);
						}
						mygrid.doLayout();
						/* code ends for setting width for Aggregate Function column of grid */
						measures_exist = new Array();
						var existingMeasures = publicJSON['existingMeasures'];
						for(var key in existingMeasures)
						{
							measures_exist.push(existingMeasures[key]);
						}

						if(publicJSON['lowerRowDataArray'] != null && publicJSON['lowerRowDataArray'] != 'undefined')
						{
							lower_grid_shown = true;
							Ext.getCmp('lower_measures_grid').show();
							Ext.getCmp('lower_measures_grid').getSelectionModel().deselectAll();
							Ext.getCmp('lower_measures_grid').getStore().loadRawData(publicJSON['lowerRowDataArray']);
							var gridColumns = publicJSON['gridColumns'];
							for(var key in gridColumns)
							{
								if(key == 0 || key == 4)
									continue;
								Ext.getCmp('lower_measures_grid').columns[key].setText(gridColumns[key]);
							}
							Ext.getCmp('lower_measures_grid').show();
							Ext.getCmp('lower_measures_button_container').show();
							Ext.getCmp('lower_measures_grid').setTitle(publicJSON['labels']['Excluded_measures_for']);
							Ext.getCmp("appendMeasures").setText(publicJSON['labels']['Include']);
							var mygrid = Ext.getCmp('lower_measures_grid');
							if(publicJSON.descriptorAggregation=='true') {
								mygrid.columns[7].setVisible(true);
							}
							else {
								mygrid.columns[7].setVisible(false);
							}
						}
						else
						{
							Ext.getCmp('lower_measures_grid').hide();
							Ext.getCmp('lower_measures_button_container').hide();
						}
						s_test = publicJSON['s_test']['s_ind_test'];
						if(upper_grid_shown)
						{
							var showAllColumns = false;
							var mygrid_upper = Ext.getCmp('upper_measures_grid');
							var gridStore = mygrid_upper.getStore();
							for(var i = 0;i<gridStore.getCount();i++)
							{
								var afn = gridStore.getAt(i).get('upper_aggregate_function').trim();
								if(afn=="Condition" || afn=="Multi-Condition")
								{
									showAllColumns=true;
									break;
								}
							}
							if(showAllColumns)
							{
								mygrid_upper.columns[4].setVisible(true);
								mygrid_upper.columns[5].setVisible(true);
								mygrid_upper.columns[6].setVisible(true);
								//mygrid_upper.columns[7].setVisible(true);
								mygrid_upper.columns[8].setVisible(true);
							}
							else
							{
								mygrid_upper.columns[4].setVisible(false);
								mygrid_upper.columns[5].setVisible(false);
								mygrid_upper.columns[6].setVisible(false);
								mygrid_upper.columns[7].setVisible(false);
								mygrid_upper.columns[8].setVisible(false);
							}
							Ext.getCmp('upper_measures_grid').getView().refresh();
						}
						if(lower_grid_shown)
						{
							var showAllColumns = false;
							var mygrid_lower = Ext.getCmp('lower_measures_grid');
							var gridStore = mygrid_lower.getStore();
							for(var i = 0;i<gridStore.getCount();i++)
							{
								var afn = gridStore.getAt(i).get('lower_aggregate_function').trim();
								if(afn=="Condition" || afn=="Multi-Condition")
								{
									showAllColumns=true;
									break;
								}
							}
							if(showAllColumns)
							{
								mygrid_lower.columns[4].setVisible(true);
								mygrid_lower.columns[5].setVisible(true);
								mygrid_lower.columns[6].setVisible(true);
								//mygrid_lower.columns[7].setVisible(true);
								mygrid_lower.columns[8].setVisible(true);
							}
							else
							{
								mygrid_lower.columns[4].setVisible(false);
								mygrid_lower.columns[5].setVisible(false);
								mygrid_lower.columns[6].setVisible(false);
								mygrid_lower.columns[7].setVisible(false);
								mygrid_lower.columns[8].setVisible(false);
							}
							Ext.getCmp('lower_measures_grid').getView().refresh();
						}

					}
				},
				failure : function(response)
				{
					Ext.MessageBox.alert(pageLabel,"Could not load aggAddTestJson.jsp");
				}
			});
		}
	},
	changeComponentType : function()
	{
		var s_component_type = Ext.getCmp('component_types').getValue();
		queryString = "operation=addMeasures&s_component_type="+s_component_type+"&testfor="+current_testfor;
		Ext.Ajax.request({
			url : '/final/admin/AggregateTests/data/aggAddTestJson.jsp?'+queryString,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				operation = publicJSON['parameters']['s_operation'];
				if(operation=="addMeasures")
				{
					if(current_testfor == "managedtests") {
						Ext.getCmp('managedcomponents').setValue(true);
					}
					else {
						Ext.getCmp('allcomponents').setValue(true);
					}
					Ext.getCmp("addtestcontainer").show();
					Ext.getCmp("addMeasures").show();
					Ext.getCmp("addMeasures").setText(publicJSON['labels']['Include']);
					Ext.getCmp("modifyMeasures").hide();
					Ext.getCmp("deleteMeasures").hide();
					Ext.getCmp("modifytestcontainer").hide();

					Ext.getCmp("testforId").setFieldLabel(publicJSON['labels']['Aggregate']);
					Ext.getCmp("managedcomponents").boxLabelEl.update(publicJSON['labels']['Managed_Components']);
					Ext.getCmp("allcomponents").boxLabelEl.update(publicJSON['labels']['All_Components']);

					Ext.getCmp("component_types").show();
					Ext.getCmp("component_types").clearValue();
					Ext.getCmp("component_types").setFieldLabel(publicJSON['labels']['Filter_by_component_type']);
					Ext.getCmp('component_types').getStore().clearFilter(true);
					Ext.getCmp('component_types').getStore().loadRawData(publicJSON['component_types']);
					var selected_component_type = publicJSON['parameters']['s_component_type'];
					if(selected_component_type != null && selected_component_type != 'undefined' && selected_component_type != '-1')
					{
						Ext.getCmp('component_types').setValue(selected_component_type);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('upper_measures_grid').show();
					}
					else
					{
						Ext.getCmp('component_types').setValue("-1");
						Ext.getCmp('aggTestDispName').hide();
						Ext.getCmp('allowedId').hide();
						Ext.getCmp('upper_measures_grid').hide();
					}

					Ext.getCmp("test").clearValue();
					Ext.getCmp("test").setFieldLabel(publicJSON['labels']['Test_to_be_aggregated']);
					Ext.getCmp('test').getStore().clearFilter(true);
					Ext.getCmp('test').getStore().loadRawData(publicJSON['tests']);
					Ext.getCmp('test').setValue("-1");
					Ext.getCmp('test').show();

					var selected_test_name = publicJSON['parameters']['s_test'];
					if(selected_test_name == null || selected_test_name == 'undefined' || selected_test_name == '-1')
					{
						Ext.getCmp('test').setValue("-1");
						Ext.getCmp('aggTestDispName').hide();
						Ext.getCmp('allowedId').hide();
						Ext.getCmp('upper_measures_grid').hide();
						Ext.getCmp('upper_measures_button_container').hide();
					}
					else
					{
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('test').setValue(selected_test_name);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('allowedId').setValue({'descriptorAggregation': 'false'});// by default, aggregate test is descriptor based
						Ext.getCmp('upper_measures_button_container').show();

						Ext.getCmp('aggTestDispName').setValue(publicJSON['displayaggname']['displayname']);
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Available_measures_for']);
						s_aggTest = publicJSON['new_aggTest']['s_aggTest'];
						var mygrid = Ext.getCmp('upper_measures_grid');
						mygrid.columns[7].setVisible(false);
					}
				}
			},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageLabel,"Could not load aggAddTestJson.jsp");
			}
		});
	},
	update_intermediate:function(obj)
	{
		operation = obj.getId();
		if(operation != "deleteMeasures" && isDuplicateDescriptionFound(operation))
		{
			return false;
		}
		else if(operation=="addMeasures" && !checkTestDispName(Ext.getCmp("aggTestDispName").getValue()))
		{
			Ext.getCmp('aggTestDispName').focus();
			return;
		}
		else if(operation=="modifyMeasures" && !checkTestDispName(Ext.getCmp("modify_aggTestDispName").getValue()))
		{
			Ext.getCmp('modify_aggTestDispName').focus();
			return;
		}

		var column1 = null;
		var column2 = null;
		var column3 = null;
		var gridid = null;
		var s_pluginId = null;
		if(operation=="addMeasures" || operation=="modifyMeasures" || operation=="deleteMeasures")
		{
			s_pluginId = "upper_plugin";
			gridid = "upper_measures_grid";
			column1 = "upper_m_name";
			column2 = "upper_measure_description";
			column3 = "upper_aggregate_function";
			column4 = "upper_relation";
			column5 = "upper_value";
			column6 = "upper_trgt_comp";
			column7 = "upper_target_violation";
			column8 = "upper_measure_value_in";
		}
		else
		{
			s_pluginId = "lower_plugin";
			gridid = "lower_measures_grid";
			column1 = "lower_m_name";
			column2 = "lower_measure_description";
			column3 = "lower_aggregate_function";
			column4 = "lower_relation";
			column5 = "lower_value";
			column6 = "lower_trgt_comp";
			column7 = "lower_target_violation";
			column8 = "lower_measure_value_in";
		}
		var gridObj = Ext.getCmp(gridid);
		var gridPlugin = gridObj.getPlugin(s_pluginId);
		var selectedObj = Ext.getCmp(gridid).getSelectionModel();
		var selectAllRows = "no";
		if(operation == "modifyMeasures" && selectedObj.selected.length ==0)
		{
			selectAllRows = "yes";
		}
		var gridStore = Ext.getCmp(gridid).getStore();
		for(var i=0;i<gridStore.getCount();i++)
		{
			if(selectAllRows == 'yes' || selectedObj.isSelected(gridStore.getAt(i)) )
			{
				var measure_description = gridStore.getAt(i).get(column2).trim();
				if(!checkMeasureDesc(measure_description))
				{
					gridPlugin.startEditByPosition({row: i,column: 2});
					return;
				}
				var aggregate_function = gridStore.getAt(i).get(column3).trim();
				if(aggregate_function=="Condition")
				{
					aggregate_function = "condition";
				}
				else if(aggregate_function=="Multi-Condition")
				{
					aggregate_function = "multi-condition";
				}
				if(aggregate_function=="condition" || aggregate_function=="multi-condition")
				{
					s_trgt_condition = gridStore.getAt(i).get(column4).trim();
					s_trgt_value = gridStore.getAt(i).get(column5).trim();
					trgt_components = gridStore.getAt(i).get(column6).trim();
					if(trgtViolationCheck)
					{
						trgt_violation_by = gridStore.getAt(i).get(column7).trim();
					}
					else
					{
						trgt_violation_by = 'Majority';
					}
					unit_of_measurement = gridStore.getAt(i).get(column8).trim();
					if(s_trgt_condition=='>')
					{
						s_trgt_condition = "GT";
					}
					else if(s_trgt_condition=='<')
					{
						s_trgt_condition = "LT";
					}
					else if(s_trgt_condition==">=")
					{
						s_trgt_condition = "GE";
					}
					else if(s_trgt_condition=="<=")
					{
						s_trgt_condition = "LE";
					}
					else if(s_trgt_condition=='=')
					{
						s_trgt_condition = "EQ";
					}
					if(s_trgt_condition=="Not Applicable")
					{
						Ext.MessageBox.alert(pageLabel,message_6+' '+measure_description);
						return;
					}
					else if(aggregate_function=="condition" && (s_trgt_value=='Not Applicable' || isNaN(s_trgt_value)))
					{
						Ext.MessageBox.alert(pageLabel,message_7+' '+measure_description);
						return;
					}
					else if(aggregate_function=="condition" && (s_trgt_value=='Not Applicable' || (parseFloat(s_trgt_value)<0)))
					{
						Ext.MessageBox.alert(pageLabel,message_18+' '+measure_description);
						return;
					}
					else if(aggregate_function=="condition" && unit_of_measurement=='Not Applicable')
					{
						Ext.MessageBox.alert(pageLabel,message_8+' '+measure_description);
						return;
					}
					else if(aggregate_function=="multi-condition" && (unit_of_measurement=='Not Applicable' || unit_of_measurement=='%'))
					{
						Ext.MessageBox.alert(pageLabel,message_9+' '+measure_description);
						return;
					}
					else if(trgtViolationCheck && trgt_violation_by=='Not Applicable')
					{
						Ext.MessageBox.alert(pageLabel,message_11+' '+measure_description);
						return;
					}
					else if(aggregate_function=="multi-condition" && invalidCharsFound(s_trgt_value))
					{
						Ext.MessageBox.alert(pageLabel,invalid_chars_found_trgt_val+' '+measure_description);
						return;
					}
					else if(aggregate_function=="multi-condition" && invalidCharsFound(trgt_components))
					{
						Ext.MessageBox.alert(pageLabel,invalid_chars_found_trgt_comps+' '+measure_description);
						return;
					}
					else if(aggregate_function=="multi-condition" && noValueSpecified(s_trgt_value))
					{
						Ext.MessageBox.alert(pageLabel,message_16+' '+measure_description);
						return;
					}
					else if(aggregate_function=="multi-condition" && noValueSpecified(trgt_components))
					{
						Ext.MessageBox.alert(pageLabel,message_17+' '+measure_description);
						return;
					}
					//target value/s check starts here
					if(aggregate_function=="condition")
					{
						if (!checkValidValue(s_trgt_value))
						{
							Ext.MessageBox.alert(pageLabel,trgt_value_invalid + ' ' +measure_description);
							return false;
						}
						else if(!checkNonNegativeFormat_agg(s_trgt_value))
						{
							Ext.MessageBox.alert(pageLabel,trgt_value_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
							"1) "+set_with_negative_value+".\n"+
							"2) "+six_digits+".\n"+
							"3) "+four_digits+".");
							return false;
						}
					}
					else if(aggregate_function=="multi-condition")
					{
						var arr = s_trgt_value.trim().split("/");
						var abs_MaxCritical = arr[0].trim();
						var abs_MaxMajor = arr[1].trim();
						var abs_MaxMinor = arr[2].trim();

						var absMaxCr = checkValidValue(abs_MaxCritical);
						if (!absMaxCr)
						{
							Ext.MessageBox.alert(pageLabel,critial_trgt_value_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxCritical != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxCritical))
							{
								Ext.MessageBox.alert(pageLabel,critial_trgt_value_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
						}

						var absMaxMa = checkValidValue(abs_MaxMajor);
						if (!absMaxMa)
						{
							Ext.MessageBox.alert(pageLabel,major_trgt_value_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxMajor != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxMajor))
							{
								Ext.MessageBox.alert(pageLabel,major_trgt_value_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
						}

						var absMaxMi = checkValidValue(abs_MaxMinor);
						if (!absMaxMi)
						{
							Ext.MessageBox.alert(pageLabel,minor_trgt_value_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxMinor != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxMinor))
							{
								Ext.MessageBox.alert(pageLabel,minor_trgt_value_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
						}
						var ret = checkNegativeValue(abs_MaxCritical);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,critial_trgt_value_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
						ret = checkNegativeValue(abs_MaxMajor);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,major_trgt_value_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
						ret = checkNegativeValue(abs_MaxMinor);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,minor_trgt_value_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
					}
					//target components check starts here
					if(aggregate_function=="multi-condition")
					{
						var arr = trgt_components.trim().split("/");
						var abs_MaxCritical = arr[0].trim();
						var abs_MaxMajor = arr[1].trim();
						var abs_MaxMinor = arr[2].trim();

						var absMaxCr = checkValidValue(abs_MaxCritical);
						if (!absMaxCr)
						{
							Ext.MessageBox.alert(pageLabel,critial_trgt_comps_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxCritical != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxCritical))
							{
								Ext.MessageBox.alert(pageLabel,critial_trgt_comps_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
							if(parseFloat(abs_MaxCritical)>100)
							{
								Ext.MessageBox.alert(pageLabel,critial_trgt_comps_100 +' ' +measure_description);
								return false;
							}
						}

						var absMaxMa = checkValidValue(abs_MaxMajor);
						if (!absMaxMa)
						{
							Ext.MessageBox.alert(pageLabel,major_trgt_comps_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxMajor != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxMajor))
							{
								Ext.MessageBox.alert(pageLabel,major_trgt_comps_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
							if(parseFloat(abs_MaxMajor)>100)
							{
								Ext.MessageBox.alert(pageLabel,major_trgt_comps_100 +' ' +measure_description);
								return false;
							}
						}

						var absMaxMi = checkValidValue(abs_MaxMinor);
						if (!absMaxMi)
						{
							Ext.MessageBox.alert(pageLabel,minor_trgt_comps_invalid + ' ' +measure_description);
							return false;
						}
						else if(abs_MaxMinor != "-")
						{
							if(!checkNonNegativeFormat_agg(abs_MaxMinor))
							{
								Ext.MessageBox.alert(pageLabel,minor_trgt_comps_invalid+' ' +measure_description+".\n"+possible_reason_could_be+" : \n"+
								"1) "+set_with_negative_value+".\n"+
								"2) "+six_digits+".\n"+
								"3) "+four_digits+".");
								return false;
							}
							if(parseFloat(abs_MaxMinor)>100)
							{
								Ext.MessageBox.alert(pageLabel,minor_trgt_comps_100 +' ' +measure_description);
								return false;
							}
						}
						var ret = checkNegativeValue(abs_MaxCritical);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,critial_trgt_comps_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
						ret = checkNegativeValue(abs_MaxMajor);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,major_trgt_comps_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
						ret = checkNegativeValue(abs_MaxMinor);
						if (ret)
						{
							Ext.MessageBox.alert(pageLabel,minor_trgt_comps_invalid+' '+measure_description+' '+should_not_contain);
							return false;
						}
					}
					if(aggregate_function=="multi-condition")
					{
						var arr1 = s_trgt_value.trim().split("/");
						var critical_trgt_value = arr1[0].trim();
						var major_trgt_value = arr1[1].trim();
						var minor_trgt_value = arr1[2].trim();

						var arr2 = trgt_components.trim().split("/");
						var critical_trgt_comps_value = arr2[0].trim();
						var major_trgt_comps_value = arr2[1].trim();
						var minor_trgt_comps_value = arr2[2].trim();

						if(critical_trgt_value == "-" && critical_trgt_comps_value != "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_1+' '+measure_description);
							return false;
						}
						else if(critical_trgt_value != "-" && critical_trgt_comps_value == "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_2+' '+measure_description);
							return false;
						}

						if(major_trgt_value == "-" && major_trgt_comps_value != "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_3+' '+measure_description);
							return false;
						}
						else if(major_trgt_value != "-" && major_trgt_comps_value == "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_4+' '+measure_description);
							return false;
						}

						if(minor_trgt_value == "-" && minor_trgt_comps_value != "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_5+' '+measure_description);
							return false;
						}
						else if(minor_trgt_value != "-" && minor_trgt_comps_value == "-")
						{
							Ext.MessageBox.alert(pageLabel,trgt_message_6+' '+measure_description);
							return false;
						}
					}
				}
			}
		}
		if(operation != "deleteMeasures")
		{
			individual_test_name = '';
			available_row_count = 0;
			if(operation=="addMeasures")
			{
				available_row_count=0;
				individual_test_name=Ext.getCmp('test').getValue();
			}
			else if(operation=="modifyMeasures" || operation=="appendMeasures")
			{
				available_row_count=Ext.getCmp("upper_measures_grid").getStore().getCount();
				individual_test_name=s_test;
			}
			var measures_with_pct_fn = new Array();
			var selectedMeasures = new Array();
			var selectedMeasuresDetails = new Array();
			for(var i=0;i<gridStore.getCount();i++)
			{
				if(operation=="modifyMeasures")
				{
					//if(selectedObj.isSelected(gridStore.getAt(i)))
					{
						var selected_measure = gridStore.getAt(i).get(column1).trim();
						var measure_description = gridStore.getAt(i).get(column2).trim();
						var aggregate_function = gridStore.getAt(i).get(column3).trim();
						if(aggregate_function=="Percent")
						{
							measures_with_pct_fn.push(selected_measure+"|"+measure_description);
						}
						selectedMeasures.push(selected_measure);
						selectedMeasuresDetails.push(selected_measure+"|"+measure_description);
						if(operation=="addMeasures")
						{
							available_row_count+=1;
						}
						else if(operation=="modifyMeasures" || operation=="appendMeasures")
						{
							available_row_count+=1;
						}
					}
				}
				else
				{
					if(selectedObj.isSelected(gridStore.getAt(i)))
					{
						var selected_measure = gridStore.getAt(i).get(column1).trim();
						var measure_description = gridStore.getAt(i).get(column2).trim();
						var aggregate_function = gridStore.getAt(i).get(column3).trim();
						if(aggregate_function=="Percent")
						{
							measures_with_pct_fn.push(selected_measure+"|"+measure_description);
						}
						selectedMeasures.push(selected_measure);
						selectedMeasuresDetails.push(selected_measure+"|"+measure_description);
						if(operation=="addMeasures")
						{
							available_row_count+=1;
						}
						else if(operation=="modifyMeasures" || operation=="appendMeasures")
						{
							available_row_count+=1;
						}
					}
				}
			}
			if(measures_with_pct_fn.length>0 && available_row_count<3)
			{
				Ext.Msg.show({
					title: pageLabel,
					msg: pct_agg_function_valid_msg+'.',
					buttons: Ext.Msg.OK,
					icon: 'iconConfirmation',
					fn: function(buttonText) {
					}
				});
			}
			else if(measures_with_pct_fn.length>0 && selectedMeasures.length>0)
			{
				var homepage = Ext.getCmp('viewPortId');
				myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
				myMask.show();
				Ext.Ajax.request(
				{
					url: 'AggregateTests/data/updatePctMeasures.jsp',
					method:'POST',
					params: {'selectedMeasures':selectedMeasures,'selectedMeasuresDetails':selectedMeasuresDetails,'measures_with_pct_fn':measures_with_pct_fn,'test':individual_test_name,'operation':operation,'aggTest':s_aggTest},
					timeout: 300000,
					success: function(response)
					{
						if(response.status  == 200 && !Ext.isEmpty(response.responseText))
						{
							var publicJSON_popup = Ext.decode(response.responseText);
							Ext.widget("percentformitems").show();
							me.DynamicGridPanel(publicJSON_popup['gridData'],publicJSON_popup['gridColumns'],publicJSON_popup)
						}
						myMask.hide();
					},
					failure: function(response)
					{
						Ext.Msg.alert(pageTitle,'Unable to process');
						myMask.hide();
					}
				});
			}
			else
			{
				me.update(obj);
			}
		}
		else
		{
			me.update(obj);
		}
	},
	update:function(obj)
	{
		var pctdetails="";
		if(obj.getId()=='updatePctMeasures')
		{
			var internal_name_array =  new Array();
			var display_name_array =  new Array();
			for(var key in display_internal_name_mapping)
			{
				var value = display_internal_name_mapping[key];
				internal_name_array.push(value);
				display_name_array.push(key);
			}
			var problemfound=false;
			var gridObj = Ext.getCmp('gridPart_1');
			var gridPlugin = gridObj.getPlugin('pct_plugin');

			var problematic_row_number=0;
			var gridStore = Ext.getCmp("gridPart_1").getStore();
			for(var i=0;i<gridStore.getCount();i++)
			{
				var selected_measure = gridStore.getAt(i).get('hidden_measure_name').trim();
				var selected_measure_display = gridStore.getAt(i).get('measure_name').trim();

				var measure_name_on_numerator_init = gridStore.getAt(i).get('measure_name_on_numerator').trim();
				var measure_name_on_numerator_last=internal_name_array[display_name_array.indexOf(measure_name_on_numerator_init)];

				var measure_name_on_denominator_init = gridStore.getAt(i).get('measure_name_on_denominator').trim();
				var measure_name_on_denominator_last=internal_name_array[display_name_array.indexOf(measure_name_on_denominator_init)];

				if(measure_name_on_numerator_last==measure_name_on_denominator_last)
				{
					problematic_row_number=i;
					problemfound=true;
					pctdetails='';
					break;
				}
				pctdetails+=","+selected_measure+":"+measure_name_on_numerator_last+":"+measure_name_on_denominator_last;
			}
			if(problemfound)
			{
				problemfound=false;
				Ext.Msg.show({
					title: pageLabel,
					msg: you_cannot_set+' '+selected_measure_display,
					buttons: Ext.Msg.OK,
					icon: 'iconConfirmation',
					fn: function(buttonText) {
						if(buttonText == "yes")
						{
							gridPlugin.startEditByPosition({row:problematic_row_number,column:2});
						}
						else if(buttonText=="no"){
						}
					}
				});
			}
			else
			{
				if(pctdetails.length>0)
				{
					pctdetails = pctdetails.substring(1);
					me.final_update(obj,pctdetails);
				}
			}
		}
		else
		{
			me.final_update(obj,'');
		}
	},
	final_update:function(obj,pctdetails)
	{
		if(Ext.getCmp('percentformitems') != null)
		{
			Ext.getCmp('percentformitems').hide();
		}
		var confirmationMsg="";
		if(operation=="addMeasures")
		{
			confirmationMsg=addConfirmationMsg;
		}
		else if(operation=="modifyMeasures")
		{
			confirmationMsg=modifyConfirmationMsg;
		}
		else if(operation=="deleteMeasures")
		{
			confirmationMsg=deleteConfirmationMsg;
		}
		else if(operation=="appendMeasures")
		{
			confirmationMsg=appendConfirmationMsg;
		}
		if(operation != "deleteMeasures" && isDuplicateDescriptionFound(operation))
		{
			return false;
		}
		var column1 = null;
		var column2 = null;
		var column3 = null;
		var gridid = null;
		var s_pluginId = null;
		var trgtViolationCheck=false;
		if(operation=="addMeasures")
		{
			if(!checkTestDispName(Ext.getCmp("aggTestDispName").getValue()))
			{
				Ext.getCmp('aggTestDispName').focus();
				return;
			}
		}
		else if(operation=="modifyMeasures")
		{
			if(!checkTestDispName(Ext.getCmp("modify_aggTestDispName").getValue()))
			{
				Ext.getCmp('modify_aggTestDispName').focus();
				return;
			}
		}
		var descriptorAggregation_New = 'false';
		if(operation=="addMeasures")
		{
			descriptorAggregation_New = Ext.getCmp('allowedId').getValue().descriptorAggregation;
			if(descriptorAggregation_New=='true')
				trgtViolationCheck=true;
		}
		else
		{
			descriptorAggregation_New = Ext.getCmp('modify_allowedId').getValue().modify_descriptorAggregation;
			if(descriptorAggregation_New=='true')
				trgtViolationCheck=true;
		}
		if(operation=="addMeasures" || operation=="modifyMeasures" || operation=="deleteMeasures")
		{
			s_pluginId = "upper_plugin";
			gridid = "upper_measures_grid";
			column1 = "upper_m_name";
			column2 = "upper_measure_description";
			column3 = "upper_aggregate_function";
			column4 = "upper_relation";
			column5 = "upper_value";
			column6 = "upper_trgt_comp";
			column7 = "upper_target_violation";
			column8 = "upper_measure_value_in";
		}
		else
		{
			s_pluginId = "lower_plugin";
			gridid = "lower_measures_grid";
			column1 = "lower_m_name";
			column2 = "lower_measure_description";
			column3 = "lower_aggregate_function";
			column4 = "lower_relation";
			column5 = "lower_value";
			column6 = "lower_trgt_comp";
			column7 = "lower_target_violation";
			column8 = "lower_measure_value_in";
		}
		var gridObj = Ext.getCmp(gridid);
		var gridPlugin = gridObj.getPlugin(s_pluginId);
		var mfd = '';
		var selectedObj = Ext.getCmp(gridid).getSelectionModel();
		var gridStore = Ext.getCmp(gridid).getStore();
		var selectedMeasures = new Array();
		var selectedPctMeasures = new Array();
		var allMeasures = new Array();
		var allPctMeasures = new Array();
		var measure_row_count = gridStore.getCount();
		var delete_or_exclude_row_count = 0;
		for(var i=0;i<gridStore.getCount();i++)
		{
			var tempo = gridStore.getAt(i).get(column1).trim();
			allMeasures.push(tempo);
			if(gridStore.getAt(i).get(column3).trim()=="Percent")
			{
				allPctMeasures.push(tempo);
			}

			if(selectedObj.isSelected(gridStore.getAt(i)) )
			{
				delete_or_exclude_row_count++;
				var measure_description = gridStore.getAt(i).get(column2).trim();
				if(!checkMeasureDesc(measure_description))
				{
					gridPlugin.startEditByPosition({row: i,column: 2});
					return;
				}
				var selected_measure = gridStore.getAt(i).get(column1).trim();
				var aggregate_function = gridStore.getAt(i).get(column3).trim();
				if(aggregate_function=="Average")
				{
					aggregate_function = "avg";
				}
				else if(aggregate_function=="Sum")
				{
					aggregate_function = "sum";
				}
				else if(aggregate_function=="Minimum")
				{
					aggregate_function = "min";
				}
				else if(aggregate_function=="Maximum")
				{
					aggregate_function = "max";
				}
				else if(aggregate_function=="Average Sum")
				{
					aggregate_function = "avg_sum";
				}
				else if(aggregate_function=="Condition")
				{
					aggregate_function = "condition";
				}
				else if(aggregate_function=="Multi-Condition")
				{
					aggregate_function = "multi-condition";
				}
				else if(aggregate_function=="Percent")
				{
					aggregate_function = "pct";
					selectedPctMeasures.push(selected_measure);
				}
				selectedMeasures.push(selected_measure);
				if(aggregate_function=="condition" || aggregate_function=="multi-condition")
				{
					s_trgt_condition = gridStore.getAt(i).get(column4).trim();
					s_trgt_value = gridStore.getAt(i).get(column5).trim();
					trgt_components = gridStore.getAt(i).get(column6).trim();
					if(trgtViolationCheck)
					{
						trgt_violation_by = gridStore.getAt(i).get(column7).trim();
					}
					else
					{
						trgt_violation_by = 'Majority';
					}
					unit_of_measurement = gridStore.getAt(i).get(column8).trim();
					if(s_trgt_condition=='>')
					{
						s_trgt_condition = "GT";
					}
					else if(s_trgt_condition=='<')
					{
						s_trgt_condition = "LT";
					}
					else if(s_trgt_condition==">=")
					{
						s_trgt_condition = "GE";
					}
					else if(s_trgt_condition=="<=")
					{
						s_trgt_condition = "LE";
					}
					else if(s_trgt_condition=='=')
					{
						s_trgt_condition = "EQ";
					}
					mfd += selected_measure+":"+aggregate_function+":"+measure_description+":"+s_trgt_condition+":"+s_trgt_value+":"+trgt_components+":"+trgt_violation_by+":"+unit_of_measurement+"$";
				}
				else
				{
					mfd += selected_measure+":"+aggregate_function+":"+measure_description+"$";
				}
			}
		}
		if(mfd.length==0)
		{
			if(operation=="addMeasures")
			{
				Ext.MessageBox.alert(pageLabel,create_alert);
			}
			else if(operation=="modifyMeasures")
			{
				Ext.MessageBox.alert(pageLabel,modify_alert);
			}
			else if(operation=="deleteMeasures")
			{
				Ext.MessageBox.alert(pageLabel,delete_alert);
			}
			else if(operation=="appendMeasures")
			{
				Ext.MessageBox.alert(pageLabel,append_alert);
			}
		}
		else
		{
			if(operation=="deleteMeasures" && selectedMeasures.length>0)
			{
				var dontdelete=false;
				for(var i=0;i<gridStore.getCount();i++)
				{
					var this_measure = gridStore.getAt(i).get(column1).trim();
					var this_measure_description = gridStore.getAt(i).get(column2).trim();
					if(selectedMeasures.indexOf(this_measure)==-1)
					{
						continue;
					}
					for(var k=0;k<pctMeasureNamesArray.length;k++)
					{
						var key = pctMeasureNamesArray[k];
						var nr_dr_measures = superMeasureMap[key].split(',');
						var nr_measure = nr_dr_measures[0];
						var dr_measure = nr_dr_measures[1];
						if(this_measure==nr_measure || this_measure==dr_measure)
						{
							if(selectedMeasures.indexOf(key)>=0)
							{
								continue;
							}
							var associated_pct_measure_desc = '';
							for(var j=0;j<gridStore.getCount();j++)
							{
								var selected_measure_pct = gridStore.getAt(j).get(column1).trim();
								if(key==selected_measure_pct)
								{
									associated_pct_measure_desc = gridStore.getAt(j).get(column2).trim();
									Ext.MessageBox.alert(pageLabel,this_measure_description+' measure cannot be excluded as it is associated with measure '+associated_pct_measure_desc+' which is not selected now for exclusion');
									dontdelete=true;
									break;
								}
							}
						}
						if(dontdelete)
						{
							break;
						}
					}
					if(dontdelete)
					{
						break;
					}
				}
				if(dontdelete)
				{
					return false;
				}
			}
			if(operation=="deleteMeasures")
			{
				var tryingToDeleteTest = true;
				if(selectedMeasures.length>0)
				{
					for(var i=0;i<measures_exist.length;i++)
					{
						if(selectedMeasures.indexOf(measures_exist[i])==-1)
						{
							tryingToDeleteTest = false;
							break;
						}
					}
				}
			}
			if(tryingToDeleteTest)
			{
				Ext.Msg.show({
					title: pageLabel,
					msg: confirmation_1,
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function(buttonText) {
						if(buttonText == "yes")
						{
							var formObj = Ext.getCmp("formitems").getForm();
							if(formObj.isValid())
							{
								var homepage = Ext.getCmp('viewPortId');
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								myMask.show();
								formObj.submit({
									url:'/final/admin/aggDeleteTest.jsp',
									method: 'POST',
									params:{"test":s_aggTest},
									standardSubmit: true
								})
							}

						}
						else if(buttonText=="no"){
						}
					}
				});
			}
			else
			{
				mfd = mfd.substring(0,mfd.length-1);
				var add_modify_test_description = null;
				if(operation=="deleteMeasures")
				{
					add_modify_test_description = Ext.getCmp("modify_aggTestDispName").getValue();
					Ext.Msg.show({
						title: pageLabel,
						msg: confirmation_2,
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(buttonText) {
							if(buttonText == "yes")
							{
								var formObj = Ext.getCmp("formitems").getForm();
								if(formObj.isValid())
								{
									var homepage = Ext.getCmp('viewPortId');
									myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
									myMask.show();
									formObj.submit({
										url:'/final/admin/AggregateTests/data/aggAddTestpJson.jsp',
										method: 'POST',
										params:{"operation":operation,"measureNames":mfd,"test":s_test,"aggTest":s_aggTest,"add_modify_test_description":add_modify_test_description,"descriptorAggregation_New":descriptorAggregation_New,"pctdetails":pctdetails},
										success: function(form, action){
											myMask.hide();
											publicJSON = Ext.decode(action.response.responseText);
											if(publicJSON['operationStatus'] != null)
											{
												var message = publicJSON['operationStatus']['message'];
												var errormessage = publicJSON['operationStatus']['errormessage'];
												if(message != null && message != 'undefined')
												{
													//window.location.href = "/final/admin/EgDefault.jsp?server=null&qctr=0&page=true&t_name="+s_aggTest+"&normalTestName="+s_test;
													qString = 'AggregateTests/data/EgDefaultJson.jsp?server=null&qctr=0&page=true&t_name='+s_aggTest+'&normalTestName='+s_test;
													var homepage = Ext.getCmp('viewPortId');
													myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
													myMask.show();
													homepage.removeAll();
													homepage.add({ xtype : 'defaultthresholds' });
													//myMask.hide();
												}
												else if(errormessage != null && errormessage != 'undefined')
												{
													Ext.Msg.alert(pageLabel,errormessage);
												}
											}
										},
										failure: function(form, action){
											myMask.hide();
										}
									})
								}
								else
								{
									Ext.MessageBox.alert(pageLabel,"Invalid form can not be submitted");
								}
							}
							else if(buttonText=="no"){}
						}
					});
				}
				else
				{
					if(operation=="addMeasures") {
						add_modify_test_description = Ext.getCmp("aggTestDispName").getValue();
					}
					else {
						add_modify_test_description = Ext.getCmp("modify_aggTestDispName").getValue();
					}
					Ext.Msg.show({
						title: pageLabel,
						msg: confirmationMsg + '. '+proceedMsg+'?',
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(buttonText)
						{
							if(buttonText == "yes")
							{
								var formObj = Ext.getCmp("formitems").getForm();
								if(formObj.isValid())
								{
									var homepage = Ext.getCmp('viewPortId');
									myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
									myMask.show();
									formObj.submit({
										url:'/final/admin/AggregateTests/data/aggAddTestpJson.jsp',
										method: 'POST',
										params:{"operation":operation,"measureNames":mfd,"test":s_test,"aggTest":s_aggTest,"add_modify_test_description":add_modify_test_description,"descriptorAggregation_New":descriptorAggregation_New,"pctdetails":pctdetails},
										success: function(form, action){
											myMask.hide();
											publicJSON = Ext.decode(action.response.responseText);
											if(publicJSON['operationStatus'] != null)
											{
												var message = publicJSON['operationStatus']['message'];
												var errormessage = publicJSON['operationStatus']['errormessage'];
												if(message != null && message != 'undefined')
												{
													window.location.href = "/final/admin/aggShowComponentTypes.jsp?agg_test_name="+s_aggTest;
												}
												else if(errormessage != null && errormessage != 'undefined')
												{
													Ext.Msg.alert(pageLabel,errormessage);
												}
											}
											else
											{
												//window.location.href = "/final/admin/EgDefault.jsp?server=null&qctr=0&page=true&t_name="+s_aggTest+"&normalTestName="+s_test;
												qString = 'AggregateTests/data/EgDefaultJson.jsp?server=null&qctr=0&page=true&t_name='+s_aggTest+'&normalTestName='+s_test;
												var homepage = Ext.getCmp('viewPortId');
												myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
												myMask.show();
												homepage.removeAll();
												homepage.add({ xtype : 'defaultthresholds' });
											}
										},
										failure: function(form, action){
											myMask.hide();
										}
									})
								}
								else
								{
									Ext.MessageBox.alert(pageLabel,"Invalid form can not be submitted");
								}
							}
					}});
				}
			}
		}
	},
	configureThresholdsPageBack: function()
	{
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'defaultthresholds' });
		myMask.hide();
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		Ext.getCmp('alarmDispField').el.update(tmpDescription);
	},
	gotoDefaultThresholdPage: function()
	{
		Ext.Ajax.request({
			url:qString,
			method: 'POST',
			scope: this,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var measureThreshValArr = publicJson['measureValArr'];
					var noMeasureThreshValArr = publicJson['noMeasureValArr'];
					var hostTestMsg = publicJson['hosttest_title'];
					var descConfigBtn = publicJson['desc_configure'];
					var fieldSetTitle = publicJson['tableTitle'];
					if (fieldSetTitle != null && !Ext.isEmpty(fieldSetTitle))
					{
						Ext.getCmp('fieldTitleId').setTitle(fieldSetTitle);
					}

					if (hostTestMsg != null && hostTestMsg != 'undefined')
					{
						Ext.getCmp('hostTestMsgContainer').show();
						Ext.getCmp('hostMsgLabel').update(hostTestMsg);
					}
					else
					{
						Ext.getCmp('hostTestMsgContainer').hide();
					}

					if(measureThreshValArr != null &&  !Ext.isEmpty(measureThreshValArr))
					{
						Ext.getCmp('measureGrid').getStore().suspendEvents();
						Ext.getCmp('measureGrid').getStore().removeAll();
						Ext.getCmp('measureGrid').getStore().loadRawData(measureThreshValArr);
						Ext.getCmp('measureGrid').getStore().resumeEvents();
						Ext.getCmp('measureGrid').getView().refresh();
						Ext.getCmp('measureGrid').show();

					}else
					{
						Ext.getCmp('measureGrid').hide();
					}

					if(noMeasureThreshValArr != null && !Ext.isEmpty(noMeasureThreshValArr))
					{
						Ext.getCmp('noMeasureGrid').getStore().suspendEvents();
						Ext.getCmp('noMeasureGrid').getStore().removeAll();
						Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureThreshValArr);
						Ext.getCmp('noMeasureGrid').getStore().resumeEvents();
						Ext.getCmp('noMeasureGrid').getView().refresh();
						Ext.getCmp('noMeasureGrid').show();
					}
					else
					{
						Ext.getCmp('noMeasureGrid').hide();
					}
				}
				myMask.hide();
			}
		});
	},
	configureMainRender: function()
	{
		Ext.Ajax.request({
			url:'AggregateTests/data/EgConfigureThresholdsJson.jsp?'+hiddenFieldsVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var testDescription = publicJson['screenLabels']['test_description'];
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							Ext.getCmp('minAutoCheck').show();
							Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							Ext.getCmp('maxAutoCheck').show();
							Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update('<center>'+testDescription+'</center>');

				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					Ext.getCmp('alarmDispField').el.animate({opacity: 1});
					Ext.getCmp('alarmPolicyCombo').getStore().removeAll();
					Ext.getCmp('alarmPolicyCombo').getStore().suspendEvents();
					Ext.getCmp('alarmPolicyCombo').getStore().loadRawData(alarmPolicyCombo);
					Ext.getCmp('alarmPolicyCombo').getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						Ext.getCmp('alarmPolicyCombo').setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						Ext.getCmp('alarmPolicyCombo').setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//Ext.getCmp('alarmDispField').el.update(selectedAlarmDescription);
						Ext.getCmp('alarmDispField').setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//Ext.getCmp('alarmDispField').el.update(tmpDescription);
						Ext.getCmp('alarmDispField').setValue(tmpDescription);
					}
				}
			}
		});
	},
	submitData: function()
	{
		var aggTestName =  publicJson['hiddenObj']['testName'];
		window.location.href = '/final/admin/aggShowComponentTypes.jsp?agg_test_name='+aggTestName;
		//window.location.href = '/final/admin/aggAddTest.jsp?';
	},
	//updateData: function ()
	//{
		//var flag = this.applyThresholdsData();
		//alert('flag : '+flag);
		//if (flag)
		//{
			////Ext.Msg.alert('Success','Threshold updated successfully.',
			////function()
			////{
				////var homepage = Ext.getCmp('viewPortId');
				////myMask = new Ext.LoadMask(homepage, {msg:"Please wait..."});
				////homepage.removeAll();
				////myMask.show();
				////homepage.add({ xtype : 'defaultthresholds' });
				////myMask.hide();
			////});

			////var aggTestName =  publicJson['hiddenObj']['testName'];
			////window.location.href = '/final/admin/aggShowComponentTypes.jsp?agg_test_name='+aggTestName;
		//}
	//},
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinCriticalErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinMajorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinMinorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-")
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinCriticalErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinMajorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMinMinorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" ||
				abs_MinCriticalDecimal == "000" ||
				abs_MinCriticalDecimal == "00" ||
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") ||
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" ||
				abs_MinMajorDecimal == "000" ||
				abs_MinMajorDecimal == "00" ||
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") ||
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" ||
				abs_MinMinorDecimal == "000" ||
				abs_MinMinorDecimal == "00" ||
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") ||
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxCriticalErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxMajorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxMinorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxCriticalErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxMajorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxMinorErrMsg1+".<br \>"+errMsg1+" : <br \>"+"1) "+errMsg2+".<br \>"+"2) "+errMsg3+".<br \>"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" ||
				abs_MaxCriticalDecimal == "000" ||
				abs_MaxCriticalDecimal == "00" ||
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(3) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" ||
				abs_MaxMajorDecimal == "000" ||
				abs_MaxMajorDecimal == "00" ||
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(3) == "0") ||
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" ||
				abs_MaxMinorDecimal == "000" ||
				abs_MaxMinorDecimal == "00" ||
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") ||
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		if (flag)
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();
			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			//this.updateThresholds(v_testname,v_threshold);
			var urlVal = '';
			var params = "&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
			urlVal = 'AggregateTests/data/EgApplyThresholdsJson.jsp?'+params;

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 60000000,
				//async:false,
				scope:this,
				success:function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = Ext.decode(response.responseText);
						if (jsonText.successUpdate != null && !Ext.isEmpty(jsonText.successUpdate) && jsonText.successUpdate == 'true')
						{
							myHomeMask.hide();
							Ext.Msg.show({
								title: pageLabel,
								msg: successMsg1,
								buttons: Ext.Msg.YESNO,
								icon: 'iconInformation',
								fn: function()
								{
									var homepage = Ext.getCmp('viewPortId');
									myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
									homepage.removeAll();
									myMask.show();
									homepage.add({ xtype : 'defaultthresholds' });
									myMask.hide();
								}
							});
						}
					}
				},
				failure: function(response)
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	//updateThresholds: function (v_test,v_threshValue)
	//{
		//var homepage = Ext.getCmp('viewPortId');
		//myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
		//homepage.removeAll();
		//myMask.show();

		////alert('entered updateThresholds method : '+new Date());
		//var urlVal = '';
		//var params = "&testName="+v_test+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";
		//urlVal = 'AggregateTests/data/EgApplyThresholdsJson.jsp?'+params;

		//Ext.Ajax.request({
			//url:urlVal,
			//method:'POST',
			//timeout: 600000,
			////async:false,
			//scope:this,
			//success:function(response)
			//{
				////alert('inside success updateThresholds method : '+new Date());
				//if (response.status == 200 && !Ext.isEmpty(response.responseText))
				//{
					//var jsonText = Ext.decode(response.responseText);
					////alert('jsonText.successUpdate  : '+jsonText.successUpdate);
					//if (jsonText.successUpdate != null && !Ext.isEmpty(jsonText.successUpdate) && jsonText.successUpdate == 'true')
					//{
						//Ext.Msg.show({
							//title: pageLabel,
							//msg: successMsg1,
							//buttons: Ext.Msg.YESNO,
							//icon: 'iconInformation',
							//fn: function()
							//{
								//homepage.add({ xtype : 'defaultthresholds' });
								//myMask.hide();
							//}
						//});
					//}
				//}
			//},
			//failure: function(response)
			//{
				//Ext.Msg.alert(pageTitle1,'Thresholds value update failed');
				//return false;
			//}
		//});
	//},
	maxStaticFieldChange: function(field){
        var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxAutoFieldChange: function(field){
        var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minStaticFieldChange: function(field){
        var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minAutoFieldChange: function(field){
        var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxStaticCheckChange: function(box, checked)
	{
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

    },
	maxAutoCheckChange: function(box, checked)
	{
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	minStaticCheckChange: function(box, checked)
	{
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

    },
	minAutoCheckChange: function(box, checked)
	{
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });
		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	getHiddenFields : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	noThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];

		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			hiddenFieldsVal = this.getHiddenFields(actualMeasName);
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'configurethresholds' });
		}
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e)
	{
		this.showEditWindow(view.getRecord(view.findTargetByEvent(e)));
    },
	showEditWindow: function(task)
	{
		var measureName = task.get('Measure');
		var thresholds = task.get('Thresholds');
		var alarmPol = task.get('AlarmPolicy');
		if(measureName.lastIndexOf(' ') != -1)
		{
			measureName = measureName.substring(0,measureName.lastIndexOf(' '));
		}
		var measureActualObj = publicJson.measureDataObj;
		hiddenFieldsVal = this.getHiddenFields(measureActualObj[measureName.trim()]);
		var me = this;
		var homepage = Ext.getCmp('viewPortId');
		homepage.removeAll();
		homepage.add({ xtype : 'configurethresholds' });
	},
	showModifyTool: function(view, record, item, index, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		 });
	},
	hideModifyTool: function( view, record, item, index, e, eOpts )
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	showPopup: function()
	{
		Ext.widget("description_window").show();
	},
	DynamicGridPanel : function(gridArray,cols,publicJSON_popup)
	{
		display_internal_name_mapping = publicJSON_popup.display_internal_name_mapping;
		var i=0;
		var chkCount = 0;
		var itemsArray	=  new Array();
		for (var key in cols)
		{
			chkCount++;
			var colObject = cols[key];
			var fieldstoStore =  new Array();
			var mainColumnsObjArray	=  new Array();
			for (var key2 in colObject)
			{
				var grid_column_display_name = colObject[key2];
				fieldstoStore.push(key2);
				if(key2 == "hidden_measure_name")
				{
					mainColumnsObjArray.push({
						header: grid_column_display_name,
						sortable:false,
						draggable : false,
						resizable : false,
						menuDisabled : true,
						hidden: true,
						dataIndex: key2,
						flex:1,
						border:0
					});
				}
				else if(key2 == "measure_name")
				{
					mainColumnsObjArray.push({
						header: grid_column_display_name,
						sortable:false,
						draggable : false,
						resizable : false,
						menuDisabled : true,
						dataIndex: key2,
						flex:1,
						border:0
					});
				}
				else if(key2 == "measure_name_on_numerator")
				{
					mainColumnsObjArray.push({
						header: grid_column_display_name,
						renderer:function(val,metaData){
							metaData.tdCls = "grid_editable_cell";
							return val;
						},
						sortable:false,
						draggable : false,
						resizable : false,
						border:0,
						menuDisabled : true,
						dataIndex: key2,
						flex:1,
						editor: new Ext.form.field.ComboBox({
							editable: false,
							width:200,
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							cls:'dropdown',
							margin:'2 0 0 0',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data: []
							})
						})
					});
				}
				else if (key2 == "measure_name_on_denominator")
				{
					mainColumnsObjArray.push({
						header: grid_column_display_name,
						renderer:function(val,metaData){
							metaData.tdCls = "grid_editable_cell";
							return val;
						},
						sortable:false,
						draggable : false,
						resizable : false,
						border:0,
						menuDisabled : true,
						dataIndex: key2,
						flex:1,
						editor: new Ext.form.field.ComboBox({
							editable: false,
							width:200,
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							cls:'dropdown',
							margin:'2 0 0 0',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data: []
							})
						})
					});
				}
			}
			var allSelectedIndex = new Array();
			var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
				clicksToEdit: 1,
				pluginId: 'pct_plugin',
				listeners : {
					'beforeedit' : function( editor, e, eOpts )
					{
						var selection = e.grid.getSelectionModel().getSelection();
						var len = e.grid.getSelectionModel().getSelection().length;
						for(var i=0; i< len; i++)
						{
							allSelectedIndex[i] = selection[i].index;
						}
						ans = e.grid.getSelectionModel().isSelected(e.grid.getStore().getAt(e.rowIdx));
					},
					'edit' : function( editor, e, eOpts )
					{
						if(!ans)
						{
							e.grid.getSelectionModel().deselect(e.rowIdx);
						}
						else
						{
							e.grid.getSelectionModel().select(e.rowIdx);
						}
						for(var i=0; i<allSelectedIndex.length; i++)
						{
							e.grid.getSelectionModel().select(allSelectedIndex[i],true);
						}
					}
				}
			});
			var gridpanel = Ext.widget('dynamicgrid',{
				store:new Ext.data.Store({
					fields: fieldstoStore,
					data: gridArray[i++]
				}),
				width : '100%',
				id: 'gridPart_'+chkCount,
				gridCountId : chkCount,
				sortableColumns:true,
				listeners : {
					'afterrender': function(obj, eOpts)
					{
						for (var colIndex=0;colIndex<obj.getStore().getCount();colIndex++)
						{
							var editorObject_col_2 = obj.columns[2].getEditor();
							editorObject_col_2.getStore().suspendEvents(true);
							editorObject_col_2.getStore().loadRawData(publicJSON_popup['TimePeriodList_'+obj.gridCountId+'_'+colIndex]);
							editorObject_col_2.getStore().resumeEvents();
							editorObject_col_2.setValue(editorObject_col_2.getStore().getAt(0).get("valueField"));

							var editorObject = obj.columns[3].getEditor();
							editorObject.getStore().suspendEvents(true);
							editorObject.getStore().loadRawData(publicJSON_popup['TimePeriodList_'+obj.gridCountId+'_'+colIndex]);
							editorObject.getStore().resumeEvents();
							editorObject.setValue(editorObject.getStore().getAt(0).get("valueField"));
						}
					}
				},
				plugins: [cellEditing],
				columns:mainColumnsObjArray,
				viewConfig: {
					forceFit: true,
					stripeRows : true
				}
			});
			itemsArray.push(gridpanel);
		}
		Ext.getCmp('dynGridContainer').removeAll();
		Ext.getCmp('dynGridContainer').add(itemsArray);
		Ext.getCmp('dynGridContainer').doLayout();
	}
});



function isDuplicateDescriptionFound(operation)
{
	if(operation=="addMeasures" || operation=="modifyMeasures" || operation=="deleteMeasures")
	{
		s_pluginId = "upper_plugin";
		gridid="upper_measures_grid";
		column1 = "upper_m_name";
		column2 = "upper_measure_description";
	}
	else
	{
		s_pluginId = "lower_plugin";
		gridid="lower_measures_grid";
		column1 = "lower_m_name";
		column2 = "lower_measure_description";
	}
	var gridObj = Ext.getCmp(gridid);
	var gridPlugin = gridObj.getPlugin(s_pluginId);

	var array_upper = new Array();
	var selectedObj_upper = Ext.getCmp('upper_measures_grid').getSelectionModel();
	var gridStore_upper = Ext.getCmp('upper_measures_grid').getStore();
	var upperMeasuresCount = gridStore_upper.getCount();
	for(var i=0;i<upperMeasuresCount;i++)
	{
		array_upper.push(gridStore_upper.getAt(i).get('upper_measure_description').toLowerCase());
	}
	if(operation=="addMeasures" || operation=="modifyMeasures")
	{
		for(var i=0;i<upperMeasuresCount;i++)
		{
			var s_desc = gridStore_upper.getAt(i).get('upper_measure_description');
			var temp = s_desc.toLowerCase();
			for(var j=0;j<upperMeasuresCount;j++)
			{
				if(i != j && temp==array_upper[j])
				{
					//don't use Ext.MessageBox.alert
					alert(measure_desc_alert1+' \''+s_desc + '\' ' + measure_desc_alert2);
					gridPlugin.startEditByPosition({row: j,column: 2});
					return true;
				}
			}
		}
	}
	else if(operation=="appendMeasures")
	{
		var array_lower = new Array();
		var selectedObj_lower = Ext.getCmp('lower_measures_grid').getSelectionModel();
		var gridStore_lower = Ext.getCmp('lower_measures_grid').getStore();
		var lowerMeasuresCount = gridStore_lower.getCount();
		for(var i=0;i<lowerMeasuresCount;i++)
		{
			var s_desc = gridStore_lower.getAt(i).get('lower_measure_description');
			var temp = s_desc.toLowerCase();
			for(var j=0;j<upperMeasuresCount;j++)
			{
				if(temp==array_upper[j])
				{
					//don't use Ext.MessageBox.alert
					alert(measure_desc_alert1+' \''+s_desc + '\' ' + measure_desc_alert2);
					gridPlugin.startEditByPosition({row: i,column: 2});
					return true;
				}
			}
			array_lower.push(temp);
		}
		for(var i=0;i<lowerMeasuresCount;i++)
		{
			var s_desc = gridStore_lower.getAt(i).get('lower_measure_description');
			var temp = s_desc.toLowerCase();
			for(var j=0;j<lowerMeasuresCount;j++)
			{
				if(i != j && temp==array_lower[j])
				{
					//don't use Ext.MessageBox.alert
					alert(measure_desc_alert1+' \''+s_desc + '\' ' + measure_desc_alert2);
					gridPlugin.startEditByPosition({row: j,column: 2});
					return true;
				}
			}
		}
	}
	return false;
}
function checkTestDispName(val)
{
	if(!checkblank(val))
	{
		alert(message_1);//dont use Ext.MessageBox.alert
		return false;
	}
	else if(!checkSpecialCharLocal(val,"~!@#$%^&*()|:,;<>"))
	{
		alert(message_19);//dont use Ext.MessageBox.alert
		return false;
	}
	return true;
}
function checkMeasureDesc(val)
{
	if(!checkblank(val))
	{
		alert(message_3);//dont use Ext.MessageBox.alert
		return false;
	}
	else if(val.indexOf('.')>-1)
	{
		alert(message_5);//dont use Ext.MessageBox.alert
		return false
	}
	else if(!checkSpecialCharLocal(val,"~!@#$%^&*()|:,;<>"))
	{
		alert(message_20);//dont use Ext.MessageBox.alert
		return false;
	}
	return true;
}
function checkSpecialCharLocal(in_val,s_spl)
{
	for(var i=0; i<in_val.length; i++)
	{
		check_char = s_spl.indexOf(in_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			//alert(_checkspecial);
			return false;
		}
	}
	return true;
}
function showTests(selected_testfor)
{
	if(current_testfor != selected_testfor)
	{
		current_testfor = selected_testfor;
		queryString = "operation=addMeasures&s_test=-1&testfor="+selected_testfor;
		Ext.Ajax.request({
			url : '/final/admin/AggregateTests/data/aggAddTestJson.jsp?'+queryString,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				operation = publicJSON['parameters']['s_operation'];
				if(operation=="addMeasures")
				{
					if(current_testfor == "managedtests") {
						Ext.getCmp('managedcomponents').setValue(true);
					}
					else {
						Ext.getCmp('allcomponents').setValue(true);
					}
					Ext.getCmp("addtestcontainer").show();
					Ext.getCmp("addMeasures").show();
					Ext.getCmp("addMeasures").setText(publicJSON['labels']['Include']);
					Ext.getCmp("modifyMeasures").hide();
					Ext.getCmp("deleteMeasures").hide();
					Ext.getCmp("modifytestcontainer").hide();

					Ext.getCmp("testforId").setFieldLabel(publicJSON['labels']['Aggregate']);
					Ext.getCmp("managedcomponents").boxLabelEl.update(publicJSON['labels']['Managed_Components']);
					Ext.getCmp("allcomponents").boxLabelEl.update(publicJSON['labels']['All_Components']);

					Ext.getCmp("component_types").show();
					Ext.getCmp("component_types").clearValue();
					Ext.getCmp("component_types").setFieldLabel(publicJSON['labels']['Filter_by_component_type']);
					Ext.getCmp('component_types').getStore().clearFilter(true);
					Ext.getCmp('component_types').getStore().loadRawData(publicJSON['component_types']);
					var selected_component_type = publicJSON['parameters']['s_component_type'];
					if(selected_component_type != null && selected_component_type != 'undefined' && selected_component_type != '-1')
					{
						Ext.getCmp('component_types').setValue(selected_component_type);
					}
					else
					{
						Ext.getCmp('component_types').setValue("-1");
					}

					Ext.getCmp("test").clearValue();
					Ext.getCmp("test").setFieldLabel(publicJSON['labels']['Test_to_be_aggregated']);
					Ext.getCmp('test').getStore().clearFilter(true);
					Ext.getCmp('test').getStore().loadRawData(publicJSON['tests']);
					Ext.getCmp('test').setValue("-1");

					var selected_test_name = publicJSON['parameters']['s_test'];
					if(selected_test_name == null || selected_test_name == 'undefined' || selected_test_name == '-1')
					{
						Ext.getCmp('test').setValue("-1");
						Ext.getCmp('aggTestDispName').hide();
						Ext.getCmp('allowedId').hide();
						Ext.getCmp('upper_measures_grid').hide();
						Ext.getCmp('upper_measures_button_container').hide();
					}
					else
					{
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_button_container').show();

						Ext.getCmp('test').setValue(selected_test_name);
						Ext.getCmp('aggTestDispName').show();
						Ext.getCmp('allowedId').show();
						Ext.getCmp('aggTestDispName').setValue(publicJSON['displayaggname']['displayname']);
						Ext.getCmp('upper_measures_grid').show();
						Ext.getCmp('upper_measures_grid').getSelectionModel().deselectAll();
						Ext.getCmp('upper_measures_grid').getStore().loadRawData(publicJSON['upperRowDataArray']);
						var gridColumns = publicJSON['gridColumns'];
						for(var key in gridColumns)
						{
							if(key == 0 || key == 4)
								continue;
							Ext.getCmp('upper_measures_grid').columns[key].setText(gridColumns[key]);
						}
						Ext.getCmp('upper_measures_grid').setTitle(publicJSON['labels']['Available_measures_for']);
						s_aggTest = publicJSON['new_aggTest']['s_aggTest'];
						var mygrid = Ext.getCmp('upper_measures_grid');
						mygrid.columns[7].setVisible(false);
					}

				}
			},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageLabel,"Could not load aggAddTestJson.jsp");
			}
		});
	}
}
function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,16}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}


function noValueSpecified(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return true;
	}
	var Cri,Maj,Min;
	Cri = arr[0].trim();
	Maj = arr[1].trim();
	Min = arr[2].trim();
	var ret = false;
	if (Cri == "-" && Maj == "-" && Min == "-")
	{
		ret = true;
	}
	return ret;
}
function isNegativeValueFound(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3) {
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0].trim();
	Maj = arr[1].trim();
	Min = arr[2].trim();
	var ret = false;
	if (Cri != "-" && (parseFloat(Cri) < 0)) {
		ret = true;
	}
	if (Maj != "-" && (parseFloat(Maj) < 0)) {
		ret = true;
	}
	if (Min != "-" && (parseFloat(Min) < 0)) {
		ret = true;
	}
	return ret;
}

// var RE = /^[0-9]{0,10}(\.[0-9]{1,4})?$/; allow non-negative and only 10 digits and decimal 4 points
function checkNonNegativeFormat_agg(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function invalidCharsFound(val)
{
	val=val.trim();
	var isFound = false;
	var validChars = "0123456789./-";
	for (var i = 0; i < val.length; i++)
	{
		if (validChars.indexOf(val.charAt(i)) == -1)
		{
			isFound = true;
			break;
		}
	}
	return isFound;
}
