var cellEditFunction = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1
});

Ext.define('AggregateTests.view.FormItems', {
	extend:'Ext.form.Panel',
	//extend:'utilities.innerScrollContainer',
	alias:'widget.aggtestform',
	title: pageTitle,
	cls:'outerpanel',
	header:{cls:'textUpper'},
	margin :'8 8 0 8',
	id: 'formitems',
	border:true,
	frame:true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools: [
		{
			xtype:'button',
			id : 'backButton',
			text: back_button,
			cls:'backbutton',
			iconCls:'iconBack',
			hidden:false
		}
	],

	dockedItems: [
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDescc+'.'+'</center>'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'testjames',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			id:'addtestcontainer',
			margin: 10,
			items: [
				{
					xtype:'container',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 540,
						labelWidth: 200
					},
					items: [
						{
							xtype: 'radiogroup',
							fieldLabel: 'Aggregate metrics from',
							columns: 2,
							cls:'radiobt',
							id: 'testforId',
							listeners: {
								click: {
									element: 'el', //bind to the underlying el property on the panel
									fn: function (id) {
										showTests(Ext.getCmp(this.id).getValue().testfor);
									}
								}
							},
							items: [
								{
									boxLabel: 'Managed Components',
									name: 'testfor',
									id:'managedcomponents',
									inputValue: 'managedtests',
								},
								{
									boxLabel: 'All Components',
									name: 'testfor',
									id:'allcomponents',
									inputValue: 'alltests'
								}
							]
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: 'Filter by component type',
							name: 'component_types',
							id:"component_types",
							//editable: false,
							queryMode: 'local',
							displayField:'displayField',
							valueField:'valueField',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: 'Test to be aggregated',
							name: 'test',
							id:"test",
							//editable: false,
							hidden: true,
							queryMode: 'local',
							displayField:'displayField',
							valueField:'valueField',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						},
						{
							xtype: 'textfield',
							fieldLabel: 'Aggregate test display name',
							name: 'aggTestDispName',
							cls:'textbox',
							id:"aggTestDispName",
							maxLength: 256,
							hidden: true,
							listeners: {
								render: function(c) {
									Ext.QuickTips.register({
									target: c.getEl(),
									text: 'Click on textbox to edit'
									});
								}
							}
						},
						{
							xtype: 'radiogroup',
							fieldLabel: report_by_desc,
							columns: 2,
							cls:'radiobt',
							id: 'allowedId',
							hidden: true,
							listeners: {
								change: function(radiogroup, radio) {
									var is_descbased='false';
									var mygrid = Ext.getCmp('upper_measures_grid');
									if(Ext.getCmp(this.id).getValue().descriptorAggregation=='true') {
										mygrid.columns[7].setVisible(true);
										is_descbased='true';
									}
									else {
										mygrid.columns[7].setVisible(false);
									}
									var showAllColumns = false;
									var conditionFound= false;
									var multiConditionFound= false;
									var gridStore = Ext.getCmp('upper_measures_grid').getStore();
									for(var i = 0;i<gridStore.getCount();i++)
									{
										var afn = gridStore.getAt(i).get('upper_aggregate_function').trim();
										if(afn=="Condition")
										{
											conditionFound=true;
											showAllColumns=true;
										}
										else if(afn=="Multi-Condition")
										{
											multiConditionFound=true;
											showAllColumns=true;
										}
										if(conditionFound && multiConditionFound)
											break;
									}
									if(showAllColumns)
									{
										mygrid.columns[4].setVisible(true);
										mygrid.columns[5].setVisible(true);
										mygrid.columns[6].setVisible(true);
										if(is_descbased=='true' && (conditionFound || multiConditionFound))
											mygrid.columns[7].setVisible(true);
										else
											mygrid.columns[7].setVisible(false);
										mygrid.columns[8].setVisible(true);
									}
									else
									{
										mygrid.columns[4].setVisible(false);
										mygrid.columns[5].setVisible(false);
										mygrid.columns[6].setVisible(false);
										mygrid.columns[7].setVisible(false);
										mygrid.columns[8].setVisible(false);
									}
									Ext.getCmp('upper_measures_grid').getView().refresh();
								}
							},
							items: [
								{
									xtype: 'radiofield',
									boxLabel: yes,
									name: 'descriptorAggregation',
									id:'nda1',
									inputValue: 'false',
									checked: true
								},
								{
									xtype: 'radiofield',
									boxLabel: no,
									name: 'descriptorAggregation',
									id:'nda2',
									inputValue: 'true'
								}
							]
						}
					]
				}
			]
		},
		{
			xtype:'container',
			id:'modifytestcontainer',
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin: 10,
			hidden:true,
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: 'Aggregate test name',
					name: 'aggTest',
					id:"aggTest",
					width: 300,
					labelAlign: 'top',
					labelSeparator: '',
					editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				},
				{
					xtype: 'textfield',
					fieldLabel: 'Aggregate test display name',
					name: 'modify_aggTestDispName',
					cls:'textbox',
					id:"modify_aggTestDispName",
					labelAlign: 'top',
					labelSeparator: '',
					width: 300,
					margin: '0 0 0 10'
				},
				{
					xtype: 'radiogroup',
					fieldLabel: report_by_desc,
					columns: 2,
					cls:'radiobt',
					labelAlign: 'top',
					labelSeparator: '',
					id: 'modify_allowedId',
					margin: '0 0 0 10',
					width: 150,
					listeners: {
						change: function(radiogroup, radio) {
							var is_descbased='false';
							if(Ext.getCmp(this.id).getValue().modify_descriptorAggregation=='true') {
								is_descbased='true';
							}
							var showAllColumns = false;
							var conditionFound= false;
							var multiConditionFound= false;
							var mygrid_upper = Ext.getCmp('upper_measures_grid');
							var gridStore = mygrid_upper.getStore();
							for(var i = 0;i<gridStore.getCount();i++)
							{
								var afn = gridStore.getAt(i).get('upper_aggregate_function').trim();
								if(afn=="Condition")
								{
									conditionFound=true;
									showAllColumns=true;
								}
								else if(afn=="Multi-Condition")
								{
									multiConditionFound=true;
									showAllColumns=true;
								}
								if(conditionFound && multiConditionFound)
									break;
							}
							if(showAllColumns)
							{
								mygrid_upper.columns[4].setVisible(true);
								mygrid_upper.columns[5].setVisible(true);
								mygrid_upper.columns[6].setVisible(true);
								if(is_descbased=='true' && (conditionFound || multiConditionFound))
									mygrid_upper.columns[7].setVisible(true);
								else
									mygrid_upper.columns[7].setVisible(false);
								mygrid_upper.columns[8].setVisible(true);
							}
							else
							{
								mygrid_upper.columns[4].setVisible(false);
								mygrid_upper.columns[5].setVisible(false);
								mygrid_upper.columns[6].setVisible(false);
								mygrid_upper.columns[7].setVisible(false);
								mygrid_upper.columns[8].setVisible(false);
							}
							Ext.getCmp('upper_measures_grid').getView().refresh();

							var mygrid_lower = Ext.getCmp('lower_measures_grid');
							if(mygrid_lower != null)
							{
								conditionFound= false;
								multiConditionFound= false;
								showAllColumns = false;
								var gridStore = mygrid_lower.getStore();
								for(var i = 0;i<gridStore.getCount();i++)
								{
									var afn = gridStore.getAt(i).get('lower_aggregate_function').trim();
									if(afn=="Condition")
									{
										conditionFound=true;
										showAllColumns=true;
									}
									else if(afn=="Multi-Condition")
									{
										multiConditionFound=true;
										showAllColumns=true;
									}
									if(conditionFound && multiConditionFound)
										break;
								}
								if(showAllColumns)
								{
									mygrid_lower.columns[4].setVisible(true);
									mygrid_lower.columns[5].setVisible(true);
									mygrid_lower.columns[6].setVisible(true);
									if(is_descbased=='true' && (conditionFound || multiConditionFound))
										mygrid_lower.columns[7].setVisible(true);
									else
										mygrid_lower.columns[7].setVisible(false);
									mygrid_lower.columns[8].setVisible(true);
								}
								else
								{
									mygrid_lower.columns[4].setVisible(false);
									mygrid_lower.columns[5].setVisible(false);
									mygrid_lower.columns[6].setVisible(false);
									mygrid_lower.columns[7].setVisible(false);
									mygrid_lower.columns[8].setVisible(false);
								}
								Ext.getCmp('lower_measures_grid').getView().refresh();
							}
						}
					},
					items: [
						{
							xtype: 'radiofield',
							boxLabel: yes,
							name: 'modify_descriptorAggregation',
							id:'modify_nda1',
							inputValue: 'false'
						},
						{
							xtype: 'radiofield',
							boxLabel: no,
							name: 'modify_descriptorAggregation',
							id:'modify_nda2',
							inputValue: 'true'
						}
					]
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			title: 'Available Measures',
			id:"upper_measures_grid",
			hidden:true,
			flex:1,
			autoScroll:true,
			scroll:true,
			margin:'5 10 10 10',
			columnLines:true,
			sortableColumns:false,
			selModel :new Ext.selection.CheckboxModel({
				checkOnly: true,
				width:55,
				injectCheckbox: 'first'
			}),
			plugins: Ext.create('Ext.grid.plugin.CellEditing', {
				pluginId: 'upper_plugin',
				clicksToEdit: 1
			}),

			store:Ext.create('Ext.data.Store',{
				fields:['upper_measures_name', 'upper_measure_description', 'upper_aggregate_function','upper_relation','upper_value','upper_trgt_comp','upper_measure_value_in','upper_target_violation','upper_m_name','upper_m_unit'],
				data:[]
			}),
			tools: [
				{
					xtype: 'button',
					text: descPageTitle,
					name:'showAll',
					id:'showAll',
					cls:'button20'
				}
			],
			columns: [
				{
					header: "Performance measure name",
					dataIndex: 'upper_measures_name',
					flex: 1,
				},
				{
					header: "Aggregate measure name",
					dataIndex: 'upper_measure_description',
					flex: 1,
					field: {
						allowBlank: false
					}
				},
				{
					header: "Aggregate function",
					dataIndex: 'upper_aggregate_function',
					renderer:function(val,metaData){
						metaData.tdCls = "grid_editable_cell";
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['Average','Average'],
							['Minimum','Minimum'],
							['Maximum','Maximum'],
							['Sum','Sum'],
							['Average Sum','Average Sum'],
							['Percent','Percent'],
							['Condition','Condition'],
							['Multi-Condition','Multi-Condition']
						],
						listeners : {
							select : function(combo, records, eOpts ) {
								var is_descbased = 'true';
								if(Ext.getCmp('allowedId').isHidden())
								{
									is_descbased = Ext.getCmp('modify_allowedId').getValue().modify_descriptorAggregation;
								}
								else
								{
									is_descbased = Ext.getCmp('allowedId').getValue().descriptorAggregation;
								}
								var showAllColumns = false;
								var conditionFound=false;
								var multiConditionFound = false;
								var functionNow = combo.getValue();
								var gobj = Ext.getCmp('upper_measures_grid');
								var selectedModel = gobj.getSelectionModel().getSelection()[0];
								if(functionNow=='Condition' || functionNow=='Multi-Condition')
								{
									showAllColumns=true;
									gobj.columns[4].editable = true;
									gobj.columns[5].editable=false;
									gobj.columns[6].editable=false;
									gobj.columns[7].editable=false;
									gobj.columns[8].editable=false;
									selectedModel.set('upper_aggregate_function', functionNow);
									selectedModel.set('upper_relation', '>=');
									if(functionNow=='Condition')
									{
										conditionFound=true;
										selectedModel.set('upper_value', '0');
										selectedModel.set('upper_trgt_comp', 'Not Applicable');
									}
									else
									{
										multiConditionFound=true;
										selectedModel.set('upper_value', '-/-/50');
										selectedModel.set('upper_trgt_comp', '-/-/50');
									}
									selectedModel.set('upper_target_violation', 'Majority');
									selectedModel.set('upper_measure_value_in', 'Number');
								}
								else
								{
									gobj.columns[4].editable=false;
									gobj.columns[5].editable=true;
									gobj.columns[6].editable=true;
									gobj.columns[7].editable=true;
									gobj.columns[8].editable=true;
									selectedModel.set('upper_aggregate_function', functionNow);
									selectedModel.set('upper_relation', 'Not Applicable');
									selectedModel.set('upper_value', 'Not Applicable');
									selectedModel.set('upper_trgt_comp', 'Not Applicable');
									selectedModel.set('upper_target_violation', 'Not Applicable');
									selectedModel.set('upper_measure_value_in', selectedModel.data['upper_m_unit']);
								}
								if(!multiConditionFound)
								{
									var gridStore = Ext.getCmp('upper_measures_grid').getStore();
									for(var i = 0;i<gridStore.getCount();i++)
									{
										var afn = gridStore.getAt(i).get('upper_aggregate_function').trim();
										if(afn=="Condition")
										{
											conditionFound=true;
											showAllColumns=true;
										}
										else if(afn=="Multi-Condition")
										{
											multiConditionFound=true;
											showAllColumns=true;
										}
										if(conditionFound && multiConditionFound)
											break;
									}
								}
								var agg_fun_column = gobj.query('gridcolumn')[3];
								if(showAllColumns)
								{
									gobj.columns[4].setVisible(true);
									gobj.columns[5].setVisible(true);
									gobj.columns[6].setVisible(true);
									if(is_descbased=='true' && (conditionFound || multiConditionFound))
									{
										gobj.columns[7].setVisible(true);
									}
									else
									{
										gobj.columns[7].setVisible(false);
									}
									gobj.columns[8].setVisible(true);
									agg_fun_column.flex = 1;
								}
								else
								{
									gobj.columns[4].setVisible(false);
									gobj.columns[5].setVisible(false);
									gobj.columns[6].setVisible(false);
									gobj.columns[7].setVisible(false);
									gobj.columns[8].setVisible(false);
									if(agg_fun_column.flex) {
										delete agg_fun_column.flex;
									}
									agg_fun_column.setWidth(200);
								}
								gobj.doLayout();
								Ext.getCmp('upper_measures_grid').getView().refresh();
							}
						}
					})
				},
				{
					header: target_operation_lab,
					dataIndex: 'upper_relation',
					renderer:function(val,metaData){
						if(val !='Not Applicable')
						{
							metaData.tdCls = "grid_editable_cell";
						}
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['>','>'],
							['<','<'],
							['>=','>='],
							['<=','<='],
							['=','='],
							['Not Applicable','Not Applicable']
						]
					})
				},
				{
					header: target_values_lab,
					dataIndex: 'upper_value',
					flex: 1,
					field: {
						allowBlank: false
					},
					cellEditing:true
				},
				{
					header: target_components_lab,
					dataIndex: 'upper_trgt_comp',
					flex: 1,
					field: {
						allowBlank: false
					},
					cellEditing:true
				},
				{
					header: trgt_violation_lab,
					dataIndex: 'upper_target_violation',
					renderer:function(val,metaData){
						if(val !='Not Applicable')
						{
							metaData.tdCls = "grid_editable_cell";
						}
						return val;
					},
					flex: 1,
					hidden: false,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['All','All'],
							['Any','Any'],
							['Majority','Majority'],
							['Not Applicable','Not Applicable']
						]
					})
				},
				{
					header: measurement_unit_lab,
					dataIndex: 'upper_measure_value_in',
					renderer:function(val,metaData){
						metaData.tdCls = "grid_editable_cell";
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['%','%'],
							['Number','Number']
						]
					})
				},
				{
					header: "hiddenCol",
					dataIndex: 'upper_m_name',
					hidden: true
				},
				{
					header: "hiddenCol",
					dataIndex: 'upper_m_unit',
					hidden: true
				}
			],
			listeners:{
				render: function()
				{
					this.on('beforeedit', function(editor, e) {
						if(e.field=='upper_relation' || e.field=='upper_value' || e.field=='upper_trgt_comp' || e.field=='upper_measure_value_in' || e.field=='upper_target_violation')
						{
							var isAggFunction = e.record.data['upper_aggregate_function'];
							if(isAggFunction == 'Multi-Condition')
							{
								return true;
							}
							else if(isAggFunction == 'Condition' && e.field !='upper_trgt_comp')
							{
								return true;
							}
							return false;
						}
					});
				}
			}
		},
		{
			xtype:'container',
			id:'upper_measures_button_container',
			hidden:true,
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin: '0 0 10 0',
			items: [
				{
					xtype: 'button',
					text: 'Include',
					name: 'addMeasures',
					id:'addMeasures',
					cls:'button20'
				},
				{
					xtype: 'button',
					text: 'Modify',
					name: 'modifyMeasures',
					id:'modifyMeasures',
					margin: '0 0 0 20',
					cls:'button20'
				},
				{
					xtype: 'button',
					text: 'Exclude',
					name: 'deleteMeasures',
					id:'deleteMeasures',
					margin: '0 0 0 20',
					cls:'button20'
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			title: 'Excluded measures',
			id:"lower_measures_grid",
			autoScroll:true,
			scroll:true,
			hidden:true,
			flex:1,
			margin: 10,
			columnLines:true,
			sortableColumns:false,
			selModel :new Ext.selection.CheckboxModel({
				checkOnly: true,
				width:55,
				injectCheckbox: 'first'
			}),
			plugins: Ext.create('Ext.grid.plugin.CellEditing', {
				pluginId: 'lower_plugin',
				clicksToEdit: 1
			}),
			store:Ext.create('Ext.data.Store',{
				fields:['lower_measures_name', 'lower_measure_description', 'lower_aggregate_function','lower_relation','lower_value','lower_trgt_comp','lower_measure_value_in','lower_target_violation','lower_m_name','lower_m_unit'],
				data:[]
			}),
			columns: [
				{
					header: "Measure name",
					dataIndex: 'lower_measures_name',
					flex: 1,
				},
				{
					header: "Aggregate measure name",
					dataIndex: 'lower_measure_description',
					flex: 1,
					field: {
						allowBlank: false
					},
					cellEditing:true
				},
				{
					header: "Aggregate function",
					dataIndex: 'lower_aggregate_function',
					renderer:function(val,metaData){
						metaData.tdCls = "grid_editable_cell"
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['Average','Average'],
							['Minimum','Minimum'],
							['Maximum','Maximum'],
							['Sum','Sum'],
							['Average Sum','Average Sum'],
							['Percent','Percent'],
							['Condition','Condition'],
							['Multi-Condition','Multi-Condition']
						],
						listeners : {
							select : function(combo, records, eOpts ) {
								var is_descbased = 'true';
								if(Ext.getCmp('allowedId').isHidden())
								{
									is_descbased = Ext.getCmp('modify_allowedId').getValue().modify_descriptorAggregation;
								}
								else
								{
									is_descbased = Ext.getCmp('allowedId').getValue().descriptorAggregation;
								}
								var conditionFound= false;
								var multiConditionFound= false;
								var showAllColumns = false;
								var functionNow = combo.getValue();
								var gobj = Ext.getCmp('lower_measures_grid');
								var selectedModel = gobj.getSelectionModel().getSelection()[0];
								if(functionNow=='Condition' || functionNow=='Multi-Condition')
								{
									showAllColumns=true;
									gobj.columns[4].editable = true;
									gobj.columns[5].editable=false;
									gobj.columns[6].editable=false;
									gobj.columns[7].editable=false;
									gobj.columns[8].editable=false;
									selectedModel.set('lower_aggregate_function', functionNow);
									selectedModel.set('lower_relation', '>');
									if(functionNow=='Condition')
									{
										conditionFound=true;
										selectedModel.set('lower_value', '0');
										selectedModel.set('lower_trgt_comp', 'Not Applicable');
									}
									else
									{
										multiConditionFound=true;
										selectedModel.set('lower_value', '-/-/50');
										selectedModel.set('lower_trgt_comp', '-/-/50');
									}
									selectedModel.set('lower_target_violation', 'Majority');
									selectedModel.set('lower_measure_value_in', 'Number');
								}
								else
								{
									gobj.columns[4].editable=false;
									gobj.columns[5].editable=true;
									gobj.columns[6].editable=true;
									gobj.columns[7].editable=true;
									gobj.columns[8].editable=true;
									selectedModel.set('lower_aggregate_function', functionNow);
									selectedModel.set('lower_relation', 'Not Applicable');
									selectedModel.set('lower_value', 'Not Applicable');
									selectedModel.set('lower_trgt_comp', 'Not Applicable');
									selectedModel.set('lower_target_violation', 'Not Applicable');
									selectedModel.set('lower_measure_value_in', selectedModel.data['lower_m_unit']);
								}
								var gridStore = Ext.getCmp('lower_measures_grid').getStore();
								for(var i = 0;i<gridStore.getCount();i++)
								{
									var afn = gridStore.getAt(i).get('lower_aggregate_function').trim();
									if(afn=="Condition")
									{
										conditionFound=true;
										showAllColumns=true;
									}
									else if(afn=="Multi-Condition")
									{
										multiConditionFound=true;
										showAllColumns=true;
									}
									if(conditionFound && multiConditionFound)
										break;
								}
								var agg_fun_column = gobj.query('gridcolumn')[3];
								if(showAllColumns)
								{
									gobj.columns[4].setVisible(true);
									gobj.columns[5].setVisible(true);
									gobj.columns[6].setVisible(true);
									if(is_descbased=='true' && (conditionFound || multiConditionFound))
									{
										gobj.columns[7].setVisible(true);
									}
									else
									{
										gobj.columns[7].setVisible(false);
									}
									gobj.columns[8].setVisible(true);
									agg_fun_column.flex = 1;
								}
								else
								{
									gobj.columns[4].setVisible(false);
									gobj.columns[5].setVisible(false);
									gobj.columns[6].setVisible(false);
									gobj.columns[7].setVisible(false);
									gobj.columns[8].setVisible(false);
									if(agg_fun_column.flex) {
										delete agg_fun_column.flex;
									}
									agg_fun_column.setWidth(200);
								}
								gobj.doLayout();
								Ext.getCmp('lower_measures_grid').getView().refresh();
							}
						}
					})
				},
				{
					header: target_operation_lab,
					dataIndex: 'lower_relation',
					renderer:function(val,metaData){
						if(val !='Not Applicable')
						{
							metaData.tdCls = "grid_editable_cell"
						}
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['>','>'],
							['<','<'],
							['>=','>='],
							['<=','<='],
							['=','='],
							['Not Applicable','Not Applicable']
						]
					})
				},
				{
					header: target_values_lab,
					dataIndex: 'lower_value',
					flex: 1,
					field: {
						allowBlank: false
					},
					cellEditing:true
				},
				{
					header: target_components_lab,
					dataIndex: 'lower_trgt_comp',
					flex: 1,
					field: {
						allowBlank: false
					},
					cellEditing:true
				},
				{
					header: trgt_violation_lab,
					dataIndex: 'lower_target_violation',
					renderer:function(val,metaData){
						if(val !='Not Applicable')
						{
							metaData.tdCls = "grid_editable_cell";
						}
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['All','All'],
							['Any','Any'],
							['Majority','Majority'],
							['Not Applicable','Not Applicable']
						]
					})
				},
				{
					header: measurement_unit_lab,
					dataIndex: 'lower_measure_value_in',
					renderer:function(val,metaData){
						metaData.tdCls = "grid_editable_cell";
						return val;
					},
					flex: 1,
					editor: new Ext.form.field.ComboBox({
						cls: 'dropdown',
						sortable: false,
						editable: false,
						width:200,
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						fields : ['displayField', 'valueField'],
						store: [
							['%','%'],
							['Number','Number']
						]
					})
				},
				{
					header: "hiddenCol",
					dataIndex: 'lower_m_name',
					hidden: true
				},
				{
					header: "hiddenCol",
					dataIndex: 'lower_m_unit',
					hidden: true
				}
			],
			listeners:{
				render: function()
				{
					this.on('beforeedit', function(editor, e) {
						if(e.field=='lower_relation' || e.field=='lower_value' || e.field=='lower_trgt_comp'  || e.field=='lower_measure_value_in' || e.field=='lower_target_violation')
						{
							var isAggFunction = e.record.data['lower_aggregate_function'];
							if(isAggFunction == 'Condition' || isAggFunction == 'Multi-Condition')
							{
								return true;
							}
							return false;
						}
					});
				}
			}
		},
		{
			xtype:'container',
			id:'lower_measures_button_container',
			hidden:true,
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin: '0 0 10 0',
			items: [
				{
					xtype: 'button',
					text: 'Include',
					name: 'appendMeasures',
					id:'appendMeasures',
					cls:'button20'
				}
			]
		}
	]

});



