Ext.define('AggregateTree.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AggTreeView'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		appController = this;
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender,
				'boxready': this.treeCollapseEvent
			},
			'main > treepanel #Expand':
			{
				'click':this.onExpandAllClick
			},
			'main > treepanel #Collapse':
			{
				'click':this.onCollapseAllClick
			},
			'main > treepanel[id="TreeViewPanel"]':
			{
				'itemclick':this.loadPage
			},
		});
	},
	treeCollapseEvent: function()
	{
		if (!Ext.isEmpty(fromWizard) && fromWizard.startsWith('componentsGlance_'))
		{
			Ext.getCmp('TreeViewPanel').toggleCollapse( );
		}
	},
	afterMainRender: function()
	{
		Ext.Ajax.request(
		{
			url: 'AggregateTree/data/aggTreeViewJson.jsp?date='+new Date().getTime(),
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('TreeViewPanel').setRootNode(publicJSON);
					Ext.getCmp('TreeViewPanel').getSelectionModel().select(parseInt(selectedTreeNode));
					var link = '';
					if (selectedTreeNode == 1)
					{
						link = 'aggDispServer.jsp?qctr=0&reqfrom=navlink&isAggregateLink=true&date='+new Date().getTime();
						if(homepage_comptype != null && homepage_comptype.length>0)
						{
							if(homepage_nickport != null && homepage_nickport.length>0)
							{
								link = 'aggNewServer.jsp?server='+homepage_nickport+'&serverType='+homepage_comptype+'&modifyserver=true&operation=modify&serverGategory=-1';
							}
							else
							{
								var showOverviewBackButton= (from_manage_unmanage=='yes')?'no':'yes';
								link +='&comptype='+homepage_comptype+'&showOverviewBackButton='+showOverviewBackButton;
							}
						}
						homepage_comptype = null;
						homepage_nickport = null;
					}
					else if (selectedPage == "Groups")
					{
						link = 'aggShowDetails.jsp?elementType=group&selectedTreeNode='+selectedTreeNode+'&selectedPage='+selectedPage+'&date='+new Date().getTime()+'&name='+selCombo;
					}
					else if (selectedPage == "Segments")
					{
						link = 'aggShowDetails.jsp?elementType=segment&selectedTreeNode='+selectedTreeNode+'&selectedPage='+selectedPage+'&date='+new Date().getTime()+'&name='+selCombo;
					}
					else if (selectedPage == "Services")
					{
						link = 'aggShowDetails.jsp?elementType=service&selectedTreeNode='+selectedTreeNode+'&selectedPage='+selectedPage+'&date='+new Date().getTime()+'&name='+selCombo;
					}
					else if (selectedPage == "Zones")
					{
						link = 'aggShowDetails.jsp?elementType=zone&selectedTreeNode='+selectedTreeNode+'&selectedPage='+selectedPage+'&date='+new Date().getTime()+'&name='+selCombo;
					}
					else
					{
						link = redirectPage + '&date='+new Date().getTime();
					}

					Ext.get('Expand').on('click', function(event, target, options)
					{
						var obj = Ext.getCmp('Expand');
						if (obj.isExpanded == true)
						{
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+expandLebel+'</div>');
							obj.isExpanded = false;
							Ext.getCmp('TreeViewPanel').collapseAll();
						}
						else
						{
							obj.isExpanded = true;
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+collapseLabel+'</div>');
							Ext.getCmp('TreeViewPanel').expandAll();
						}
					});

					link = link + '&fromWizard='+fromWizard;
					if (!Ext.isEmpty(fromWizard) && fromWizard.startsWith('componentsGlance_'))
					{
						link = "aggNewServer.jsp?isAggregateLink=false&serverGategory=-1&serverType="+compGlanceCompType+"&compGlanceCompType="+compGlanceCompType+'&fromWizard='+fromWizard;
						if (!Ext.isEmpty(compGlanceCompName))
						{
							link += "&modifyserver=true&siteSupport=false&treeViewSrc=null&server="+compGlanceCompName;
						}
					}

					var tempObj = Ext.select('#SelectViewPanel');
					tempObj.set({src:link});
				}
			}
		});
	},
	onExpandAllClick: function()
	{
		var me = Ext.getCmp('TreeViewPanel');
		var toolbar = me.down('toolbar');
		me.getEl().mask('Expanding tree...');
		toolbar.disable();
		me.expandAll(function() {
			me.getEl().unmask();
			toolbar.enable();
		});
	},
	onCollapseAllClick: function()
	{
		var me = Ext.getCmp('TreeViewPanel');
		var toolbar = me.down('toolbar');
		toolbar.disable();
		me.collapseAll(function() {
			toolbar.enable();
		});
	},
	loadPage: function(view,record,item,index,event)
	{
		var selectedNode = record.data.text;
		if(selectedNode != null && selectedNode != 'Add/Modify Aggregates')
		{
			var parentForSelNode = record.parentNode.data.text;
			var selectedNumber = record.raw.selectedTreeNode;
			var selectedPage = record.raw.selectedPage;
			var tempObj = Ext.select('#SelectViewPanel');
			if (selectedNode != 'undefined')
			{
				if(selectedNode == 'Components' && parentForSelNode == 'Add/Modify Aggregates')
				{
					var link = 'aggDispServer.jsp?qctr=0&reqfrom=navlink&isAggregateLink=true&date='+new Date().getTime();
				}
				else if(selectedNode == 'Groups' && parentForSelNode == 'Add/Modify Aggregates')
				{
					var link = 'aggShowDetails.jsp?elementType=group&selectedTreeNode='+selectedNumber+'&selectedPage='+selectedPage+'&date='+new Date().getTime();
				}
				else if(selectedNode == 'Segments' && parentForSelNode == 'Add/Modify Aggregates')
				{
					var link = 'aggShowDetails.jsp?elementType=segment&selectedTreeNode='+selectedNumber+'&selectedPage='+selectedPage+'&date='+new Date().getTime();
				}
				else if(selectedNode == 'Services' && parentForSelNode == 'Add/Modify Aggregates')
				{
					var link = 'aggShowDetails.jsp?elementType=service&selectedTreeNode='+selectedNumber+'&selectedPage='+selectedPage+'&date='+new Date().getTime();
				}
				else if(selectedNode == 'Zones' && parentForSelNode == 'Add/Modify Aggregates')
				{
					var link = 'aggShowDetails.jsp?elementType=zone&selectedTreeNode='+selectedNumber+'&selectedPage='+selectedPage+'&date='+new Date().getTime();
				}
				else
				{
					if(parentForSelNode == "Groups")
					{
						var link = 'aggShowTypes.jsp?operation=add&element=group&name='+selectedNode+'&date='+new Date().getTime();
					}
					else if(parentForSelNode == "Segments")
					{
						var link = 'aggShowTypes.jsp?operation=add&element=segment&name='+selectedNode+'&date='+new Date().getTime();
					}
					else if(parentForSelNode == "Services")
					{
						var link = 'aggShowTypes.jsp?operation=add&element=service&name='+selectedNode+'&date='+new Date().getTime();
					}
					else if(parentForSelNode == "Zones")
					{
						var link = 'aggShowTypes.jsp?operation=add&element=zone&name='+selectedNode+'&date='+new Date().getTime();
					}
					link += '&selectedTreeNode='+selectedNumber+'&selectedPage=childPage';
				}
			}

			if (!Ext.isEmpty(compGlanceCompType))
			{
				link = link + '&fromWizard='+fromWizard+'&compGlanceCompType='+compGlanceCompType;
			}
			else
			{
				link = link + '&fromWizard='+fromWizard;
			}
			tempObj.set({src:link});
		}
	}
});