Ext.define('AlarmPolicy.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'alarmpolicies', ref:'alarmpolicies'},
		{selector:'alarmpolicy', ref:'alarmpolicy'},
		{selector:'showassociates', ref:'showassociates'}
	],
	init:function(){
		me = this,
		this.control({
			'alarmpolicies':
			{
				'afterrender': this.afterMainRender
			},
			'alarmpolicies button[id="addNewPolicyBtn"]':
			{
				'click': this.addNewPolicy
			},
			'alarmpolicy button[id="updateBtn"]':
			{
				'click':this.updateAlarmPolicy
			},
			'alarmpolicies [id="preDefineAlarmPolicyGrid"]':
			{
				itemmouseenter: this.showPreDefineTool,
				itemmouseleave: this.hidePreDefineTool
			},
			'alarmpolicies [id="userDefineAlarmPolicyGrid"]':
			{
				'itemmouseenter': this.showUserDefineTool,
				'itemmouseleave': this.hideUserDefineTool
			},
			'alarmpolicies trigger[id="searchTrigger"]':
			{
				'change': this.alarmPolicySearch
			},
			'alarmpolicies trigger[id="searchTrigger1"]':
			{
				'change': this.alarmPolicySearch
			}
		});
	},
	alarmPolicySearch : function(obj)
	{
		var fromId = obj.id;
		if (!Ext.isEmpty(fromId) && fromId == 'searchTrigger')
		{
			searchStr = Ext.getCmp('searchTrigger').getValue();
		}
		else
		{
			searchStr = Ext.getCmp('searchTrigger1').getValue();
		}
		
		if (!Ext.isEmpty(fromId) && fromId == 'searchTrigger')
		{
			if (searchStr == "" || searchStr.length == 0)
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');
			}
		}
		else
		{
			if (searchStr == "" || searchStr.length == 0)
			{
				Ext.get('MyTrigger1_0').setStyle('display','none');
				Ext.get('MyTrigger1_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger1_1').setStyle('display','none');
				Ext.get('MyTrigger1_0').setStyle('display','block');
			}
		}
		if (searchStr == null || searchStr == "")
		{
			urlVal = 'AlarmPolicy/data/EgAlarmPolicyJson.jsp';
		}
		else if (searchStr != null)
		{
			urlVal ='AlarmPolicy/data/EgAlarmPolicyJson.jsp?egTitleSearchStr='+encodeURI(searchStr);
		}
		Ext.Ajax.request({
			url: urlVal,
			method: 'POST',
			scope: this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var noPreDefSearchStr = publicJson['no_predefine_search_item'];
					var noUserDefSearchStr = publicJson['no_userdefine_search_item'];

					if (!Ext.isEmpty(fromId) && fromId == 'searchTrigger')
					{
						if (noPreDefSearchStr != null && noPreDefSearchStr != 'undefined')
						{
							Ext.getCmp('preDefineAlarmPolicyGrid').store.loadData('');
							Ext.getCmp('preDefineAlarmPolicyGrid').getView().emptyText = '<table align="center" height="400"><tr><td align="center" ><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noPreDefineAlarmFound+'.</td></tr></table></td></tr></table>';
							Ext.getCmp('preDefineAlarmPolicyGrid').getView().refresh();
						}
						else
						{
							Ext.getCmp('preDefineAlarmPolicyGrid').show();
							Ext.getCmp('preDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['DefaultAlramList']);
						}
					}
					else
					{
						if (noUserDefSearchStr != null && noUserDefSearchStr != 'undefined')
						{
							Ext.getCmp('userDefineAlarmPolicyGrid').store.loadData('');
							Ext.getCmp('userDefineAlarmPolicyGrid').getView().emptyText = '<table align="center" height="400"><tr><td align="center" ><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noUserDefineAlarmFound+'.</td></tr></table></td></tr></table>';
							Ext.getCmp('userDefineAlarmPolicyGrid').getView().refresh();
						}
						else
						{
							if(publicJson['userDefAlarmArr'] != null && publicJson['userDefAlarmArr'] != 'undefined')
							{
								Ext.getCmp('userDefineAlarmPolicyGrid').show();
								Ext.getCmp('userDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['userDefAlarmArr']);
							}
						}
					}
				}
			}
		});
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e)
	{
		this.showEditWindow(view.getRecord(view.findTargetByEvent(e)));
    },
    handleDeleteIconClick: function(view, rowIndex, colIndex) 
	{
		var task = Ext.getCmp('userDefineAlarmPolicyGrid').getStore().getAt(rowIndex);
		this.deleteTask(task);
    },
	handleShowAssociateIconClick: function(view, rowIndex, colIndex) 
	{
		var task = Ext.getCmp('userDefineAlarmPolicyGrid').getStore().getAt(rowIndex);
		this.showAssociateTask(task);
    },
	deleteTask: function(task, successCallback)
	{
		var polName =  task.get('Policy');
		Ext.Msg.show({
			title: pageName,
			msg: alert1+" '"+polName +"'?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
            fn: function(response) {
				if(response === 'yes')
				{
					var alarmName = task.get('Policy');
					Ext.Ajax.request({
						url:'AlarmPolicy/data/Egconfigalarmpolicyp.jsp?mode=del&alarmName='+alarmName,
						method:'post',
						scope:this,
						success:function(response)
						{
								Ext.Msg.show({
									title: pageName,
									msg: alert2,
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: function() {
										Ext.Ajax.request({
										url:'AlarmPolicy/data/EgAlarmPolicyJson.jsp?',
										method:'post',	
										scope:this,
										async: false,
										success:function(response)
										{
											if(response.status == 200 && !Ext.isEmpty(response.responseText))
											{
												var jsonText = response.responseText;
												publicJson = Ext.decode(jsonText);
												var noUserDefSearchStr = publicJson['no_userdefine_item'];
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().removeAll();
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['DefaultAlramList']);

												if(publicJson['userDefAlarmArr'] != null && publicJson['userDefAlarmArr'] != 'undefiend')
												{
													Ext.getCmp('searchTrigger1').setDisabled(false);
													Ext.getCmp('userDefineAlarmPolicyGrid').show();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().removeAll();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['userDefAlarmArr']);
												}
												else
												{
													if (!Ext.isEmpty(noUserDefSearchStr) && noUserDefSearchStr != undefined)
													{
														Ext.getCmp('searchTrigger1').setDisabled(true);
														Ext.getCmp('userDefineAlarmPolicyGrid').show();
														Ext.getCmp('userDefineAlarmPolicyGrid').store.loadData('');
														Ext.getCmp('userDefineAlarmPolicyGrid').getView().emptyText = noUserDefSearchStr;
														Ext.getCmp('userDefineAlarmPolicyGrid').getView().refresh();
													}
												}
											}
										}
									});
								}
							});
						}
					});
				}
			}
        });
    },
	showEditWindow: function(task)
	{
		var alarmPolicyName = task.get('Policy');
		var winSize = task.get('WindowSize');
		var noc = task.get('NoC');
        var me = this;
        var taskEditWindow = Ext.widget('alarmpolicy');
		Ext.Ajax.request({
			url:'AlarmPolicy/data/EgConfigAlarmPolicyJson.jsp?flag=true&mod=modify&window='+winSize+'&noCross='+noc+'&alarmName='+alarmPolicyName,
			method:'post',	
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					taskEditWindow.show();
					Ext.getCmp('alarmPolicyText').setValue(publicJson['alarmPolicy']);
					Ext.getCmp('alarmPolicyText').setReadOnly(true);

					Ext.getCmp('winSizeText').setValue(publicJson['winSize_value']);
					Ext.getCmp('nocText').setValue(publicJson['noCross_value']);
					Ext.getCmp('updateBtn').setText('Update');
					
				}
			}
		});
	},
	showAssociateTask: function(task)
	{
		var alarmPolicyName = task.get('Policy');
		var winSize = task.get('WindowSize');
		var noc = task.get('NoC');
        var me = this;
        var taskEditWindow = Ext.widget('showassociates');
		Ext.Ajax.request({
			url:'AlarmPolicy/data/EgAlarmPolicyAssociatesJson.jsp?policy='+alarmPolicyName,
			method:'post',	
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					taskEditWindow.show();
					policyName = publicJson['policyName'];
					Ext.getCmp('showassociates').setTitle(label11+'&nbsp;'+policyName);
					defaultAssoAlarmGridArr = publicJson['defaultAssoAlarmGridArr'];
					specificAssoAlarmGridArr = publicJson['specificAssoAlarmGridArr'];
					descAssoAlarmGridArr = publicJson['descAssoAlarmGridArr'];
					grpRuleAssoAlarmGridArr = publicJson['grpRuleAssoAlarmGridArr'];
					
					if (descAssoAlarmGridArr != null && descAssoAlarmGridArr != 'undefined' && !Ext.isEmpty(descAssoAlarmGridArr))
					{
						if (Ext.getCmp('descThreshAlarmPolGrid').isHidden())
							Ext.getCmp('descThreshAlarmPolGrid').show();
						Ext.getCmp('descThreshAlarmPolGrid').getStore().removeAll();
						Ext.getCmp('descThreshAlarmPolGrid').getStore().loadRawData(descAssoAlarmGridArr);
					}
					else
					{
						if (Ext.getCmp('descThreshAlarmPolGrid').isVisible())
							Ext.getCmp('descThreshAlarmPolGrid').hide();
					}

					if (specificAssoAlarmGridArr != null && specificAssoAlarmGridArr != 'undefined' && !Ext.isEmpty(specificAssoAlarmGridArr))
					{
						if (Ext.getCmp('specificThreshAlarmPolGrid').isHidden())
							Ext.getCmp('specificThreshAlarmPolGrid').show();
						Ext.getCmp('specificThreshAlarmPolGrid').getStore().removeAll();
						Ext.getCmp('specificThreshAlarmPolGrid').getStore().loadRawData(specificAssoAlarmGridArr);
					}
					else
					{
						if (Ext.getCmp('specificThreshAlarmPolGrid').isVisible())
							Ext.getCmp('specificThreshAlarmPolGrid').hide();
					}
					
					if (grpRuleAssoAlarmGridArr != null && grpRuleAssoAlarmGridArr != 'undefined' && !Ext.isEmpty(grpRuleAssoAlarmGridArr))
					{
						if (Ext.getCmp('grpRuleThreshAlarmPolGrid').isHidden())
							Ext.getCmp('grpRuleThreshAlarmPolGrid').show();

						Ext.getCmp('grpRuleThreshAlarmPolGrid').getStore().removeAll();
						Ext.getCmp('grpRuleThreshAlarmPolGrid').getStore().loadRawData(grpRuleAssoAlarmGridArr);
					}
					else
					{
						if (Ext.getCmp('grpRuleThreshAlarmPolGrid').isVisible())
							Ext.getCmp('grpRuleThreshAlarmPolGrid').hide();
					}

					if (defaultAssoAlarmGridArr != null && defaultAssoAlarmGridArr != 'undefined' && !Ext.isEmpty(defaultAssoAlarmGridArr))
					{
						if (Ext.getCmp('defaultThreshAlarmPolGrid').isHidden())
							Ext.getCmp('defaultThreshAlarmPolGrid').show();
						Ext.getCmp('defaultThreshAlarmPolGrid').getStore().removeAll();
						Ext.getCmp('defaultThreshAlarmPolGrid').getStore().loadRawData(defaultAssoAlarmGridArr);
					}
					else
					{
						if (Ext.getCmp('defaultThreshAlarmPolGrid').isVisible())
							Ext.getCmp('defaultThreshAlarmPolGrid').hide();
					}
				}
			}
		});
	},
	afterMainRender: function()
	{
		var urlVal = 'AlarmPolicy/data/EgAlarmPolicyJson.jsp?';
		if(isSubmit != null && isSubmit == 'Yes')
		{
			urlVal += defaultParams;
		}
		Ext.Ajax.request({
			url:urlVal, //'AlarmPolicy/data/EgAlarmPolicyJson.jsp?',
			method:'post',	
			scope:this,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var noUserDefSearchStr = publicJson['no_userdefine_item'];

					Ext.getCmp('preDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['DefaultAlramList']);
					if(publicJson['userDefAlarmArr'] != null && publicJson['userDefAlarmArr'] != 'undefiend')
					{
						Ext.getCmp('userDefineAlarmPolicyGrid').show();
						Ext.getCmp('userDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['userDefAlarmArr']);
					}
					else
					{
						if (!Ext.isEmpty(noUserDefSearchStr) && noUserDefSearchStr != undefined)
						{
							Ext.getCmp('searchTrigger1').setDisabled(true);
							Ext.getCmp('userDefineAlarmPolicyGrid').show();
							Ext.getCmp('userDefineAlarmPolicyGrid').store.loadData('');
							Ext.getCmp('userDefineAlarmPolicyGrid').getView().emptyText = noUserDefSearchStr;
							Ext.getCmp('userDefineAlarmPolicyGrid').getView().refresh();
						}
					}
				}
			}
		});
	},
	showPreDefineTool: function(view, record, item, index, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		 });
	},
	hidePreDefineTool: function( view, record, item, index, e, eOpts )
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	showUserDefineTool: function(view, record, item, index, e)
	{
		var showIcon = view.getStore().getAt(index);
		var isAssociateView = showIcon.get('isPolAssociated');

		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			if(!isAssociateView)
			{
				//Ext.get(icons[1]).removeCls('x-hidden');
				//Ext.get(icons[2]).removeCls('x-hidden');
			}
			else
			{
				//Ext.get(icon).removeCls('x-hidden');
				//Ext.get(icons[0]).removeCls('x-hidden');
				//Ext.get(icons[1]).removeCls('x-hidden');
			}
		 });
	},
	hideUserDefineTool: function( view, record, item, index, e, eOpts )
	{
		var hideIcon = view.getStore().getAt(index);
		var isAssociateView = hideIcon.get('isPolAssociated');
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);

		Ext.each(icons, function(icon){
			if(!isAssociateView)
			{
				//Ext.get(icons[1]).addCls('x-hidden');
				//Ext.get(icons[2]).addCls('x-hidden');
			}
			else
			{
				//Ext.get(icon).addCls('x-hidden');
			}
		});
	},
	
	updateAlarmPolicy: function()
	{
		var btnText = Ext.getCmp('updateBtn').getText();
		if (btnText == 'Add')
		{
			var alarm_policy = jsonData['hidden_s_alarm_policy'];
			var alar=Ext.getCmp('alarmPolicyText').getValue();
			var alm_policy=true;
			var isDouble = jsonData['isDouble'];
			if('<%=isDouble%>'=="false")
				alm_policy = validateSingleByte(alar);
			alar = alar.toLowerCase();
			if (alar == "new" || alar == "none")
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert3+" '" +alar+ "'.",
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmPolicyText').focus();
					}
				});
				return;
			}
			var alarm_count = jsonData['hidden_i_alarm_count'];
			var alarm_policy_array = new Array(alarm_count);

			var p = 0;
			for(var q=0; q<alarm_count; q++)
			{
				if(alarm_policy.indexOf(",") > 0)
				{
					var values = alarm_policy.split(',');
					for(var l=0; l<values.length; l++)
					{
						alarm_policy_array[p] = values[l];
						p++;
					}
				}
				else
				{
					alarm_policy_array[p] = alarm_policy;
					p++;
				}
			}

			for(var m=0; m<alarm_policy_array.length; m++)
			{
				var strCheck = alarm_policy_array[m];
				if(alar == strCheck)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert4,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('alarmPolicyText').focus();
						}
					});
					return;
				}
			}

			var win=Ext.getCmp('winSizeText').getValue();
			var cross=Ext.getCmp('nocText').getValue();
			win++;
			cross++;
			var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()_-+=[]{}|\\:;\"\'<>,?\/";
			if(!checkblank(alar))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert5,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmPolicyText').focus();
					}
				});
			}
			else if(!checkspecialnomess(alar,"`~!@#$%^&*()+=[]{}|\\:;\"\'<>,?\/"))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert6,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmPolicyText').focus();
					}
				});
			}
			else if(!checkspace(alar))
			{
				Ext.getCmp('alarmPolicyText').focus();
			}
			else if(!alm_policy)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert4,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmPolicyText').focus();
					}
				});
			}
			else if(!checkblank(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert5,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!checkspecialnomess(Ext.getCmp('winSizeText').getValue(),splChar))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert8,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!check(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.getCmp('winSizeText').focus();
			}
			else if(!checkspace(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.getCmp('winSizeText').focus();
			}
			else if(win < 2)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert9,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!checkblank(Ext.getCmp('nocText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert5,
					width: alert5.length * 7,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!checkspace(Ext.getCmp('nocText').getValue()))
			{
				Ext.getCmp('nocText').focus();
			}
			else if(!checkspecialnomess(Ext.getCmp('nocText').getValue(),splChar))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert8,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!check(Ext.getCmp('nocText').getValue()))
			{
				Ext.getCmp('nocText').focus();
			}
			else if(cross < 2)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert10,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(cross > win)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert11,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!isNumeric(Ext.getCmp('winSizeText').getValue()) || !isNumeric(Ext.getCmp('nocText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert12,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			else
			{
				var winSize=Ext.getCmp('winSizeText').getValue();
				var crossNum=Ext.getCmp('nocText').getValue();
				Ext.Ajax.request({
					url:'AlarmPolicy/data/Egconfigalarmpolicyp.jsp?new0='+alar+'&new1='+winSize+'&new2='+crossNum+'&mode=add',
					method:'post',	
					scope:this,
					success:function(response)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert13,
							width: alert13.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function()
							{
								Ext.getCmp('alarmPolicyWindowId').destroy();
								var searchStr = Ext.getCmp('searchTrigger').getValue();
								if (!Ext.isEmpty(searchStr))
								{
									me.alarmPolicySearch()
								}
								else
								{
									Ext.Ajax.request({
										url:'AlarmPolicy/data/EgAlarmPolicyJson.jsp?',
										method:'post',	
										scope:this,
										async: false,
										success:function(response)
										{
											if(response.status == 200 && !Ext.isEmpty(response.responseText))
											{
												var jsonText = response.responseText;
												publicJson = Ext.decode(jsonText);
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().removeAll();
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['DefaultAlramList']);
												if(publicJson['userDefAlarmArr'] != null && publicJson['userDefAlarmArr'] != 'undefiend')
												{
													Ext.getCmp('searchTrigger1').setDisabled(false);
													Ext.getCmp('userDefineAlarmPolicyGrid').show();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().removeAll();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['userDefAlarmArr']);
												}
											}
										}
									});
								}
							}
						});
					}
				});
			}
		}
		else if(btnText == 'Update')
		{
			var win=Ext.getCmp('winSizeText').getValue();
			var cross=Ext.getCmp('nocText').getValue();
			win++;
			cross++;
			var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()_-+=[]{}|\\:;\"\'<>,?\/";
			if(!checkblank(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert5,
					buttons: Ext.MessageBox.OK,
					width: alert5.length * 7,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!checkspecialnomess(Ext.getCmp('winSizeText').getValue(),splChar))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert8,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					width: alert8.length * 7,
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!check(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.getCmp('winSizeText').focus();
			}
			else if(!checkspace(Ext.getCmp('winSizeText').getValue()))
			{
				Ext.getCmp('winSizeText').focus();
			}
			else if(win < 2)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert9,
					width: alert9.length * 7,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winSizeText').focus();
					}
				});
			}
			else if(!checkblank(Ext.getCmp('nocText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert5,
					width: alert5.length * 7,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!checkspace(Ext.getCmp('nocText').getValue()))
			{
				Ext.getCmp('nocText').focus();
			}
			else if(!checkspecialnomess(Ext.getCmp('nocText').getValue(),splChar))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert8,
					buttons: Ext.MessageBox.OK,
					width: alert8.length * 7,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!check(Ext.getCmp('nocText').getValue()))
			{
				Ext.getCmp('nocText').focus();
			}
			else if(cross < 2)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert10,
					width: alert10.length * 7,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(cross > win)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert11,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					width: alert11.length * 7,
					fn: function() {
						Ext.getCmp('nocText').focus();
					}
				});
			}
			else if(!isNumeric(Ext.getCmp('winSizeText').getValue()) || !isNumeric(Ext.getCmp('nocText').getValue()))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert12,
					width: alert12.length * 7,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
				});
				return;
			}
			else
			{
				var winSize=Ext.getCmp('winSizeText').getValue();
				var crossNum=Ext.getCmp('nocText').getValue();
				var alarm_policy_mod = publicJson['winSize_value'];
				var alarm_count_mod = publicJson['noCross_value'];
				Ext.Ajax.request({
					url:'AlarmPolicy/data/Egconfigalarmpolicyp.jsp?text1='+winSize+'&text2='+crossNum+'&mode=modify'+'&alarm_policy_mod='+alarm_policy_mod+'&alarm_count_mod='+alarm_count_mod,
					method:'post',	
					scope:this,
					success:function(response)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert14,
							width: alert14.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('alarmPolicyWindowId').destroy();
								var searchStr = Ext.getCmp('searchTrigger').getValue();
								if (!Ext.isEmpty(searchStr))
								{
									me.alarmPolicySearch()
								}
								else
								{
									Ext.Ajax.request({
										url:'AlarmPolicy/data/EgAlarmPolicyJson.jsp?',
										method:'post',	
										scope:this,
										async: false,
										success:function(response)
										{
											if(response.status == 200 && !Ext.isEmpty(response.responseText))
											{
												var jsonText = response.responseText;
												publicJson = Ext.decode(jsonText);
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().removeAll();
												Ext.getCmp('preDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['DefaultAlramList']);
												if(publicJson['userDefAlarmArr'] != null && publicJson['userDefAlarmArr'] != 'undefiend')
												{
													Ext.getCmp('searchTrigger1').setDisabled(false);
													Ext.getCmp('userDefineAlarmPolicyGrid').show();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().removeAll();
													Ext.getCmp('userDefineAlarmPolicyGrid').getStore().loadRawData(publicJson['userDefAlarmArr']);
												}
											}
										}
									});
								}
							}
						});
					}
				});
			}
		}
	},
	addNewPolicy: function()
	{
		from = "add";
		Ext.Ajax.request({
			url:'AlarmPolicy/data/EgConfigAlarmPolicyJson.jsp?flag=true&alarmName=new&isSumbit=Yes',
			method:'post',	
			scope:this,
			success:function(response)
			{	
				var jsonText = response.responseText;
				jsonData = Ext.decode(jsonText);
				var windowMail = Ext.widget('alarmpolicy');
				
				windowMail.show();
				
			}
		});
	}
});

function check(field)
{
	var dot_count = 0;
	s_val = field.value;
	for(x=0;x < field.length;x++)
	{
		if(field.charAt(x) == '.')
		{
			dot_count = dot_count + 1;
		}
		else
		{
			continue;
		}
	}
	if(dot_count > 0)
	{
		Ext.Msg.show ({
			title: pageName,
			msg: alert15,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation',
		});
		return false;
	}
	if(field.charAt(field.length - 1) == '.')
	{
		Ext.Msg.show ({
			title: pageName,
			msg: alert16,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation',
		});
		return false;
	}
	return true;
}

function isNumeric(sText)
{
	var validChars = "0123456789";
	var isNumber = true;
	var character;
	for (i = 0; i < sText.length; i++)
	{
		character = sText.charAt(i);
		if (validChars.indexOf(character) == -1)
		{
			isNumber = false;
			break;
		}
	}
	return isNumber;
}



