Ext.define('AlarmPolicy.view.AlarmPolicies', {
	extend:'utilities.innerScrollContainer',
	alias: 'widget.alarmpolicies',
	cls:'outerpanel',
	title: pageName,
	margin: '8 8 0 8',

	requires : [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		width: '100%',
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle" >&nbsp;&nbsp;'+pageDesc+'.</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'container',
			flex: 1,
			layout: {
				type: 'hbox',
				align:'stretch',
			},
			items: [
				{
					xtype: 'customgrid',
					cls:'gridSkin',
					id: 'preDefineAlarmPolicyGrid',
					title: label2,
					store:new Ext.data.Store(
					{
						fields: ['Policy', 'WindowSize', 'NoC'],
						data: []
					}),
					autoScroll: true,
					scroll: true,
					flex: 1,
					viewConfig: {
						deferEmptyText: true
					},
					emptyText: '<table align="center" height="400"><tr><td align="center"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noPreDefineAlarmFound+'</td></tr></table></td></tr></table>',
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: label3,
								id: 'policyNameId',
								dataIndex: 'Policy',
								flex:1
							},
							{
								text: label4,
								id: 'winSizeId',
								dataIndex: 'WindowSize',
								flex:1
							},
							{
								text: label5,
								id: 'nocId',
								dataIndex: 'NoC',
								flex:1
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								//icon: '../../../../resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: label6,
								sortable: false,
								handler: function(view, rowIndex, colIndex, column, e) {
									me.handleEditIconClick(view, rowIndex, colIndex, column, e);
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
								}
							}
						]
					},
					margin: '10 5 10 10',
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							id: 'searchTrigger',
							itemId: 'searchTrigger1',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							//padding: '2 6 2 0',
							margin:'0 0 0 0',
							padding:0,
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										 });
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function()
							{
								this.reset();
								me.alarmPolicySearch(this);
							},
							onTrigger2Click: function()
							{
								me.alarmPolicySearch(this);
							}
						}
					]
				},
				{
					xtype: 'customgrid',
					cls:'gridSkin',
					id: 'userDefineAlarmPolicyGrid',
					title: label7,
					store:new Ext.data.Store(
					{
						fields: ['Policy', 'WindowSize', 'NoC','isPolAssociated'],
						data: []
					}),
					autoScroll: true,
					scroll: true,
					flex: 1,
					viewConfig: {
						deferEmptyText: true
					},
					emptyText: '<table align="center" height="400"><tr><td align="center"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noUserDefineAlarmFound+'</td></tr></table></td></tr></table>',
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: label3,
								dataIndex: 'Policy',
								flex:1
							},
							{
								text: label4,
								dataIndex: 'WindowSize',
								flex:1
							},
							{
								text: label5,
								dataIndex: 'NoC',
								flex:1
							},
							{
								xtype: 'actioncolumn',
								dataIndex: 'showAssociate',
								//cls: 'tasks-icon-column-header tasks-associate-column-header',
								width: 36,
								//icon: '../../../../resources/images/new_list.png',
								iconCls: 'iconShowAssociates',
								//tooltip: label8,
								sortable: false,
								//disabled: true,
								handler: function(view,rowIndex,colIndex,column,e) {
									var isPolAssociated = view.getStore().getAt(rowIndex).get('isPolAssociated');
									if (isPolAssociated)
									{
										me.handleShowAssociateIconClick(view, rowIndex, colIndex, column,e);
									}
									else
									{
										return false;
									}
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var isPolAssociated = record.get('isPolAssociated');
									metaData.tdAttr = "data-qtip='"+label8+"' data-qclass='yellowTip'";
									if (!isPolAssociated)
									{
										metaData.style = "filter:alpha(opacity=20);opacity:.2;cursor:hand;"
									}
									return value;
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								//icon: '../../../../resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: label6,
								sortable: false,
								handler: function(view, rowIndex, colIndex, column, e) {
									me.handleEditIconClick(view, rowIndex, colIndex, column, e);
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='"+label6+"' data-qclass='yellowTip'";
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-delete-column-header',
								width: 36,
								//icon: '../../../../resources/images/delete.png',
								//iconCls: 'iconDelete',
								//tooltip: label9,
								sortable: false,
								//handler: function(view, rowIndex, colIndex, column, e) {me.handleDeleteIconClick(view, rowIndex, colIndex, column, e);},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var isPolAssociated = record.get('isPolAssociated');

									metaData.tdAttr = "data-qtip='"+label9+"' data-qclass='yellowTip'";
									if (isPolAssociated)
									{
										return '<div class="iconDeleteDisabled"></div>';
									}
									else
									{
										return "<div style='cursor:pointer' onclick=\"javascript:me.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
									}
								}
							}
						]
					},
					margin: '10 10 10 5',
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							id: 'searchTrigger1',
							margin:'0 5 0 0',
							padding:0,
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger1_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger1_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										 });
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function()
							{
								this.reset();
								me.alarmPolicySearch(this);
							},
							onTrigger2Click: function()
							{
								me.alarmPolicySearch(this);
							}
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							margin:0,
							padding:0,
							items:[
								{
									xtype: 'button',
									id: 'addNewPolicyBtn',
									cls:'button20',
									margin:0,
									padding:0,
									text: label1
								}
							]
						}
					]
				}
			]
		}
	]
});



