
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.egurkha.util.EgSorter" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject resultObj = new JSONObject();
	screenLabels.put("TITLE"," AGENTS - ALARM POLICIES");
	IniFile thresholdsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");

	EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String strSortBy = request.getParameter("strSortBy");
	String orderby = request.getParameter("orderby");
	if (strSortBy == null || strSortBy.equals(""))
	{
		strSortBy = "winsize";
	}
	if (orderby == null || orderby.equals(""))
	{
		orderby = "asc";
	}

	boolean sortbyPolicy = strSortBy.equals("policy");
	boolean sortbywinsize = strSortBy.equals("winsize");
	boolean sortbyNoc = strSortBy.equals("noc");
	boolean orderbyAsc = orderby.equals("asc");
	boolean orderbyDesc = orderby.equals("desc");

	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	if (egTitleSearchStr == null)
	{
		egTitleSearchStr = "";
	}
	boolean isSearchResult = (egTitleSearchStr != null && !egTitleSearchStr.equals(""));
	boolean allPermission = ri.hasAllComponentAccess();
	rootJson.put("allPermission",allPermission);
	boolean searchItemFound = false;
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals("")) continue;
			searchList.add(thisToken);
		}
	}

	ArrayList defaultAlarmList = new ArrayList();
	ArrayList defaultAlarmListNew = new ArrayList();
	ArrayList userDefinedAlarmList = new ArrayList();

	String defaultPolicies[] = uiIni.getVariables("DEFAULT_ALARM_POLICY");
	if (defaultPolicies != null)
	{
		defaultAlarmList = new ArrayList(Arrays.asList(defaultPolicies));
	}
	
	String subject = "ALARM_POLICY";
	String alarmVariables[] = thresholdsIni.getVariables(subject);

	for (int z=0;z<alarmVariables.length;z++)
	{
		String value1 = thresholdsIni.getValue(subject,alarmVariables[z]).trim();
		StringTokenizer token = new StringTokenizer(value1,",");
		String windowSize = token.nextToken();
		String nocalarmPolicy = token.nextToken();
		if (defaultAlarmList.contains(alarmVariables[z]))
		{
			defaultAlarmListNew.add(alarmVariables[z]);
			defaultAlarmListNew.add(windowSize);
			defaultAlarmListNew.add(nocalarmPolicy);
		}
		else
		{
			userDefinedAlarmList.add(alarmVariables[z]);
			userDefinedAlarmList.add(windowSize);
			userDefinedAlarmList.add(nocalarmPolicy);
		}
	}

	EgSorter sorter = new EgSorter(defaultAlarmListNew,3);
	if (strSortBy.equals("policy"))
	{
		defaultAlarmListNew = (ArrayList)sorter.sort(1,"String",orderby);
	}
	else if (strSortBy.equals("winsize"))
	{
		defaultAlarmListNew = (ArrayList)sorter.sort(2,"Integer",orderby);
	}
	else if (strSortBy.equals("noc"))
	{
		defaultAlarmListNew = (ArrayList)sorter.sort(3,"Integer",orderby);
	}

	if (userDefinedAlarmList.size()>0)
	{
		EgSorter sorter1 = new EgSorter(userDefinedAlarmList,3);
		if (strSortBy.equals("policy"))
		{
			userDefinedAlarmList = (ArrayList)sorter1.sort(1,"String",orderby);
		}
		else if (strSortBy.equals("winsize"))
		{
			userDefinedAlarmList = (ArrayList)sorter1.sort(2,"Integer",orderby);
		}
		else if (strSortBy.equals("noc"))
		{
			userDefinedAlarmList = (ArrayList)sorter1.sort(3,"Integer",orderby);
		}
	}
	session.setAttribute("egPageDesc","EgAlarmPolicy.jsp");
	session.setAttribute("egBackComplete","/final/admin/EgAlarmPolicy.jsp");
	session.setAttribute("egTitlehref","/final/admin/EgConfigAlarmPolicy.jsp?flag=true&alarmName=new");

	if (allPermission)
	{
	}
	else
	{
	}

	String predefinedPolicy = "";
	String windowSize = "";
	String preDefNoc = "";
	JSONArray defAlarmListArr = new JSONArray();
	for (int i=0;i<defaultAlarmListNew.size();i=i+3)
	{
		JSONObject defAlarmObj = new JSONObject();
		predefinedPolicy = (String)defaultAlarmListNew.get(i);
		windowSize = (String)defaultAlarmListNew.get(i+1);
		preDefNoc = (String)defaultAlarmListNew.get(i+2);
		defAlarmObj.put("Policy",predefinedPolicy);
		defAlarmObj.put("WindowSize",Integer.parseInt(windowSize));
		defAlarmObj.put("NoC",Integer.parseInt(preDefNoc));
		if (isSearchResult && !doesExist(searchList,predefinedPolicy ))
		{
			continue;
		}
		searchItemFound=true;
		if (allPermission)
		{
			String defUrl = "javascript:window.location.href='EgConfigAlarmPolicy.jsp?flag=true&mod=modify&window="+windowSize+"&noCross="+preDefNoc+"&alarmName="+EgURLEncoder.encode(predefinedPolicy,"UTF-8")+"'";
		}
		else
		{
		}

		if (allPermission)
		{
			String defModifyBtnUrl = "javascript:window.location.href='EgConfigAlarmPolicy.jsp?flag=true&mod=modify&window="+windowSize+"&noCross="+preDefNoc+"&alarmName="+EgURLEncoder.encode(predefinedPolicy,"UTF-8")+"'";
		}
		defAlarmListArr.add(defAlarmObj);
	}
	
	rootJson.put("DefaultAlramList",defAlarmListArr);
	if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
	{
		String htmlPreDefData = "<table><tr><td align='center' height='100'><table><tr><td align='center'><div style='background: url(/final/images/eG_Icons32.png) no-repeat top left;background-position: 0 -200px !important;width: 32px !important;height: 32px !important;' /></td></tr>";
		htmlPreDefData += "<tr><td align='center' style='font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:10px' nowrap>";
		htmlPreDefData += "No pre-defined alarm policy found for your current search,&nbsp;<i>"+egTitleSearchStr+"</td></tr></table>";
		rootJson.put("no_predefine_search_item",htmlPreDefData);
	}

	if (userDefinedAlarmList.size() > 0 || isSearchResult)
	{
		JSONArray userDefAlarmArr = new JSONArray();

		String userPolicy ="";
		String windowSizeNew ="";
		String userDefNoc = "";
		searchItemFound=false;

		EgServerGroupBean infoGroup = null;
		if (userDefinedAlarmList.size() > 0)
		{
			infoGroup = new EgServerGroupBean();
		}

		for (int i=0;i<userDefinedAlarmList.size();i=i+3)
		{
			JSONObject userDefObj = new JSONObject();
			userPolicy = (String)userDefinedAlarmList.get(i);
			userDefObj.put("Policy",userPolicy);
			boolean isPolAssociated = threshInfo.isAlarmPolicyAssociatedWithTests(userPolicy);
			if (!isPolAssociated)
			{
				isPolAssociated = infoGroup.isAlarmPolicyAssociatedWithRules(userPolicy);
			}
			
			windowSizeNew = (String)userDefinedAlarmList.get(i+1);
			userDefNoc = (String)userDefinedAlarmList.get(i+2);
			userDefObj.put("WindowSize",Integer.parseInt(windowSizeNew));
			userDefObj.put("NoC",Integer.parseInt(userDefNoc));
			userDefObj.put("isPolAssociated",isPolAssociated);

			if (isSearchResult && !doesExist(searchList,userPolicy))
			{
				continue;
			}
			searchItemFound=true;
			if (allPermission)
			{
			}
			else
			{
			}

			if (allPermission)
			{
				String userModifyBtnUrl = "javascript:window.location.href='EgConfigAlarmPolicy.jsp?flag=true&mod=modify&window="+windowSizeNew+"&noCross="+userDefNoc+"&alarmName="+EgURLEncoder.encode(userPolicy,"UTF-8")+"'";

				userDefObj.put("userModifyBtnUrl",userModifyBtnUrl);
				if(isPolAssociated)
				{
					String userShowAssociateUrl = "javascript:window.location.href='EgAlarmPolicyAssociates.jsp?policy="+userPolicy+"'";
					//userDefObj.put("userShowAssociateUrl",userShowAssociateUrl);

				}

			}

			userDefAlarmArr.add(userDefObj);
		}
		rootJson.put("userDefAlarmArr",userDefAlarmArr);
		if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
		{
			String htmlPreDefData = "<table align='center' height='400'><tr><td align='center'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.alarmpolicy.No user-defined alarm policy found for your current search")+".</td></tr></table>";
			rootJson.put("no_userdefine_search_item",htmlPreDefData);
		}
	}
	else
	{
		String htmlPreDefData = "<table align='center' height='400'><tr><td align='center'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.alarmpolicy.No user-defined alarm policy has been configured")+".</td></tr></table></td></tr></table>";
		rootJson.put("no_userdefine_item",htmlPreDefData);

	}



	if (request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAlarmPolicy.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAlarmPolicy.jsp");
	}
	out.println(rootJson.toString());

%>


<%!
	private boolean doesExist(List searchList,String policy)
	{
		Iterator i = searchList.iterator();
		while (i.hasNext())
		{
			String nextStr = (String) i.next();
			if (policy.indexOf(nextStr)!=-1||(policy.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>




