var originalShow = Ext.window.MessageBox.prototype.show;
Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}

			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},
	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}

			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

var a;
var b;
var assetval;
Ext.Loader.setConfig({
	enabled:true,
	disableCaching: false
});

Ext.Loader.setPath('Ext.ux','/final/scripts/ux');
Ext.Loader.setPath('utilities','/final/scripts/utilities');

function createCustomData()
{
	assetInfo.getController("Main").createCustomData();
}

Ext.application({
	name: 'AssetManagement',
	requires:['AssetManagement.view.AssetConfiguration','AssetManagement.view.AssetList','AssetManagement.view.Main'],
	appFolder:'/final/admin/AssetManagement/app',
	views: ["AssetManagement.view.AssetMenu","AssetManagement.view.AssetConfiguration","AssetManagement.view.AssetList","AssetManagement.view.Main"],
	controllers: ["AssetManagement.controller.Main"],
	launch: function() {
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

		assetInfo = this;
		Ext.Ajax.request({
				url: '/final/admin/AssetManagement/data/EgAssetDashboard.jsp',
				scope: this,
				method : 'POST',
				success: function(response)
				{
					jsonData = Ext.decode(response.responseText);
					Ext.create("Ext.container.Viewport", {
					layout:'fit',
					id : 'assetmgmtViewPort',
					name : 'assetmgmtViewPort',
					items: [{
							xtype:'assetmenu',
							margin: 10,
							itemData:jsonData
						}]
					});
			
				}
			});

	}

});