Ext.define('AssetManagement.view.AssetBarChart',{
	extend:'Ext.container.Container',
	alias:'widget.barchartnew',
	cls:'assetManagement',
	layout: {
		type: 'vbox',
		align:'stretch'
	},
	id: 'AssetBarChart',
	padding: 0,
	margin:0,
	items:[],
	initComponent: function(){
		var self = this;
		var barchartItems=[];
		var firstFieldSet=[];
		var secondFieldSet=[];
		var firstContainer = '';
		var secondContainer = '';
		var fieldSet = '';
		for(var index in jsonData.barchart){
			fieldSet = self.loadFieldSet(index);
			if(index < 3){
				firstFieldSet.push(fieldSet);
			}else{
				secondFieldSet.push(fieldSet);
			}
			if(index == 2){
				firstContainer = self.loadPanel(firstFieldSet);
				barchartItems.push(firstContainer);
			}
			if(index == 5){
				secondContainer = self.loadPanel(secondFieldSet);
				barchartItems.push(secondContainer);
			}
		}
		self.items = barchartItems;		
		this.callParent();
	},
	loadFieldSet: function(index){
		Ext.define('legendModel', {
			extend: 'Ext.data.Model',
			fields: [
				{ name:'name', type:'string' },
				{ name:'color', type:'string' }
			]
		});

		Ext.create('Ext.data.Store', {
			id:'legendStore',
			model: 'legendModel',
			data: jsonData.barchart[index].Legend
		});
	 var fieldSet = Ext.create('Ext.form.FieldSet',{
				flex:1,
				id:'fieldsetCont'+index,
				margin: 5,
				padding:0,
				cls : ' assetfieldset',
				title: '<span class="newFont_bold14" >'+jsonData.barchart[index].Name+'</span>',
				items: [
					{				
						xtype: 'dataview',
						id:'legendCont'+index,
						model:'legendModel',
						height:35,
						store: Ext.data.StoreManager.lookup('legendStore'),
						
						tpl: new Ext.XTemplate(
						
						'<div  class="b_box" style="display:inline-block;  width:100%;">',								
							 '<div   style="text-align:center;">',					
								'<div class="">',
									 '<div class="assetChartviewBox" style="width:100%;padding: 6px 10px 0; height: 42px; float:left; overflow:hidden; ">',										
										  '<ul id="legend" style="height:42px; vertical-align: top; overflow: scroll;  align-items: center; text-align:center;">',
											'<tpl for="."><li style="display:inline-block; padding-left:10px; text-transform: none;" class="newFont_normal11 assetLegend" style=""><span  style="background-color:{color}; width:6px;height:6px;border-radius:50%;display:inline-block; margin: 0 5px 0 0;"></span>{name}</li></tpl>',
										'</ul>',										
									'</div>',					   
								'</div>',
							'</div>',
						'</div>'
						
						)		
					},
					{				
					xtype: 'container',
					flex:1,
					height: 176,
					margin: '0 25 10 25',
					padding:0,
					id: 'bar'+index,
					chartData:jsonData.barchart[index].Value,
					listeners:{
						boxready:function(cmp){
							var me = this;	
							var width = Ext.get('fieldsetCont0-body').getWidth();
							try {								
							var barChart = [];
							if(cmp.chartData.DataSet[0].data.length>0){
								barChart = jQuery.extend(true, {}, getHighChartsBarInstance(cmp.id, '178', (me.getWidth())), barChart);
								barChart.setData(cmp.chartData, currentDateFormat, '', 'assetBarchart');
								barChart.drawChart();
							}else{
								this.html = '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (this.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="iconExclamation" style="margin:0px auto"></div><div class="noMeasuresFound" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ noMeasuresFoundMsg + '</div></td></tr></table></div>';
								Ext.getCmp(this.id).update(this.html);
							}
							} catch (barChartEx) {
								console.log(barChartEx);
							}							
						}
					}
				
				}
				]
		}
		)
		return fieldSet;	
	},
	loadPanel: function(fieldSetArray){
		var barChartContainer = Ext.create('Ext.container.Container',{
			layout: {
				type: 'hbox',
				align:'stretch'
			},
			flex:1,
			cls:'',
			padding: 0,
			margin: '0px 0px 0px 0px',
			items: fieldSetArray
		})
		return barChartContainer;
	}
	
});
