Ext.define('AssetManagement.view.AssetConfiguration',{
	extend : 'Ext.form.FormPanel',
	requires:['Ext.ux.form.MultiSelect','utilities.ScrollCombo',],
	alias:'widget.assetConfiguration',
	margin:'0 10 10 10',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex:1,
	cls:'outerpanel',
	title:' ',
	autoScroll:true,
	scroll:false,
	tools: [
	{
		xtype: 'container',
		cls: 'iconBg',
		id: 'assetFileImport',
		margin: '0 3 0 0',
		items: [{
			xtype: 'button',
			id: 'importToolBtn',
			iconCls: 'iconUpload',
			style: {
				background: 'none',
				border: '0px'
			},
			listeners: {
			  afterrender: function () {
				  Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: importLbl
				  });
			  },
			  click:function(){
			      Ext.widget('fileupload').show();
			  }
			}
		}]
	},
	{
		xtype: "button",
		iconCls: "iconXl",
		id: 'excelToolBtn',
		name: 'excelToolBtn',
		margin: '0 3 0 0',
		style: {
			background: "none",
			border: "0px"
		},
		listeners: {
		  afterrender: function() {
			Ext.create("Ext.tip.ToolTip", {
				target: this.id,
				anchor: "top",
				cls: "yellowTip",
				trackMouse: true,
				html: saveAsExcelLbl
			})
		  },
		  click:function(){
				  window.location.href ="/final/admin/AssetManagement/data/EgAssetFileDownload.jsp?downloadType=export&downloadCSV=AssetXLSFile&com.eg.CSRF_NONCE="+csrfToken;
		  }
		}
	},
	{
		xtype: "button",
		iconCls: "iconPdfDownload",
		id: 'saveIconTool',
		name: 'saveIconTool',
		style: {
			background: "none",
			border: "0px"
		},
		listeners: {
		  afterrender: function() {
			Ext.create("Ext.tip.ToolTip", {
				  target: this.id,
				  anchor: "top",
				  cls: "yellowTip",
				  trackMouse: true,
				  html: saveAsPDFLbl
			})
		  }
		}
	},
	],
	items:[
	{
		xtype: 'form',
		margin:'10 10 10 10',
		id:'form1',
		items:[{
				xtype:'container',
				cls:'assetContainer',
				layout: {
						type: 'hbox',
						pack:'left',
						align:'left'
				},
				margin:'0 0 0 0',
				padding:'10 0 10 10',
				defaults:{
					labelSeparator:'',
					labelAlign:'top',
					margin:'0 20 0 0'
				},
				items : [
					{
						xtype : 'scrollcombo',
						fieldLabel : assetTypeLbl,
						editable : false,
						width:250,
						name : 'assetType',
						id:'assetType',
						cls : 'dropdown',
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						store : new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
						listeners : {}
					},
					{
						xtype : 'scrollcombo',
						fieldLabel : componentTypeLbl,
						editable : false,
						width:250,
						name : 'componenttype',
						id:'componenttype',
						cls : 'dropdown',
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						store : new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
						listeners : {}
					},{
						xtype : 'scrollcombo',
						fieldLabel : componentNameLbl,
						editable : false,
						width:250,
						name : 'componentname',
						id:'componentname',
						cls : 'dropdown',
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						store : new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						listeners : {}
					}]
			}
		]
	},/* From 2 */
	{
		xtype: 'container',
		id: 'form2',
		hidden:true
	},
	{
		xtype: 'container',
		id: 'form3',
		hidden:true,
		items: [
			/*-------------------------*/
			{
				xtype: 'tabpanel',
				minHeight: 315,
				flex:1,
				activeTab: 0,
				margin: '0 10 0 10',
				ui: 'autoWithTabPanel',
				layout: {
						type: 'vbox',
						align:'stretch'
					},
				
				bodyPadding: '0 0 2 0',
				defaults: {
					margin:'0 0 0 0',
					padding:20,
					hidden:true,
					layout: 'column',
					defaults:{
						labelSeparator:'',
						labelAlign:'top',
						margin:'0 20 10 0',
						width: 230,
					},
				},
				id:'assetTabpanel',
				listeners: {
					afterrender: function(panel){
						
						Ext.defer(function(){
							panel.setActiveTab(0);
						},1000);
						
						var bar = panel.tabBar;
						var count = 1;
						bar.add({
							xtype: 'button',
							html: '<div ><span class="addButton" style="float:left; margin-top:10px;"></span><p class="newFont_normal14" style="float:left; margin:15px 0px 0px 10px;">Add Custom Fields</p></div>',
							style: {
								background: "none",
								border: "0px"
							},
							width:170,
							height:40,
							margin:'0 0 0 5',
							id:'addCustomFieldBtn',
							handler : function(f){
								panel.getComponent('customContainer').tab.show(); 
								panel.setActiveTab('customContainer');
								assetInfo.getController("Main").createCustomData();
								Ext.getCmp('addCustomFieldBtn').hide();
							}
						});
						
					}
				},
				/*-----*/

				items: [
				{
					title: '<p class="newFont_normal14">'+assetDetailsLbl+'</p>',
					id:'assetDetail',
				}, 
				{
					title: '<p class="newFont_normal14">'+assetTechnicalDetailsLbl+'&nbsp;</p>',
					id:'techDetails'
				}, 
				{
					title: '<p class="newFont_normal14">'+softwarePropertiesLbl+'</p>',
					id:'software',
				},
				{
					title: '<p class="newFont_normal14">'+softwareListLbl+'</p>',
					id:'softwareList',
					padding:10,
					defaults:{
						margin:'0 0 10 0',
					}, 
					layout: {
						type: 'fit',
					},
					scroll:true,
					autoScroll : true,
				},
				{
					title: '<p class="newFont_normal14">'+upsPropertiesLbl+'</p>',
					id:'ups',
				},
				{
					title: '<p class="newFont_normal14">'+cloudPropertiesLbl+'</p>',
					id:'cloud',
				},
				{
					title: '<p class="newFont_normal14">'+AWSPropertiesLbl+'</p>',
					id:'aws',
				},
				{
					title: '<p class="newFont_normal14">'+MiscLbl+'</p>',
					id:'misc',
				},
				{
					title: '<p class="newFont_normal14">'+customFieldsLbl+'</p>',
					id:'customContainer',
					name:'customContainer',
					defaults:{
						width: '100%',
					}
				}
				]
			},
			{
				xtype:'container',
				id:'CustomFieldContainer',
				items:[
				{
					xtype:'fieldcontainer',
					defaultType: 'checkboxfield',
					defaults:{
						labelSeparator:'',
						hideLabel :true,
						labelWidth: 120
					},
					items: [{
						xtype: 'checkboxfield',
						boxLabel : applyassetInformationLbl,
						inputValue: 'true',
						uncheckedValue: 'false',
						formBind: false,
						hidden:true,
						margin: '10 0 10 10',
						cls:'checkbt',
						id  : 'checkbox1',
						name:'checkbox1',
						handler: function () {
							var checkbox = Ext.getCmp('checkbox1');

							if(checkbox.checked == true)
							{
								Ext.getCmp('multiSelectAsset').show();
								Ext.getCmp('SimilarLabel').show();
							}
							else
							{
								Ext.getCmp('multiSelectAsset').hide();
								Ext.getCmp('SimilarLabel').hide();
							}
						}
					},{
						xtype:'container',
						id:'SimilarLabel',
						name:'SimilarLabel',
						hidden:true,
						margin: '0 0 5 30',
						html:'<div style="font-size:12px;"><b>'+similarComponentsLbl+'</b></div>'
					},{
						xtype:'multiselect',
						msgTarget: 'side',
						allowBlank:false,
						autoScroll:true,
						scroll:false,
						width:280,
						margin: '0 0 0 30',
						id:'multiSelectAsset',
						name:'multiSelectAsset',
						store : new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : [ ]
						}),
						value:'',
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						height:80,
						hidden:true,
						listConfig: {simpleSelect: true}
					}]
				},
				{
					xtype:'container',
					margin:'12 20 12 20',
					layout: {
						type: 'vbox',
						pack:'center',
						align:'center'
					},
					height: 30,
					items:[{
						xtype:'button',
						text :saveLbl,
						ui:'assetReportBtn',
						id:'saveBtn',
						name:'saveBtn',
						padding:'5 25',
						action: 'SaveConfiguration'
					}]
				}
				]
			}
		]
	}
	]
});