Ext.define('AssetManagement.view.AssetListColumnConfig', {
    extend: 'Ext.window.Window',
    alias: 'widget.assetListColumn',
    requires: ['utilities.CustomGrid','utilities.ScrollCombo','utilities.CommonPanel'],
	refs : [],
    width: 785,
	height:450,
    modal: true,
	border:false,
	frame:false,
    autoShow: false,
	padding:'0 0 0 0',
	autoScroll:true,
	 draggable: false,
	resizable: false,
	closeAction : 'destroy',
	id: 'assetListColConf',
	ui: 'newPopupWindow newplainHeader_border',
	maskCls: 'windowModal',
	header: {
		height: 48,
		padding: 0,
		margin: '0 20 0 20'
	},
	initComponent : function()
	{
		this.callParent();
	},
	listeners:{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						
						var el = Ext.fly(dom[dom.length-1]);
						
						el.addCls('windowModal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('windowModal');
					}
				}	
			},
	items: [
		{
			xtype:'container',
			id:'assetDetailsColumn',
			hidden: false,
			autoScroll:true,
			margin:'10 20 0 16',
			padding:0,
			bodyPadding:0,
			layout:'form', 
		}
		],
		dockedItems: [{
			xtype: 'toolbar',
			dock: 'bottom',
			cls: 'assetSetupColPopupWinFooter',
			height: 50,
			layout:{
				pack: 'center'
			},
			items: [
				{
					xtype: 'button',
					id:'saveAsstColumnBtn',
					name:'saveAsstColumnBtn',
					//buttonAlign: 'left',
					text: applyBtnLbl,
					margin: '0 20 0 0',
					padding: '5 15 5 15',
					ui:'assetReportBtn',
					//cls: 'newConfigWinBtn newFont_normal14',
					handler: function () {
					}
				},
			]
		}],
})