Ext.define('AssetManagement.view.AssetPieChart',{
	extend:'Ext.container.Container',
	alias:'widget.piechartnew',
	layout: {
		type: 'hbox',
		align:'stretch'
	},
	flex:1,
	cls:'assetManagement',
	padding: 0,
	initComponent:function(){
	var self = this;
	var piechartItems=[];
	var pieChart = [];
	for(var index in jsonData.piechart){
		Ext.define('piechartLegendModel', {
				extend: 'Ext.data.Model',
				fields: [
					{ name:'name', type:'string' },
					{ name:'color', type:'string' }
				]
			});
			Ext.create('Ext.data.Store', {
				id:'piechartLegendStore',
				model: 'piechartLegendModel',
				data: jsonData.piechart[index].Legend.data
			});
			piechartItems.push(Ext.create('Ext.form.FieldSet',{
					flex:1,
					margin:5,
					padding:0,
					id:'pieCont'+index,
					cls: 'assetfieldset',
					title: '<span class="newFont_bold14">'+jsonData.piechart[index].Name+'</span>',
					items:[{				
						xtype: 'dataview',
						id:'pieLegendCont'+index,
						model:'piechartLegendModel',
						store: Ext.data.StoreManager.lookup('piechartLegendStore'),
						height:35,
						tpl: new Ext.XTemplate(						
						'<div  class="b_box" style="display:inline-block;  width:100%; padding: 0px  10px 0px 10px; margin:0px; ">',								
							 '<div   style="text-align:center;">',					
								'<div >',
									  '<div class="assetChartviewBox" style="width:100%;padding: 6px 10px 0; height: 42px; float:left; overflow:hidden; ">',
											
											  '<ul id="legend" style="height:42px; vertical-align: top; overflow: scroll;  align-items: center; text-align:center;">',
													'<tpl for="."><li style="display:inline-block; padding-left:10px; text-transform: none;" class="newFont_normal11 assetLegend" style=""><span style="background-color:{color}; width:6px;height:6px;border-radius:50%;display:inline-block; margin: 0 5px 0 0;"></span>{name}</li></tpl>',
												'</ul>',										
										'</div>',					   
								'</div>',
							'</div>',
						'</div>'						
						)		
					},{
						xtype: 'container',
						index : index,
						margin: '0 25 10 25',
						height:176,
						id: 'pie'+index,
						chartData  :jsonData.piechart[index].Value,
						listeners:{
							boxready:function(cmp){
								var me = this;
														
								try {
								var pieChart = [];
								if(cmp.chartData.DataSet[0].data.length>0){
									pieChart = jQuery.extend(true, {}, getPieChartsforNetflow(cmp.id, '226', (me.getWidth())), pieChart);
									pieChart.setData(cmp.chartData, currentDateFormat, '', '');
									pieChart.drawChart();
								}else{
									this.html = '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
													+ (this.getHeight() - 20)
													+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="iconExclamation" style="margin:0px auto"></div><div class="noMeasuresFound" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
													+ noMeasuresFoundMsg + '</div></td></tr></table></div>';
									Ext.getCmp(this.id).update(this.html);
								}
								
								} catch (pieChartEx) {
									//console.log(pieChartEx);
								}
								
							}
						}
					}]
			}
			))
	}
	self.items = piechartItems;
			this.callParent();
	}

});
