<%/*******************************************************************************
 *	File name			:	EgAssetConfigUpload.jsp
 *	Purpose				:	to upload and display the asset information.
 *	Creation Date		:	Jan-20-2014 (dd-MM-yyyy)
 ******************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.multipart.*"%>
<%@ page import = "com.egurkha.admin.EgAssetInfoReader"%>
<%@ page import = "com.egurkha.admin.EgAssetManagementDAO"%>
<%@ page import = "com.egurkha.admin.EgAssetImportFileValidation"%>

<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="java.io.File"%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>

<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject messagesJson = new JSONObject();

	FileWriter fwriter = null;
	EgAssetInfoReader assetReader = new EgAssetInfoReader();
	SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	EgDateInfo dateInfo = new EgDateInfo();
	String userFormat = _user.getUserDateFormat();

	ArrayList getDefHeaderList = null, getCusHeaderList = null, getDefOuterValList = null, getCusOuterValList = null, getTargetHostList = new ArrayList();
	boolean defaultValuesAvailable = false, repeatedColumns = false;
	int hostInserted = 0;
	EgAssetManagementDAO assetDAO = new EgAssetManagementDAO();
	EgMappingInfo mappingInfo = new EgMappingInfo(trackerLanguage);
	Hashtable ht_parampart=new Hashtable();
	Hashtable ht_filepart=new Hashtable();
	ArrayList trgtHostLists = new ArrayList();
	String getDt = "";
	String installDir = EgInstallInfo.getInstallDir();
	installDir = StringUtils.replace(installDir, '\\', '/');
	String fileName = "", assetFilePath = installDir+"/asset/";
	String s_iniFile_dir = installDir + "/manager/config/";
	IniFile servicesIni = new IniFile(s_iniFile_dir + "eg_services.ini");
	IniFile infraIni = new IniFile(s_iniFile_dir + "eg_infrastructure.ini");
	try
	{
		fwriter = new FileWriter(installDir+"/manager/logs/assetInfo.log");
		/*****************To get File and write into /egurkha_installsDir/asset/ directory******************/
		MultipartParser mp = new MultipartParser(request, 10*1024*1024); // 10MB
		com.egurkha.util.multipart.Part part;
		String folder="";
		
		while ( ( part = mp.readNextPart() ) != null )
		{
			String name = part.getName();
			if ( part.isParam() )
			{
				ParamPart paramPart = (ParamPart) part;
				ht_parampart.put( name, paramPart.getStringValue() );
			}
			else if ( part.isFile() )
			{
				FilePart filePart = (FilePart) part;
				ht_parampart.put("#"+name, name);
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				filePart.writeTo( baos );
				byte[] fileContent = baos.toByteArray();
				baos.flush();
				baos.close();
				if ( fileContent.length > 0 )
				{
					ht_parampart.put(name+"_name", filePart.getFileName());
					ht_filepart.put(name, fileContent);
				}
			}
		}
		Iterator itr = ht_filepart.keySet().iterator();
		byte[] thisFileContent=null;
		boolean checkCustomFolder = false;
		File f = new File(installDir+"/asset/");
		if ( !f.isDirectory() )
		{
			f.mkdir();
		}
		while(itr.hasNext())
		{
			String key = (String) itr.next();
			fileName = (String) ht_parampart.get(key+"_name");
			thisFileContent = ( byte[] )ht_filepart.get( key );
			File thisFile = new File(installDir+"/asset/"+fileName);
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO Asset Info - "+fileName+" uploading...\n");
			fwriter.flush();
			FileOutputStream fos = new FileOutputStream(thisFile);
			fos.write(thisFileContent);
			fos.flush();
			fos.close();
			fwriter.write(getDt+" INFO Asset Info - "+fileName+" uploaded successfully.\n");
			fwriter.flush();

		}
		/*****************To get File and write into /egurkha_installsDir/asset/ directory******************/

		assetFilePath += fileName;
		Hashtable assetTbl = new Hashtable();
		if ( !StringUtils.isNull( assetFilePath ) )
		{
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO reading Asset Information from "+fileName+"\n");
			fwriter.flush();
			if ( assetFilePath.endsWith("csv") )
			{
				assetReader.readFromCSV(assetFilePath);
			}
			else if ( assetFilePath.endsWith("xls") )
			{
				assetReader.readFromXLS(assetFilePath);
			}
			assetTbl = assetReader.getAssetTable();
			if ( assetTbl != null && !assetTbl.isEmpty() )
			{
				fwriter.write(getDt+" INFO read Asset Information from "+fileName+"\n");
				fwriter.flush();
			}
			else
			{
				fwriter.write(getDt+" ERROR "+fileName+" file may be invalid format or Empty. \n");
				fwriter.flush();
			}
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("def_header") )
		{
			getDefHeaderList  = (ArrayList) assetTbl.get("def_header");
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("cus_header") )
		{
			getCusHeaderList  = (ArrayList) assetTbl.get("cus_header");
		}

		if ( getDefHeaderList == null || getDefHeaderList.isEmpty() || getDefHeaderList.size() < 20 )
		{
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" ERROR Please should give default values \n");
			fwriter.flush();
			String DEFAULT_VALUES = mappingInfo.getTextDescription("admin.Asset.Please should give default values");
			rootJson.put("Msg",DEFAULT_VALUES);
		}
		else if ( getDefHeaderList == null || getDefHeaderList.isEmpty() || getDefHeaderList.size() >= 20 )
		{
			defaultValuesAvailable = true;
		}

		if ( getDefHeaderList != null && !getDefHeaderList.isEmpty() && getCusHeaderList != null && !getCusHeaderList.isEmpty() )
		{
			for ( int i = 0; i < getDefHeaderList.size(); i++ )
			{
				String getDefVal = (String) getDefHeaderList.get(i);
				for ( int j = 0; j < getCusHeaderList.size() ; j++ )
				{
					String getCusVal = (String) getCusHeaderList.get(j);
					if ( getDefVal.equalsIgnoreCase(getCusVal) && ( !StringUtils.isNull(getDefVal) && !StringUtils.isNull(getCusVal) ) )
					{
						repeatedColumns = true;
						getDt = assetReader.getLogDate();
						fwriter.write(getDt+" ERROR "+getDefVal+" appears two times in sheet, Please check the header name \n");
						fwriter.flush();
						String Check_HeaderName= mappingInfo.getTextDescription("admin.Asset.Appears two times	in sheet, Please check the header name");
						rootJson.put("Msg",getDefVal+" "+Check_HeaderName);
						break;
					}
				}
			}
		}
		
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("def_values") )
		{
			getDefOuterValList = (ArrayList) assetTbl.get("def_values");
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("cus_values") )
		{
			getCusOuterValList = (ArrayList) assetTbl.get("cus_values");
		}

		if ( getDefOuterValList != null && !getDefOuterValList.isEmpty() )
		{
			Iterator defOuterItr = getDefOuterValList.iterator();
			int getListIndex = 0;
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO Checking Host Name \n");
			fwriter.flush();
			while ( defOuterItr.hasNext() )
			{
				ArrayList getDefValList = (ArrayList) defOuterItr.next();
				String genCmpTypeWithNamePort = "";
				if ( getDefValList != null && !getDefValList.isEmpty() )
				{
					String getCmpTypeWithName = "", compType = "", reverseCompType = "";
					getCmpTypeWithName = (String) getDefValList.get(0);
					getCmpTypeWithName = StringUtils.replace(getCmpTypeWithName, '\"', ' ');
					getCmpTypeWithName = getCmpTypeWithName.trim();
					if ( getCmpTypeWithName.indexOf(":") > 0)
					{
						compType = getCmpTypeWithName.substring(0, getCmpTypeWithName.indexOf(":") );
						reverseCompType = mappingInfo.getReverseComponentTypeDescription(compType);
					}
					if ( !StringUtils.isNull( reverseCompType ) )
					{
						int getColCount = 0;
						StringTokenizer strTkn = new StringTokenizer(getCmpTypeWithName, ":");
						getColCount = strTkn.countTokens();
						if ( ( reverseCompType.equals("Oracle_server") && getColCount != 4 ) || ( !reverseCompType.equals("Oracle_server") && getColCount != 2 && getColCount != 3) )
						{
							defOuterItr.remove();
							if ( getCusOuterValList != null && !getCusOuterValList.isEmpty() )
							{
								getCusOuterValList.set(getListIndex, "");

							}
							getDt = assetReader.getLogDate();
							fwriter.write(getDt+" ERROR '"+getCmpTypeWithName+"' is not a valid Host Name and not imported, Please check the Servertype, Nick name and Port or with Instance name...\n");
							fwriter.flush();
							trgtHostLists.add(getCmpTypeWithName+"|false");
						}
						else
						{
							String tmpCmpNameWithPort = getCmpTypeWithName.substring( getCmpTypeWithName.indexOf(":") + 1 );
							if(tmpCmpNameWithPort.indexOf(":NULL") > -1)
							tmpCmpNameWithPort=tmpCmpNameWithPort.substring(0,tmpCmpNameWithPort.indexOf(":NULL"));
							genCmpTypeWithNamePort = reverseCompType+":"+tmpCmpNameWithPort;
							getDefValList.set(0, genCmpTypeWithNamePort);
							getTargetHostList.add(genCmpTypeWithNamePort);
							trgtHostLists.add(getCmpTypeWithName+"|true");
							hostInserted++;
							Date dt = dateInfo.egetRealDate();
							String getDate = sdf.format(dt);
							fwriter.write(getDate+" INFO '"+getCmpTypeWithName+"' is valid Host Name and importing...\n");
							fwriter.flush();
						}
					}
					String getAssetType = (String) getDefValList.get(3);
					if(getAssetType == null || getAssetType.equalsIgnoreCase("NONE")){
						String[] Subjects = infraIni.getSubjects();
						String serverCategory="";
						for (int j = 0;j<Subjects.length;j++ )
						{
							serverCategory = Subjects[j];
							String[] allVariables = infraIni.getVariables(serverCategory);
							if(allVariables==null || allVariables.length==0)
								continue;
							boolean hasVar = false;
							for(int g=0;g<allVariables.length;g++)
							{
								String variable = allVariables[g];
								//if(validServerList.contains(variable) || validServerList.contains("#"+variable))
								if(variable.equalsIgnoreCase(reverseCompType)){
									hasVar = true;
									break;
								}
							}
							//if(!hasVar) continue;
							if(hasVar) break;
						}
						String[] assetTypeList = servicesIni.getVariables("ASSET_TYPE_CATEGORY MAPPING");
						String defaultAssetType = "Application";
						for(int kk=0;kk<assetTypeList.length; kk++)
						{
							boolean typeFound=false;
							String type =assetTypeList[kk];
							String variable=servicesIni.getValue("ASSET_TYPE_CATEGORY MAPPING",type);
							String categoryArr[]=variable.split(",");
							for(int k=0; k<categoryArr.length;k++)
							{
								String arrElement =  categoryArr[k];
								if(arrElement.equalsIgnoreCase(serverCategory)){
									defaultAssetType = type;
									typeFound=true;
									break;
								}
							}	
							if(typeFound) break;
						}
						getDefValList.set(3, defaultAssetType);
					}
				}
				getListIndex++;
			}
			if ( getCusOuterValList != null && !getCusOuterValList.isEmpty() )
			{
				getCusOuterValList.removeAll(Collections.singleton(""));
				assetTbl.put("cus_values", getCusOuterValList);
			}
		}
		
		JSONObject errMsgsJson = new JSONObject();
		JSONArray  JSONArr=new JSONArray();
		int ErrCount=0;
	
		if((getDefOuterValList!=null&&!getDefOuterValList.isEmpty()))
		{
		
			EgAssetImportFileValidation afv=new EgAssetImportFileValidation();
			HashMap rsMap=afv.importFileValidation(getTargetHostList,assetTbl,userFormat);
			Iterator i = rsMap.keySet().iterator();
			while(i.hasNext())
			{
				String cmpName= (String)i.next();  
				ArrayList list= (ArrayList)rsMap.get(cmpName);
				ErrCount+=list.size();
				Iterator  itr2=list.iterator();
				while(itr2.hasNext())
				{
					String val=(String)itr2.next(); 
					String[] valArr=val.split("#");
					if(valArr.length>1){
						JSONObject errObj = new JSONObject();
						String FieldName=valArr[0];
						String FieldErrMsg=valArr[1];
						errObj.put("FieldName",FieldName);
						errObj.put("FieldErrMsg",FieldErrMsg);
						errObj.put("CmpName",cmpName);
						JSONArr.add(errObj);
					}
				}
			}
			errMsgsJson.put("items",JSONArr);
			if(ErrCount>0)
			{
				String failure_Msg = mappingInfo.getTextDescription("admin.Asset.Some problems occured while importing asset information, Please check assetinfo log");
				rootJson.put("Msg",failure_Msg);
				rootJson.put("ErrMsgsJson",errMsgsJson);
			}
			else 
			{
				Hashtable  getDefaultResultTable=assetDAO.insertDefaultAssetInfo(getTargetHostList, assetTbl);
				Hashtable  getCustomResultTable = assetDAO.insertCustomAssetInfo(getTargetHostList, assetTbl);
				if ( defaultValuesAvailable && !repeatedColumns )
				{
					if ( getDefaultResultTable != null && !getDefaultResultTable.containsKey("error") && getCustomResultTable != null && !getCustomResultTable.containsKey("error") && ( trgtHostLists.size() == hostInserted ) )
					{
						String Success_Msg= mappingInfo.getTextDescription("admin.Asset.Asset Information Imported Successfully");
						rootJson.put("Success_Msg",Success_Msg);
					}
					else
					{
					String failure_Msg = mappingInfo.getTextDescription("admin.Asset.Some problems occured while importing asset information, Please check assetinfo log");
					rootJson.put("Msg",failure_Msg);
					}
				}
			}

		}
		else
		{
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" ERROR<!-- <!--  --> --> Please should give default values \n");
			fwriter.flush();
			String DEFAULT_VALUES = mappingInfo.getTextDescription("admin.Asset.Asset file is empty");
			rootJson.put("Msg",DEFAULT_VALUES);
		}





		rootJson.put("success","true");

		fwriter.close();

	//	rootJson.put("AssetConfigUploadMsg",messagesJson);
		System.out.println("AssetConfigUploadMsg------>"+rootJson.toString());
		//out.println(rootJson.toString());
		response.setContentType("text/html;charset=UTF-8");
		response.getWriter().write(rootJson.toString());

	}
	catch ( Exception e )
	{
		System.err.println("[Exception] @ EgAssetConfigImportJSON.jsp "+e);
		e.printStackTrace();
	}
%>

