Ext.define('AssignToManager.controller.Main', {
	extend:'Ext.app.Controller',

	views:['FormItems'],

	refs:[
		{
			selector:'formitems',
			ref:'formitems'
		},
	],

	init:function(){
		this.loadFieldData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="ManagerIp"]': {
				'select': this.comboLoad
			},
			'formitems button[id="UpdateBTN"]': {
				'click': this.update
			}
		});
	},

	loadFieldData: function(){
		Ext.Ajax.request({
			url: 'AssignToManager/data/EgAssignAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	comboLoad: function(){
		var manager_IP = Ext.getCmp('ManagerIp').getValue();
		Ext.Ajax.request({
			url: 'AssignToManager/data/EgAssignAgentsJson.jsp?manager_IP='+manager_IP,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectAssignToMgr').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.agents.AGENTS ASSIGNED TO']);

				if (Ext.getCmp('itemselectAssignToMgr').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectAssignToMgr').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectAssignToMgr').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectAssignToMgr').toField.store.removeAll();
				}
				Ext.getCmp('itemselectAssignToMgr').fromField.store.add(publicJSON['agentsForThisMgr']);
				Ext.getCmp('itemselectAssignToMgr').toField.store.add(publicJSON['agentsForOtherMgr']);
			}
		});
	},

	update: function(){
		var managerIP = Ext.getCmp('ManagerIp').getValue();
		var prevAssignedAgents = publicJSON['assignedAgents'];
		var myAssignMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myAssignMask.show(); 

		var Arr = new Array();
		var noOfManAgent = Ext.getCmp('itemselectAssignToMgr').fromField.store.getCount();

		var allValue = new Array();
		for (var i=0;i < noOfManAgent;i++)
		{
			allValue[allValue.length]=Ext.getCmp('itemselectAssignToMgr').fromField.store.getAt(i).get('valueField');
		}
		for (var m=0;m<allValue.length;m++ )
		{
			var isData = false;
			if (prevAssignedAgents != null && prevAssignedAgents.length > 0)
			{
				for (var j=0;j<prevAssignedAgents.length;j++ )
				{

					if (allValue[m] == prevAssignedAgents[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length] = allValue[m];
				}
			}
			else
			{
				Arr[Arr.length] = allValue[m];
			}
		}
		var assignAgntToSelectedMgr = Arr;
		var primaryManagerIP = publicJSON['primaryManagerIP'];

		var qrString = "managerIP="+encodeURIComponent(managerIP)+"&primaryManagerIP="+encodeURIComponent(primaryManagerIP);
		Ext.Ajax.request({
			url: 'AssignToManager/data/Egassignagentsp.jsp?'+qrString,
			method: 'POST',
			params :
			{
				'agentsForOtherManagers':assignAgntToSelectedMgr
			},
			success: function( response )
			{
				myAssignMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1'],
							function(btn){
								Ext.Ajax.request({
								url: 'AssignToManager/data/EgAssignAgentsJson.jsp?manager_IP='+managerIP,
								method: 'POST',
								success: function( response )
								{
									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode( jsonText );
									}
									if (Ext.getCmp('itemselectAssignToMgr').fromField.store.getCount() >= 1)
									{
										Ext.getCmp('itemselectAssignToMgr').fromField.store.removeAll();
									}
									if (Ext.getCmp('itemselectAssignToMgr').toField.store.getCount() >= 1)
									{
										Ext.getCmp('itemselectAssignToMgr').toField.store.removeAll();
									}

									Ext.getCmp('itemselectAssignToMgr').fromField.store.add(publicJSON['agentsForThisMgr']);
									Ext.getCmp('itemselectAssignToMgr').toField.store.add(publicJSON['agentsForOtherMgr']);
								}
							});
						});
					}
				}
			}
		});
	},

	initializeFields : function(){
		var me=this;
		var executiveForm = this.getFormitems().getForm();
		me.setValueWithOptionInList(executiveForm, 'ManagerIp', publicJSON['managerChosenArr'],'');
	},

	setValueWithOptionInList : function(form, fieldName, list, value){
	form.findField(fieldName).getStore().loadRawData(list);
	form.findField(fieldName).suspendEvents(false);
	var valueAssigned = false;
	for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
		if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
			form.findField(fieldName).setValue(value);
			valueAssigned = true;
		}
	}
	
	if(!valueAssigned){
		form.findField(fieldName).setValue(list[0].valueField);
	}
	form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(){
		this.initializeFields();
		Ext.getCmp('ManagerIp').setFieldLabel(publicJSON['screenLabels']['admin.agents.Manager']);
		Ext.getCmp('itemselectAssignToMgr').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.agents.AGENTS ASSIGNED TO']);
		Ext.getCmp('itemselectAssignToMgr').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.agents.AGENTS ASSIGNED TO OTHER MANAGERS']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

		var manager_IP = Ext.getCmp('ManagerIp').getValue();
		Ext.Ajax.request({
			url: 'AssignToManager/data/EgAssignAgentsJson.jsp?manager_IP='+manager_IP,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectAssignToMgr').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectAssignToMgr').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectAssignToMgr').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectAssignToMgr').toField.store.removeAll();
				}
				Ext.getCmp('itemselectAssignToMgr').fromField.store.add(publicJSON['agentsForThisMgr']);
				Ext.getCmp('itemselectAssignToMgr').toField.store.add(publicJSON['agentsForOtherMgr']);
			}
		});
	}

});



