Ext.define('AssociateDissociateTests.controller.Main',{
	extend:'Ext.app.Controller',

	views:['AssoDissoTests'],

	refs:[
		{selector:'assodissotests', ref:'assodissotests'}
	],

	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'assodissotests':
			{
				'boxready': this.afterMainRender
			},
			'assodissotests [id = "compType"]' :
			{
				'change': this.loadAssDisassTests
			},
			'assodissotests [id = "testType"]' :
			{
				'change': this.loadAssDisassTests
			},
			'assodissotests [id = "update"]' :
			{
				'click': this.updateTests
			},
			'assodissotests [id = "associateSeacrchBox"]' :
			{
				'change': this.searchAssoComponent
			},
			'assodissotests [id = "dissociateSeacrchBox"]' :
			{
				'change': this.searchDissoComponent
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'AssociateDissociateTests/data/ADPerfConfigTestsJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	loadData: function(componentType,testType,search,searchType,searchEnable)
	{
		Ext.Ajax.request(
		{
			url: 'AssociateDissociateTests/data/ADPerfConfigTestsJson.jsp?componentType='+encodeURIComponent(componentType)+'&testType='+encodeURIComponent(testType)+'&search='+encodeURIComponent(search)+'&searchType='+encodeURIComponent(searchType)+'&searchEnable='+encodeURIComponent(searchEnable),
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		var pdComboObj = Ext.getCmp('compType');
		pdComboObj.show();
		pdComboObj.getStore().removeAll();
		pdComboObj.getStore().loadRawData(publicJSON.allCompType);
		pdComboObj.setValue(publicJSON.allCompType[0].valueField);
		if(showTestType == 'true'){
			Ext.getCmp("testType").show();
		}
	},
	loadAssDisassTests : function()
	{
		appCnt = this;
		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		if(componentType == '-1'){
			var itemSelObj = Ext.getCmp('itemselectTests');
			itemSelObj.fromField.store.removeAll();
			itemSelObj.toField.store.removeAll();
			Ext.getCmp('associateSeacrchBox').hide();
			Ext.getCmp('dissociateSeacrchBox').hide();
		}
		if(componentType != null && componentType != '-1' && testType != null){
			var search = null;
			var searchType = null;
			var searchEnable = false;
			this.loadData(componentType,testType,search,searchType,searchEnable);

			//if(publicJSON.enableAssoSearch)
				//Ext.getCmp('associateSeacrchBox').show();
			//if(publicJSON.enableDisassoSearch)
				//Ext.getCmp('dissociateSeacrchBox').show();
			if(!publicJSON.enableAssoSearch)
				Ext.getCmp('associateSeacrchBox').hide();
			if(!publicJSON.enableDisassoSearch)
				Ext.getCmp('dissociateSeacrchBox').hide();

			var hiddenasso = '';
			var hiddendisasso = '';
			var hiddenassoListLength = 0;
			var hiddendisassoListLength = 0;
			var hiddenassoList = publicJSON.hiddenassoList;
			var hiddendisassoList = publicJSON.hiddendisassoList;
			if(hiddenassoList != undefined && hiddenassoList != null && hiddenassoList != "")
			{
				hiddenassoListLength = hiddenassoList.length;
			}
			if(hiddendisassoList != undefined && hiddendisassoList != null && hiddendisassoList != "")
			{
				hiddendisassoListLength = hiddendisassoList.length;
			}
			for (var i = 0; i < hiddenassoListLength; i++) 
			{
				hiddenasso += hiddenassoList[i]+',';
			}
			for (var i = 0; i < hiddendisassoListLength; i++ )
			{
				hiddendisasso += hiddendisassoList[i]+',';
			}

			var hiddenComp = Ext.getCmp('hiddenCont');
			hiddenComp.removeAll();
			hiddenComp.add({
				xtype: 'hidden',
				name: 'hiddenassociate',
				id : 'hiddenassociate',
				value: hiddenasso
			});
			hiddenComp.add({
				xtype: 'hidden',
				name: 'hiddendisassociate',
				id : 'hiddendisassociate',
				value: hiddendisasso
			});
			var itemSelObj = Ext.getCmp('itemselectTests');
			itemSelObj.fromField.store.removeAll();
			itemSelObj.toField.store.removeAll();
			if (publicJSON.assoList != null)
			{
				itemSelObj.fromField.store.add(publicJSON.assoList);
			}
			if (publicJSON.disassoList != null)
			{
				itemSelObj.toField.store.add(publicJSON.disassoList);
			}
		}
	},
	updateTests : function()
	{
		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var form = Ext.getCmp('form').getForm();
		var itemSelObj = Ext.getCmp('itemselectTests');
		var fromFieldObj = itemSelObj.fromField.store;
		var toFieldObj = itemSelObj.toField.store;
		
		if(componentType != '-1')
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			var currentAssociated = '';
			for (var s = 0; s < fromFieldObj.getCount(); s++)
			{
				var newVal = fromFieldObj.getAt(s).get('valueField');
				currentAssociated += newVal+',';
			}

			var currentDisassociated = '';
			for (var s = 0; s < toFieldObj.getCount(); s++)
			{
				var newVal = toFieldObj.getAt(s).get('valueField');
				currentDisassociated += newVal+',';
			}
			var hiddenasso = Ext.getCmp('hiddenassociate').getValue();
			var hiddendisasso = Ext.getCmp('hiddendisassociate').getValue();

			form.submit(
			{
				url: 'AssociateDissociateTests/data/ADPerfConfigTestsJsonp.jsp',
				params: '&componentType='+encodeURIComponent(componentType)+'&currentAssociated='+currentAssociated+'&currentDisassociated='+currentDisassociated+'&hiddenasso='+hiddenasso+'&hiddendisasso='+hiddendisasso,
				method: 'POST',
				success: function(form,action)
				{
					myMask.hide();
					var resultJSON = Ext.decode(action.response.responseText);
					if(resultJSON.AlertType)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: successMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: errorMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
					appCnt.loadAssDisassTests();
				}
			});
		}
	},
	searchAssoComponent : function()
	{
		var searchType = 'associate';
		var searchEnable = true;
		var search = Ext.getCmp('associateSeacrchBox').getValue();
		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();

		if (search == "" || search.length == 0)
		{
			Ext.get('MyTriggerAssociate_0').setStyle('display','none');
			Ext.get('MyTriggerAssociate_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTriggerAssociate_1').setStyle('display','none');
			Ext.get('MyTriggerAssociate_0').setStyle('display','block');
		}
		if(componentType != null && componentType != '-1' && testType != null){
			this.loadData(componentType,testType,search,searchType,searchEnable);
			var itemSelObj = Ext.getCmp('itemselectTests');
			itemSelObj.fromField.store.removeAll();
			if (publicJSON.assoList != null)
			{
				itemSelObj.fromField.store.add(publicJSON.assoList);
			}
		}

	},
	searchDissoComponent : function()
	{
		var searchType = 'dissociate';
		var searchEnable = true;
		var search = Ext.getCmp('dissociateSeacrchBox').getValue();
		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		if (search == "" || search.length == 0)
		{
			Ext.get('MyTriggerDisAssociate_0').setStyle('display','none');
			Ext.get('MyTriggerDisAssociate_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTriggerDisAssociate_1').setStyle('display','none');
			Ext.get('MyTriggerDisAssociate_0').setStyle('display','block');
		}

		if(componentType != null && componentType != '-1' && testType != null){
			this.loadData(componentType,testType,search,searchType,searchEnable);
			var itemSelObj = Ext.getCmp('itemselectTests');
			itemSelObj.toField.store.removeAll();
			if (publicJSON.disassoList != null)
			{
				itemSelObj.toField.store.add(publicJSON.disassoList);
			}
		}
	}
});



