Ext.define('AssociateDissociateTests.view.AssoDissoTests', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.assodissotests',
	title: pageTitle,
	cls:'outerpanel',
	header:{cls:'textUpper'},
	margin:'8 8 0 8',
	id: 'formitems',
	requires: [
		'Ext.ux.ItemSelectorSm',
		'Ext.ux.form.ItemSelectorSI',
		'utilities.ScrollCombo'
	],

	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' '
	},

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+"."+"</center>",
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			margin: '5 5 10 5',
			items:[
				{
					xtype: 'form',
					id: 'form',
					cls:'formOuter',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					margin: 10,
					padding:10,
					items: [
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							id : 'compType',
							name: 'compType',
							fieldLabel: compType,
							fieldName : 'compType',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: true,
							width: 250,
							parent:this,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							id : 'testType',
							name: 'testType',
							fieldLabel: testType,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							width: 150,
							margin: '0 0 0 20',
							parent:this,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: [
									{
										'displayField' : 'Performance',
										'valueField' : 'Performance'
									},
									{
										'displayField' : 'Configuration',
										'valueField' : 'Configuration'
									}
								]
							}),
							value : 'Performance',
							hidden : true
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id : 'searchFieldContainer',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'container',
					width: 385,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'associateSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: search,
							margin: '0 0 5 0',
							hidden : true,
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTriggerAssociate_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTriggerAssociate_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCtn.searchAssoComponent();
							}
						}
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 385,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'dissociateSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: search,
							margin: '0 0 5 0',
							hidden : true,
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTriggerDisAssociate_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTriggerDisAssociate_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCnt.searchDissoComponent();
							}
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id : 'hiddenCont',
			name : 'hiddenCont'
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'itemselector',
					cls:'multiselect',
					name: 'itemselectTests',
					fieldName: 'itemselectTests',
					id: 'itemselectTests',
					//font: 'bold',
					buttons: ['add','remove'],
					buttonsText: {
						add: dissobtn,
						remove: assobtn
					},
					store: new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					height: 370,
					width: 800,
					fromTitle: assoTests,
					toTitle: disoTests
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 20 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: update,
					id: 'update',
					width: 80
				}
			]
		}
	]
});



