Ext.define('Auditlog.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormItems','Print','EgInfraDownloader'],

	refs:[
		{selector:'FormItems', ref:'FormItems'}
	],
	init:function(){
		this.buildMainData();
		this.control({
			'auditlog_widget':
			{
				'afterrender': this.afterMainRender
			},
			'auditlog_widget button[id="schedule"]':
			{
				'click': this.callSaveSchedule
			},
			'auditlog_widget button[id="save"]':
			{
				'click': this.savePdf
			},
			'auditlog_widget button[id="print"]':
			{
				'click': this.printData
			},
			'auditlog_widget button[id="csv"]':
			{
				'click': this.saveInCSVFormat
			},
			'auditlog_widget combo[id="timeline"]':
			{
				'select': this.changeTimeline
			},
			'auditlog_widget combo[id="clusterManager"]':
			{
				'select': this.populate_temp
			},
			'auditlog_widget combo[id="filterBy"]':
			{
				'select': this.populate_temp
			},
			'auditlog_widget combo[id="users"]':
			{
				'select': this.setUserName
			},
			'auditlog_widget button[id="backButton"]':
			{
				'click': this.goback
			}
		});
	},
	populate_temp : function(obj)
	{
		populate(obj.getId(),'onchange');
	},
	setUserName : function()
	{
		if(!validateDates())
		{
			return;
		}
		selectedUser = Ext.getCmp('users').getValue();
		if(selectedUser == null || selectedUser=='undefined' || selectedUser.length==0 || selectedUser=='-1')
		{
			Ext.Msg.alert(pageTitle,select_user_name);
			return;
		}
		hideAuditlogReportPanel();
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&users='+encodeURIComponent(selectedUser)+'&category='+category+'&eg_timeline='+Ext.getCmp('timeline').getValue()+'&startdate='+sformattedValue+'&enddate='+eformattedValue,
			method: 'POST',
			async: true,
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				Ext.getCmp('clusterManager').getStore().loadRawData(publicJSON['clusterArray']);
				Ext.getCmp('clusterManager').setValue("All");
				Ext.getCmp('filterBy').getStore().loadRawData(publicJSON['filterByArray']);
				Ext.getCmp('filterBy').setValue("All");
				Ext.getCmp('hostip').getStore().loadRawData(publicJSON['hostip']);
				Ext.getCmp('hostip').boundList.getSelectionModel().selectAll();
				populate('hostip','onload');
			},
			failure : function(response)
			{
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
			}
		});
	},
	goback: function()
	{
		var timelineVal = "";
		var startDate = "";
		var endDate = "";
		var filterBy = "";
		var user = "";
		var flag = false;
		var qryStrVals = queryString.split("&");
		if (qryStrVals != null)
		{
			for (var i=0;i<qryStrVals.length;i++)
			{
				var values = qryStrVals[i];
				var valSplit = values.split("=");
				var key = valSplit[0];
				var val = valSplit[1];
				if (key == "timeline")
				{
					if (val != null && val != "null" && val != "")
					{
						flag = true;
						break;
					}
				}
			}
		}

		if (qryStrVals != null)
		{
			for (var i=0;i<qryStrVals.length;i++)
			{
				var values = qryStrVals[i];
				var valSplit = values.split("=");
				var key = valSplit[0];
				var val = valSplit[1];
				if (key == "timeline")
				{
					timelineVal = val;
				}
				if (key == "tlStrtDate")
				{
					startDate = val;
				}
				if (key == "tlEndDate")
				{
					endDate = val;
				}
				if (key == "tlFilterBy")
				{
					filterBy = val;
				}
				if (key == "tlUser")
				{
					user = val;
				}
			}
		}
		if (flag)
		{
			window.location.href='/final/admin/logons.jsp?eg_timeline='+timelineVal+'&startdate='+startDate+'&enddate='+endDate+'&filterBy='+filterBy+'&users='+user+'&requestFrom=auditlog';
		}
		else
		{
			window.location.href='/final/admin/logons.jsp';
		}
	},
	buildMainData: function(){
		if(thisjsppage != null && thisjsppage=='loginDetails')
		{
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.AuditServletExtJS?'+queryString,
				method: 'POST',
				async: false,
				success: function(response)
				{
					publicJSON = Ext.decode(response.responseText);
				},
				failure : function(response)
				{
					var topWindow = window;
					while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
					{
						mainWindow = topWindow;
						topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
					}
					if(topWindow.location.pathname!="/")
					{
						mainWindow=topWindow;
					}
					mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
					mainWindow.focus();
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.AuditServletExtJS?'+queryString,
				method: 'POST',
				async: false,
				success: function(response)
				{
					publicJSON = Ext.decode(response.responseText);
				},
				failure : function(response)
				{
					var topWindow = window;
					while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
					{
						mainWindow = topWindow;
						topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
					}
					if(topWindow.location.pathname!="/")
					{
						mainWindow=topWindow;
					}
					mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
					mainWindow.focus();
				}
			});
		}
	},
	afterMainRender : function()
	{
		if(isSuperManager=='true')
		{
			Ext.getCmp("schedule").hide();
		}
		if(thisjsppage != null && thisjsppage=='loginDetails')
		{
			/*Ext.Ajax.request({
				url : '/final/servlet/com.eg.AuditServletExtJS?'+queryString,
				method: 'POST',
				async: true,
				success: function(response)
				{*/
					Ext.getCmp('backButton').show();
					Ext.getCmp('bkSeperator').show();
					//publicJSON = Ext.decode(response.responseText);
					Ext.getCmp('user_hostip_session_period').show();
					if(publicJSON['total_records'] != null && publicJSON['total_records'] != 'undefined')
					{
						Ext.getCmp('total_records_label').update(totalRecordsLabel+'&nbsp;:&nbsp;' + publicJSON["total_records"]['count']);
					}
					if(publicJSON['total_pages'] != null && publicJSON['total_pages'] != 'undefined')
					{
						total_pages = parseInt(publicJSON["total_pages"]['count']);
					}
					if(total_pages>0)
					{
						Ext.getCmp('total_records_container').show();
						if(total_pages==1)
						{
							Ext.getCmp('firstpage').setDisabled(true);
							Ext.getCmp('previouspage').setDisabled(true);
							Ext.getCmp('nextpage').setDisabled(true);
							Ext.getCmp('lastpage').setDisabled(true);
						}
						else if(total_pages>1)
						{
							Ext.getCmp('firstpage').setDisabled(true);
							Ext.getCmp('previouspage').setDisabled(true);
							Ext.getCmp('nextpage').setDisabled(false);
							Ext.getCmp('lastpage').setDisabled(false);

							if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
							{
								Ext.getCmp('nextpage').removeCls('al_next_disabled');
								Ext.getCmp('nextpage').addCls('al_next_enabled');
							}
							if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
							{
								Ext.getCmp('lastpage').removeCls('al_last_disabled');
								Ext.getCmp('lastpage').addCls('al_last_enabled');
							}
						}
						Ext.getCmp('of_label').setText(ofLabel+' '+total_pages);
						Ext.getCmp("save").setDisabled(false);
						Ext.getCmp("print").setDisabled(false);
						Ext.getCmp("csv").setDisabled(false);
						Ext.Ajax.request({
							url : '/final/admin/Auditlog/data/auditlogInfo.jsp?submitted=true&rowsperpage=15&'+queryString,
							method: 'POST',
							async: true,
							success: function(response)
							{
								Ext.getCmp('auditlog_data_panel').show();
								Ext.getCmp("auditlog_data_component").update(response.responseText);
							},
							failure : function(response)
							{
								Ext.MessageBox.alert(pageTitle,information);
							}
						});
					}
					else
					{
						Ext.getCmp('user_session_data_not_found').show();
					}
				/*},
				failure : function(response)
				{
					Ext.MessageBox.alert(pageTitle,could_not_load);
				}
			});*/
		}
		else
		{
			Ext.getCmp('bkSeperator').hide();
			Ext.getCmp('backButton').hide();
			Ext.getCmp('timeline_container').show();
			Ext.getCmp('user_cluster_interface_container').show();
			Ext.getCmp('hostip_module_activity_container').show();
			Ext.getCmp('showbutton_container').show();
			if(isClusterSupported=="false" && auditLogEnabledForCLI=="false")
			{
				Ext.getCmp('clusterManager').hide();
				Ext.getCmp('filterBy').hide();
			}
			else if(isClusterSupported=="true" && auditLogEnabledForCLI=="true")
			{
				Ext.getCmp('clusterManager').show();
				Ext.getCmp('filterBy').show();
			}
			else if(isClusterSupported=="true")
			{
				Ext.getCmp('clusterManager').show();
				Ext.getCmp('filterBy').hide();
			}
			else
			{
				Ext.getCmp('clusterManager').hide();
				Ext.getCmp('filterBy').show();
			}
			/*Ext.Ajax.request({
			url : '/final/servlet/com.eg.AuditServletExtJS?'+queryString,
			method: 'POST',
			async: true,
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);*/

				Ext.getCmp('timeline').getStore().loadRawData(publicJSON['timelinesArray']);
				Ext.getCmp('timeline').setValue(publicJSON['defaults']["timeline"]);

				Ext.getCmp('eg_stdate').setValue(publicJSON['defaults']["eg_stdate"]);
				Ext.getCmp('starthr').setValue(publicJSON['defaults']["starthr"]);
				Ext.getCmp('startmin').setValue(publicJSON['defaults']["startmin"]);

				Ext.getCmp('eg_enddate').setValue(publicJSON['defaults']["eg_enddate"]);
				Ext.getCmp('endhr').setValue(publicJSON['defaults']["endhr"]);
				Ext.getCmp('endmin').setValue(publicJSON['defaults']["endmin"]);
				if(publicJSON['userIdsArray'] != null && publicJSON['userIdsArray'] != 'undefined' && publicJSON['userIdsArray'].length>0)
				{
					Ext.getCmp('users').getStore().loadRawData(publicJSON['userIdsArray']);
				}
				if(publicJSON['defaultuser'] != null && publicJSON['defaultuser'] != 'undefined' && publicJSON['defaultuser'].length>0)
				{
					Ext.getCmp('users').setValue(publicJSON["defaultuser"]);
				}
				else if(publicJSON['nousersavailable'] != null && publicJSON['nousersavailable'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["nousersavailable"]);
					disableAll();
				}
				Ext.getCmp('clusterManager').getStore().loadRawData(publicJSON['clusterArray']);
				Ext.getCmp('clusterManager').setValue(publicJSON["defaultClusterManager"]);
				Ext.getCmp('filterBy').getStore().loadRawData(publicJSON['filterByArray']);
				Ext.getCmp('filterBy').setValue(publicJSON['defaultFilterBy']);
				if(publicJSON['hostip'] != null && publicJSON['hostip'] != 'undefined' && publicJSON['hostip'].length>0)
				{
					Ext.getCmp('hostip').getStore().loadRawData(publicJSON['hostip']);
					Ext.getCmp('hostip').boundList.getSelectionModel().selectAll();
				}
				var labels = publicJSON['labels'];
				Ext.getCmp('timeline').setFieldLabel(labels['timeline']);
				Ext.getCmp('eg_stdate').setFieldLabel(labels['eg_stdate']);
				Ext.getCmp('starthr').setFieldLabel(labels['starthr']);
				Ext.getCmp('startmin').setFieldLabel(labels['startmin']);
				Ext.getCmp('eg_enddate').setFieldLabel(labels['eg_enddate']);
				Ext.getCmp('endhr').setFieldLabel(labels['starthr']);
				Ext.getCmp('endmin').setFieldLabel(labels['startmin']);
				Ext.getCmp('users').setFieldLabel(labels['users']);
				Ext.getCmp('clusterManager').setFieldLabel(labels['clusterManager']);
				Ext.getCmp('filterBy').setFieldLabel(labels['filterBy']);
				Ext.getCmp('showbutton').setText(labels['showbutton']);
				populate('hostip','onload');
			/*},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageTitle,could_not_load);
			}
		});*/
		}
	},
	callSaveSchedule :function(btn)
	{
		if(validateDates())
		{
			var schedule_type = category+"AuditLog";
			var qryString = '/final/admin/saveSchedule.jsp?er_timeline='+Ext.getCmp('timeline').getValue()+'&er_gtype='+schedule_type+'&er_rtype='+schedule_type+'&submitted=true&jsppage=auditlog&submit=true&users='+Ext.getCmp('users').getValue()+'&er_userid='+Ext.getCmp('users').getValue()+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&eg_timeline='+Ext.getCmp('timeline').getValue()+'&'+schedule_type+'=true&s_hostip='+Ext.getCmp('hostip').getValue()+'&s_module='+Ext.getCmp('module').getValue()+'&category='+category+'&reloaded=true';
			if(isClusterSupported=="true")
			{
				qryString +='&filterBy='+Ext.getCmp('filterBy').getValue();
			}
			if(auditLogEnabledForCLI=="true")
			{
				qryString +='&clusterManager='+Ext.getCmp('clusterManager').getValue();
			}
			if(Ext.getCmp('activity').getValue().length==0)
			{
				Ext.getCmp('activity').boundList.getSelectionModel().selectAll();
			}
			var activityList = Ext.getCmp('activity').getValue();
			for(var i in activityList)
			{
				activityList[i] = filterEncode(activityList[i]);
			}
			qryString +='&s_activity='+encodeURIComponent(activityList);
			scheduleWindow(qryString);
			Ext.getCmp('scheduleWin').setTitle(scheduleTitle);
		}
	},
	savePdf: function()
	{
		var getSaveObj = Ext.widget('savepdf');
		getSaveObj.savePDF(pdfURLString);
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+trackerLanguage;
	},
	printData: function()
	{
		var printPage = "/final/admin/Auditlog/data/auditlogPrint.jsp?reload=false&reporterName=&category="+category+"&com.eg.CSRF_NONCE="+csrfToken;
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	changeTimeline :function()
	{
		hideAuditlogReportPanel();
		var obj = Ext.getCmp('timeline');
		if (obj.getValue() == 'Any')
		{
			Ext.getCmp('eg_stdate').setDisabled(false);
			Ext.getCmp('starthr').setDisabled(false);
			Ext.getCmp('startmin').setDisabled(false);
			Ext.getCmp('eg_enddate').setDisabled(false);
			Ext.getCmp('endhr').setDisabled(false);
			Ext.getCmp('endmin').setDisabled(false);
			Ext.getCmp('icon_go').show();
			disableAll();
		}
		else
		{
			Ext.getCmp('eg_stdate').setDisabled(true);
			Ext.getCmp('starthr').setDisabled(true);
			Ext.getCmp('startmin').setDisabled(true);
			Ext.getCmp('eg_enddate').setDisabled(true);
			Ext.getCmp('endhr').setDisabled(true);
			Ext.getCmp('endmin').setDisabled(true);
			Ext.getCmp('icon_go').hide();

			var timeline = Ext.getCmp("timeline").getValue();
			var strtdt = Ext.getCmp("eg_stdate").getValue();
			var enddt = Ext.getCmp("eg_enddate").getValue();
			var strthour = Ext.getCmp("starthr").getValue();
			var endhr = Ext.getCmp("endhr").getValue();
			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
			var param = "F=getTime&C=id" + no_params;
			Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response) {
					var jsonData = Ext.decode(response.responseText);
					if(!Ext.isEmpty(jsonData))
					{
						var timedata = jsonData.timeline;
						Ext.getCmp("eg_stdate").setValue(timedata[6]);
						Ext.getCmp("eg_stdate").dataArray = timedata[0];
						Ext.getCmp("eg_enddate").setValue(timedata[7]);
						Ext.getCmp("eg_enddate").dataArray = timedata[1];
						Ext.getCmp("starthr").setValue(timedata[8]);
						Ext.getCmp("starthr").dataArray = timedata[2];
						Ext.getCmp("endhr").setValue(timedata[9]);
						Ext.getCmp("endhr").dataArray = timedata[3];

						Ext.getCmp("startmin").setValue(timedata[10]);
						Ext.getCmp("startmin").dataArray = timedata[11];
						Ext.getCmp("endmin").setValue(timedata[10]);
						Ext.getCmp("endmin").dataArray = timedata[11];
					}
				}
			});
			findUsers();
		}
	}
});
function sub()
{
	total_pages = 0;
	currentPageNumber = 0;
	var users_found = false;
	selectedUser = Ext.getCmp('users').getValue();
	if(selectedUser != null && selectedUser != 'undefined' && selectedUser.length>0 && selectedUser != '-1')
	{
		users_found = true;
	}
	if(users_found && validateDates())
	{
		var urlStr = '/final/servlet/com.eg.AuditServletExtJS?eg_timeline='+Ext.getCmp('timeline').getValue()+'&submitted=true&jsppage=auditlog&submit=true&users='+Ext.getCmp('users').getValue()+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&category='+category+'&clicked=all';
		if(isClusterSupported=="true")
		{
			urlStr +='&filterBy='+Ext.getCmp('filterBy').getValue();
		}
		if(auditLogEnabledForCLI=="true")
		{
			urlStr +='&clusterManager='+Ext.getCmp('clusterManager').getValue();
		}
		if(Ext.getCmp('activity').getValue().length==0)
		{
			Ext.getCmp('activity').boundList.getSelectionModel().selectAll();
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
		myMask.show();
		Ext.getCmp("showbutton").setDisabled(true);
		Ext.Ajax.request({
			url :urlStr,
			method: 'POST',
			params:{'s_hostip':Ext.getCmp('hostip').getValue(),'s_module':Ext.getCmp('module').getValue(),'s_activity':Ext.getCmp('activity').getValue()},
			async: true,
			success: function(response)
			{
				myMask.hide();
				Ext.getCmp("showbutton").setDisabled(false);
				publicJSON = Ext.decode(response.responseText);
				Ext.getCmp('pagenumber').setValue('1');
				if(publicJSON['total_records'] != null && publicJSON['total_records'] != 'undefined')
				{
					Ext.getCmp('total_records_label').update(totalRecordsLabel+'&nbsp;:&nbsp;' + publicJSON["total_records"]['count']);
				}
				if(publicJSON['total_pages'] != null && publicJSON['total_pages'] != 'undefined')
				{
					total_pages = publicJSON["total_pages"]['count'];
					currentPageNumber = 1;

					if(total_pages==1)
					{
						Ext.getCmp('firstpage').setDisabled(true);
						Ext.getCmp('previouspage').setDisabled(true);
						Ext.getCmp('nextpage').setDisabled(true);
						Ext.getCmp('lastpage').setDisabled(true);
					}
					else if(total_pages>1)
					{
						Ext.getCmp('firstpage').setDisabled(true);
						Ext.getCmp('previouspage').setDisabled(true);
						Ext.getCmp('nextpage').setDisabled(false);
						Ext.getCmp('lastpage').setDisabled(false);

						Ext.getCmp('nextpage').removeCls('al_next_disabled');
						Ext.getCmp('lastpage').removeCls('al_last_disabled');
						Ext.getCmp('nextpage').addCls('al_next_enabled');
						Ext.getCmp('lastpage').addCls('al_last_enabled');
					}
					Ext.get('of_label').update('&nbsp;&nbsp; '+ofLabel+'&nbsp;'+total_pages);
				}
				else
				{
					Ext.get('of_label').update('&nbsp;&nbsp;'+ofLabel+'&nbsp;1');
				}
				loadData();
			},
			failure : function(response)
			{
				myMask.hide();
				Ext.getCmp("showbutton").setDisabled(false);
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
			}
		});
	}
}
function validateDates()
{
	if(Ext.getCmp('timeline').getValue() != "Any")
	{
		return true;
	}
	else
	{
		var st_value = Ext.getCmp('eg_stdate').getValue();
		var st_hr = Ext.getCmp('starthr').getValue();
		var st_min = Ext.getCmp('startmin').getValue();
		var ed_value = Ext.getCmp('eg_enddate').getValue();
		var ed_hr = Ext.getCmp('endhr').getValue();
		var ed_min = Ext.getCmp('endmin').getValue();
		var start_date_check = Ext.Date.format(Ext.getCmp('eg_stdate').getValue(), 'm/d/Y');
		var end_date_check = Ext.Date.format(Ext.getCmp('eg_enddate').getValue(), 'm/d/Y');

		if(!checkExtTime(start_date_check,end_date_check,st_hr,ed_hr,st_min,ed_min))
		{
			sformattedValue = null;
			eformattedValue = null;
			Ext.Msg.alert(pageTitle,dateAlert);
			return false
		}
		else
		{
			sformattedValue = Ext.Date.format(st_value, 'm/d/Y')+ ' ' + st_hr + ':'+ st_min + ':00';
			eformattedValue = Ext.Date.format(ed_value, 'm/d/Y') + ' ' + ed_hr + ':'+ ed_min + ':00';
			return true;
		}
	}
}
function findUsers()
{
	hideAuditlogReportPanel();
	if(validateDates())
	{
		ajaxURL='';
		var s_timeline = Ext.getCmp('timeline').getValue();
		if(s_timeline=="Any")
		{
			ajaxURL='/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&eg_timeline=Any&hideinputs=true&category='+category+'&startdate='+sformattedValue+'&enddate='+eformattedValue;
		}
		else
		{
			ajaxURL='/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&eg_timeline='+s_timeline+'&category='+category+'&startdate='+sformattedValue+'&enddate='+eformattedValue;
		}
		Ext.Ajax.request({
			url : ajaxURL,
			method: 'POST',
			async: true,
			success: function(response)
			{
				enableAll();
				publicJSON = Ext.decode(response.responseText);
				if(publicJSON['userIdsArray'] != null && publicJSON['userIdsArray'] != 'undefined')
				{
					Ext.getCmp('users').getStore().loadRawData(publicJSON['userIdsArray']);
				}
				else
				{
					disableAll();
				}
				if(publicJSON['defaultuser'] != null && publicJSON['defaultuser'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["defaultuser"]);
				}
				else if(publicJSON['nousersavailable'] != null && publicJSON['nousersavailable'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["nousersavailable"]);
					disableAll();
				}
				Ext.getCmp('clusterManager').setValue('All');
				Ext.getCmp('filterBy').setValue('All');
				if(publicJSON['hostip'] == null || publicJSON['hostip'] == 'undefined')
				{
					Ext.getCmp('hostip').getStore().removeAll();
					Ext.getCmp('module').getStore().removeAll();
					Ext.getCmp('activity').getStore().removeAll();
				}
				else
				{
					Ext.getCmp('hostip').getStore().loadRawData(publicJSON['hostip']);
					Ext.getCmp('hostip').suspendEvents(true);
					Ext.getCmp('hostip').boundList.getSelectionModel().selectAll();
					Ext.getCmp('hostip').resumeEvents();
					populate('hostip','onload');
				}
			},
			failure : function(response)
			{
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
			}
		});
	}
}
function disableAll()
{
	Ext.getCmp("users").setDisabled(true);
	Ext.getCmp("clusterManager").setDisabled(true);
	Ext.getCmp("filterBy").setDisabled(true);
	Ext.getCmp("showbutton").setDisabled(true);
	Ext.getCmp('hostip').getStore().removeAll();
	Ext.getCmp('module').getStore().removeAll();
	Ext.getCmp('activity').getStore().removeAll();
}
function enableAll()
{
	Ext.getCmp("users").setDisabled(false);
	Ext.getCmp("clusterManager").setDisabled(false);
	Ext.getCmp("filterBy").setDisabled(false);
	Ext.getCmp("showbutton").setDisabled(false);
}
function hideAuditlogReportPanel()
{
	if(isSuperManager=='true')
	{
		Ext.getCmp("schedule").hide();
	}
	Ext.getCmp("schedule").setDisabled(true);
	Ext.getCmp("save").setDisabled(true);
	Ext.getCmp("print").setDisabled(true);
	Ext.getCmp("csv").setDisabled(true);
	Ext.getCmp('total_records_container').hide();
	Ext.getCmp("auditlog_data_panel").hide();
}
function showAuditlogReportPanel()
{
	if(isSuperManager=='true')
	{
		Ext.getCmp("schedule").hide();
	}
	Ext.getCmp("schedule").setDisabled(false);
	Ext.getCmp("save").setDisabled(false);
	Ext.getCmp("print").setDisabled(false);
	Ext.getCmp("csv").setDisabled(false);
	Ext.getCmp('total_records_container').show();
	Ext.getCmp("auditlog_data_panel").show();
}
function populate(item,way)
{
	var successful = true;
	var s_hostips = Ext.getCmp('hostip').getValue();
	if(s_hostips == null || s_hostips=='undefined' || s_hostips.length==0)
	{
		Ext.getCmp('module').getStore().removeAll();
		Ext.getCmp('activity').getStore().removeAll();
		if(Ext.getCmp('hostip').getStore().getCount()>0)
		{
			Ext.getCmp('hostip').boundList.getSelectionModel().selectAll();
		}
	}
	var selectedUser = Ext.getCmp('users').getValue();
	if(selectedUser=='undefined' || selectedUser.length==0 || selectedUser=='-1')
	{
		return;
	}
	if(!validateDates())
	{
		successful = false;
		return;
	}
	var remoteUrl;
	if(way == 'onload' && (selectedUser=='undefined' || selectedUser.length==0 || selectedUser=='-1'))
	{
		Ext.getCmp('users').setDisabled(true);
		if(auditLogEnabledForCLI)
		{
			Ext.getCmp('filterBy').setDisabled(true);
		}
		if(isClusterSupported)
		{
			Ext.getCmp('clusterManager').setDisabled(true);
		}
		Ext.getCmp('hostip').setDisabled(true);
		Ext.getCmp('module').setDisabled(true);
		Ext.getCmp('activity').setDisabled(true);
		Ext.getCmp('showbutton').setDisabled(true);
		return;
	}
	if(way == 'onchange' && (selectedUser=='undefined' || selectedUser.length==0 || selectedUser=='-1'))
	{
		successful = false;
		return;
	}
	var timeLine = Ext.getCmp('timeline').getValue();
	if(item == 'clusterManager')
	{
		Ext.getCmp('showbutton').setDisabled(true);
		hideAuditlogReportPanel();
		remoteUrl = '/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&users='+encodeURIComponent(selectedUser)+'&eg_timeline='+timeLine+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&clicked=clusterManager&category='+category+'&ajax=true';
	}
	else if(item == 'filterBy')
	{
		Ext.getCmp('showbutton').setDisabled(true);
		hideAuditlogReportPanel();
		if(auditLogEnabledForCLI)
		{
			var filterbys = Ext.getCmp('filterBy').getValue();
			if(filterbys=='undefined' || filterbys.length==0 || filterbys=='-1')
			{
				successful = false;
				return;
			}
		}
		remoteUrl = '/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&users='+encodeURIComponent(selectedUser)+'&eg_timeline='+timeLine+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&clicked=filterBy&category='+category+'&ajax=true';
	}
	else if(item == 'hostip')
	{
		var hostips = Ext.getCmp('hostip').getValue();
		if(hostips == null || hostips=='undefined' || hostips.length==0)
		{
			successful = false;
			return;
		}
		remoteUrl = '/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&users='+encodeURIComponent(selectedUser)+'&eg_timeline='+timeLine+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&clicked=hostIP&hostip='+hostips+'&category='+category+'&ajax=true';
	}
	else if(item == 'module')
	{
		var hostips = Ext.getCmp('hostip').getValue();
		if(hostips == null || hostips=='undefined' || hostips.length==0)
		{
			if(Ext.getCmp('hostip').getStore().getCount()>0)
			{
				Ext.getCmp('hostip').boundList.getSelectionModel().selectAll();
				hostips = Ext.getCmp('hostip').getValue()
			}
			else
			{
				successful = false;
				return;
			}
		}
		var modules = Ext.getCmp('module').getValue();
		if(modules == null || modules=='undefined' || modules.length==0)
		{
			if(Ext.getCmp('module').getStore().getCount()>0)
			{
				Ext.getCmp('module').boundList.getSelectionModel().selectAll();
				modules = Ext.getCmp('module').getValue()
			}
			else
			{
				successful = false;
				return;
			}
		}
		remoteUrl='/final/servlet/com.eg.AuditServletExtJS?jsppage=auditlog&users='+encodeURIComponent(selectedUser)+'&eg_timeline='+timeLine+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&clicked=module&module='+modules+'&hostip='+hostips+'&category='+category+'&ajax=true';
	}
	if(auditLogEnabledForCLI)
	{
		remoteUrl+='&filterBy='+Ext.getCmp('filterBy').getValue()+'&isClusterSupported='+isClusterSupported;
	}
	if(isClusterSupported)
	{
		remoteUrl+='&clusterManager='+Ext.getCmp('clusterManager').getValue()+'&isClusterSupported='+isClusterSupported;
	}
	if(successful)
	{
		Ext.Ajax.request({
			url :remoteUrl,
			method: 'POST',
			params:{'s_hostip':Ext.getCmp('hostip').getValue(),'s_module':Ext.getCmp('module').getValue(),'s_activity':Ext.getCmp('activity').getValue()},
			async: true,
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				fillModules(item,publicJSON);
			},
			failure : function(response)
			{
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
			}
		});
	}
}
function fillModules(item,publicJSON)
{
	if(item == 'hostip')
	{
		Ext.getCmp('module').getStore().loadRawData(publicJSON['module']);
		Ext.getCmp('module').boundList.getSelectionModel().selectAll();
		if(Ext.getCmp('hostip').getStore().getCount()==0)
		{
			Ext.getCmp('showbutton').setDisabled(true);
		}
		else
		{
			Ext.getCmp('showbutton').setDisabled(false);
		}
	}
	else if(item == 'module')
	{
		Ext.getCmp('activity').getStore().loadRawData(publicJSON['activity']);
		Ext.getCmp('activity').boundList.getSelectionModel().selectAll();
	}
	else if(item == 'filterBy')
	{
		Ext.getCmp('hostip').getStore().loadRawData(publicJSON['hostip']);
	}
	else if(item == 'clusterManager')
	{
		Ext.getCmp('clusterManager').getStore().loadRawData(publicJSON['clusterArray']);
	}
	if(item == 'hostip')
	{
		populate('module','onchange');
	}
	if(item == 'clusterManager')
	{
		populate('filterBy','onchange');
	}
	if(item == 'filterBy')
	{
		populate('hostip','onchange');
	}
}
function loadData()
{
	if(total_pages==1)
	{
		if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_first_enabled');
			Ext.getCmp('firstpage').addCls('al_first_disabled');
		}
		if(Ext.getCmp('firstpage').hasCls("al_previous_enabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_previous_enabled');
			Ext.getCmp('firstpage').addCls('al_previous_disabled');
		}
		if(Ext.getCmp('nextpage').hasCls("al_next_enabled"))
		{
			Ext.getCmp('nextpage').removeCls('al_next_enabled');
			Ext.getCmp('nextpage').addCls('al_next_disabled');
		}
		if(Ext.getCmp('lastpage').hasCls("al_last_enabled"))
		{
			Ext.getCmp('lastpage').removeCls('al_last_enabled');
			Ext.getCmp('lastpage').addCls('al_last_disabled');
		}
	}
	else
	{
		if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_first_enabled');
			Ext.getCmp('firstpage').addCls('al_first_disabled');
		}
		if(Ext.getCmp('firstpage').hasCls("al_previous_enabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_previous_enabled');
			Ext.getCmp('firstpage').addCls('al_previous_disabled');
		}
		if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
		{
			Ext.getCmp('nextpage').removeCls('al_next_disabled');
			Ext.getCmp('nextpage').addCls('al_next_enabled');
		}
		if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
		{
			Ext.getCmp('lastpage').removeCls('al_last_disabled');
			Ext.getCmp('lastpage').addCls('al_last_enabled');
		}
	}
	Ext.Ajax.request({
		url : '/final/admin/Auditlog/data/auditlogInfo.jsp?submitted=true&rowsperpage=15',
		method: 'POST',
		async: true,
		success: function(response)
		{
			Ext.getCmp("auditlog_data_component").update(response.responseText);
			showAuditlogReportPanel();
		},
		failure : function(response)
		{
			Ext.MessageBox.alert(pageTitle,information);
		}
	});
}
function gotoPage(gotoPageN)
{
	if(gotoPageN=='' || parseInt(gotoPageN)<=0 || parseInt(gotoPageN)>parseInt(total_pages))
	{
		Ext.MessageBox.alert(pageTitle,information2 + ' ' + total_pages);
		return;
	}
	else if(parseInt(previousPageNumber)==parseInt(gotoPageN))
	{
		return;
	}
	else if(parseInt(gotoPageN)>0 && parseInt(gotoPageN)<=parseInt(total_pages))
	{
		if(parseInt(gotoPageN)==1)
		{
			currentPageNumber=1;
			Ext.getCmp('firstpage').setDisabled(true);
			Ext.getCmp('previouspage').setDisabled(true);
			Ext.getCmp('nextpage').setDisabled(false);
			Ext.getCmp('lastpage').setDisabled(false);

			if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
			{
				Ext.getCmp('firstpage').removeCls('al_first_enabled');
				Ext.getCmp('firstpage').addCls('al_first_disabled');
			}
			if(Ext.getCmp('previouspage').hasCls("al_previous_enabled"))
			{
				Ext.getCmp('previouspage').removeCls('al_previous_enabled');
				Ext.getCmp('previouspage').addCls('al_previous_disabled');
			}
			if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
			{
				Ext.getCmp('nextpage').removeCls('al_next_disabled');
				Ext.getCmp('nextpage').addCls('al_next_enabled');
			}
			if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
			{
				Ext.getCmp('lastpage').removeCls('al_last_disabled');
				Ext.getCmp('lastpage').addCls('al_last_enabled');
			}
		}
		else if(parseInt(gotoPageN)==parseInt(total_pages))
		{
			currentPageNumber = total_pages;
			Ext.getCmp('firstpage').setDisabled(false);
			Ext.getCmp('previouspage').setDisabled(false);
			Ext.getCmp('nextpage').setDisabled(true);
			Ext.getCmp('lastpage').setDisabled(true);

			if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
			{
				Ext.getCmp('firstpage').removeCls('al_first_disabled');
				Ext.getCmp('firstpage').addCls('al_first_enabled');
			}
			if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
			{
				Ext.getCmp('previouspage').removeCls('al_previous_disabled');
				Ext.getCmp('previouspage').addCls('al_previous_enabled');
			}
			if(Ext.getCmp('nextpage').hasCls("al_next_enabled"))
			{
				Ext.getCmp('nextpage').removeCls('al_next_enabled');
				Ext.getCmp('nextpage').addCls('al_next_disabled');
			}
			if(Ext.getCmp('lastpage').hasCls("al_last_enabled"))
			{
				Ext.getCmp('lastpage').removeCls('al_last_enabled');
				Ext.getCmp('lastpage').addCls('al_last_disabled');
			}
		}
		else
		{
			currentPageNumber=gotoPageN;
			if((currentPageNumber-1)<=0)
			{
				Ext.getCmp('firstpage').setDisabled(true);
				Ext.getCmp('previouspage').setDisabled(true);
				Ext.getCmp('nextpage').setDisabled(false);
				Ext.getCmp('lastpage').setDisabled(false);

				if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
				{
					Ext.getCmp('firstpage').removeCls('al_first_enabled');
					Ext.getCmp('firstpage').addCls('al_first_disabled');
				}
				if(Ext.getCmp('previouspage').hasCls("al_previous_enabled"))
				{
					Ext.getCmp('previouspage').removeCls('al_previous_enabled');
					Ext.getCmp('previouspage').addCls('al_previous_disabled');
				}
				if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
				{
					Ext.getCmp('nextpage').removeCls('al_next_disabled');
					Ext.getCmp('nextpage').addCls('al_next_enabled');
				}
				if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
				{
					Ext.getCmp('lastpage').removeCls('al_last_disabled');
					Ext.getCmp('lastpage').addCls('al_last_enabled');
				}
			}
			else if((currentPageNumber+1)>=total_pages)
			{
				Ext.getCmp('firstpage').setDisabled(false);
				Ext.getCmp('previouspage').setDisabled(false);
				Ext.getCmp('nextpage').setDisabled(true);
				Ext.getCmp('lastpage').setDisabled(true);

				if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
				{
					Ext.getCmp('firstpage').removeCls('al_first_disabled');
					Ext.getCmp('firstpage').addCls('al_first_enabled');
				}
				if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
				{
					Ext.getCmp('previouspage').removeCls('al_previous_disabled');
					Ext.getCmp('previouspage').addCls('al_previous_enabled');
				}
				if(Ext.getCmp('nextpage').hasCls("al_next_enabled"))
				{
					Ext.getCmp('nextpage').removeCls('al_next_enabled');
					Ext.getCmp('nextpage').addCls('al_next_disabled');
				}
				if(Ext.getCmp('lastpage').hasCls("al_last_enabled"))
				{
					Ext.getCmp('lastpage').removeCls('al_last_enabled');
					Ext.getCmp('lastpage').addCls('al_last_disabled');
				}
			}
			else
			{
				Ext.getCmp('firstpage').setDisabled(false);
				Ext.getCmp('previouspage').setDisabled(false);
				Ext.getCmp('nextpage').setDisabled(false);
				Ext.getCmp('lastpage').setDisabled(false);

				if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
				{
					Ext.getCmp('firstpage').removeCls('al_first_disabled');
					Ext.getCmp('firstpage').addCls('al_first_enabled');
				}
				if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
				{
					Ext.getCmp('previouspage').removeCls('al_previous_disabled');
					Ext.getCmp('previouspage').addCls('al_previous_enabled');
				}
				if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
				{
					Ext.getCmp('nextpage').removeCls('al_next_disabled');
					Ext.getCmp('nextpage').addCls('al_next_enabled');
				}
				if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
				{
					Ext.getCmp('lastpage').removeCls('al_last_disabled');
					Ext.getCmp('lastpage').addCls('al_last_enabled');
				}
			}
		}
		previousPageNumber = gotoPageN;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
		myMask.show();
		Ext.getCmp("showbutton").setDisabled(true);
		Ext.Ajax.request({
			url : '/final/admin/Auditlog/data/auditlogInfo.jsp?submitted=true&rowsperpage=15&pageNo='+gotoPageN,
			method: 'POST',
			async: true,
			success: function(response)
			{
				Ext.getCmp("auditlog_data_component").update(response.responseText);
				showAuditlogReportPanel();
				myMask.hide();
				Ext.getCmp("showbutton").setDisabled(false);
			},
			failure : function(response)
			{
				Ext.MessageBox.alert(pageTitle,information);
				myMask.hide();
				Ext.getCmp("showbutton").setDisabled(false);
			}
		});
	}
}
function pagination(buttonClicked)
{
	if(buttonClicked=='first')
	{
		currentPageNumber=1;
		Ext.getCmp('firstpage').setDisabled(true);
		Ext.getCmp('previouspage').setDisabled(true);
		Ext.getCmp('nextpage').setDisabled(false);
		Ext.getCmp('lastpage').setDisabled(false);

		if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_first_enabled');
			Ext.getCmp('firstpage').addCls('al_first_disabled');
		}
		if(Ext.getCmp('previouspage').hasCls("al_previous_enabled"))
		{
			Ext.getCmp('previouspage').removeCls('al_previous_enabled');
			Ext.getCmp('previouspage').addCls('al_previous_disabled');
		}
		if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
		{
			Ext.getCmp('nextpage').removeCls('al_next_disabled');
			Ext.getCmp('nextpage').addCls('al_next_enabled');
		}
		if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
		{
			Ext.getCmp('lastpage').removeCls('al_last_disabled');
			Ext.getCmp('lastpage').addCls('al_last_enabled');
		}
	}
	else if(buttonClicked=='previous')
	{
		currentPageNumber--;
		if((currentPageNumber-1)<1)
		{
			Ext.getCmp('firstpage').setDisabled(true);
			Ext.getCmp('previouspage').setDisabled(true);
			Ext.getCmp('nextpage').setDisabled(false);
			Ext.getCmp('lastpage').setDisabled(false);

			if(Ext.getCmp('firstpage').hasCls("al_first_enabled"))
			{
				Ext.getCmp('firstpage').removeCls('al_first_enabled');
				Ext.getCmp('firstpage').addCls('al_first_disabled');
			}
			if(Ext.getCmp('previouspage').hasCls("al_previous_enabled"))
			{
				Ext.getCmp('previouspage').removeCls('al_previous_enabled');
				Ext.getCmp('previouspage').addCls('al_previous_disabled');
			}
			if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
			{
				Ext.getCmp('nextpage').removeCls('al_next_disabled');
				Ext.getCmp('nextpage').addCls('al_next_enabled');
			}
			if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
			{
				Ext.getCmp('lastpage').removeCls('al_last_disabled');
				Ext.getCmp('lastpage').addCls('al_last_enabled');
			}
		}
		else
		{
			Ext.getCmp('nextpage').setDisabled(false);
			Ext.getCmp('lastpage').setDisabled(false);
			if(Ext.getCmp('nextpage').hasCls("al_next_disabled"))
			{
				Ext.getCmp('nextpage').removeCls('al_next_disabled');
				Ext.getCmp('nextpage').addCls('al_next_enabled');
			}
			if(Ext.getCmp('lastpage').hasCls("al_last_disabled"))
			{
				Ext.getCmp('lastpage').removeCls('al_last_disabled');
				Ext.getCmp('lastpage').addCls('al_last_enabled');
			}
		}
	}
	else if(buttonClicked=='next')
	{
		currentPageNumber++;
		if((currentPageNumber+1)>total_pages)
		{
			Ext.getCmp('firstpage').setDisabled(false);
			Ext.getCmp('previouspage').setDisabled(false);
			Ext.getCmp('nextpage').setDisabled(true);
			Ext.getCmp('lastpage').setDisabled(true);

			if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
			{
				Ext.getCmp('firstpage').removeCls('al_first_disabled');
				Ext.getCmp('firstpage').addCls('al_first_enabled');
			}
			if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
			{
				Ext.getCmp('previouspage').removeCls('al_previous_disabled');
				Ext.getCmp('previouspage').addCls('al_previous_enabled');
			}
			if(Ext.getCmp('nextpage').hasCls("al_next_enabled"))
			{
				Ext.getCmp('nextpage').removeCls('al_next_enabled');
				Ext.getCmp('nextpage').addCls('al_next_disabled');
			}
			if(Ext.getCmp('lastpage').hasCls("al_last_enabled"))
			{
				Ext.getCmp('lastpage').removeCls('al_last_enabled');
				Ext.getCmp('lastpage').addCls('al_last_disabled');
			}
		}
		else
		{
			Ext.getCmp('firstpage').setDisabled(false);
			Ext.getCmp('previouspage').setDisabled(false);

			if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
			{
				Ext.getCmp('firstpage').removeCls('al_first_disabled');
				Ext.getCmp('firstpage').addCls('al_first_enabled');
			}
			if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
			{
				Ext.getCmp('previouspage').removeCls('al_previous_disabled');
				Ext.getCmp('previouspage').addCls('al_previous_enabled');
			}
		}
	}
	else if(buttonClicked=='last')
	{
		currentPageNumber = total_pages;
		Ext.getCmp('firstpage').setDisabled(false);
		Ext.getCmp('previouspage').setDisabled(false);
		Ext.getCmp('nextpage').setDisabled(true);
		Ext.getCmp('lastpage').setDisabled(true);

		if(Ext.getCmp('firstpage').hasCls("al_first_disabled"))
		{
			Ext.getCmp('firstpage').removeCls('al_first_disabled');
			Ext.getCmp('firstpage').addCls('al_first_enabled');
		}
		if(Ext.getCmp('previouspage').hasCls("al_previous_disabled"))
		{
			Ext.getCmp('previouspage').removeCls('al_previous_disabled');
			Ext.getCmp('previouspage').addCls('al_previous_enabled');
		}
		if(Ext.getCmp('nextpage').hasCls("al_next_enabled"))
		{
			Ext.getCmp('nextpage').removeCls('al_next_enabled');
			Ext.getCmp('nextpage').addCls('al_next_disabled');
		}
		if(Ext.getCmp('lastpage').hasCls("al_last_enabled"))
		{
			Ext.getCmp('lastpage').removeCls('al_last_enabled');
			Ext.getCmp('lastpage').addCls('al_last_disabled');
		}
	}
	previousPageNumber = currentPageNumber;
	Ext.getCmp('pagenumber').setValue(currentPageNumber);
	var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
	myMask.show();
	Ext.getCmp("showbutton").setDisabled(true);
	Ext.Ajax.request({
		url : '/final/admin/Auditlog/data/auditlogInfo.jsp?submitted=true&rowsperpage=15&pageNo='+currentPageNumber,
		method: 'POST',
		async: true,
		success: function(response)
		{
			Ext.getCmp("auditlog_data_component").update(response.responseText);
			showAuditlogReportPanel();
			myMask.hide();
			Ext.getCmp("showbutton").setDisabled(false);
		},
		failure : function(response)
		{
			Ext.MessageBox.alert(pageTitle,information);
			myMask.hide();
			Ext.getCmp("showbutton").setDisabled(false);
		}
	});
}


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}