Ext.define('Auditlog.view.FormItems', {
	extend:'utilities.innerScrollContainer',
	alias:'widget.auditlog_widget',
	id: 'formitems',
	cls:'outerpanel',
	title: pageTitle,
	margin: '8 8 0 8',

	scroll: false,
	autoScroll: true,

	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' ',
	},

	requires: [
		'Ext.ux.form.MultiSelectSI',
		'utilities.ScrollCombo',
		'utilities.DatePicker'
	],

	tools: [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPdf',
					id: 'save',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Save'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPrinter',
					id: 'print',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Print'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'csvTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconCsv',
					id: 'csv',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'CSV'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'scheduleTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconSchedule',
					id: 'schedule',
					disabled : true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Schedule this Report'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype:'button',
			id : 'backButton',
			text: 'Back',
			cls:'backbutton',
			iconCls:'iconBack',
			hidden:true
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDescc+'.</center>'
			}
		]
	}],

	items: [
	{
		xtype:'container',
		cls:'formOuter',
		layout: {
				type:'hbox',
				pack:'center'
			},
		padding:'5 0 10 0',
		margin: '10 10 0 10',
		items:[
	{
			xtype:'container',
			id:'timeline_container',
			
			layout: {
				type:'hbox',
				pack:'center'
			},
			defaults: {
				labelAlign: "top",
				margin: "15 0 10 0",
				labelSeparator: "",
				editable: false
			},
			//margin: '15 0 10 0',
			hidden: true,
			items: [
				{
					xtype: 'scrollcombo',
					fieldLabel: 'Timeline',
					width: 80,
					margin: '10 0 0 5',
					cls: "dropdown",
					defaultListConfig: {
					loadingHeight: 70,
					minWidth: 80,
					maxHeight: 300,
					shadow: "sides"
					},
					name: 'timeline',
					id:"timeline",
					editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				},
				{
					xtype: 'datepicker',
					cls: 'datepicker',
					name:'eg_stdate',
					id:'eg_stdate',
					fieldLabel: 'Start Date',
					format: mgrDateFormat,
					disabled: true,
					editable:false,
					//width:150,
					margin: '10 0 0 5',
				},
				{
					xtype: 'scrollcombo',
					defaultListConfig: {
					loadingHeight: 70,
					minWidth: 50,
					maxHeight: 300,
					shadow: "sides"
					},
					fieldLabel: 'Hr',
					//cls: 'dropdown',
					id: 'starthr',
					name: 'starthr',
					store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					disabled: true,
					editable : false,
					dataArray: null,
					width:50,
					margin: '10 0 0 5',
				},
				{
					xtype: 'scrollcombo',
						defaultListConfig: {
						loadingHeight: 70,
						minWidth: 50,
						maxHeight: 300,
						shadow: 'sides'
					},
					fieldLabel: 'Min',
					//cls: 'dropdown',
					id: 'startmin',
					name: 'startmin',
					store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49','50','51','52','53','54','55','56','57','58','59'],
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					disabled: true,
					editable : false,
					dataArray: null,
					width:50,
					margin: '10 10 0 5',
				},
				{
					xtype: 'datepicker',
					cls: 'datepicker',
					name:'eg_enddate',
					id:'eg_enddate',
					fieldLabel: 'End Date',
					format: mgrDateFormat ,
					disabled: true,
					editable:false,
					//width:150,
					margin: '10 0 0 5',
				},
				{
					xtype: 'scrollcombo',
						defaultListConfig: {
						loadingHeight: 70,
						minWidth: 50,
						maxHeight: 300,
						shadow: 'sides'
					},
					fieldLabel: 'Hr',
					//cls: 'dropdown',
					id: 'endhr',
					name: 'endhr',
					store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					disabled: true,
					editable : false,
					dataArray: null,
					width:50,
					margin: '10 0 0 5',
				},
				{
					xtype: 'scrollcombo',
						defaultListConfig: {
						loadingHeight: 70,
						minWidth: 50,
						maxHeight: 300,
						shadow: 'sides'
					},
					fieldLabel: 'Min',
					//cls: 'dropdown',
					id: 'endmin',
					name: 'endmin',
					store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49','50','51','52','53','54','55','56','57','58','59'],
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					disabled: true,
					editable : false,
					dataArray: null,
					width:50,
					margin: '10 0 0 5',
				},
				{
					xtype: 'component',
					html: '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconGo" valign="middle" style="cursor:pointer">',
					id:'icon_go',
					hidden:true,
					listeners: {
						el: {
							click: function() {
								if(Ext.getCmp("timeline").getValue()=="Any") {
									findUsers();
								}
							}
						},
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:loadTipData
							});
						}
					},
					margin: '31 0 0 5'
				}
			]
		},
		{
			xtype:'container',
			id:'user_cluster_interface_container',
			layout: {
				type:'hbox',
				pack:'center'
			},
			defaults: {
				labelSeparator: ' ',
				labelAlign: "top",
			},
			margin: '10 0 10 5',
			hidden: true,
			items: [
				{
					xtype: 'scrollcombo',
					fieldLabel: 'User',
					name: 'users',
					id:"users",
					width:100,
					editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					defaultListConfig: {
						minWidth: 250,
						maxHeight: 300
					}
				},
				{
					xtype: 'scrollcombo',
					fieldLabel: 'Manager',
					name: 'clusterManager',
					id:"clusterManager",
					width: 100,
					editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					margin: '0 0 0 10'
				},
				{
					xtype: 'scrollcombo',
					fieldLabel: 'Interface',
					name: 'filterBy',
					id:"filterBy",
					width: 100,
					editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					margin: '0 0 0 10',
					defaultListConfig: {
						minWidth: 130,
						maxHeight: 300
					}
				}
			]
		}]
	}	,
		{
			xtype:'container',
			id:'hostip_module_activity_container',
			layout: {
				type:'hbox',
				pack:'center'
			},
			hidden:true,
			margin: '15 0 10 0',
			items: [
				{
					xtype: 'container',
					items: [
						{
							xtype: 'label',
							id: 'hostLabel',
							html: hostIpsLabel,
							style : {'font-weight':'bold'}
						},
						{
							xtype: 'multiselectSi',
							margin : '6 0 0 0',
							id : 'hostip',
							cls:"multiselect",
							name: 'hostip',
							allowBlank:false,
							displayField: 'displayField',
							valueField: 'valueField',
							height: 150,
							width: 300,
							//title: 'Host IPs',
							listeners: {
								el: {
									click: function() {
										populate('hostip','onchange');
									}
								}
							},
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						}
					]
				},
				{
					xtype: 'container',
					items: [
						{
							xtype: 'label',
							id: 'moduleLabel',
							margin: '0 0 0 20',
							html: modulesLabel,
							style : {'font-weight':'bold'}
						},
						{
							xtype: 'multiselectSi',
							cls:"multiselect",
							id : 'module',
							name: 'module',
							allowBlank:false,
							displayField: 'displayField',
							valueField: 'valueField',
							height: 150,
							width: 300,
							//title: 'Modules',
							listeners: {
								el: {
									click: function() {
										populate('module','onchange');
									}
								}
							},
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							margin: '6 0 0 20'
						},
					]
				},
				{
					xtype: 'container',
					items: [
						{
							xtype: 'label',
							id: 'activityLabel',
							margin: '0 0 0 20',
							html: activitiesLabel,
							style : {'font-weight':'bold'}
						},
						{
							xtype: 'multiselectSi',
							cls:"multiselect",
							id : 'activity',
							name: 'activity',
							allowBlank:false,
							displayField: 'displayField',
							valueField: 'valueField',
							height: 150,
							width: 300,
							//title: 'Activities',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							margin: '6 0 0 20'
						}
					]
				}
			]
		},
		{
			xtype:'container',
			id:'showbutton_container',
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin:'10 0 20 0',
			hidden:true,
			items: [
				{
					xtype: 'button',
					text: 'Show',
					name: 'showbutton',
					id:'showbutton',
					cls:'button20',
					width: 80,
					handler: function() {
						sub();
					}
				}
			]
		},
		{
			xtype:'container',
			id:'user_hostip_session_period',
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin: '15 10 10 10',
			hidden:true,
			items: [
				{
					xtype:'container',
					layout:'column',
					width: 900,
					items: [
						{
							xtype: 'displayfield',
							name: 'userid_df',
							id: 'userid_df',
							fieldLabel: 'User ID',
							value:sessionUsername,
							columnWidth:0.25
						},
						{
							xtype: 'displayfield',
							fieldLabel: 'Host IP',
							name: 'hostip_df',
							id: 'hostip_df',
							value:sessionHostIp,
							columnWidth:0.25,
							margin: '0 0 0 20'
						},
						{
							xtype: 'displayfield',
							fieldLabel: 'Session Period',
							name: 'session_period_df',
							id: 'session_period_df',
							value:sessionDetails,
							columnWidth:0.50,
							margin: '0 0 0 20'
						}
					]
				}
			]
		},
		{
			xtype:'container',
			id:'total_records_container',
			border:true,
			layout: {
				type:'hbox',
				pack:'left'
			},
			cls:'table_autitborder table_autitborderbottom',
			margin:'0 10 0 10',
			hidden:true,
			items: [
				{
					xtype: 'label',
					margin:'5 10 5 10',
					name: 'total_records_label',
					cls : 'font_bold11',
					id: 'total_records_label',
					text:''
				}
			]
		},
		{
			xtype: 'panel',
			name:'auditlog_data_panel',
			id:'auditlog_data_panel',
			border:true,
			margin: '0 10 10 10',
			cls:'table_autitborderbottom',
			hidden:true,
			tbar: [
				{
					xtype:'button',
					id:'firstpage',
					name:'firstpage',
					tooltip:'First Page',
					disabled:true,
					width:20,
					handler: function()
					{
						pagination('first');
					},
					cls:'al_first_disabled'
				},
				{
					xtype:'button',
					id:'previouspage',
					name:'previouspage',
					tooltip:'Previous Page',
					disabled:true,
					width:20,
					handler: function()
					{
						pagination('previous');
					},
					cls:'al_previous_disabled'
				},
				{
					xtype: 'textfield',
					fieldLabel: pageLabel,
					labelAlign: 'left',
					cls:'textbox',
					value:1,
					width: 80,
					labelWidth:40,
					name: 'pagenumber',
					id:"pagenumber",
					allowBlank: false,
					enforceMaxLength: true,
					minLength: '1',
					maxLength: '4',
					maskRe: /[0-9]/,
					listeners: {
						specialkey: function (f,e) {
							if(e.getKey() == e.ENTER) {
								gotoPage(f.getValue());
							}
						}
					},
					margin: '0 0 0 5'
				},
				{
					xtype: 'label',
					id: 'of_label',
					text:"of 1"
				},
				{
					xtype:'button',
					id:'nextpage',
					name:'nextpage',
					tooltip:'Next Page',
					disabled:true,
					width:20,
					handler: function()
					{
						pagination('next');
					},
					cls:'al_next_disabled',
					margin: '0 0 0 10'
				},
				{
					xtype:'button',
					id:'lastpage',
					name:'lastpage',
					tooltip:'Last Page',
					disabled:true,
					width:20,
					handler: function()
					{
						pagination('last');
					},
					cls:'al_last_disabled'
				}
			],
			items: [
				{
					xtype: 'component',
					id:'auditlog_data_component',
					html: "-",
					margin: '0 5 5 5'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			id: 'user_session_data_not_found',
			hidden: true,
			//margin: 15,
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+no_data_found+'.</td></tr></table></td></tr></table>',
				}
			]
		}
	]

});



