Ext.define('AutoTopology.controller.ConfigSegmentControl',{
	extend:'Ext.app.Controller',
	views:['ComponentSegment'],
	refs:[
		{selector:'componentsegment', ref:'componentsegment'},
	],
	init:function(){
		//this.buildFieldData()

		this.control({
			'ComponentSegment':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(mode,segmentName){
		Ext.Ajax.request({
			url: 'AutoTopology/data/ComponentPropertiesJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segmentName)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(segmentName){
		var me=this;
		var executiveForm = this.getComponentsegment().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (segmentName == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'segmentNameCombo', publicJSON['ExistingSegmentNames'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'segmentNameCombo', publicJSON['ExistingSegmentNames'],segmentName);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(mode,segmentName,zoneName)
	{
		Ext.getCmp('manageall').disable();
		Ext.getCmp('savetopo').disable();
		Ext.getCmp('clearall').disable();
		var newsegment='';
		var myzonename=zoneName;
		if(zoneName==null || zoneName=='null' || zoneName=='')
		{
			myzonename='-1';
		}
		if(mode=='modify')
		{
			
			newsegment=false;
			this.initializeFields(segmentName);
		}
		else if(mode=="add")
		{
			newsegment=true;
		}
		var zoneAssociation = publicJSON['AssociatedToZone'];
		var thisSegment='';
		thisSegment = segmentName;
		var adminTopoUrl = 'AutoTopology/data/ComponentTypeNameJson.jsp?mode='+mode+'&zone='+encodeURIComponent(myzonename)+'&segment='+encodeURIComponent(thisSegment)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl; //+'&showIndOnlyParam=true'+'&newsegment='+newsegment,
		//if(mode=='modify')
			//adminTopoUrl = adminTopoUrl+"&fromPage=modifySegment";
		Ext.Ajax.request({
		url: 'AutoTopology/data/ComponentTypeNameJson.jsp?mode='+mode+'&zone='+encodeURIComponent(myzonename)+'&segment='+encodeURIComponent(thisSegment)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl, //+'&showIndOnlyParam=true'+'&newsegment='+newsegment,
		//url:adminTopoUrl,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
			Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
			Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
			Ext.getCmp('compTypeCombo').getStore().resumeEvents();
			Ext.getCmp('compTypeCombo').setValue('-1');
			Ext.getCmp("componentsList").getStore().suspendEvents(true);
			Ext.getCmp("componentsList").getStore().clearFilter(true);
			Ext.getCmp("componentsList").getStore().loadRawData(publicJSON["ComponentList"]);
			Ext.getCmp("componentsList").getStore().resumeEvents();
			Ext.getCmp("componentsList").setValue("-1");
		}
		});
		//thisSegment='';
		//if(thisSegment=='aa')
		{
			var segmentName=Ext.getCmp('segmentName').getValue();
			//var urlToSend = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+thisSegment+'&zone='+myzonename+''+"&action=show";
			var urlToSend = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(thisSegment)+'&zone='+encodeURIComponent(myzonename)+''+"&action=show";
		
			Ext.Ajax.request({
				url: urlToSend,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 )
					{
						var topologyUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURIComponent(thisSegment)+"&zone="+encodeURIComponent(myzonename)+"&zoom=100";
						//topologyUrl = topologyUrl + "&comptype="+componentType + "&compname="+compname;
						Ext.getCmp('topologyPanel').setVisible(true);
						Ext.getCmp('topologyFrame').setVisible(true);
						Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%" ></iframe>');
						Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
						$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass("serviceOthersSmall");
						Ext.getCmp('imagecombo').setValue("serviceOthersSmall");
					}
				}
			});
		}
	}
});



