Ext.define('AutoTopology.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ComponentSegments','ComponentSegment','RenameSegment','ManageSaveView','TopologySettings','ManagedComponents','UsesConnectsWindow','RenameSegment','RenameGroup','CreateGroupWindow','GroupDetails','Mywindow'],
	requires : ['AutoTopology.view.RenameSegment','AutoTopology.view.Mywindow','AutoTopology.view.RenameGroup'],
	refs:[
		{selector:'componentsegments', ref:'componentsegments'},
		{selector:'componentsegment', ref:'componentsegment'},
		{selector:'renamesegment', ref:'renamesegment'},
		{selector:'renamegroup', ref:'renamegroup'},
		{selector:'topologysettings', ref:'topologysettings'},
		{selector:'managesaveview', ref:'managesaveview'},
		{selector:'managedcomponents', ref:'managedcomponents'},
		{selector:'usesConnects', ref:'usesConnects'},
		{selector:'renamesegment', ref:'renamesegment'},
		{selector:'creategroup', ref:'creategroup'},
		{selector:'groupdetails', ref:'groupdetails'},
		{selector:'mypopwindow', ref:'mypopwindow'}
	],

	init:function(){
		appCnt = this;
		var myHref='';
		this.buildFieldData()

		this.control({
			'componentsegments':
			{
				'afterrender': this.afterMainRender
			},
			'componentsegments grid[id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'componentsegments trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
//			'componentsegments button[id="addSegment"]': {
//				'click': this.addSegment
//			},
			'componentsegments button[id="autoTopPreview"]': {
				'click': this.autoTopologyPreview
			},
			'componentsegment textfield[id="segmentName"]':
			{
				'blur': this.validateName
			},
			'componentsegment combo[id="segmentNameCombo"]':
			{
				'select': this.comboLoad
			},
			'componentsegment combo[id="compTypeCombo"]':
			{
				'select': this.compTypeLoad
			},
			'renamegroup button[id="renameGrpbtn"]':
			{
				'click': this.renameBtnClick
			},
			'componentsegment combo[id="componentsList"]':
			{
				'select': this.multiselectLoad
			},
			'componentsegment button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'componentsegment button[id="deleteBtn"]':
			{
				'click': this.deleteSegment
			},
			'componentsegment button[id="clearall"]':
			{
				'click': this.clearAllFunction
			},
			'componentsegment button[id="manageall"]':
			{
				'click': this.openManageAll
			},
			'componentsegment button[id="savetopo"]':
			{
				'click': this.openSaveTopology
			},
			'groupdetails button[id="addBtn"]': 
			{
				'click': this.manageGrpComponent
			},
			'groupdetails button[id="removeBtn"]': 
			{
				'click': this.removeGrpComponent
			},
			'managesaveview button[id="saveBtn"]':
			{
				'click': this.saveTopology
			},
			'managesaveview button[id="cancelBtn"]':
			{
				'click': this.closeManageDiv
			},
			'topologysettings button[id="UpdateSettings"]':
			{
				'click': this.updateSettings
			},
			'managesaveview button[id="addManage"]':
			{
				'click': this.manageComponents
			},
			'managesaveview button[id="addManageGrpbtn"]':
			{
				'click': this.manageGroups
			},
			'managedcomponents button[id="close"]':
			{
				'click': this.closeManageDiv
			},
			'usesConnects combo[id="typeOfComp"]':
			{
				'select': this.LoadComponentTypeMain
			},
			'usesConnects combo[id="startcompTypeCombo"]':
			{
				'select': this.LoadComponentTypeMain
			},
			'usesConnects button[id="UpdateTopo"]':
			{
				'click': this.LoadComponentTypeMain
			},
			'renamesegment button[id="renameBTN"]':
			{
				'click': this.renameSegment
			},
			'creategroup radiogroup[id="groupType"]':
			{
				'change': this.groupTypeChange
			},
			'creategroup combo[id="GrpcompTypeCombo"]':
			{
				'select': this.ComponentLoadForGroup
			},
			'creategroup [id="unManageGridDisplay"]': {
				'itemmouseenter': this.showActions,
				'itemmouseleave': this.hideActions
			},
			'creategroup button[id="assign"]':
			{
				'click': this.AssignAddMore
			},
			'creategroup button[id="finish"]':
			{
				'click': this.AssignAddMore
			},
			'creategroup button[id="AddManageBtn"]':
			{
				'click': this.addManageCompFromGroup
			},
			'creategroup combo[id="groupCombo"]':
			{
				'change': this.ComponentLoadForGroup
			},
			'componentsegment button[id="iconMaximize"]':
			{
				'click': this.iconMaximize
			},
			'componentsegment button[id="iconAutofit"]':
			{
				'click': this.autoFit
			}
		});
	},
	autoFit: function()
	{
		window.frames[0].autoFit();
	},
	iconMaximize: function()
	{
		window.frames[0].openBigDiv();
	},
	gridCreate: function(fwdURL,topologyName) {
		var me = this;
		Ext.Ajax.request(
		{
			url: fwdURL,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var resText = response.responseText;
					var jsonText = '';
					var status = '';
					if(resText.indexOf('^%^')>0 && resText.indexOf('%&%')>0)
					{
						jsonText = resText.substring(0,resText.indexOf('^%^'));
						status = resText.substring(resText.indexOf('^%^')+3,resText.indexOf('%&%')).trim();
						urlDatas = resText.substring(resText.indexOf('%&%')+3).trim();
						publicJSON = Ext.decode( jsonText );
						var NoCompPresent = publicJSON['NoComponents'];
						var grpData = publicJSON['windowGrpGridDatas'];
						var compData = publicJSON['windowGridDatas'];
						var isNewCompExists = publicJSON['isNewCompExists'];
						var isManageCompExists = publicJSON['isManageExists'];
						var isComplete = publicJSON['isComplete'];
						var segLimitExceed = publicJSON['segLimitExceed'];
						if(segLimitExceed == true)
						{
							publicJSON.segLimitExceed = true;
						}
						if(!isManageCompExists)
						{
							me.topologyMsgWindow();
							Ext.getCmp('NoComponentPresentVal').show();
						}
						else if(isManageCompExists)
						{
							me.topologyWindow(fwdURL,topologyName,publicJSON.resultTD,publicJSON.segLimitExceed, publicJSON.isDouble);
							var resultWindowGridobj = Ext.getCmp('resultWindowGrid').getStore();
							resultWindowGridobj.suspendEvents(true);
							resultWindowGridobj.loadRawData(publicJSON['windowGridDatas']);
							resultWindowGridobj.resumeEvents();
							if(compData == "")
							{
								Ext.getCmp('resultWindowGrid').hide();
								Ext.getCmp('compAddbtn').hide();
								
							}
							if(publicJSON['ManagedGroupGrid'].length > 0)
							{
								Ext.getCmp('resultWindowGridGroup').show();
								var resultWindowGridGroupobj = Ext.getCmp('resultWindowGridGroup').getStore();
								resultWindowGridGroupobj.suspendEvents(true);
								resultWindowGridGroupobj.loadRawData(publicJSON['ManagedGroupGrid']);
								resultWindowGridGroupobj.resumeEvents();
							}
							Ext.getCmp('resultGroupWindowGrid').hide();
							Ext.getCmp('grpAddbtn').hide();
						}
						if(publicJSON['windowGrpGridDatas'].length > 0)
						{
							Ext.getCmp('resultWindowGrid').hide();
							Ext.getCmp('resultWindowGridGroup').hide();
							Ext.getCmp('compAddbtn').hide();
							Ext.getCmp('resultGroupWindowGrid').show();
							Ext.getCmp('grpAddbtn').show();
							var resultGrpWindowGridobj = Ext.getCmp('resultGroupWindowGrid').getStore();
							resultGrpWindowGridobj.suspendEvents(true);
							resultGrpWindowGridobj.loadRawData(publicJSON['windowGrpGridDatas']);
							resultGrpWindowGridobj.resumeEvents();
						}
					}
				}
			}
		});
	},
	topologyMsgWindow : function()
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			title: 'Save Topology as',
			height: 350,
			width: 750,
			id: 'addOrManageMsg',
			padding:'5 10 10 10',
			autoScroll: true,
			modal : true,
			closeAction: 'destroy',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				'afterrender': function()
				{
					this.doLayout();
				}
			},
			items: [{
					xtype: 'container',
					id: 'NoComponentPresentVal',
					hidden:true,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'label',
							html: '<table><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noCompMsg+'.</td></tr></table></td></tr></table>'
						}
					]
				},
			]
		}).show();
	},
	topologyWindow : function(fwdURL,topologyName,messageText,segLimitExceed,isDouble)
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			title: 'Save Topology as',
			height: 390,
			//width: 790,
			id: 'addOrManage',
			//padding:'5 10 10 10',
			autoScroll: true,
			modal : true,
			closeAction: 'destroy',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				'afterrender': function()
				{
					this.doLayout();
				}
			},
			dockedItems:[
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 0 5 0',
					items: [
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							id: 'compAddbtn',
							width: 80,
							text : 'Save',
							handler: function() {
								var win = Ext.WindowManager.getActive();
								if (win) {
									win.close();
								}
								me.segmentWindow(topologyName, publicJSON.segLimitExceed, publicJSON.isDouble);
							}
						},
						{
							xtype: 'button',
							cls:'quickMenuWhiteButton',
							text : lblAddManage,
							id : "grpAddbtn",
							width: 100,
							//margin : '20 0 20 325',
							handler: function() {
								var selTopology = Ext.getCmp('resultGroupWindowGrid').getSelectionModel().getSelection();
								var values='';
								var array=new Array();
								var selectedGroups="";
								var selectedList=[];
								var action = 'multigroupSelect';
								var store = Ext.getCmp('resultGroupWindowGrid').getStore();
								var selModel = Ext.getCmp('resultGroupWindowGrid').getSelectionModel();
								store.each(function(rec)
								{
									var groupname = rec.get('groupname');
									if(!groupname.endsWith(":NULL"))
									{
										groupname = groupname+":NULL";
									}
									var isSelected = selModel.isSelected(rec);
									if(isSelected)
									{
										selectedList.push(groupname);
									}
								});
								if(selTopology.length == 0)
								{
									Ext.Msg.alert(pageTitle,"Please select a group to manage");
								}
								else
								{
									var param = '';
									var gridCount =Ext.getCmp('resultGroupWindowGrid').getStore().getCount();
									var selCount =Ext.getCmp('resultGroupWindowGrid').getSelectionModel().getSelection().length;
									var url ="AutoTopology/data/EgAutoTopologyMainPageJSON.jsp?action="+encodeURI(action)+'&segment='+encodeURI(topologyName)+'&grplist='+encodeURI(selectedList);
									if(gridCount == selCount)
									{
										param = 'segment='+encodeURIComponent(topologyName)+'&grplist='+encodeURIComponent(selectedList)+'&action='+encodeURI(action)+"&chkAll=true";//'&saveFrom=previewPage'+
									}
									else
									{
										param = 'segment='+encodeURIComponent(topologyName)+'&grplist='+encodeURIComponent(selectedList)+'&action='+encodeURI(action);//'&saveFrom=previewPage'+
									}
									Ext.Ajax.request(
										{
											url: 'AutoTopology/data/EgAutoTopologyMainPageJSON.jsp',
											method:'POST',
											params: param,
											success: function(response)
											{
												if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
												{
													var jsonText = response.responseText;
													publicJSON = Ext.decode( jsonText );
													Ext.getCmp('addOrManage').removeAll();
													var isShow = true;
													//if (publicJSON.showSaveTopology == true)
													//{
													//	isShow = false;
													//}
													//var errorMsg = publicJSON['err_msg'];
													var status = publicJSON['status'];
													var grpStatus = publicJSON['grpStatus'];
													var win = Ext.WindowManager.getActive();
													if (win) {
														win.close();
													}
													var grpStatusMsg = publicJSON['grpStatusMsg'];
													var filePath = publicJSON['filePath'];
													if(status != 'eG_CLI_0030')
													{
														Ext.Msg.show({
															title: pageTitle,
															msg: compErrMsg1 + "<br>" + compErrMsg2 + "<br>" +filePath,
															buttons: Ext.Msg.OK,
															icon: "iconExclamation"
														});
													}
													else if(grpStatus !="eG_CLI_Res_0323")
													{
														Ext.Msg.show({
															title : pageTitle,
															msg : grpStatusMsg,
															buttons : Ext.Msg.OK,
															icon : 'iconExclamation'
														});
													}
													else
													{
														Ext.create('Ext.window.Window',(
														{
															title: 'Save Topology as',
															height: 350,
															width: 750,
															id: 'addOrManageGrpbtn',
															padding:'5 10 10 10',
															autoScroll: true,
															modal : true,
															closeAction: 'destroy',
															doClose: function() {
																this.destroy();
															},
															xtype:'container',
															layout: {
																type: 'vbox',
																align: 'center'
															},
															items: [
																{
																	xtype: 'component',
																	margin: '10 0 0 0',
																	html: '<table><tr><td align="center"><img src="/final/admin/eg_images/info2.gif"></td><td align="center"><font size="2">&nbsp;&nbsp;'+lblInfoGrpManage+'</font></td></tr></table>'
																},
																{
																	xtype: 'grid',
																	cls:'gridSkin',
																	id: 'showGrpManagedGrid',
																	margin : '20 0 0 0',
																	resizable: false,
																	width: 600,
																	store:Ext.create('Ext.data.Store',{
																		fields:['groupname'],
																		data:[]
																	}),
																	columns: [
																		{
																			header: '<center>'+lblGrpName.toUpperCase()+'</center>', 
																			style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
																			dataIndex: 'groupname',
																			sortableColumns: false,
																			sortable:false,
																			draggable : false,
																			menuDisabled : true,
																			flex:1
																			//width: 300
																		}
																	]
																},
																{
																	xtype: 'container',
																	layout: {
																		type: 'vbox',
																		align: 'center'
																	},
																	margin: '20 0 0 0',
																	items: [
																		{
																			xtype: 'button',
																			cls:'button20',
																			text: lblOk,
																			width: 75,
																			handler: function() {
																				Ext.getCmp('addOrManageGrpbtn').destroy();
																			}
																		},
																	/*{
																			xtype: 'button',
																			cls:'button20',
																			text: lblSaveTopology,
																			width: 100,
																			hidden: isShow,
																			margin: '10 0 0 0',
																			handler: function() {
																				me.segmentWindow(topologyName, segLimitExceed, isDouble);
																				Ext.getCmp('addOrManageGrpbtn').destroy();
																			}
																		}*/
																	]
																}
															]
														})).show();
														var showManagedGridobj = Ext.getCmp('showGrpManagedGrid').getStore();
														showManagedGridobj.suspendEvents(true);
														showManagedGridobj.loadRawData(publicJSON['managedGrpArr']);
														showManagedGridobj.resumeEvents();
													}
												}
											}
										}
									);
								}
							}
						},
					]
				}
			],
			items: [
				{
					xtype: 'component',
					margin: 10,
					html: '<table><tr><td align="center"><div class="iconSuccess"></div></td><td align="center"><font size="2"><b>&nbsp;&nbsp;'+messageText+'</b></font></td></tr></table>'
				},
				{
					xtype: 'grid',
					cls:'gridSkin',
					margin: 10,
					flex:1,
					id: 'resultWindowGridGroup',
					hidden:true,
					store:new Ext.data.Store(
					{
						fields: ['groupname'],
						 data:[]
					}),
					autoScroll: true,
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: "Group",
								dataIndex: 'groupname',
								id: 'SegmentGroupnameShow',
								flex : 1
							}
						]
					}
				},
				{
					xtype: 'grid',
					id:'resultWindowGrid',
					cls:'gridSkin',
					margin: 10,
					//width: 650,
					//height: 250,
					flex:1,
					resizable: false,
					columnLines: true,
					autoScroll: true,
					scrollable: true,
					/*selModel :new Ext.selection.CheckboxModel(
					{
						checkOnly: true,
						width:50,
						injectCheckbox: 'first',
					}),*/
					store:Ext.create('Ext.data.Store',{
						fields:['hostnick', 'port', 'componentType', 'componentTypeDisp'],
						data:[]
					}),
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							scrollable: true,
						},
					items:[
						{
							header: '<center>'+lblNick.toUpperCase()+'</center>', 
							style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
							dataIndex: 'hostnick',
							sortableColumns: false,
							sortable:false,
							draggable : false,
							menuDisabled : true,
							flex: 1
						},
						{
							header: '<center>'+lblPort.toUpperCase()+'</center>', 
							style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
							dataIndex: 'port',
							flex: 1,
							sortable:false,
							draggable : false,
							menuDisabled : true
						},
						{
							header: '<center>'+lblComponentType.toUpperCase()+'</center>',
							style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
							dataIndex: 'componentType',
							sortable:false,
							draggable : false,
							hidden: true,
							menuDisabled : true,
							flex: 1
						},
						{
							header: '<center>'+lblComponentType.toUpperCase()+'</center>',
							style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
							dataIndex: 'componentTypeDisp',
							sortable:false,
							draggable : false,
							menuDisabled : true,
							flex: 1
						}
					]
					}
				},
				{
					xtype: 'grid',
					id:'resultGroupWindowGrid',
					cls:'gridSkin',
					margin: 10,
					//flex:1,
					width: 650,
					resizable: false,
					columnLines: true,
					selModel :new Ext.selection.CheckboxModel(
					{
						checkOnly: true,
						width:50,
						injectCheckbox: 'first',
					}),
					store:Ext.create('Ext.data.Store',{
						fields:['groupname'],
						data:[]
					}),
					columns:[
						{
							header: lblGrpName.toUpperCase(),
							style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'bold'},
							dataIndex: 'groupname',
							sortableColumns: false,
							sortable:false,
							draggable : false,
							menuDisabled : true,
							flex: 1
						}
					]
				},
			],
		}).show();
	},
	segmentWindow : function(topologyName, segLimitExceed, isDouble)
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			title: 'Save Topology as',
			id: 'segmentNameChange',
			height: 160,
			width: 450,
			padding:10,
			modal : true,
			autoScroll: true,
			listeners : {
				close : function()
				{
					Ext.Ajax.request({
					url:'AutoTopology/data/autoTopologyPreviewJson.jsp', 
					method:'POST'
					});
				}
			},
			items: [
				{
					xtype: 'container',
					layout: {
						type : 'vbox',
						align : 'center'
					},
					items: [
						{
							xtype: 'textfield',
							cls:'textbox',
							id: 'newSegmentName',
							labelSeparator : '',
							labelAlign:'top',
							fieldLabel: lblSegmentName,
							allowBlank: false,
							width: 375,
							margin: '20 0 0 0'
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'center'
							},
							margin: '20 0 0 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id: 'saveSegmentName',
									text : lblSave,
									action: 'submit',
									width: 80,
									handler: function()
									{
										var newName = Ext.getCmp('newSegmentName').getValue();
										var singleByteSupport=true;
										if(isDouble=='false')
										{
											singleByteSupport = validateSingleByte(newName);
										}
										if(newName == '' || newName == null)
										{
											Ext.Msg.alert(pageTitle, lblNoBlank);
											return false;
										}
										else if(segLimitExceed == true)
										{
											Ext.Msg.alert(pageTitle, lblSegmentsExceed);
											return false;
										}
										else if(!checkspace(newName))
										{
											return false;
										}
										else if(!checkspecial_(newName,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
										{
											return false;
										}
										else if(newName == 'independent_servers')
										{
											Ext.Msg.alert(pageTitle,lblIndepentServers);
											return false;
										}
										else if(!singleByteSupport)
										{
											Ext.Msg.alert(pageTitle, lblDoubleByte);
											return false;
										}
										else
										{
											var segment = topologyName;
											var action = 'save';
											var zone = urlDatas.substring(urlDatas.indexOf("*&*")+3);
											Ext.Ajax.request(
											{
												url: '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(segment)+"&action="+encodeURIComponent(action)+"&zone="+encodeURIComponent(zone)+"&newNameToSave="+encodeURIComponent(newName)+"&imageName=serviceOthersSmall",
												method:'POST',
												success: function(response)
												{
													if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
													{
														var jsonText = response.responseText;
														Ext.getCmp('segmentNameChange').destroy();
														Ext.Msg.show({
															title : pageTitle,
															msg : jsonText,
															buttons : Ext.Msg.OK,
															icon : 'iconInformation',
															fn : function(btn)
															{
																var win = Ext.WindowManager.getActive();
																if (win) {
																	win.close();
																}
															}
														});
														Ext.Ajax.request({
															url:'AutoTopology/data/autoTopologyPreviewJson.jsp', 
															method:'POST'
														});
													}
												}
											});
										}
									}
								},
								{
									xtype: 'button',
									cls:'button20',
									text: lblCancel,
									width: 80,
									margin: '0 0 0 20',
									handler: function() {
										Ext.getCmp('segmentNameChange').destroy();
										Ext.Ajax.request({
											url:'AutoTopology/data/autoTopologyPreviewJson.jsp', 
											method:'POST'
										});
									}
								}
							]
						}
					]
				}
			]
		}).show();
	},
	segmentSaveWindow : function(topologyName,segLimitExceed,isDouble,zone,imageName)
	{
		Ext.create('Ext.window.Window', {
			title: 'Save Topology as',
			id: 'segmentNameChange',
			height: 160,
			width: 450,
			padding:10,
			modal : true,
			autoScroll: true,
			
			items: [
				{
					xtype: 'container',
					layout: {
						type : 'vbox',
						align : 'center'
					},
					items: [
						{
							xtype: 'textfield',
							cls:'textbox',
							id: 'newSegmentName',
							labelSeparator : '',
							labelAlign:'top',
							fieldLabel: lblSegmentName,
							allowBlank: false,
							width: 375,
							margin: '20 0 0 0'
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'center'
							},
							margin: '20 0 0 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id: 'saveSegmentName',
									text : lblSave,
									action: 'submit',
									width: 80,
									handler: function()
									{
										var newName = Ext.getCmp('newSegmentName').getValue();
										var singleByteSupport=true;
										if(isDouble=='false')
										{
											singleByteSupport = validateSingleByte(newName);
										}
										if(newName == '' || newName == null)
										{
											Ext.Msg.alert(pageTitle, lblNoBlank);
											return false;
										}
										else if(segLimitExceed == true)
										{
											Ext.Msg.alert(pageTitle, lblSegmentsExceed);
											return false;
										}
										else if(!checkspace(newName))
										{
											return false;
										}
										else if(!checkspecial_(newName,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
										{
											return false;
										}
										else if(newName == 'independent_servers')
										{
											Ext.Msg.alert(pageTitle,lblIndepentServers);
											return false;
										}
										else if(!singleByteSupport)
										{
											Ext.Msg.alert(pageTitle, lblDoubleByte);
											return false;
										}
										else
										{
											var segment = topologyName;
											var action = 'save';
																					
											Ext.Ajax.request(
											{
												url: '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(segment)+"&action="+encodeURIComponent(action)+"&zone="+encodeURIComponent(zone)+"&newNameToSave="+encodeURIComponent(newName)+"&imageName="+imageName,
												method:'POST',
												success: function(response)
												{
													if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
													{
														var jsonText = response.responseText;
														Ext.getCmp('segmentNameChange').destroy();
														Ext.Msg.show({
															title : pageTitle,
															msg : jsonText,
															buttons : Ext.Msg.OK,
															icon : 'iconInformation'
														});
														
													}
												}
											});
										}
									}
								},
								{
									xtype: 'button',
									cls:'button20',
									text: lblCancel,
									width: 80,
									margin: '0 0 0 20',
									handler: function() {
										Ext.getCmp('segmentNameChange').destroy();
										
									}
								}
							]
						}
					]
				}
			]
		}).show();
	},
	clearAllFunction: function()
	{
		mode = publicJSON['mode'];
		var action='clearall';
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thiszone = frames[0].document.getElementById('zone').value; 
		var thissegment = frames[0].document.getElementById('segment').value; 
		var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(thissegment)+'&zone='+encodeURIComponent(thiszone);
		if(action == 'clearall'){
			url = url + "&action="+encodeURIComponent(action);
		}
		else{
			var comptitle =frames[0].document.getElementById('#h_title').value; 
			var compsrc = frames[0].document.getElementById('#h_src').value; 
			var thiscomptype = compsrc;
			var thiscompname = comptitle;
			if(comptitle.indexOf(":") < 0)
				thiscompname = thiscompname+":NULL";
			if (compsrc.indexOf(".gif")>0)
				thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
			else if (compsrc.indexOf(".png")>0)
				thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
			url = url + '&comptype='+encodeURIComponent(thiscomptype)+'&compname='+encodeURIComponent(thiscompname)+"&action="+encodeURIComponent(action);
		}
		var zoomValue = frames[0].document.getElementById('zoom').value;
		var enableDrag = 'false';
		var modify=publicJSON['modify'];
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200)
				{
					var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURIComponent(thissegment)+"&zone="+encodeURIComponent(thiszone)+"&zoom="+encodeURIComponent(zoomValue)+"&enableDrag="+encodeURIComponent(enableDrag)+"&modify="+encodeURIComponent(modify)+"&com.eg.CSRF_NONCE="+csrfToken;
					Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;overflow:auto;border:0px;" scrolling="no"></iframe>');
				}
			}
		});
		var segmentType = publicJSON['segmentType'];
		if(segmentType=='manual')
		{
			//myControllerObj.afterMainRender(publicJSON['mode'],thissegment,thiszone,"manual");
			getComboBoxDatas(mode,thissegment,thiszone,"manual");
		}
		else if(segmentType=='auto')
		{
			//myControllerObj.afterMainRender(publicJSON['mode'],thissegment,thiszone,"auto");
			getComboBoxDatas(mode,thissegment,thiszone,"auto");
		}
		Ext.getCmp('compTypeCombo').setValue('-1');
		Ext.getCmp('componentsList').reset();
		//loading start comp data begin
		Ext.Ajax.request({
		url: 'AutoTopology/data/ComponentTypeNameJson.jsp?mode='+mode+'&zone='+encodeURIComponent(thiszone)+'&segment='+encodeURIComponent(thissegment), 
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
			Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
			Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
			Ext.getCmp('compTypeCombo').getStore().resumeEvents();
			Ext.getCmp('compTypeCombo').setValue('-1');
		}
		});
		//end
	},
	LoadComponentTypeMain: function(combo)
	{
		var title = Ext.getCmp('usesConnects').title;
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thissegment = frames[0].document.getElementById("segment").value;
		var link = frames[0].document.getElementById('lorn').value;
		var thiszone =  "-1";
		var thissegment = frames[0].document.getElementById('segment').value; 
		var comptitle = frames[0].document.getElementById('h_title').value;
		var compsrc = frames[0].document.getElementById('h_src').value;
		var zoom = frames[0].document.getElementById('zoom').value;
		var frmcomptype = frames[0].document.getElementById('h_cmptype').value;
	
		var frmcompname=comptitle;

		if(comptitle.indexOf(":") < 0)
			frmcompname = comptitle+":NULL";
		//if (compsrc.indexOf(".gif")>0)
			//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
		//else if (compsrc.indexOf(".png")>0)
			//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		//frmcomptype = compsrc;
	
		if(frmcomptype === 'undefined'){
			frmcomptype = "user_image";
			frmcompname = "User:NULL";
		}
		
		var modify=publicJSON['modify'];
		var href = "segment="+encodeURIComponent(thissegment)+"&zone="+encodeURIComponent(thiszone)+"&link="+encodeURIComponent(link)+'&frmcomptype='+encodeURIComponent(frmcomptype)+'&frmcompname='+encodeURIComponent(frmcompname)+'&zoom='+encodeURIComponent(zoom)+"&modifySegment="+encodeURIComponent(modify);
		
		var typeValue = Ext.getCmp('typeOfComp').getValue();
		var nameValue = Ext.getCmp('startcompTypeCombo').getValue();

		if(combo.id=='typeOfComp')
			loadComponentType(typeValue,href);
		else if(combo.id=='startcompTypeCombo')
			loadComponentNames(nameValue,href);
		else
		{
			updateTopology(myHref);
		}
	},
	openSettingsWin: function()
	{
		
		Ext.widget('topologysettings').show();
		
		Ext.Ajax.request({
			url: 'AutoTopology/data/TopologySettingsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var myjsonText = response.responseText;
					var mySettingObj = Ext.decode( myjsonText );
					var vgapobj = Ext.getCmp('vgap').getStore();
					var hgapobj = Ext.getCmp('hgap').getStore();
					vgapobj.suspendEvents(true);
					vgapobj.loadRawData(mySettingObj['VerticalGapEntries']);
					vgapobj.resumeEvents();
					hgapobj.suspendEvents(true);
					hgapobj.loadRawData(mySettingObj['HorizontalGapEntries']);
					hgapobj.resumeEvents();
					Ext.getCmp('vgap').setValue(mySettingObj['SelectedVGap']);
					Ext.getCmp('hgap').setValue(mySettingObj['SelectedHGap']);
					var checkNo = mySettingObj['checkNo'];
					if(checkNo=="checked")
					{
						Ext.getCmp('multi').setValue(false);
						Ext.getCmp('single').setValue(true);
					}
					else
					{
						Ext.getCmp('multi').setValue(true);
						Ext.getCmp('single').setValue(false);
					}
				}
			}
		});
	},
	closeManageDiv: function()
	{
		var win = Ext.WindowManager.getActive();
		if (win) {
			win.close();
		}
		else
		{
			this.refreshPage();
		}
	},
	openSaveTopology: function(btn)
	{
		
		var action='';
		
		Ext.widget('managesaveview').show();
		
		if(btn.id=='saveas')
		{
			action='saveAs';
			Ext.getCmp('managesaveview').setTitle(saveAsHeader);
		}
		else
		{
			action='save';
			Ext.getCmp('managesaveview').setTitle(saveHeader);
		}
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thiszone = "-1";
		var thissegment = "";
		if(frames[1] == undefined)
		{
			thissegment = frames[0].document.getElementById("segment").value;
		}
		else
		{
			thissegment = frames[1].document.getElementById("segment").value;
		}
		
		var zoomValue = frames[0].document.getElementById("zoom").value;
		var modify=publicJSON['modify'];
		
		var enableDrag = 'false';
		var urlToDisplay ='';
		urlToDisplay ="AutoTopology/data/EgAutoManagePageJson.jsp?mode=savetopo&segment="+encodeURIComponent(thissegment)+"&action="+action+"&zone="+encodeURIComponent(thiszone)+"&enableDrag="+encodeURIComponent(enableDrag);
		
		Ext.Ajax.request({
			url: urlToDisplay,
			method: 'POST',
			async: false,
			success: function( response )
			{
				
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var myjsonText = response.responseText;
					var myJsonObj = Ext.decode( myjsonText );
					var NoCompPresent = myJsonObj['NoComponents'];
					var isNewCompExists = myJsonObj['isNewCompExists'];
					var isManageCompExists = myJsonObj['isManageExists'];
					var isUnManageExists = myJsonObj['isUnManageExists'];
					var isNewDiscGrp = myJsonObj['isNewDiscGrp'];
					var isComplete = myJsonObj['isComplete'];
					var segLimitExceed = myJsonObj['segLimitExceed'];
					if(segLimitExceed == true)
					{
						publicJSON.segLimitExceed = true;
					}
					if(NoCompPresent=='true')
					{
						Ext.getCmp('NoComponentPresent').show();
						Ext.getCmp('ManageMessage').hide();
						Ext.getCmp('SaveMessage').hide();
						Ext.getCmp('NoLinkMessage').hide();
						Ext.getCmp('manageGridDisplay').hide();
						Ext.getCmp('addManageContainer').hide();
					}
					//else if(isNewCompExists || isUnManageExists)
					//{
						//Ext.getCmp('NoComponentPresent').hide();
						//Ext.getCmp('ManageMessage').hide();
						//Ext.getCmp('SaveMessage').show();
						//Ext.getCmp('NoLinkMessage').hide();
						//Ext.getCmp('manageGridDisplay').show();
						//var manageGridDisplayobj = Ext.getCmp('manageGridDisplay').getStore();
						// manageGridDisplayobj.suspendEvents(true);
						// manageGridDisplayobj.loadRawData(myJsonObj['CommonGrid']);
						// manageGridDisplayobj.resumeEvents();
						//Ext.getCmp('addManageContainer').show();
						// if(isNewDiscGrp)
						//{
							//Ext.getCmp('NoComponentPresent').hide();
							//Ext.getCmp('ManageMessage').hide();
							//Ext.getCmp('SaveMessage').show();
							//Ext.getCmp('NoLinkMessage').hide();
							//Ext.getCmp('manageGridDisplay').show();
							//Ext.getCmp('manageGrpGridDisplay').show();
							//var managedGrpObj = Ext.getCmp('manageGrpGridDisplay').getStore();
							// managedGrpObj.suspendEvents(true);
							// managedGrpObj.loadRawData(myJsonObj['CommonGrpGrid']);
							// managedGrpObj.resumeEvents();
							//Ext.getCmp('addManageGrp').show();
						//}
					//}
					else if(isNewDiscGrp)
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('ManageMessage').hide();
						Ext.getCmp('SaveMessage').show();
						Ext.getCmp('NoLinkMessage').hide();
						Ext.getCmp('manageGridDisplay').hide();
						Ext.getCmp('manageGrpGridDisplay').show();
						var managedGrpObj = Ext.getCmp('manageGrpGridDisplay').getStore();
						managedGrpObj.suspendEvents(true);
						managedGrpObj.loadRawData(myJsonObj['CommonGrpGrid']);
						managedGrpObj.resumeEvents();
						Ext.getCmp('addManageGrp').show();
					}
					else if(isComplete)
					{
						Ext.getCmp('NoLinkMessage').show();
						Ext.getCmp('addManageContainer').hide();
						Ext.getCmp('addMangeBtnText').hide();
						Ext.getCmp('manageGridDisplay').show();
						var manageGridDisplayobj = Ext.getCmp('manageGridDisplay').getStore();
						manageGridDisplayobj.suspendEvents(true);
						manageGridDisplayobj.loadRawData(myJsonObj['CommonGrid']);
						manageGridDisplayobj.resumeEvents();
					}
					else
					{
						if(btn.id=='savetopo')
						{
							//Ext.getCmp('SaveConfirmationMessage').show();
							Ext.getCmp('saveBtn').show();
							Ext.getCmp('cancelBtn').show();
							Ext.getCmp('addManage').hide();
							var addToGroup = myJsonObj['addToGroup'];
							var addToZone = myJsonObj['addToZone'];
							if(addToGroup)
							{
								Ext.getCmp('addToGroup').show();
								Ext.getCmp('addToGroup').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+addToGroupMsg+" "+myJsonObj['RecentlyAddedtoGroup']+'</center>');
								Ext.getCmp('addToGroupGrid').show();
								var addToGroupGridobj = Ext.getCmp('addToGroupGrid').getStore();
								addToGroupGridobj.suspendEvents(true);
								addToGroupGridobj.loadRawData(myJsonObj['GroupGrid']);
								addToGroupGridobj.resumeEvents();
							}
							if(addToZone && thiszone!=null)
							{
								Ext.getCmp('addToZone').show();
								Ext.getCmp('addToZone').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+addToZoneMsg+" "+thiszone+'</center>');
								Ext.getCmp('addToZoneGrid').show();
								var addToZoneGridobj = Ext.getCmp('addToZoneGrid').getStore();
								addToZoneGridobj.suspendEvents(true);
								addToZoneGridobj.loadRawData(myJsonObj['ZoneGrid']);
								addToZoneGridobj.resumeEvents();
							}
							if(myJsonObj['saveTopoArr'].length > 1)
							{
								Ext.getCmp('addToSegment').show();
								Ext.getCmp('addToSegment').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+addToSegmentMsg+" "+thissegment+'</center>');
								Ext.getCmp('addToSegmentGrid').show();
								var addToSegmentGridobj = Ext.getCmp('addToSegmentGrid').getStore();
								addToSegmentGridobj.suspendEvents(true);
								addToSegmentGridobj.loadRawData(myJsonObj['saveTopoArr']);
								addToSegmentGridobj.resumeEvents();
								if(myJsonObj['ManagedGroupGrid'].length > 0)
								{
									Ext.getCmp('addToSegmentGroupGrid').show();
									var addToSegmentGroupGridobj = Ext.getCmp('addToSegmentGroupGrid').getStore();
									addToSegmentGroupGridobj.suspendEvents(true);
									addToSegmentGroupGridobj.loadRawData(myJsonObj['ManagedGroupGrid']);
									addToSegmentGroupGridobj.resumeEvents();
								}
							}
							else
							{
								//Ext.getCmp('SaveConfirmationMessage').hide();
								Ext.getCmp('saveBtn').hide();
								Ext.getCmp('cancelBtn').hide();
								Ext.getCmp('NoComponentPresent').show();
							}
						}
						else
						{
							Ext.getCmp('managesaveview').setHeight(140);
							Ext.getCmp('managesaveview').setWidth(350);
							Ext.getCmp('saveAsContainer').show();
							Ext.getCmp('saveAsBtn').show();
							Ext.getCmp('cancelBtn').show();
						}
					}
				}
			}
		});
	},
	updateSettings: function()
	{
		
		var colValue = Ext.getCmp('hgap').getValue();
		var rowValue = Ext.getCmp('vgap').getValue();
		var typeVal = Ext.getCmp('multi').getValue();
		var action = "updateOptions";
		var singleTopology='';
		if(typeVal==true)
		{
			singleTopology ='No';
		}
		else
		{
			singleTopology ='Yes';
		}
		var url  = '/final/servlet/com.eg.EgAutoTopologyServlet?action='+encodeURIComponent(action)+'&rowspace='+encodeURIComponent(rowValue)+'&colspace='+encodeURIComponent(colValue)+'&singletopology='+(singleTopology);
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : settingsUpdationMsg,
						buttons : Ext.Msg.OK,
						icon : 'iconInformation'
					});
				}
			}
		});
	},
	refreshPage: function(toPage)
	{
		var toPage1 = toPage;
		if (toPage != 'group')
		{
			toPage = 'main';
		}
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thiszone = frames[0].document.getElementById('zone').value;
		var thissegment = frames[0].document.getElementById("segment").value;
		var zoomValue = frames[0].document.getElementById("zoom").value;
		var enableDrag = 'false';
		var modify=publicJSON['modify'];
		
		var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?segment="+encodeURIComponent(thissegment)+"&zone="+encodeURIComponent(thiszone)+"&zoom="+zoomValue+"&enableDrag="+encodeURIComponent(enableDrag)+"&modify="+encodeURIComponent(modify)+'&index='+toPage+"&com.eg.CSRF_NONCE="+csrfToken;
		Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px;" scrolling="no"></iframe>');
	},
	openManageAll: function()
	{
		
		Ext.widget('managesaveview').show();
		Ext.getCmp('managesaveview').setTitle(ManageWinHeader);
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thiszone = '-1';
		
		var thissegment = frames[0].document.getElementById("segment").value;
		var zoomValue = frames[0].document.getElementById("zoom").value;
		var modify=publicJSON['modify'];
		var enableDrag = 'false';
		var urlToDisplay ='';
		urlToDisplay ="AutoTopology/data/EgAutoManagePageJson.jsp?mode=manageall&segment="+encodeURIComponent(thissegment)+"&zone="+encodeURIComponent(thiszone)+"&enableDrag="+encodeURIComponent(enableDrag);
		
		Ext.Ajax.request({
			url: urlToDisplay,
			method: 'POST',
			async: false,
			success: function( response )
			{
				
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					
					var myjsonText = response.responseText;
					var myJsonObj = Ext.decode( myjsonText );
					var NoCompPresent = myJsonObj['NoComponents'];
					var isNewCompExists = myJsonObj['isNewCompExists'];
					var isUnManageExists = myJsonObj['isUnManageExists'];
					var isNewDiscGrp = myJsonObj['isNewDiscGrp'];
					var isComplete = myJsonObj['isComplete'];
					if(NoCompPresent=='true')
					{
						Ext.getCmp('NoComponentPresent').show();
						Ext.getCmp('ManageMessage').hide();
						Ext.getCmp('SaveMessage').hide();
						Ext.getCmp('NoLinkMessage').hide();
						Ext.getCmp('manageGridDisplay').hide();
						Ext.getCmp('addManageContainer').hide();
					}
					else if(isNewCompExists || isUnManageExists)
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('ManageMessage').show();
						Ext.getCmp('SaveMessage').hide();
						Ext.getCmp('NoLinkMessage').hide();
						Ext.getCmp('manageGridDisplay').show();
						var manageGridDisplayobj = Ext.getCmp('manageGridDisplay').getStore();
						manageGridDisplayobj.suspendEvents(true);
						manageGridDisplayobj.loadRawData(myJsonObj['CommonGrid']);
						manageGridDisplayobj.resumeEvents();
						Ext.getCmp('addManageContainer').show();
						if(isNewDiscGrp)
						{
							Ext.getCmp('NoComponentPresent').hide();
							Ext.getCmp('ManageMessage').hide();
							Ext.getCmp('SaveMessage').show();
							Ext.getCmp('NoLinkMessage').hide();
							Ext.getCmp('manageGridDisplay').show();
							Ext.getCmp('manageGrpGridDisplay').show();
							var managedGrpObj = Ext.getCmp('manageGrpGridDisplay').getStore();
							managedGrpObj.suspendEvents(true);
							managedGrpObj.loadRawData(myJsonObj['CommonGrpGrid']);
							managedGrpObj.resumeEvents();
							Ext.getCmp('addManageGrp').show();
						}
					}
					else if(isNewDiscGrp)
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('ManageMessage').hide();
						Ext.getCmp('SaveMessage').show();
						Ext.getCmp('NoLinkMessage').hide();
						Ext.getCmp('manageGridDisplay').hide();
						Ext.getCmp('manageGrpGridDisplay').show();
						var managedGrpObj = Ext.getCmp('manageGrpGridDisplay').getStore();
						managedGrpObj.suspendEvents(true);
						managedGrpObj.loadRawData(myJsonObj['CommonGrpGrid']);
						managedGrpObj.resumeEvents();
						Ext.getCmp('addManageGrp').show();
					}
					else
					{
						Ext.getCmp('alreadyManaged').show();
						Ext.getCmp('addManage').hide();
						Ext.getCmp('addManageContainer').hide();
					}
				}
			}
		});
	},
	manageComponents: function()
	{
		
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thissegment = frames[0].document.getElementById("segment").value;
		var selectedList=[];
		var store = Ext.getCmp('manageGridDisplay').getStore();
		var selModel = Ext.getCmp('manageGridDisplay').getSelectionModel();
		store.each(function(rec)
		{
			var cbValue = rec.get('Cbvalue');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(cbValue);
			}
		});
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment);
		var selectedComps = selectedList.toString();
		if(selectedComps!=null && selectedComps.length>0)
		{
			url = url+"&test=" + selectedComps;
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						//Ext.widget('managesaveview').close();
						var win = Ext.WindowManager.getActive();
						if (win) {
							win.close();
						}
						Ext.widget('managedcomponents').show();
						var managed = myJsonObj['Managed'];
						if(managed=='true')
						{
							Ext.getCmp('ManageCompMessage').show();
							Ext.getCmp('managedComponents').show();
							var managedComponentsobj = Ext.getCmp('managedComponents').getStore();
							managedComponentsobj.suspendEvents(true);
							managedComponentsobj.loadRawData(myJsonObj['ManagedComponents']);
							managedComponentsobj.resumeEvents();
						}
						if(myJsonObj['NotManaged']=='true')
						{
							Ext.getCmp('NotManagedMessage').show();
							Ext.getCmp('notManagedComponents').show();
							var notManagedComponentsobj = Ext.getCmp('notManagedComponents').getStore();
							notManagedComponentsobj.suspendEvents(true);
							notManagedComponentsobj.loadRawData(myJsonObj['NotManagedComponents']);
							notManagedComponentsobj.resumeEvents();
						}
						if(myJsonObj['callBasicErrorPage']==true)
						{
							var errCompMsg = myJsonObj['ErrorMessage'];
							var licenseMsg = myJsonObj['licenseMsg'];
							var messageText1 = errCompMsg +""+licenseMsg
							var htmlText= '<div class="error_panel" style="text-align:center"><div style="margin:0px auto;align:center;width:50px" class="iconExclamation"></div>'+messageText1+'</div>'
							Ext.getCmp('errorMsg').setText(htmlText,false);
							Ext.getCmp('close').hide();
							Ext.getCmp('ErrorMessage').show();
						}
					}
				}
			});
		}
		else
			Ext.Msg.alert(pageTitle,chhoseComp);
	},
	manageGroups : function()
	{
		var thissegment = frames[0].document.getElementById("segment").value;
		var action = "multigroupSelect";
		var selectedList=[];
		var store = Ext.getCmp('manageGrpGridDisplay').getStore();
		var selModel = Ext.getCmp('manageGrpGridDisplay').getSelectionModel();
		store.each(function(rec)
		{
			var groupname = rec.get('groupname');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				groupname = groupname+":NULL";
				selectedList.push(groupname);
			}
		});
		var url = "AutoTopology/data/EgAutoTopologyMainPageJSON.jsp?action="+encodeURI(action)+'&segment='+encodeURI(thissegment)+'&grplist='+encodeURI(selectedList);
		var url2 = "AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?segment="+encodeURI(thissegment);
		var selectedComps = selectedList.toString();
		if(selectedComps!=null && selectedComps.length>0)
		{
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var mypublicJSON = Ext.decode( jsonText);
						var status = mypublicJSON['status'];
						var grpStatus = mypublicJSON['grpStatus'];
						var grpStatusMsg = mypublicJSON['grpStatusMsg'];
						if(grpStatusMsg.indexOf(":")>-1)
						{
							grpStatusMsg = grpStatusMsg.substring(grpStatusMsg.indexOf(":")+1);
						}
						var filePath = mypublicJSON['filePath'];
						var win = Ext.WindowManager.getActive();
						if (win) {
							win.close();
						}
						if(status != 'eG_CLI_0030')
						{
							Ext.Msg.show({
							title: pageTitle,
								msg: compErrMsg1 +"<br>"+compErrMsg2+"<br>"+filePath,
								buttons: Ext.Msg.OK,
								icon: "iconExclamation"
							});
						}
						else if(grpStatus !="eG_CLI_Res_0323")
						{
							Ext.Msg.alert(pageTitle,grpStatusMsg);
						}
						else if(grpStatus =="eG_CLI_Res_0323")
						{
							Ext.widget('managedcomponents').show();
							Ext.getCmp('ManageGrpMessage').show();
							Ext.getCmp('managedGroup').show();
							var managedComponentsobj = Ext.getCmp('managedGroup').getStore();
							managedComponentsobj.suspendEvents(true);
							managedComponentsobj.loadRawData(mypublicJSON['managedGrpArr']);
							managedComponentsobj.resumeEvents();
							//Ext.Msg.show({
							//	title: pageTitle,
							//	msg: grpStatusMsg,
							//	buttons: Ext.Msg.OK,
							//	icon: "iconInformation"
							//});
							//Ext.getCmp('topologyFrame').update('<iframe src="' + url2+ '" style="width:100%;height:100%;border:0px" scrolling="yes"></iframe>');
						}
						else
						{
							Ext.getCmp('topologyFrame').update('<iframe src="' + url2+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
						}
					}
				}
			});
		}
		else
		{
			Ext.Msg.alert(pageTitle,chhosegrp);
		}
	},
	expandAllRows:function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(!expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	collapseAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	backbutton: function()
	{
		if(returnToMain=='true')
		{
				window.location.href=mainUrl;
				return;
		}
		window.location.href="EgAutoTopology.jsp";
	},
	showPopupWindow : function(row)
	{
		if (Ext.getCmp('previewWindow') != undefined)
		{
			Ext.getCmp('previewWindow').destroy();
		}
		var records = Ext.getCmp('gridDisplay').getStore().getAt(row);
		var topo = records.get('nameTopology');
		var url=records.get('actions');
		var temp = url.split("&^&");
		Ext.widget('mypopwindow').show();
		var obj = Ext.select('#frameId');
		obj.set({ src: temp[1] });
		Ext.getCmp('previewWindow').setTitle('Preview for '+topo);
	},

	hidePopupWindow : function()
	{
		if (Ext.getCmp('previewWindow') != undefined)
		{
			Ext.getCmp('previewWindow').destroy();
		}
	},
	showEditText: function(d)
	{
		var ed = Ext.getCmp("editText").getValue();
	},
	
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var isDisabled = hideIcon.get('isDisabled');
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			if (isDisabled == 'true')
			{
				Ext.get(icons[0]).removeCls('x-hidden');
				Ext.get(icons[1]).removeCls('x-hidden');
			}
			else
			{
				Ext.get(icon).removeCls('x-hidden');
			}
		});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
		});
	},

	buildFieldData: function(){
		
		//Removing localStorage related to paning saved postions(We are setting this data inside D3Js related files). 
		window.localStorage.removeItem('svgScale');
		window.localStorage.removeItem("pervoiussgt");
		
		Ext.Ajax.request({
			url: 'AutoTopology/data/EgDispSegmentsJson.jsp?reqfrom=navlink',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		Ext.Ajax.request(
		{
			url: 'AutoTopology/data/autoTopologyPreviewJson.jsp',
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var result = publicJSON['gridDatas'];
					if (result != null && result.length > 0)
					{
						Ext.getCmp('gridSearch').enable();
					}
					else
					{
						Ext.getCmp('gridSearch').disable();
					}
					var gridDisplayobj = Ext.getCmp('gridDisplay').getStore();
					gridDisplayobj.suspendEvents(true);
					gridDisplayobj.loadRawData(publicJSON['gridDatas']);
					gridDisplayobj.resumeEvents();
					var flag = publicJSON['screenLabel']['flagResult'];
					var agentDiscoveryFlag = publicJSON['screenLabel']['agentDiscoveryFlag'];
					if(flag && agentDiscoveryFlag == 'true')
						Ext.getCmp('activeStatus').update('<img src="/final/images/spacer.gif" class="iconInformationSmall" border="0">'+enableTopology+'.<a href="EgDiscoveryPane.jsp?from=seg_top">&nbsp;<span class=font_bold11>Click here</span><img src="/final/images/spacer.gif" class="iconClickHere" border="0"></a>&nbsp;'+todisable+'.');
					else
						Ext.getCmp('activeStatus').update('<img src="/final/images/spacer.gif" class="iconInformationSmall" border="0">'+disableTopology+'.<a href="EgDiscoveryPane.jsp?from=seg_top">&nbsp;<span class=font_bold11>Click here</span><img src="/final/images/spacer.gif" class="iconClickHere" border="0"></a>&nbsp;'+toenable+'.');
				}
			}
		});
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'AutoTopology/data/autoTopologyPreviewJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridDatas'];
				Ext.getCmp('gridDisplay').show();
				Ext.getCmp('NoExtPresent').hide();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridDatas']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+nodata+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		});
	},
	updateSegments: function(newEditText) {
			if(newEditText == null || newEditText == undefined )
			{
				newEditText != "" ;
			}
			var d = Ext.getCmp("gridDisplay").getStore();
			var grid = Ext.getCmp("gridDisplay");
			var record = grid.getSelectionModel().getSelection()[0];
			var rowIndex = grid.getStore().indexOf(record);
			var nameTopo = d.getAt(rowIndex).data.nameTopology;

			Ext.Ajax.request({
				url: "AutoTopology/data/autoTopologyPreviewJson.jsp",
				method: "POST",
				async: false,
				params: {
						'newEditText' : newEditText,
						'nameTopo'    : nameTopo
				} ,
				success: function(b) {
						if (b.status == 200 && !Ext.isEmpty(b.responseText)) {
							var e = b.responseText;
							var d = Ext.decode(e);
						}
					}
			});
	},
	addSegment : function(topoName)
	{
		var configGroupController = this.getController('AutoTopology.controller.ConfigSegmentControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("add",topoName);
		Ext.getCmp('viewport').add({xtype: 'componentsegment'});
		configGroupController.afterMainRender("add",topoName,"-1");
	},
	autoTopologyPreview: function()
	{
		window.location.href="EgDispAutoTopology.jsp";
	},
	validateName: function()
	{
		var segName = Ext.getCmp('segmentName').getValue();
		 this.validation();
		 Ext.Ajax.request({
			url: 'AutoTopology/data/ComponentPropertiesJson.jsp?mode='+publicJSON['mode']+'&segment='+segName+'&validate=firsttime'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonObj = Ext.decode( jsonText );
					var isValidName = jsonObj['screenLabels']['isValid'];
					if(isValidName=="false")
					{
						Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.common.ErroInAddingSegment']);
						return false;
					}
				}
			}
		});
	},
	comboLoad: function()
	{
		var segmentCombo = Ext.getCmp('segmentNameCombo').getValue();
		Ext.getCmp('compTypeCombo').setValue('-1');
		Ext.Ajax.request({
			url: 'AutoTopology/data/ComponentPropertiesJson.jsp?segment='+encodeURIComponent(segmentCombo)+"&mode="+'modify'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				
				var showIndOnly = publicJSON['showIndCheck'];
				if(!showIndOnly)
				{
					Ext.getCmp('association').setValue(true);
				}
				else
					Ext.getCmp('association').setValue(false);
				var showIndOnlyParam = Ext.getCmp('association').getValue();
				Ext.Ajax.request({
					url: 'AutoTopology/data/ComponentPropertiesJson.jsp?mode='+publicJSON['mode']+'&segment='+encodeURIComponent(segmentCombo)+'&newsegment=false'+'&zone='+publicJSON['selectedZone']+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl+'&showIndOnlyParam='+!showIndOnlyParam,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
						}
						var topologyUrl = publicJSON['topologyUrl'];
						var compTypeComboobj = Ext.getCmp('compTypeCombo').getStore();
						compTypeComboobj.suspendEvents(true);
						compTypeComboobj.loadRawData(publicJSON['ComponentTypeList']);
						compTypeComboobj.resumeEvents();
						Ext.getCmp('compTypeCombo').setValue('-1');
						var componentsListobj = Ext.getCmp('componentsList').getStore();
						componentsListobj.suspendEvents(true);
						componentsListobj.loadRawData(publicJSON['ComponentList']);
						componentsListobj.resumeEvents();
						var listLabel = "Start Component";
						if(publicJSON['screenLabels']['ListBoxLabel']!=undefined)
							//listLabel = "Start Component ["+publicJSON['screenLabels']['ListBoxLabel']+"]";
							listLabel = publicJSON['screenLabels']['ListBoxLabel']+" components";
						Ext.getCmp('componentsList').setFieldLabel(listLabel);
						Ext.getCmp('componentsList').setValue('-1');
						
						if(!Ext.getCmp('topologyFrame').isVisible() && !Ext.getCmp('topologyPanel').isVisible())
						{
							Ext.getCmp('topologyPanel').setVisible(true);
							Ext.getCmp('topologyFrame').setVisible(true);
						}
						Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:945px;border:0px;" height="100%"></iframe>');
						var isZone = publicJSON['isZone'];
						if(isZone=='true')
						{
							table = '<table width="100%" cellspacing="0" cellpadding="0" border="0" style="font-size:12px">';
							table += '<tr><td align="left"><table border="0" cellspacing="4" cellspacing="0" style="font-size:12px"><tr>';
							var serviceArr = publicJSON['AssociatedServiceList'];
							if(serviceArr!=null && serviceArr!=undefined && serviceArr.length>0)
							{
								table += '<td width="120"><i>Service(s) mapping</i></td><td width="10">:</td>';
								table += '<td>';
								var fieldValue='';
								for(var s=0;s<serviceArr.length;s++)
								{
									var serviceName = serviceArr[s];
									var serviceUrl = publicJSON['AssociatedServiceUrl'][serviceName];
									table += '<a style="text-decoration:none;color:#000;" href='+serviceUrl+'>'+serviceName+'</a>';
									if(s!=(serviceArr.length-1))
									{
										table +=", ";
									}
								}
								table += '</td>';
							}
							var AssociatedZoneForEdit = publicJSON['AssociatedZoneForEdit'];
							var configZoneLink = publicJSON['configZoneLink'];
							var dissociateZonelink = publicJSON['dissociateZonelink'];
							
							table += '</tr>';
							table += '<tr><td width="120" align="left" nowrap><i>Zone mapping</i></td><td width="10">:</td>';
							table += '<td align="left"><a style="text-decoration:none;color:#000;" href='+configZoneLink+'>'+AssociatedZoneForEdit+'</a>';
							if(publicJSON['disassString']!=null && publicJSON['disassString']!=undefined)
							{
								table += ' (<a style="text-decoration:none;color:#000;" href=# onclick="javascript:disassociateZone();">Disassociate)';
							}
							table +='</td></tr></table></td></tr>';
							table += '</table>';	

							Ext.getCmp('associationPanel').show();
							Ext.getCmp('associationDiv').show();
							Ext.getCmp('associationDiv').update(
							{
								html:table
							});
						}
						else
						{
							Ext.getCmp('associationPanel').hide();
							Ext.getCmp('associationDiv').hide();
						}
						Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
					}
				});
			}
		});
	},
	modifyTopology: function(topoName)
	{
		segName = topoName;
		Ext.getCmp('topologyOuterPanal').setTitle(pageTitle + " - PREVIEW OF "+segName);
		zone= "-1";
		var urlToSend = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(segName)+'&zone='+encodeURIComponent(zone)+"&action=show";
		Ext.Ajax.request({
			url: urlToSend,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 )
				{
					var topologyUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURIComponent(segName)+"&zone="+encodeURIComponent(zone)+"&zoom=100&com.eg.CSRF_NONCE="+csrfToken;
					//topologyUrl = topologyUrl + "&comptype="+componentType + "&compname="+compname;
					Ext.getCmp('segmentName').setValue(segName);
					Ext.getCmp('topologyPanel').setVisible(true);
					Ext.getCmp('topologyFrame').setVisible(true);
					//Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px;" ></iframe>');
					Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:100%;height:100%;border:0px;" scrolling="no"></iframe>');
				}
			}
		});
	},
	multiselectLoad: function(combo)
	{
		var mode = publicJSON['mode'];
		var segName='';
		var compname = Ext.getCmp('componentsList').getValue();
		
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var showIndOnlyParam = '';
		var componentType = Ext.getCmp('compTypeCombo').getValue();
		var urlToSend = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURIComponent(segName)+'&zone='+encodeURIComponent(zone)+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+"&action=show&isAddFlag=true";
		Ext.Ajax.request({
			url: urlToSend,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 )
				{
					
					var topologyUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURIComponent(segName)+"&zone="+encodeURIComponent(zone)+"&zoom=100&action=show&com.eg.CSRF_NONCE="+csrfToken;
					topologyUrl = topologyUrl + "&comptype="+encodeURIComponent(componentType) + "&compname="+encodeURIComponent(compname);
					Ext.getCmp('topologyPanel').setVisible(true);
					Ext.getCmp('topologyFrame').setVisible(true);
					Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px;" ></iframe>');
				}
			}
		});
		//reloading start component begin
		Ext.Ajax.request({
			url: 'AutoTopology/data/ComponentTypeNameJson.jsp?mode='+mode+'&zone='+encodeURIComponent(zone)+'&segment='+encodeURIComponent(segName), 
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
				Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
				Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
				Ext.getCmp('compTypeCombo').getStore().resumeEvents();
				Ext.getCmp('compTypeCombo').setValue('-1');
				var componentsListobj = Ext.getCmp('componentsList').getStore();
				componentsListobj.removeAll();
				Ext.getCmp('componentsList').setValue('-1');
			}
		});
		//end
	},
	compTypeLoad: function()
	{
		var val = Ext.getCmp('segmentName').getValue();
		if(Ext.getCmp('segmentName').getValue().length> 0)
		{
			var mode = publicJSON['mode'];
			var segName = '';
			var newsegment='';
			if(mode=='add')
			{
				segName = Ext.getCmp('segmentName').getValue();
				newsegment='true';
			}
			else if(mode=='modify')
			{
				segName = Ext.getCmp('segmentNameCombo').getValue();
				newsegment='false';
			}
			var showIndOnlyParam = '';
			var componentType = Ext.getCmp('compTypeCombo').getValue();
			Ext.Ajax.request({
					url: 'AutoTopology/data/ComponentTypeNameJson.jsp?segment='+encodeURIComponent(segName)+'&zone='+encodeURIComponent(zone)+'&comptype='+encodeURIComponent(componentType),
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
							var compTypeComboobj = Ext.getCmp('compTypeCombo').getStore();
							compTypeComboobj.suspendEvents(true);
							compTypeComboobj.loadRawData(publicJSON['ComponentTypeList']);
							compTypeComboobj.resumeEvents();
							var componentsListobj = Ext.getCmp('componentsList').getStore();
							componentsListobj.suspendEvents(true);
							componentsListobj.loadRawData(publicJSON['ComponentList']);
							componentsListobj.resumeEvents();
							Ext.getCmp('compTypeCombo').setValue(componentType);
							Ext.getCmp('componentsList').setValue('-1');
						}
					}
			});
		}
		else
		{
			Ext.Msg.alert(pageTitle, "Please enter the segment name");
			Ext.getCmp('compTypeCombo').setValue('-1');
			Ext.getCmp('componentsList').reset();
			return;
		}
	},
	saveTopology: function(btn)
	{
		
		var configSegmentController = this.getController('AutoTopology.controller.ConfigSegmentControl');
		var segment='';
		var newName='';
		var action = "save";
		var proceed = false;
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var zoomValue = frames[0].document.getElementById("zoom").value;
		var modify=publicJSON['modify'];
		var enableDrag = 'false';
		if(btn.id=='saveAsBtn')
		{
			var retValue = renameTopology();
			if(retValue)
			{
				var oldName = frames[0].document.getElementById("segment").value;
				segment = oldName;
				newName = Ext.getCmp("newName").getValue();
				proceed = true;
			}
			else
				return;
		}
		else
		{
			segment =  frames[0].document.getElementById("segment").value;
			
			newName="";
			proceed = true;
			var win = Ext.WindowManager.getActive();
			if (win) {
				win.close();
			}
			
			var imageName = Ext.getCmp('imagecombo').getValue();
			this.segmentSaveWindow(segment,publicJSON.segLimitExceed,publicJSON.isDouble,zone,imageName);
				
		}
		//var imageName = Ext.getCmp('imagecombo').getValue();
		//if(proceed){

			//var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(segment)+"&action="+encodeURI(action)+"&zone="+encodeURI(zone)+"&newNameToSave="+encodeURI(newName)+'&imageName='+imageName;
			
			//var httpObj = createRequestObject();
			//var params = "";
			//var tempurl = "";
			//if (url.indexOf("?") > -1){
				//params=url.substring(url.indexOf("?")+1);
				//tempurl=url.substring(0,url.indexOf("?"));
			//}
			//else{
				//tempurl=url;
			//}
			//httpObj.open('POST',tempurl,true);
			//httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
			////httpObj.setRequestHeader('Content-length',params.length);
			////httpObj.setRequestHeader('Connection','close');
			//httpObj.onreadystatechange = function() {
				//if (httpObj.readyState == 4 && httpObj.status == 200)
				//{
					//Ext.Msg.show({
						//title : pageTitle,
						//msg : httpObj.responseText,
						//buttons : Ext.Msg.OK,
						//icon : 'iconInformation'
					//});
					////if(btn.id=='saveAsBtn')
						////Ext.getCmp('segmentName').setValue(newName);
					
					//Ext.getCmp('segmentName').setDisabled(true);
					//Ext.getCmp('assocZoneCombo').setDisabled(true);
				//}
			//}
			//httpObj.send(params);
		//}
		//var win = Ext.WindowManager.getActive();
		//if (win) {
			//win.close();
		//}
	},
	groupTypeChange: function()
	{
		var option='';
		var typeVal = Ext.getCmp('new').getValue();
		if(typeVal==true)
		{
			option='newgroup';
		}
		else
			option='oldgroup';
		var selectedComponent = Ext.getCmp('GrpcompTypeCombo').getValue();
		var thisGrpName=Ext.getCmp('groupCombo').value;
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var status = frames[0].document.getElementById("h_status").value;
		var thiscomp = frames[0].document.getElementById("h_title").value;
		var compsrc = frames[0].document.getElementById("h_src").value;
		var segment = frames[0].document.getElementById("segment").value;
		//var zone = Ext.getCmp('assocZoneCombo').getValue();//frames[0].document.getElementById("zone").value;
		var zone ="-1";
		var src = compsrc;
		var autoUrl = "AutoTopology/data/EgAutoTopologyGroupJson.jsp?option="+option+"&segment="+encodeURIComponent(segment)+"&zone="+encodeURIComponent(zone)+"&src="+encodeURIComponent(src)+"&comp="+encodeURIComponent(thiscomp)+"&selectedComponent="+encodeURIComponent(selectedComponent)+"&compStatus="+encodeURIComponent(status)+"&title="+encodeURIComponent(thisGrpName);

		Ext.Ajax.request({
			url: autoUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var myPublicJSON = Ext.decode( jsonText );
					var typeVal = Ext.getCmp('new').getValue();

					if(typeVal==true)
					{
						Ext.getCmp('groupName').show();
						Ext.getCmp('groupCombo').hide();
						Ext.getCmp('NoGroupFound').hide();
						Ext.getCmp('GrpcompTypeCombo').show();
						var combo = Ext.getCmp('GrpcompTypeCombo');
						var toselect = Ext.getCmp('GrpcompTypeCombo').getStore().getAt(0);
						combo.select(toselect);
						var record = combo.getStore().findRecord('name', toselect);
						combo.fireEvent('select', combo, [record]);
					}
					else
					{
						Ext.getCmp('groupName').hide();
						var groupFound = myPublicJSON['groupFound'];
						if(!groupFound)
						{
							Ext.getCmp('NoGroupFound').show();
							Ext.getCmp('groupCombo').hide();
							Ext.getCmp('GrpcompTypeCombo').hide();
							Ext.getCmp('manageCompGridDisplay').hide();
							Ext.getCmp('unManageGridDisplay').hide();
							Ext.getCmp('assign').hide();
							Ext.getCmp('finish').hide();
							Ext.getCmp('AddManageBtn').hide();
						}
						else
							Ext.getCmp('groupCombo').show();
					}
				}
			}
		});
		
		this.ComponentLoadForGroup();
	},
	manageGrpComponent:function()
	{
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thissegment = frames[0].document.getElementById("segment").value;
		var compname = frames[0].document.getElementById("h_cmpName").value;
		var compStatus = frames[0].document.getElementById("h_status").value;
		var selectedList=[];
		var store = Ext.getCmp('GrpDetailsDisplay').getStore();
		var selModel = Ext.getCmp('GrpDetailsDisplay').getSelectionModel();
		var grpName = compname;
		if(compname.endsWith(":NULL"))
		{
			grpName = grpName.replace(":NULL","");
		}
		store.each(function(rec)
		{
			var CompVal = rec.get('CompVal');//Citrix_XcXenApp_server:192.168.11.9:1494
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(CompVal);
			}
		});
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment)+"&grpname="+compname+"&compStatus="+encodeURIComponent(compStatus);
		var url2 = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(grpName)+"&segment="+encodeURIComponent(thissegment)+"&compName="+encodeURIComponent(compname);
		var selectedComps = selectedList.toString();
		if(selectedComps!=null && selectedComps.length>0)
		{
			var action = "manageGrpComp";
			url = url+"&test=" + selectedComps+"&action="+action;
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						//Ext.widget('managesaveview').close();
						var isManagedComp = myJsonObj['isManagedComp'];
						var msgString = myJsonObj['msgString'];
						var isNewCompExceedLicense = myJsonObj['isNewCompExceedLicense'];
						if(isManagedComp == true)
						{
							Ext.MessageBox.show({
								title : grpDetails,
								msg : managedCompAlert,
								buttons: Ext.Msg.OK,
								icon : 'iconInformation',
								width : 300,
								fn : function(btn)
								{
									var win = Ext.WindowManager.getActive();
									if (win) {
										win.close();
									}
									this.showGroupDetails(grpName);
								}
							});
						}
						else if (isNewCompExceedLicense == true)
						{
							var win = Ext.WindowManager.getActive();
							if (win) {
								win.close();
							}
							Ext.widget('managedcomponents').show();
							if(myJsonObj['callBasicErrorPage']==true)
							{
								var errCompMsg = myJsonObj['ErrorMessage'];
								var licenseMsg = myJsonObj['licenseMsg'];
								var messageText1 = errCompMsg +""+licenseMsg
								var htmlText= '<div class="error_panel" style="text-align:center"><div style="margin:0px auto;align:center;width:50px" class="iconExclamation"></div>'+messageText1+'</div>'
								Ext.getCmp('errorMsg').setText(htmlText,false);
								Ext.getCmp('close').hide();
								Ext.getCmp('ErrorMessage').show();
							}
						}
						else
						{
							var win = Ext.WindowManager.getActive();
							if (win) {
								win.close();
							}
							Ext.widget('managedcomponents').show();
							var managed = myJsonObj['Managed'];
							if(managed=='true')
							{
								Ext.getCmp('ManageCompMessage').show();
								Ext.getCmp('managedComponents').show();
								var managedComponentsobj = Ext.getCmp('managedComponents').getStore();
								managedComponentsobj.suspendEvents(true);
								managedComponentsobj.loadRawData(myJsonObj['ManagedComponents']);
								managedComponentsobj.resumeEvents();
							}
							if(myJsonObj['NotManaged']=='true')
							{
								Ext.getCmp('NotManagedMessage').show();
								Ext.getCmp('notManagedComponents').show();
								var notManagedComponentsobj = Ext.getCmp('notManagedComponents').getStore();
								notManagedComponentsobj.suspendEvents(true);
								notManagedComponentsobj.loadRawData(myJsonObj['NotManagedComponents']);
								notManagedComponentsobj.resumeEvents();
							}
							if(myJsonObj['callBasicErrorPage']==true)
							{
								var errCompMsg = myJsonObj['ErrorMessage'];
								var licenseMsg = myJsonObj['licenseMsg'];
								var messageText1 = errCompMsg +""+licenseMsg
								var htmlText= '<div class="error_panel" style="text-align:center"><div style="margin:0px auto;align:center;width:50px" class="iconExclamation"></div>'+messageText1+'</div>'
								Ext.getCmp('errorMsg').setText(htmlText,false);
								Ext.getCmp('close').hide();
								Ext.getCmp('ErrorMessage').show();
							}
						}
						Ext.widget('groupdetails').hide();
					}
				}
			});
		}
		else
			Ext.Msg.alert(grpDetails,selectComptoManage);
	},
	removeGrpComponent:function()
	{
		var frames;
		try
		{
			frames = window.frames;
		}
		catch(e)
		{
			frames = document.frames;
		}
		var thissegment = frames[0].document.getElementById("segment").value;
		var compname = frames[0].document.getElementById("h_cmpName").value;
		var grpStatus = frames[0].document.getElementById("h_status").value;
		var grpName = compname;
		if(compname.endsWith(":NULL"))
		{
			grpName = grpName.replace(":NULL","");
		}
		var selectedList=[];
		var store = Ext.getCmp('GrpDetailsDisplay').getStore();
		var selModel = Ext.getCmp('GrpDetailsDisplay').getSelectionModel();
		var gridCount = Ext.getCmp('GrpDetailsDisplay').getStore().getCount();
		var selCount = Ext.getCmp('GrpDetailsDisplay').getSelectionModel().getSelection().length;
		store.each(function(rec)
		{
			var CompVal = rec.get('CompVal');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(CompVal);
			}
		});
		var action = "removeGrpComp";
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment)+"&action="+encodeURIComponent(action)+"&compname="+encodeURIComponent(compname)+"&compStatus="+grpStatus;
		var url2 = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(grpName)+"&segment="+encodeURIComponent(thissegment)+"&compName="+encodeURIComponent(compname)+"&compStatus="+grpStatus;
		var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURI(thissegment);
		var selectedComps = selectedList.toString();
		if((gridCount-selCount) == 0)
		{
			Ext.Msg.alert(pageTitle,associateAtleastOneComp);
		}
		else if(selectedComps!=null && selectedComps.length>0)
		{
			url = url+"&removeComp="+selectedComps;
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if (response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						var win = Ext.WindowManager.getActive();
						if (win) {
							win.close();
						}
						Ext.MessageBox.show({
						title : grpDetails,
						msg : dissociateMsg,
						buttons: Ext.Msg.OK,
						icon : 'iconInformation',
						width : 300,
						fn : function(btn)
						{
								Ext.Ajax.request({
								url: url2,
								method: 'POST',
								async: false,
								success: function( response )
								{
									if (response.status == 200 && !Ext.isEmpty(response.responseText))
									{
										var myjson = response.responseText;
										var myJsonObj = Ext.decode( myjson );
										var disp = myJsonObj['GroupDetails'];
										var GrpDetailsDisplayobj = Ext.getCmp('GrpDetailsDisplay').getStore();
										GrpDetailsDisplayobj.suspendEvents(true);
										GrpDetailsDisplayobj.clearFilter(true);
										GrpDetailsDisplayobj.loadRawData(myJsonObj['GroupDetails']);
										GrpDetailsDisplayobj.resumeEvents();
										Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
									}
								}
							});
						}
					});
					}
					Ext.widget('groupdetails').hide();
				}
			});
		}
		else if(selectedComps.length <= 0)
		{
			Ext.Msg.alert(grpDetails,selectComptoDissociate);
		}
	},
	ComponentLoadForGroup : function()
	{
		var option='';
		var typeVal = Ext.getCmp('new').getValue();
		if(typeVal==true)
		{
			option='newgroup';
		}
		else
			option='oldgroup';
//		option='newgroup';
		var selectedComponent = Ext.getCmp('GrpcompTypeCombo').getValue();
		var thisGrpName = Ext.getCmp('groupCombo').getValue();
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var status = frames[0].document.getElementById("h_status").value;
		var thiscomp = frames[0].document.getElementById("h_title").value;
		var compsrc = frames[0].document.getElementById("h_src").value;
		var segment = frames[0].document.getElementById("segment").value;
		//var zone = Ext.getCmp('assocZoneCombo').getValue();//frames[0].document.getElementById("zone").value;
		var zone ="-1";
		var src = compsrc;
		var autoUrl = "AutoTopology/data/EgAutoTopologyGroupJson.jsp?option="+option+"&segment="+encodeURIComponent(segment)+"&zone="+encodeURIComponent(zone)+"&src="+encodeURIComponent(src)+"&comp="+encodeURIComponent(thiscomp)+"&selectedComponent="+encodeURIComponent(selectedComponent)+"&compStatus="+encodeURIComponent(status)+"&title="+encodeURIComponent(thisGrpName);
		Ext.Ajax.request({
			url: autoUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var myPublicJSON = Ext.decode( jsonText );
					var groupFound = myPublicJSON['groupFound'];
					var AssociatedToSegment = myPublicJSON['AssociatedToSegment'];
					var isNewCompExists = myPublicJSON['isNewCompExists'];
					var NewSelectedComponent = myPublicJSON['NewSelectedComponent'];
					if(groupFound)
					{
						var displayCompDetails = true;
						if(AssociatedToSegment == 'true')
						{
							var showMsg = true;
							if(isNewCompExists)
							{
								var gridValues = myPublicJSON['NewComponentDetails'];
								if(gridValues != null && gridValues.length > 0)
								{
									if(NewSelectedComponent==selectedComponent)
									{
										Ext.getCmp('manageCompGridDisplay').hide();
										Ext.getCmp('finish').hide();
										Ext.getCmp('assign').hide();
										Ext.getCmp('associatedToSegmentResult').hide();
										Ext.getCmp('unManageGridDisplay').show();
										var unManageGridDisplayobj = Ext.getCmp('unManageGridDisplay').getStore();
										unManageGridDisplayobj.suspendEvents(true);
										unManageGridDisplayobj.loadRawData(gridValues);
										unManageGridDisplayobj.resumeEvents();
										Ext.getCmp('AddManageBtn').show();
										displayCompDetails = false;
										showMsg = false;
									}
								}
							}
							var compGrid = myPublicJSON['ComponentDetails'];
							if(compGrid != null && compGrid.length > 0)
							{
								if(NewSelectedComponent==selectedComponent)
								{
									Ext.getCmp('associatedToSegmentResult').hide();
									Ext.getCmp('manageCompGridDisplay').show();
									var manageCompGridDisplayobj = Ext.getCmp('manageCompGridDisplay').getStore();
									manageCompGridDisplayobj.suspendEvents(true);
									manageCompGridDisplayobj.loadRawData(myPublicJSON['ComponentDetails']);
									manageCompGridDisplayobj.resumeEvents();
									Ext.getCmp('finish').show();
									Ext.getCmp('assign').show();
									Ext.getCmp('unManageGridDisplay').hide();
									Ext.getCmp('AddManageBtn').hide();
									showMsg = false;
								}
							}
							if(showMsg)
							{
								var name = myPublicJSON['AssociatedToSegmentName'];
								Ext.getCmp('SegResultMsg').setText('<table><tr><td align="center" height="30"><table><tr><td align="center"></td></tr><tr><td align="center" style="font-size:12">'+associatedToSegMsg+'<br>'+name+'</td></tr></table></td></tr></table>',false);
								Ext.getCmp('associatedToSegmentResult').show();
								Ext.getCmp('manageCompGridDisplay').hide();
								Ext.getCmp('unManageGridDisplay').hide();
								Ext.getCmp('finish').hide();
								Ext.getCmp('assign').hide();
								Ext.getCmp('AddManageBtn').hide();
								displayCompDetails = false;
							}
						}
						if(displayCompDetails)
						{
							Ext.getCmp('associatedToSegmentResult').hide();
							Ext.getCmp('manageCompGridDisplay').show();
							var manageCompGridDisplayobj = Ext.getCmp('manageCompGridDisplay').getStore();
							manageCompGridDisplayobj.suspendEvents(true);
							manageCompGridDisplayobj.loadRawData(myPublicJSON['ComponentDetails']);
							manageCompGridDisplayobj.resumeEvents();
							Ext.getCmp('finish').show();
							Ext.getCmp('assign').show();
							Ext.getCmp('unManageGridDisplay').hide();
							Ext.getCmp('AddManageBtn').hide();
						}
						if(isNewCompExists)
						{
							var gridValues = myPublicJSON['NewComponentDetails'];
							var NewSelectedComponent = myPublicJSON['NewSelectedComponent'];
							if(gridValues != null && gridValues.length > 0)
							{
								if(NewSelectedComponent==selectedComponent)
								{
									Ext.getCmp('manageCompGridDisplay').hide();
									Ext.getCmp('finish').hide();
									Ext.getCmp('assign').hide();
									Ext.getCmp('associatedToSegmentResult').hide();
									Ext.getCmp('unManageGridDisplay').show();
									var unManageGridDisplayobj = Ext.getCmp('unManageGridDisplay').getStore();
									unManageGridDisplayobj.suspendEvents(true);
									unManageGridDisplayobj.loadRawData(gridValues);
									unManageGridDisplayobj.resumeEvents();
									Ext.getCmp('AddManageBtn').show();
									displayCompDetails = false;
								}
							}
						}
					}
					else
					{
						Ext.getCmp('NoGroupFound').show();
					}
				}
			}
		});
	},
	AssignAddMore : function(btn)
	{
		var addOption='';
		if(btn.id=='assign')
			addOption='addMore';
		else
			addOption='finish';
		var option = Ext.getCmp('new').getValue();
		var isNewGroup='';
		if(option==true)
			isNewGroup="true";
		else
			isNewGroup="false";

		var action="";
		var selElement="";
		var group = "";
		var sendToServlet="";
		var unchecked="";
		var selectedComponent = Ext.getCmp('GrpcompTypeCombo').getValue();
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var compStatus = frames[0].document.getElementById("h_status").value;
		var comp = frames[0].document.getElementById("h_title").value;
		var src = frames[0].document.getElementById("h_src").value;
		var segment = frames[0].document.getElementById("segment").value;
		var zoomValue = frames[0].document.getElementById("zoom").value;
		var selectedList=[];
		var deSelectedList=[];
		if(isNewGroup=="true")
		{
			action="add";
			group = Ext.getCmp('groupName').getValue();
		}
		else
		{
			action="modify";
			group = Ext.getCmp('groupCombo').getValue();
		}
		var store = Ext.getCmp('manageCompGridDisplay').getStore();
		var selModel = Ext.getCmp('manageCompGridDisplay').getSelectionModel();
		store.each(function(rec)
		{
			var cbValue = rec.get('Cbvalue');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(cbValue);
			}
			else
			{
				deSelectedList.push(cbValue);
			}
		});
		selElement = selectedList.toString();
		unchecked = deSelectedList.toString();
		var htmlContent = Ext.getCmp('associationDiv').html;
		if(selElement.length == 0 && htmlContent=='') 
		{
			Ext.Msg.alert(pageTitle,selectCompName);
			return;
		}
		// Validation
		if(isNewGroup=="true")
		{
			var isDouble = publicJSON['isDouble'];
			var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
			if (group==null || group.length == 0)
			{
				//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please enter a group name']);
				Ext.Msg.alert(pageTitle,'Please enter a group name');
				return false;
			}
			if(group!=null)
			{
				for(count = 0; count < group.length; count++)
				{
					var check_char = s_spl.indexOf(group.charAt(count));
					if(group.charAt(count) == ' ')
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
						return false;
					}
					else if(check_char >= 0)
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
						return false;
					}
					else if(!isDouble)
					{
						var charValue=group.charCodeAt(count);
						if(charValue>255)
						{
							Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
							return false;
						}
					}
				}
			}
			sendToServlet="true";
		}
		else
		{
			sendToServlet="true";
		}
		if(sendToServlet=="true")
		{
			if(isNewGroup=="true" && selElement.length!= 0)
			{
				Ext.getCmp('groupName').setDisabled(true);
			}
			else if(isNewGroup!="true" && selElement.length != 0)
			{
				Ext.getCmp('groupCombo').setDisabled(true);
			}
			var disableOp=false;
			var topoUrl = "/final/servlet/com.eg.EgAutoTopologyServlet?group="+encodeURIComponent(group)+"&isNewGroup="+encodeURIComponent(isNewGroup)+"&grpElement="+encodeURIComponent(selElement)+"&segment="+encodeURIComponent(segment)+"&zone="+encodeURIComponent(zone)+"&action=addGroup"+"&finish="+encodeURIComponent(addOption)+"&uncheckedVal="+encodeURIComponent(unchecked)+"&continue=default";
			var httpObj = createRequestObject();
			var params = "";
			var tempurl = "";
			if (topoUrl.indexOf("?") > -1)
			{
				params=topoUrl.substring(topoUrl.indexOf("?")+1);
				tempurl=topoUrl.substring(0,topoUrl.indexOf("?"));
			}
			else
			{
				tempurl=topoUrl;
			}
			httpObj.open('POST',tempurl,true);
			httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
			//httpObj.setRequestHeader('Content-length',params.length);
			//httpObj.setRequestHeader('Connection','close');
			httpObj.onreadystatechange = function() {
				if (httpObj.readyState == 4 && httpObj.status == 200)
				{
					var myResponseText = httpObj.responseText;
					if(myResponseText.length>0)
					{	
						var win = Ext.WindowManager.getActive();
						if (win) {
							win.close();
						}
						Ext.Msg.alert("Create group",myResponseText);
					}
					Ext.getCmp('groupCombo').setDisabled(true);
					Ext.getCmp('groupName').setDisabled(true);
					if(addOption=='finish')
					{
						var modify=publicJSON['modify'];
						var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=addandassign&segment="+encodeURIComponent(segment)+"&zone="+encodeURIComponent(zone)+'&zoom='+encodeURIComponent(zoomValue)+"&modify="+encodeURIComponent(modify)+"&com.eg.CSRF_NONCE="+csrfToken;
				

						Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
						var win = Ext.WindowManager.getActive();
						if (win) {
							win.close();
						}
					}
					if(addOption=='addMore')
					{
						var TopoGrpPage = "AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=group&segment="+ encodeURIComponent(segment) +"&zone="+encodeURIComponent(zone) + "&thiscomp="+encodeURIComponent(comp)+"&src="+encodeURIComponent(src);
						Ext.Ajax.request({
							url: TopoGrpPage, 
							method: 'POST',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
								{
									var jsonText = response.responseText;
									var myPublicJSON = Ext.decode( jsonText );
									var AllElementsArray = myPublicJSON['AllElementsArray'];
									if(AllElementsArray!=null && AllElementsArray.length>0)
									{
										var table = '<table><tr><td style="font-size:12">'+AllElementsArray+'</td></tr></table>'
										
										var content = Ext.getCmp('creategroup'); 
										var scroll_position = content.getHeight(); 
										Ext.getCmp('creategroup').body.scrollTo('top', scroll_position, true)


										Ext.getCmp('associationPanel').show();
										Ext.getCmp('associationDiv').show();
										Ext.getCmp('associationDiv').update(
										{
											html:table
										});
									}
									else
									{
										//Ext.getCmp('associationContainer').hide();
										Ext.getCmp('associationPanel').hide();
										Ext.getCmp('associationDiv').hide();
										Ext.getCmp('groupCombo').setDisabled(false);
										Ext.getCmp('groupName').setDisabled(false);
										Ext.getCmp('new').setDisabled(false);
										Ext.getCmp('old').setDisabled(false);
									}
									if(isNewGroup=="true")
									{
										Ext.getCmp('groupCombo').hide();
										if(selElement.length!=0 && !disableOp){
											Ext.getCmp('old').setDisabled(true);
										}
									}
									else
									{
										Ext.getCmp('groupName').hide();
										Ext.getCmp('groupCombo').setValue(group);
										if(selElement.length!=0 && !disableOp){
											Ext.getCmp('new').setDisabled(true);
										}
									}
								}
							}
						});
					}
				}
			}
			httpObj.send(params);
		}
	},
	addManageCompFromGroup: function()
	{
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var thissegment = frames[0].document.getElementById("segment").value;
		var selectedList=[];
		var store = Ext.getCmp('unManageGridDisplay').getStore();
		var selModel = Ext.getCmp('unManageGridDisplay').getSelectionModel();
		store.each(function(rec)
		{
			var cbValue = rec.get('CbNewvalue');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(cbValue);
			}
		});
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment);
		var selectedComps = selectedList.toString();
		if(selectedComps!=null && selectedComps.length>0)
		{
			url = url+"&test=" + selectedComps;
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						if(myJsonObj['callBasicErrorPage']==true)
						{
							Ext.getCmp('ErrorMessage').show();
						}
					}
				}
			});
			Ext.widget('creategroup').hide();
			this.refreshPage('group');
		}
		else
			Ext.Msg.alert("Segment","Please choose a component to manage");
	},
	deleteSegment: function()
	{
		var mode = publicJSON['mode'];
		var compName = Ext.getCmp('componentsList').getValue();
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		Ext.Ajax.request({
			url: 'AutoTopology/data/ComponentPropertiesJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zoneName)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(compType)+'&compname='+encodeURIComponent(compName)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var siteAssociated = publicJSON['site_associated'];
					var zoneAssociated = publicJSON['zone_associated'];

					if(siteAssociated=='false' && zoneAssociated=='false')
					{
						Ext.Msg.confirm('Segment', publicJSON['screenLabels']['admin.common.Delete Segment'], function(buttonText) {
							if (buttonText == "yes") 
							{
							    Ext.Ajax.request({
									url: 'AutoTopology/data/EgdelsegmentpJson.jsp?qctr='+publicJSON['qctr']+'&segment='+encodeURIComponent(segName)+'&destiny=segments'+'&comptype='+encodeURIComponent(compType)+ "&compname=" +encodeURIComponent(compName)+"&zone="+encodeURIComponent(zoneName)+"&zoneAssociated="+zoneAssociated+"&reqfrom=navlink",
									method: 'POST',
									async: false,
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											var jsonObj = Ext.decode( jsonText );
											var deleteSegment = jsonObj['deleteSegment'];
											if(deleteSegment=='true')
											{
												window.location.href='EgAutoTopology.jsp';
											}
											else
											{
												Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']);
												return false;
											}
										}
									}
								});
							}
						});
					}
					else
					{
						Ext.Ajax.request({
							url: 'AutoTopology/data/EgdelsegmentpJson.jsp?qctr='+publicJSON['qctr']+'&segment='+encodeURIComponent(segName)+'&destiny=topology'+'&comptype='+encodeURIComponent(compType)+ "&compname=" +encodeURIComponent(compName)+"&zone="+publicJSON['HiddenValues']['zone']+"&zoneAssociated="+zoneAssociated+"&reqfrom=navlink",
							method: 'POST',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonText = response.responseText;
									var jsonObj = Ext.decode( jsonText );
									var deleteSegment = jsonObj['deleteSegment'];
									if(deleteSegment=='false')
									{
										Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']);
										return false;
									}
									else if(deleteSegment=='true')
									{
										window.location.href='EgAutoTopology.jsp';
									}
								}
							}
						});
					}
				}
			}
		});
	},
		handleManageIcon: function(grid, rowIndex, colIndex){
		var rec = grid.getStore().getAt(rowIndex);
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var val = rec.get('CbNewvalue');
		
		var compstatus = frames[0].document.getElementById("h_status").value;
		var compsrc = val.substring(0,val.indexOf(":"));
		var comptitle = val.substring(val.indexOf(":")+1);
		var thissegment = frames[0].document.getElementById("segment").value;
		var thiszone = frames[0].document.getElementById("zone").value;

		var servertype=compsrc;
		if (compsrc.indexOf(".gif")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
		else if (compsrc.indexOf(".png")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		var newServerUrl = "EgNewServer.jsp?server=new&compstatus="+ encodeURIComponent(compstatus)+"&serverType="+encodeURIComponent(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle="+encodeURIComponent(comptitle)+"&topoSegName="+encodeURIComponent(thissegment);

		var w ;
		if(!w){
				w = new Ext.Window({
				layout: 'fit',
				title: 'Manage components',
				id:'manageWindow',
				closeAction: 'destroy',
				width:850,
				height:450,
				padding:'5 10 10 10',
				border: false,
				html: '<iframe width="100%" src='+newServerUrl+' style="height:100%;border:0"></iframe>',
				});
		}
		w.show();
	},
	validation: function()
	{
		var mode = publicJSON['mode'];
		var segName='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
		}
		
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		if (segName==null || segName.length == 0)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please enter a name']);
			return false;
		}
		else
		{
			for(count = 0; count < segName.length; count++)
			{
				var check_char = s_spl.indexOf(segName.charAt(count));
				if(!isDouble)
				{
					var charValue=segName.charCodeAt(count);
					if(charValue>255)
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
						return false;
					}
				}
				if(segName.charAt(count) == ' ')
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
					return false;
				}
				else if(segName == "independent_servers")
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Cannot add segment by name']);
					return false;
				}
			}
		}
		return true;
	},
	renameBtnClick:function()
	{
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		var action = "renameGrpName";
		var thissegment = frames[0].document.getElementById("segment").value;
		var grpStatus = frames[0].document.getElementById("h_status").value;
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : lblNoBlank,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : lblSameName,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.show({
						title : renameTitle,
						msg : lblNoDBL,
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : lblNoSpace,
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
					});
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : lblNoSplChar,
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
		}
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment)+"&action="+encodeURIComponent(action)+"&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name)+"&compStatus="+grpStatus;
		var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURI(thissegment);
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					var win = Ext.WindowManager.getActive();
					if (win) {
						win.close();
					}
					if(renameJSON.renamed)
					{
						Ext.MessageBox.show({
							title : renameGrpTitle,
							msg : renameJSON.message,
							buttons: Ext.Msg.OK,
							icon : 'iconInformation',
							width : 300,
							fn : function(btn)
							{
								Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title : renameGrpTitle,
							msg : renameJSON.message,
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
					}
				}
				Ext.widget('renamegroup').hide();
			}
		});
	}
	
});



function disassociateZone()
{
	var dissociateZonelink = publicJSON['dissociateZonelink'];
	if(dissociateZonelink!=null)
	{
		Ext.Ajax.request({
			url: dissociateZonelink,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonObj = Ext.decode( jsonText );
					if(jsonObj['removeElements']=='false')
					{
						Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.common.ErrorInRemovingComponents']);
					}
					else
					{
						window.location.href=jsonObj['ForwardPageTo'];
					}
				}
			}
		});
	}
}
function nameCheck()
{
	if(Ext.getCmp('segmentName').getValue().length == 0)
	{
		Ext.Msg.alert(pageTitle, "Please enter the segment name");
		this.clearAllFunction();
		return;
	}
}
function createRequestObject()
{
	var request_o;
	var browser = navigator.appName;
	if(browser == "Microsoft Internet Explorer")
		request_o = new ActiveXObject("Microsoft.XMLHTTP");
	else
		request_o = new XMLHttpRequest();
	return request_o;
}
function OpenUsesDiv(href,link)
{
	
	Ext.widget('usesConnects').show();
	Ext.getCmp('typeOfComp').setValue('Managed Components');
	Ext.getCmp('usesConnects').setTitle(link);

	// Functions to open uses,connects div
	var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
		selType: 'checkboxmodel',
		mode: 'MULTI',
		checkOnly: true,  
		renderer : function(val, meta, record, rowIndex, colIndex, store,view){
			if( record.get('Checked')== "checked")
			{  
				Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
			}
			if( record.get('Disabled')=='disabled')
			{    
				meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
				return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker DisableCheckBox">&#160;</div>';
			}
			else
			{
				meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			}
		},
		selectAll: function(){
			var rowIndex=0;
			while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
				var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
				if (record.get('Disabled')=='disabled'){
					Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
				}
				else {
					Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
				}
				rowIndex++;
			}
			var view   = Ext.getCmp('gridDisplay').getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd  = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {
					checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');          
			}
		},
		deselectAll: function(){
			var rowIndex=0;
			while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
				var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
				Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);           
				rowIndex++;
			}
			var view   = Ext.getCmp('gridDisplay').getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd  = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {            
				 checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');            
			}
		},
		listeners : {
					beforeselect: function(selModel, record, index) {
						if (record.get('Disabled')=='disabled') {
							 return false;  
						}
					},
					rowclick : function (in_this, rowIndex, e) {
						var record = in_this.getStore().getAt(rowIndex);
						if (record.get('Disabled')=='disabled'){
							in_this.getSelectionModel().deselectRow(rowIndex);
						}
					}
				}
	});

	var segmentPreviewGrid = {
		xtype: 'customgrid',
		cls:'gridSkin',
		id: 'gridDisplay',
		store:new Ext.data.Store({
			fields: ['Checked','Disabled','CheckboxValue','isZoneComp','isGroupType','isGroupName','Componentname','AlertTitle'],
			data:[]
		}),
		selModel:mySelectionModel,
		autoScroll: true,
		margin: 10,
		height: 200,
		columns: {
			defaults: {
				sortable: true,
				hideable: false,
				menuDisabled: true,
				draggable: false,
				resizable: false
			},
			items: [
				{
					text: listOfComps,
					dataIndex: 'Componentname',
					id: 'DispComponentname',
					flex: 1,
					//style: {fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',fontSize: '10px',fontWeight:'normal'},
					renderer :function (data, metadata, record, rowIndex, columnIndex, store) {
						var isZoneComp = record.get('isZoneComp');
						var isGroupType = record.get('isGroupType');
						var isGroupName = record.get('isGroupName');
						var RecComponentname = record.get('Componentname');
						RecComponentname=RecComponentname.trim();
						var onclickFunction = "\"showGroupDetails('"+RecComponentname+"');\""
						var tmpData='';
						if(isZoneComp)
						{
							if(isGroupType)
							{
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '<td align="center"><img src="/final/images/spacer.gif" class="zone20_GRAY"></td>';
								tmpData += '<td align="right"><img src="/final/images/spacer.gif"  class="iconGroup" onclick='+onclickFunction+'></td>';
								tmpData += '</tr></table>';
							}
							else if(isGroupName)
							{
								metadata.tdAttr = 'data-qtip= "' + record.get('AlertTitle') + '"';
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '<td align="center"><img src="/final/images/spacer.gif" class="zone20_GRAY"></td>';
								tmpData += '</tr></table>';
							}
							else
							{
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '<td align="center"><img src="/final/images/spacer.gif" class="zone20_GRAY"></td>';
								tmpData += '</tr></table>';
							}
						}
						else
						{
							if(isGroupType)
							{
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '<td align="center"><img src="/final/images/spacer.gif" class="iconGroup" onclick='+onclickFunction+'></td>';
								tmpData += '</tr></table>';
							}
							else if(isGroupName)
							{
								metadata.tdAttr = 'data-qtip= "' + record.get('AlertTitle') + '"';
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '</tr></table>';
							}
							else
							{
								tmpData = '<table height="100%" width="100%" style="font-size:12px">';
								tmpData += '<tr><td align="left" style="font-size:12">'+RecComponentname+'</td>';
								tmpData += '</tr></table>';
							}
						}
						//alert(tmpData);
						return tmpData;
					}
				}
			]
		},
		//height:200
	}
	Ext.suspendLayouts();
	Ext.getCmp('componentPreviewCt').removeAll();
	Ext.getCmp('componentPreviewCt').add(segmentPreviewGrid);
	Ext.resumeLayouts(true)
	var combo = Ext.getCmp('typeOfComp');
	var toselect = "Managed Components";
	combo.select(toselect);
	var record = combo.getStore().findRecord('name', toselect);
	combo.fireEvent('select', combo, [record]);
	myHref = href;
}
function updateTopology(href,title)
{
	var action='';
	var selectedList=[];
	var deSelectedList=[];
	var comptName = Ext.getCmp('typeOfComp').getValue();
	var segmentName = Ext.getCmp('segmentName').getValue();
	var thiscomptype = Ext.getCmp('startcompTypeCombo').getValue();
	var store = Ext.getCmp('gridDisplay').getStore();
	var selModel = Ext.getCmp('gridDisplay').getSelectionModel();
	store.each(function(rec)
	{
		var cbValue = rec.get('CheckboxValue');
		var isSelected = selModel.isSelected(rec);
		if(isSelected)
		{
			selectedList.push(cbValue);
		}
		else
		{
			deSelectedList.push(cbValue);
		}
	});
	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?'+href+'&comptype='+encodeURIComponent(thiscomptype)+'&segment='+encodeURIComponent(segmentName);
	var selectedComps = selectedList.toString();
	var deselectedComps = deSelectedList.toString();
	var isDeletion = 'false';
	if(selectedComps != null && selectedComps.length > 0 && selectedComps.indexOf(',') == -1)
	{
		isDeletion = 'true';
	}
	if(selectedComps!=null && selectedComps.length>0)
	{
		if(comptName == 'Discovered Components')
			var myUrl = url+'&action=show'+'&compname='+encodeURIComponent(selectedComps)+'&isDeletion='+isDeletion;
		else
			var myUrl = url+'&action=addlink'+'&compname='+encodeURIComponent(selectedComps)+'&isDeletion='+isDeletion;
		var httpObj = createRequestObject();
		var params = "";
		var tempurl = "";
		if (myUrl.indexOf("?") > -1)
		{
			params=myUrl.substring(myUrl.indexOf("?")+1);
			tempurl=myUrl.substring(0,myUrl.indexOf("?"));
		}
		else
		{
			tempurl=myUrl;
		}
		
		httpObj.open('POST',tempurl,true);
		httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		httpObj.onreadystatechange = function() {
			if (httpObj.readyState == 4 && httpObj.status == 200)
			{
				var zoom = '100';
				var modify = publicJSON['modify'];
				
				var refreshUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?"+href+"&modify="+modify+"&segment="+encodeURIComponent(segmentName)+"&fromAutoCompType=true&index=main&isAddFlag=true&action=addlink"+'&comptype='+encodeURIComponent(thiscomptype)+'&compname='+encodeURIComponent(selectedComps)+"&com.eg.CSRF_NONCE="+csrfToken;
				Ext.getCmp('topologyPanel').setVisible(true);
				Ext.getCmp('topologyFrame').setVisible(true);
				Ext.getCmp('topologyFrame').update('<iframe src="' + refreshUrl+ '" frameborder="0" style="width:100%;height:100%;overflow:auto;border:0px;" scrolling="no"></iframe>');
			}
		}
		httpObj.send(params);
	}
	
	if(deselectedComps!=null && deselectedComps.length>0)
	{
		var myUrl = url+'&action=removelink'+'&compname='+encodeURIComponent(deselectedComps)+'&isDeletion='+isDeletion;
		var httpObj = createRequestObject();
		var params = "";
		var tempurl = "";
		if (myUrl.indexOf("?") > -1)
		{
			params=myUrl.substring(myUrl.indexOf("?")+1);
			tempurl=myUrl.substring(0,myUrl.indexOf("?"));
		}
		else
		{
			tempurl=myUrl;
		}
		httpObj.open('POST',tempurl,true);
		httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		httpObj.onreadystatechange = function() {
			if (httpObj.readyState == 4 && httpObj.status == 200)
			{
				var zoom = '100';
				var modify=publicJSON['modify'];
				var refreshUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?"+href+"&modify="+modify+'&segment='+encodeURIComponent(segmentName)+'&fromAutoCompType=true&index=uses&isAddFlag=true&action=addlink'+'&comptype='+encodeURIComponent(thiscomptype)+'&compname='+encodeURIComponent(selectedComps)+"&com.eg.CSRF_NONCE="+csrfToken;
				
				Ext.getCmp('topologyPanel').setVisible(true);
				Ext.getCmp('topologyFrame').setVisible(true);
				Ext.getCmp('topologyFrame').update('<iframe src="' + refreshUrl+ '" style="width:100%;height:100%;border:0px;" scrolling="no"></iframe>');
			}
		}
		httpObj.send(params);
	}
}
function loadComponentNames(comboValue,href,title)
{
	var compStatus = frames[0].document.getElementById("h_status").value;
	var choiceValue = Ext.getCmp('typeOfComp').getValue();
	var choice='';
	if(choiceValue=='Managed Components')
		choice = 'managedComp';
	else if(choiceValue=='Discovered Components')
		choice = 'newComp';
	else if(choiceValue=='Unmanaged Components')
		choice = 'unManagedComp';
	else if(choiceValue=='Managed Groups')
		choice = 'managedGrp';
	else if(choiceValue=='Discovered Groups')
		choice = 'discGrp';

	var url = "AutoTopology/data/MainPageCompNamesJson.jsp?"+href+"&choice="+choice+'&comptype='+encodeURIComponent(comboValue)+'&index='+title+'&compStatus='+compStatus;
	Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var mypublicJSON = Ext.decode( jsonText );
					var compgridVal = mypublicJSON['CompNameGridValues'];
					if(compgridVal != "")
					{
						Ext.getCmp('NoGroupPresent').hide();
						var gridDisplayobj = Ext.getCmp('gridDisplay').getStore();
						gridDisplayobj.suspendEvents(true);
						gridDisplayobj.loadRawData(mypublicJSON['CompNameGridValues']);
						gridDisplayobj.resumeEvents();
					}
					else 
					{
						if(choice == "managedGrp" || choice == "discGrp")
						{
							Ext.getCmp('NoGroupPresent').show();
							Ext.getCmp('startcompTypeCombo').hide();
							Ext.getCmp('gridDisplay').hide();
							Ext.getCmp('UpdateTopo').hide();
						}
					}
				}
			}
	});
}
function loadComponentType(comboValue,href,title)
{
	var choice='';
	if(comboValue=='Managed Components')
		choice = 'managedComp';
	else if(comboValue=='Discovered Components')
		choice = 'newComp';
	else if(comboValue=='Unmanaged Components')
		choice = 'unManagedComp';
	else if(comboValue=='Managed Groups')
		choice = 'managedGrp';
	else if(comboValue=='Discovered Groups')
		choice = 'discGrp';

	var url = "AutoTopology/data/MainPageCompTypesJson.jsp?"+href+"&choice="+choice+'&index='+title;
	Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var mypublicJSON = Ext.decode( jsonText );
					var count = mypublicJSON['Total'];
					var selType = mypublicJSON['SelectedCompType'];
					if(count == 0)
					{
						Ext.getCmp('NoComponentPresent').show();
						Ext.getCmp('startcompTypeCombo').hide();
						Ext.getCmp('gridDisplay').hide();
						Ext.getCmp('UpdateTopo').hide();
					}
					else if(selType == "DGroup")
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('startcompTypeCombo').hide();
						Ext.getCmp('gridDisplay').show();
						Ext.getCmp('UpdateTopo').show();
					}
					else
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('startcompTypeCombo').show();
						Ext.getCmp('gridDisplay').show();
						Ext.getCmp('UpdateTopo').show();
					}
					var startcompTypeComboobj = Ext.getCmp('startcompTypeCombo').getStore();
					startcompTypeComboobj.suspendEvents(true);
					startcompTypeComboobj.loadRawData(mypublicJSON['ComponentTypes']);
					startcompTypeComboobj.resumeEvents();
					Ext.getCmp('startcompTypeCombo').setValue(selType);
					loadComponentNames(selType,href,title);
				}
			}
	});
}
function RemoveFunction(myServletUrl,myJspUrl)
{
	var compType = frames[0].document.getElementById("h_cmptype").value;
	var enableDrag = 'false';
	myJspUrl = myJspUrl+"&enableDrag="+enableDrag+'&index=main';
	var Segmentname = '';
	var mode = publicJSON['mode'];
	var alertMsg1 = "";
	if(compType == "DGroup")
	{
		alertMsg1 = RemoveGrpMsg1;
	}
	else
	{
		alertMsg1 = RemoveCompMsg1;
	}
	Ext.Msg.confirm('Segment',alertMsg1+". "+RemoveCompMsg2, function(buttonText) {
	if (buttonText == "yes") 
	{
		if(mode=='add')
		{
			Segmentname = Ext.getCmp('segmentName').getValue();
			Ext.Ajax.request({
				url: myServletUrl,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200)
					{
						Ext.getCmp('topologyFrame').update('<iframe src="' + myJspUrl+ '" style="width:100%;height:100%;border:0px;" scrolling="no"></iframe>');
					}
				}
			});
		}
		else if(mode=="modify")
		{
			Segmentname = Ext.getCmp('segmentNameCombo').getValue();
			var callServlet='false';
			var removeUrl = myServletUrl.substring(myServletUrl.indexOf("?")+1);
			removeUrl = 'AutoTopology/data/EgRemoveComponentJson.jsp?'+removeUrl+'&mode='+mode+'&newsegment=false'+'&updateZone=false'+'&update=false';
			Ext.Ajax.request({
				url: removeUrl,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						var mypublicJSON = Ext.decode( jsonText );
						var removedComponents = mypublicJSON['removedComponentsArr'];
						var dontRemoveComponents = mypublicJSON['dontRemoveComponents'];
						if(dontRemoveComponents!=null && dontRemoveComponents.length>0)
						{
							Ext.Msg.alert("Segment",mypublicJSON['screenLabels']['admin.error.Error']);
						}
						else //if(removedComponents!=null && removedComponents.length>0)
						{
							Ext.Ajax.request({
								url: myServletUrl,
								method: 'POST',
								async: false,
								success: function( response )
								{
									if ( response.status == 200)
									{
										Ext.getCmp('topologyFrame').update('<iframe src="' + myJspUrl+ '" style="width:100%;height:100%;border:0px;" scrolling="no"></iframe>');
									}
								}
							});
						}
					}
				}
			});
		}
		var segmentType = publicJSON['segmentType'];
		if(segmentType=='manual')
		{
			getComboBoxDatas(mode,Segmentname,zoneName,"manual");
		}
		else if(segmentType=='auto')
		{
			getComboBoxDatas(mode,Segmentname,zoneName,"auto");
		}
	}});
}
function CreateGroup(href)
{
	myGroupUrl = href;
	Ext.widget('creategroup').show();
	var groupName = Ext.getCmp('GrpcompTypeCombo').getValue();
	Ext.Ajax.request({
			url: 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?'+href+'&index=group',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var myPublicJSON = Ext.decode( jsonText );
					//var otherSegment = myPublicJSON['otherSegment'];
					var newStatus = myPublicJSON['newStatus'];
					//if(otherSegment)
					//{
						//var OtherSegmentMessage =  myPublicJSON['screenLabels']['OtherSegmentMessage'];
						//Ext.getCmp('associatedToSegment').show();
						//Ext.getCmp('SegMsg').setText('<table><tr><td align="center" height="150"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+OtherSegmentMessage+'</td></tr></table></td></tr></table>',false);
					//}
					if(newStatus)
					{
						Ext.getCmp('UnManagedMsg').show();
						Ext.getCmp('redirectToManage').setText('<table><tr><td align="center" height="150"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconExclamation"></td></tr><tr><td class="commonErrorMsgText" align="center"><a href="#" class="eg_monlink" onClick="javascript:OpenManageDiv();"><b>Click here</b>&nbsp;<img src="/final/images/spacer.gif" class="iconRight" border="0"></a>to Add/Manage the component</td></tr></table></td></tr></table>',false);
					}
					else
					{
						Ext.getCmp('groupType').show();
						var radioValue = Ext.getCmp('new').getValue();
						if(radioValue==true)
							Ext.getCmp('groupName').show();
						else
							Ext.getCmp('groupCombo').show();
						Ext.getCmp('GrpcompTypeCombo').show();
						var groupComboobj = Ext.getCmp('groupCombo').getStore();
						groupComboobj.suspendEvents(true);
						groupComboobj.loadRawData(myPublicJSON['AllGroupNames']);
						groupComboobj.resumeEvents();
						Ext.getCmp('groupCombo').select(Ext.getCmp('groupCombo').getStore().getAt(0));
						var grpCompTypeComboobj = Ext.getCmp('GrpcompTypeCombo').getStore();
						grpCompTypeComboobj.suspendEvents(true);
						grpCompTypeComboobj.loadRawData(myPublicJSON['AllComponentTypes']);
						grpCompTypeComboobj.resumeEvents();
						Ext.getCmp('GrpcompTypeCombo').setValue(myPublicJSON['SelectedComponentType']);

						var combo = Ext.getCmp('GrpcompTypeCombo');
						var toselect = myPublicJSON['SelectedComponentType'];

						combo.select(toselect);
						var record = combo.getStore().findRecord('name', toselect);
						combo.fireEvent('select', combo, [record]);
					}
				}
			}
	});
}
function showRename()
{
	var frames;
	try{
		frames = window.frames;
	}catch(e){
		frames = document.frames;
	}
	var grpName = frames[0].document.getElementById("h_cmpName").value;
	Ext.widget('renamegroup').show();
	if(grpName.endsWith(":NULL"))
	{
		grpName = grpName.replace(":NULL","");
	}
	Ext.getCmp('currentname').setValue(grpName);
}
function OpenManageDiv()
{
	
	var frames;
	try{
		frames = window.frames;
	}catch(e){
		frames = document.frames;
	}
	var compstatus = frames[0].document.getElementById("h_status").value;
	var comptitle = frames[0].document.getElementById("h_title").value;
	var compsrc = frames[0].document.getElementById("h_src").value;
	var thissegment = frames[0].document.getElementById("segment").value;
	var thiszone = frames[0].document.getElementById("zone").value;
	var servertype = frames[0].document.getElementById('h_cmptype').value;

	var zoom = 100;
	//var frmcompname = comptitle;	
	//var servertype='';
	//if (compsrc.indexOf(".gif")>0)
		//servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
	//servertype = compsrc;
	var newServerUrl = "EgNewServer.jsp?server=new&from=inventory&compstatus="+ encodeURIComponent(compstatus)+"&serverType="+encodeURIComponent(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&frmPage=DiscSeg&comptitle="+encodeURIComponent(comptitle)+"&topoSegName="+encodeURIComponent(thissegment);

	var w ;
	if(!w){
		 w = new Ext.Window({
		 /*autoLoad: {
			url: newServerUrl,
//			params: {
//			  firstName: "Shuman", 
//			  lastName: "Human"
//			},
			scripts: true 
		  },*/
		  layout: 'fit',
		  title: 'Manage components',
		  id:'manageWindow',
		  listeners :{
			close:function(){
				Ext.Ajax.request({
					url: "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURIComponent(thissegment),
					method: 'POST'
				});
			}
		},
		  closeAction: 'destroy',
		  width:850,
		  padding:'5 10 10 10',
		  height:450,
		  border: false, 
		  html: '<iframe width="100%" src='+newServerUrl+' style="height:100%;border:0"></iframe>',
		});
	}
	w.show();
}
function showGroupDetails(thisGrpName)
{
	var thissegment = frames[0].document.getElementById("segment").value;
	var compName = frames[0].document.getElementById("h_cmpName").value;
	var compStatus = frames[0].document.getElementById("h_status").value;
	var compType = frames[0].document.getElementById("h_cmptype").value;
	var unmanagedCmpList = [];
	var newCmpList = [];
	Ext.widget('groupdetails').show();
	Ext.getCmp('GrpDetailsHeader').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+grpDetailsMsg+" ("+'<b>'+thisGrpName+'</b>'+")"+'</center>');
	var url = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(thisGrpName)+"&segment="+encodeURIComponent(thissegment)+"&compName="+encodeURIComponent(compName)+"&compStatus="+compStatus;
	Ext.Ajax.request({
		url: url,
		method: 'POST',
		async: false,
		success: function(response)
		{
			if ( response.status == 200 && !Ext.isEmpty(response.responseText))
			{
				var jsonText = response.responseText;
				var mypublicJSON = Ext.decode( jsonText );
				var manageBtnDis = mypublicJSON['manageBtnDis'];
				var GrpDetailsDisplayobj = Ext.getCmp('GrpDetailsDisplay').getStore();
				GrpDetailsDisplayobj.suspendEvents(true);
				GrpDetailsDisplayobj.loadRawData(mypublicJSON['GroupDetails']);
				GrpDetailsDisplayobj.resumeEvents();
				GrpDetailsDisplayobj.each(function(rec)
				{
					var compstatus = rec.get('compstatus');//* or # 192.168.11.9:1494
					if(compstatus.startsWith("#"))
					{
						unmanagedCmpList.push(compstatus);
					}
					else if(compstatus.startsWith("*"))
					{
						newCmpList.push(compstatus);
					}
				});
				if(unmanagedCmpList.length<=0)
				{
						Ext.getCmp('unmanagemsg').hide();
				}
				if(newCmpList.length<=0)
				{
						Ext.getCmp('discmsg').hide();
				}
				if(newCmpList.length<=0 && unmanagedCmpList.length<=0)
				{
					Ext.getCmp('emptytxt').show();
				}
				if(manageBtnDis == 'disablebtn')
				{
						Ext.getCmp('addBtn').setDisabled(true);
				}
			}
		}
	});
}
function UnGroupFunction(myUrl,url,jsonurl)
{
	var enableDrag = 'false';
	myUrl = myUrl+"&enableDrag="+encodeURIComponent(enableDrag)+'&index=main&com.eg.CSRF_NONCE='+csrfToken;
	Ext.Ajax.request({
		url: url,
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonText = response.responseText;
				var mypublicJSON = Ext.decode( jsonText );
				if(mypublicJSON['isallowForUngroup'] == true)
				{
					Ext.Ajax.request({
					url: jsonurl,
					method: 'POST',
					async: false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
							{
								var jsonText1 = response.responseText;
								var mypublicJSON1 = Ext.decode( jsonText );
								Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
								
								
							}
						},
						failure: function(response)
						{
							Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
						}
					});
				}
				else
				{
					Ext.Msg.alert("Segment",mypublicJSON['screenLabels']['admin.error.Error']);
				}
				
			}
		}
	});
}
function manageGrpFunction(url,myUrl)
{
	var thissegment = frames[0].document.getElementById("segment").value;
	var enableDrag = 'false';
	url = url+"&enableDrag="+encodeURIComponent(enableDrag)+'&index=main&com.eg.CSRF_NONCE='+csrfToken;
	myUrl = myUrl+"&enableDrag="+encodeURIComponent(enableDrag)+'&index=main&com.eg.CSRF_NONCE='+csrfToken;
	Ext.Ajax.request({
		url: url,
		method: 'POST',
		async: false,
		success: function( response )
		{
			if (response.status == 200 && !Ext.isEmpty(response.responseText))
			{
				var jsonText = response.responseText;
				var mypublicJSON = Ext.decode( jsonText);
				var status = mypublicJSON['status'];
				var grpStatus = mypublicJSON['grpStatus'];
				var grpStatusMsg = mypublicJSON['grpStatusMsg'];
				if(grpStatusMsg.indexOf(":")>-1)
				{
					grpStatusMsg = grpStatusMsg.substring(grpStatusMsg.indexOf(":")+1);
				}
				var filePath = mypublicJSON['filePath'];
				if(status != 'eG_CLI_0030')
				{
						Ext.Msg.show({
						title: pageTitle,
						msg: compErrMsg1 + "<br>" + compErrMsg2 + "<br>" + filePath,
						buttons: Ext.Msg.OK,
						icon: "iconExclamation"
						});
				}
				else if(grpStatus !="eG_CLI_Res_0323")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : grpStatusMsg,
						buttons : Ext.Msg.OK,
						icon : 'iconExclamation'
					});
				}
				else if(grpStatus =="eG_CLI_Res_0323")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : grpStatusMsg,
						buttons : Ext.Msg.OK,
						icon : 'iconInformation'
					});
					//Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="yes"></iframe>');
				}
				//else
				//{
					Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:100%;height:100%;border:0px" scrolling="no"></iframe>');
				//}
			}
		}
	});
}
function checkspace(newName)
{
	var s_val = newName;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			Ext.MessageBox.alert(pageTitle,lblNoSpace);
			return false;
		}
	}
	return true;
}
function checkspecial_(newName,s_spl)
{
	var obj_val = newName;
	for(var i=0; i<obj_val.length; i++)
	{
		var check_char = s_spl.indexOf(obj_val.charAt(i))
		if(check_char >= 0)
		{
			Ext.MessageBox.alert(pageTitle,lblNoSplChar);
			return false;
		}
	}
	return true;
}
function validateSingleByte(newName)
{
	for(var i=0;i<newName.length;i++)
	{
		var charValue=tempVal.charCodeAt(i);
		if(charValue>255)
			return false;
	}
	return true;
}
function closedManagedWindow()
{
	appCnt.refreshPage();
	var windowObj = Ext.getCmp('manageWindow');
	if (windowObj != null && windowObj != undefined)
	{
		windowObj.destroy();
	}
}



