Ext.define('AutoTopology.view.ComponentSegment', {
	extend: 'Ext.form.Panel',
	alias: 'widget.componentsegment',
	id: 'componentsegment',
	requires:[
		'Ext.ux.OptGroupItemSelectorRv',
		'utilities.ScrollCombo'
	],
	cls:'outerpanel',
	title: '',
	id:'topologyOuterPanal',
	header:{cls:'textUpper'},
	margin:'8 8 0 8',
	layout:{
		type:'vbox',
		align:'stretch'
	},
	scroll: true,
	autoScroll: true,
	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' '
	},
	items: [
		{
			xtype: 'component',
			html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+configPageDesc+"."+"</center>",
			cls:'adminHeadInfoText',
			height: 25,
			border:true,
			padding: 3
		},
		{
			xtype: 'textfield',
			cls:'textbox',
			name: 'segmentName',
			id: 'segmentName',
			fieldLabel: Segmentname,
			labelStyle: 'white-space: nowrap;',
			hidden:true,
			maxLength:32,
			enforceMaxLength:true,
			//readOnly: true,
			margin: '0 0 0 50',
			listeners: {
				change: function( me, newValue, oldValue, eOpts )
				{
					if(newValue.length > 0)
					{
						Ext.getCmp('manageall').enable();
						Ext.getCmp('savetopo').enable();
						Ext.getCmp('clearall').enable();
					}
					else
					{
						Ext.getCmp('manageall').disable();
						Ext.getCmp('savetopo').disable();
						Ext.getCmp('clearall').disable();
					}
				}
			}
		},
		{
			xtype:'panel',
			cls:'datapanel',
			title:'',
			flex:1,
			layout: 'fit',
			id:'topologyPanel',
			margin: 10,

			dockedItems: [
				{
					dock: 'top',
					layout: {
						type:'hbox',
						pack:'start'
					},
					margin: 5,
					border: false,
					items: [
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: startCompType,
							id:'compTypeCombo',
							name:'compTypeCombo',
							displayField:'displayField',
							valueField:'valueField',
							queryMode: 'local',
							emptyText:'--Select--',
							parent:this,
							selectOnFocus:true,
							labelStyle: 'white-space: nowrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: startComp,
							id:'componentsList',
							name:'componentsList',
							displayField:'displayField',
							valueField:'valueField',
							queryMode: 'local',
							emptyText:'--Select--',
							parent:this,
							margin: '0 0 0 50',
							selectOnFocus:true,
							labelStyle: 'white-space: nowrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							margin: '0 0 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls:'imagecombo',
							store:new Ext.data.Store({
								fields: ['abbr','name'],
								data: []
							}),
							id:'imagecombo',
							name:'imagecombo',
							displayField:'name',
							valueField:'abbr',
							queryMode: 'local',
							editable: false,
							typeAhead: false,
							editable:false,
							fieldLabel: imagecombo,
							tpl: Ext.create('Ext.XTemplate',
								'<ul>',
								'<tpl for=".">',
								 '<li class="x-boundlist-item"><img  src="/final/images/clear.png" style="vertical-align:middle;display:inline-block;" class={abbr} />{name}</li>',
								'</tpl>',
								'</ul>'
							),
							listeners:{
									select:function(combo, records, eOpts){
									var record = records[0];
									var image = record.get('abbr');
									cls = image;
									if(image){
										$('#'+combo.inputEl.id).removeClass().addClass(cls);
									}
								}
							},
							margin: '0 0 0 5'
						},
						{
							xtype: 'tbfill'
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							margin: '18 0 0 0',
							items:[
								{
									xtype: 'button',
									cls:'button20',
									text: manageall,
									id: 'manageall'
								},
								{
									xtype: 'button',
									cls:'button20',
									text: savetopo,
									id: 'savetopo'
								},
								{
									xtype: 'button',
									cls:'button20',
									text: clearall,
									id: 'clearall'
								},
								{
									xtype: 'tbseparator',
									margin: '0 4 0 0'
								},
								{
									xtype: 'button',
									iconCls: 'iconAutofit',
									itemId:'iconAutofit',
									id: 'iconAutofit',
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'Fit'
										});
									}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								},
								{
									xtype: 'tbseparator',
									margin: '0 4 0 0',
									hidden:true
								},
								{
									xtype: 'button',
									iconCls: 'iconMaximize',
									itemId:'iconMaximize',
									id: 'iconMaximize',
									hidden:true,
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'New Window'
										});
									}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}
							]
						}
					]
				}
			],

			items : [
				{
					xtype: "component",
					id:'topologyFrame',
					name:'topologyFrame',
					//constrain : true,
					height: '100%',
					//layout: 'fit',
					//html: '',
					html: '',
					margin: '0 5 5 5'
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'backbutton',
			text : backBtn
		}
	]

});



