Ext.define('AutoTopology.view.ComponentSegments', {
	//extend: 'Ext.form.Panel',
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.componentsegments',
	id: 'mainComponentSegments',
	cls:'outerpanel',
	title: mainPageTitle,
	header:{cls:'textUpper'},
	margin:'8 8 0 8',

	layout : {
		type : 'vbox',
		align : 'stretch'
	},

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'utilities.CustomGrid',
		'AutoTopology.view.Mywindow'
	],

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		height: 25,
		border:true,
		padding: 3,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+pageDescc+'.</center>'
			}
		]
	}],

	items: [
		{
			xtype: 'container',
			layout: 'hbox',
			margin: '10 10 0 0',
			items:[
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'component',
					id: 'activeStatus',
					html: ''
				}
			]
		},
		{
			xtype: 'container',
			id: 'NoExtPresent',
			hidden:true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noSegmentMsg+'.</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'customgrid',
			autoScroll: true,
			scroll: true,
			flex : 1,
			cls:'gridSkin',
			id: 'gridDisplay',
			plugins: [Ext.create("Ext.grid.plugin.CellEditing",
			{
				pluginId: "applicationPorts",
				clicksToEdit : 1,
				autoCancel: false
			})],
			store:new Ext.data.Store(
			{
				fields: ["nameTopology","description_id","type","keycomponents","actions"],
				data: []
			}),
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText" id="searchID">'+noTopologyMsg+'.</div></td></tr></table>',
			margin: 10,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text:"Type",
						dataIndex:"type",
						flex:1,
						minWidth:200,
						renderer:function(d) 
						{
							if(d!=null || d != "-")
							{
								var dlen1;
								var dlen2;
								var a;
								if(d.length > 26)
								{
									dlen1 = d.substring(0,26);
									dlen2 = d.substring(26,d.length);
								}
								else
								{
									dlen1 = d;
									dlen2 = "";
								}
								if(dlen1 != undefined)
								{
									 a = "<span style='float:left;text-align:left;width:90'>"+dlen1+"</span><span style='float:left;text-align:left;width:90'>"+dlen2+"</span>";
								}
								else
								{
									dlen1 = "-";
									dlen2 = "";
									a = "<span style='float:left;text-align:left;width:90'>"+dlen1+"</span><span style='float:left;text-align:left;width:90'>"+dlen2+"</span>";
								}
								return a;
							}
						}
					},
					{
						text: 'DISCOVERED SEGMENT NAME',
						dataIndex: 'nameTopology',
						flex:1,
						minWidth:200,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							return '<div><div style="width:0px" onmouseover="javascript:appCnt.showPopupWindow('+row+')"  >'+value+'</div></div>';//onmouseout="javascript:appCnt.hidePopupWindow('+row+')"
						}
					},
					{
						text:"Description",
						dataIndex:"description_id",
						id:"desc_id",
						flex:2,
						sortable: true,
						editor: 
						{
							xtype: 'textareafield',
							cls : 'text-area',
							grow: true,
							id:'editortext',
							flex:1,
							emptyText: descMsg,
							listeners: 
							{
								'change': function(field, newVal, oldVal, e)
									{
										appCnt.updateSegments(newVal);
									},
									focus:function() {
										var val = Ext.getCmp('editortext').getValue();
										if(val == descMsg)
										{
											Ext.getCmp("editortext").setValue("");
										}
									}
							}
						},
						renderer:function(d, meta, rec, rowIndex, colIndex, store) 
						{
							if(d == '')
							{
								d = descMsg;
							}
							if(d!=null) 
							{
								var a="<table  cellpadding='0' cellspacing='0' width='103%' border='0px solid black'>";
								a = a+"<style>.x-grid-cell-outer { white-space: normal; line-height:18px;}</style>";
								a = a+"<tr><td class='x-grid-cell-outer x-grid-column-font'>"+d+"</td></tr>";
								a=a+"</table>";
								return a;
							}
						}
					},
					{
						text:"<style>.div2 {white-space: nowrap; width:120%; overflow:visible; text-overflow: ellipsis; display: inline-block;}</style><div width:100%><tr><td class='x-grid-column-font div2'><span style='float:left;text-align:left;width:45%'>Key Type</span><span style='float:right;text-align:left;width:55%'>Components</span></td></tr></div></table>",
						dataIndex:"keycomponents",
						flex:2 ,menuDisabled:true,
						renderer:function(d) 
						{
							if(d!=null&&d.indexOf("|$|")!=-1) 
							{
								var b=d.split("|$|");
								var a="<table>";
								a = a+"<style>.div2 {white-space: nowrap; width:180px; overflow:visible; text-overflow: ellipsis; display: inline-block;}</style>";
								var blen = b.length;
								if(blen == 4)
								{
									blen = blen - 1;
								}
								for(var c=0; c<blen; c++) 
								{
									var compType = b[c].substring(0,b[c].indexOf(":"));
									if(compType.length > 30)
									{
										compType = compType.substring(0,28) + "..";
									}
									var compName = b[c].substring(b[c].indexOf(":")+1);
									a=a+"<tr><td class='x-grid-column-font div2'><span style='float:left;text-align:left;width:100%'>"+compType+"</span><span style='float:right;text-align:left;width:0%'>"+compName+"</span></td></tr>";
								}
								a=a+"</table>";
								return a;
							}
							else 
							{
								return d;
							}
						}
					},
//					{
//						xtype: 'actioncolumn',
//						width: 24,
//						id: 'DeleteOver',
//						iconCls: 'iconRename',
//						sortable: false,
//						renderer: function(value, metaData, record, row, col, store, gridView)
//						{
//							metaData.tdAttr = "data-qtip='Preview' data-qclass='yellowTip'";
//						},
//						handler: function(grid, rowIndex, colIndex) 
//						{
//							var records = grid.getStore().getAt(rowIndex);
//							var url=records.get('actions');
//							var temp = url.split("&^&");
//							var topo = records.get('nameTopology');
//							Ext.widget('mypopwindow').show();
//							var obj = Ext.select('#frameId');
//							obj.set({ src: temp[0] });
//							Ext.getCmp('previewWindow').setTitle('Preview for '+topo);
//						}
//					},
					{
						xtype: 'actioncolumn',
						width: 36,
						id: 'EditOver',
						iconCls: 'iconModify',
						tooltip: 'Modify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var topoName = grid.getStore().getAt(rowIndex).data.nameTopology;
							appCnt.addSegment(topoName);
							appCnt.modifyTopology(topoName);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						id: 'RenameOver',
						iconCls: 'iconSave',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var records = grid.getStore().getAt(rowIndex);
							var url=records.get('actions');
							if(url.indexOf("&^&")>0)
							{
								var temp = url.split("&^&");
								appCnt.gridCreate(temp[2],records.get('nameTopology')); 
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Save' data-qclass='yellowTip'";
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					id: 'gridSearch',
					name: 'gridSearch',
					emptyText: 'Search',
					padding: '2 6 2 0',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) 
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					}
				}
			]
		}
	]
});



