Ext.define('AutoTopology.view.UsesConnectsWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.usesConnects',
	id : 'usesConnects',
	requires:['utilities.ScrollCombo','utilities.CustomGrid'],
	title: 'Uses',
	width: 300,
	height: 360, 
	modal: true,
	closeAction: 'destroy',

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'left',
				pack: 'center'
			},
			defaults: {
				width: 265,
				labelAlign: 'top',
				labelSeparator: ''
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id:'typeOfComp',
					name:'typeOfComp',
					displayField:'displayField',
					valueField:'valueField',
					queryMode: 'local',
					emptyText:'--Select--',
					parent:this,
					editable:false,
					labelStyle: 'white-space: nowrap;',
					store: ['Managed Components','Discovered Components','Unmanaged Components',"Managed Groups","Discovered Groups"],
					defaultValue: 'Managed Components',
					margin: '10 0 0 10'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id:'startcompTypeCombo',
					name:'startcompTypeCombo',
					displayField:'displayField',
					valueField:'valueField',
					queryMode: 'local',
					emptyText:'--Select--',
					parent:this,
					editable:false,
					labelStyle: 'white-space: nowrap;',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					margin: '5 0 0 10'
				},
				{
					xtype: 'container',
					id: 'NoComponentPresent',
					hidden:true,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					items: [
						{
							xtype: 'label',
							html: '<table><tr><td align="center" height="180"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoCompMsg+'.</td></tr></table></td></tr></table>'
						}
					]
				},
				{
					xtype: 'container',
					id: 'NoGroupPresent',
					hidden:true,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					items: [
						{
							xtype: 'label',
							html: '<table><tr><td align="center" height="180"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoGrpMsg+'.</td></tr></table></td></tr></table>'
						}
					]
				}
			]
		},
		{
			xtype : 'container',
			id : 'componentPreviewCt'
		},
		{
			xtype : 'container',
			id : 'grpRenameCt'
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align:'center'
			},
			margin: '10 0 10 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					id:'UpdateTopo',
					name:'UpdateTopo',
					text: btnUpdate,
				}
			]
		}
	]
});

