Ext.define('BTMProfilerDownload.controller.Main',{
	extend:'Ext.app.Controller',

	views:['BTMJars','BTMJar'],
	requires : ['BTMProfilerDownload.view.BTMJar'],

	refs:[
		{selector:'btmjars', ref:'btmjars'},
		{selector:'btmjar', ref:'btmjar'},
	],

	init:function(){
		appRmtCnt = this;
		this.buildMainData()

		this.control({
			'btmjars': {
				'afterrender': this.afterMainRender
			},
			'btmjars trigger[name="gridRmtSearch"]': {
				'change': this.mainGridSearch
			},
			'btmjar button[id="updateBtn"]': {
				'click' : this.addUpdate
			},
			'assignremoteagent button[id="backbutton"]': {
				'click': this.backbutton
			},
			'deleterumcollector trigger[name="agentsearch"]': {
				'change': this.mainFormEvent
			},
		});
	},
	buildMainData: function(){
		Ext.Ajax.request({
			url: 'BTMProfilerDownload/data/EgDispBtmComponentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					
				}
			}
		});
	},

	handleDownloadIconClick: function(gridView, rowIndex, colIndex){
		
		var DispValues = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var apmType = DispValues.get('APMName');
		var compName = DispValues.get('CompNickName');
		var compType = DispValues.get('compType');
		var port = DispValues.get('comPort');
		var hostIP = DispValues.get('hostIP');
		var agentIP = DispValues.get('agentIP');
		var appname = DispValues.get('appName');
		var tierName = DispValues.get('tierName');
		var monitoring = DispValues.get('monitoring');
		this.downloadTask(apmType,compName,port,agentIP,monitoring,appname,tierName,hostIP,compType);
	},

	handleEditIconClick: function(gridView, rowIndex, colIndex){
		btnText = 'Change RUM';
		var rec = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var CompName = rec.get('CompNickName');
		var rumUrl = rec.get('hostIP');
		var compPort = rec.get('comPort');
		var comAppName = rec.get('appName');
		var comTierName = rec.get('tierName');
		var compType1 = rec.get('compType');
		this.showEditWindow(CompName,comAppName,compPort,comTierName,compType1);
	},

	showEditWindow: function(CompName,comAppName,compPort,comTierName,compType1){

		Ext.widget('btmjar').show();
		Ext.getCmp('AppName').setFieldLabel('Application Name');
		Ext.getCmp('AppName').setValue(comAppName);
		Ext.getCmp('tierName').setFieldLabel('Tier Name');
		Ext.getCmp('tierName').setValue(comTierName);
		Ext.getCmp('compType').setValue(compType1);
		Ext.getCmp('compName').setValue(CompName);
		Ext.getCmp('compPort').setValue(compPort);
		Ext.getCmp('updateBtn').setText('Update');
		Ext.getCmp('AddModRmtView').setTitle(rmtModPageTitle);
		Ext.getCmp('interLinkYes').setValue(true);	
		// Ext.getCmp('hostIP').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Data Collector URL']);
		// Ext.getCmp('CompNickName').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Host/Nick Name']);
		// alert('comAppName : '+comAppName);
		// alert('comTierName : '+comTierName);

	},
	downloadTask: function(apmType,compName,port,agentIP,monitoring,appname,tierName,hostIP,compType){
		// alert('appname- '+appname)
		// alert('apmType -'+apmType)
		// alert('compName- '+compName)
		// alert('port- '+port)
		// alert('hostIP- '+hostIP)
		// alert('monitoring- '+monitoring)
		// alert('tierName- '+tierName)
		var serverType = compName+"_"+port;
		var form = document.createElement("form");
		var qrString = "&apmType="+encodeURIComponent(apmType)+"&compIp="+encodeURIComponent(hostIP)+"&compName="+encodeURIComponent(compName)+"&port="+encodeURIComponent(port)+"&agentIP="+encodeURIComponent(agentIP)+"&monitoring="+encodeURIComponent(monitoring)+"&appName="+encodeURIComponent(appname)+"&tierName="+encodeURIComponent(tierName)+"&Stype="+encodeURIComponent(serverType)+"&BTM="+encodeURIComponent("true")+"&compType="+encodeURIComponent(compType);
		form.setAttribute("method", "post");
		form.setAttribute("action", "/final/servlet/com.eg.ProfilerScriptDownloader?"+qrString);
		document.body.appendChild(form);
		form.submit();
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridRmtSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request({
		url: 'BTMProfilerDownload/data/EgDispBtmComponentsJson.jsp?egTitleSearchStr='+gridsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['gridRmtAgents'];
			Ext.getCmp('gridRmtDisplay').show();
			Ext.getCmp('associateDissociate').enable();
			Ext.getCmp('deleteJar').enable();
			if (value != null && value.length > 0)
			{
				Ext.getCmp('gridRmtDisplay').store.loadData(publicJSON['gridRmtAgents']);
			}
			else
			{
				Ext.getCmp('gridRmtDisplay').store.loadData('');
				Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+','+"'"+gridsearch+"'"+'</td></tr></table></td></tr></table>';
				Ext.getCmp('gridRmtDisplay').getView().refresh();
			}
		}
		});
	},
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	validationForAddModify: function(){
		var appname = Ext.getCmp('AppName').getValue();
		var tierName = Ext.getCmp('tierName').getValue();
		

		if(appname!=null && appname=='')
		{
			Ext.Msg.alert("Agent Jar Download","Please Enter Application name");
			Ext.getCmp('AppName').focus(true);
			return false;
		}
		else if(!checkblank(appname))
		{
			Ext.Msg.alert("Agent Jar Download","Please Enter Application name");;
			Ext.getCmp('AppName').focus(true);
			return false;
		}	
		else if(tierName!=null && tierName=='')
		{
			Ext.Msg.alert("Agent Jar Download","Please Enter Tier name ");
			Ext.getCmp('tierName').focus(true);
			return false;
		}
		else if(!checkblank(tierName))
		{
			Ext.Msg.alert("Agent Jar Download","Please Enter Tier name ");;
			Ext.getCmp('tierName').focus(true);
			return false;
		}
		else
		{
			return true;
		}
	},
	backbutton: function(){
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'btmjars'});
		this.afterMainRender();
	},


	mainFormEvent : function(obj){
		this.getController('BTMProfilerDownload.controller.DeleteRumCtrl').buildDeleteFieldData();
		var compsearch = Ext.getCmp('agentsearch').getValue();
		if (compsearch == "" || compsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		
		Ext.Ajax.request({
		url: 'BTMProfilerDownload/data/DeleteRUMCollectorsJson.jsp?compsearch='+compsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['searchArr'];
			if (value != null && value.length > 0)
			{
				Ext.getCmp('agents').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('rmtTitleLblId').show();
				Ext.getCmp('NoDelSearchFound').hide();
				Ext.getCmp('agents').getStore().loadRawData(publicJSON['searchArr']);
			}
			else
			{
				Ext.getCmp('agents').hide();
				Ext.getCmp('deleteBtn').hide();
				Ext.getCmp('rmtTitleLblId').hide();
				Ext.getCmp('NoDelSearchFound').show();
				Ext.getCmp('DelSearch').update('<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+','+"'"+compsearch+"'"+'</td></tr></table></td></tr></table>');
			}
		}
		});
	},
	backDelButton: function(btn){
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'btmjars'});
		this.afterMainRender();
	},
	afterMainRender : function(){
		var resultsData = publicJSON['gridRmtAgents'];
		console.log('',resultsData);
		if (resultsData == null || resultsData.length == 0)
		{
			Ext.getCmp('associateDissociate').disable();
			Ext.getCmp('deleteJar').disable();
			Ext.getCmp('gridRmtDisplay').store.loadData('');
			Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtDesc+'</td></tr></table></td></tr></table>';
			Ext.getCmp('gridRmtDisplay').getView().refresh();
		}
		else
		{
			Ext.getCmp('associateDissociate').enable();
			Ext.getCmp('deleteJar').enable();
			Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
		}
		var noRmtFound = publicJSON['NoRmtFound'];
		if (noRmtFound == "true")
		{
			Ext.getCmp('gridRmtSearch').disable();
		}
		else
		{
			Ext.getCmp('gridRmtSearch').enable();
		}
	},
		addUpdate : function(btn){
		var me = this;
		var appname = Ext.getCmp('AppName').getValue();
		var tierName = Ext.getCmp('tierName').getValue();
		var compType = Ext.getCmp('compType').getValue();
		var compName = Ext.getCmp('compName').getValue();
		var compPort = Ext.getCmp('compPort').getValue();
		var interLinkFlag = Ext.getCmp('interLinkYes').getValue();
		var updateInterLinkComp = 'Yes';
		if(!interLinkFlag)
		{
			updateInterLinkComp = 'No';
		}
		var compNameWithPort = compName+":"+compPort
		// alert(compNameWithPort);
		
		var mode= '';
		if (btnText == 'Add New Collector')
		{
			mode = 'add';
		}
		else
		{
			mode = 'modifyUrl';
		}
		var me = this;
		var checkAppValidation =  this.specialCharacterCheck(appname);
		var checkTierValidation = this.specialCharacterCheck(tierName);
		var qstring = "appName="+appname+"&tierName="+tierName+"&compType="+compType+"&compName="+compName+"&compNameWithPort="+compNameWithPort+"&updateInterLinkComp="+updateInterLinkComp;
		// alert(qstring);
		
		if(checkAppValidation)
		{
			Ext.Msg.alert("Profiler Download","Special characters not allowed");;
			Ext.getCmp('AppName').focus();
		}
		if(checkTierValidation)
		{
			Ext.Msg.alert("Profiler Download","Special characters not allowed");;
			Ext.getCmp('tierName').focus();
		}
		 if (!checkAppValidation && !checkTierValidation)
		 {
			Ext.Ajax.request({
				url: 'BTMProfilerDownload/data/EgBtmAppNameUpdate.jsp?'+qstring,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
				});
				Ext.getCmp('AddModRmtView').destroy();
				me.buildMainData();
				me.afterMainRender();
		 }
		
		/* if (checkValidation)
		{
			var rumUrl = Ext.getCmp('hostIP').getValue();
			var rumPrivateUrl = Ext.getCmp('comPort').getValue();

			var hostname = Ext.getCmp('CompNickName').getValue();
			
			var appname = Ext.getCmp('AppName').getValue();
			var tierName = Ext.getCmp('tierName').getValue();
			
			//var qrString =mode+"&rumUrl="+rumUrl+"&hostname="+hostname+"&rumPrivateUrl="+rumPrivateUrl;
			var qrString =mode+"&rumUrl="+encodeURIComponent(rumUrl)+"&hostname="+hostname+"&rumPrivateUrl="+encodeURIComponent(rumPrivateUrl);
			Ext.Ajax.request({
			url: 'BTMProfilerDownload/data/EgBtmComponentsJson.jsp?mode='+qrString,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success")
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1'],
						function(btn){
							Ext.getCmp('AddModRmtView').destroy();
							if(mode=='modifyUrl')
							{
								if(rumCollectorUrl!=rumUrl)
								{
									
									Ext.Msg.alert('RUM Data Collector','The RUM Data Collector URL has been modified. Please download the agent files from the modified components and deploy it in the corresponding applications.');
									rumCollectorUrl=rumUrl;
								}
								
							}
						});
						
						
					}
					else
					{
						
						var errorStatus = publicJSON['error'];
						Ext.MessageBox.alert(errorStatus['title'],errorStatus['message1']+errorStatus['message2'],
							function(btn){
								Ext.getCmp('AddModRmtView').destroy();
						});

						
					}
					me.buildMainData();
					var resultsData = publicJSON['gridRmtAgents'];
					Ext.getCmp('gridRmtSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					Ext.getCmp('deleteJar').enable();

					Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridRmtSearch').setRawValue('text me');
				}
			}
		});
		} */
	}
});
