var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		if(record.get('isDisabled'))
		{
			meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
			return '<div class="iconLock" style="position:relative;left:-5px">&#160;</div>';
		}
		else
		{
			meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
			if (record.get('isDisabled')){
				Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
			}
			else {
				Ext.getCmp('gridRmtDisplay').getSelectionModel().select(rowIndex, true);
			}
			rowIndex++;
		}
		var view = Ext.getCmp('gridRmtDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
			Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.getCmp('gridRmtDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('BTMProfilerDownload.view.BTMJars', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.btmjars',
	id: 'mainBTMJars',

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
	],
	title: rmtPageTitle,
	margin:'8 8 0 8',
	cls:'outerpanel',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	/*dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		items: [
			
		]
	}],*/

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+jarPageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			layout:'hbox',
			//padding:3,
			margin:'10 10 0 10',
			items:[
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					id: 'gridRmtSearch',
					name: 'gridRmtSearch',
					emptyText: 'Search',
					margin: '1 5 1 3',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
				 
					   // TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
					   // single triggerCls config. Should rethink this, perhaps something more structured like a list of
					   // trigger config objects that hold cls, handler, etc.
					   // triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
						me.trigger1Cls = me.triggerCls;
						}
					 
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appRmtCnt.mainGridSearch();
					},
					hidden:true,
				},
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'button',
					cls:'button20',
					margin:'0 5',
					text: lbl_AddJar,
					id: 'addRumCollector',
					hidden:true,
					disabled:true
				},
				{
					xtype: 'button',
					cls:'button20',
					margin:'0 5',
					text: lbl_AssHost,
					id: 'associateDissociate',
					hidden:true,
					disabled:true
				},
				{
					xtype: 'button',
					cls:'button20',
					margin:'0 5',
					text: lbl_DelJar,
					id: 'deleteJar',
					hidden:true,
					disabled:true,
					listeners: {
						"afterrender":function()
						{
							Ext.create("Ext.tip.ToolTip",{target:this.id,anchor:"top",cls:"yellowTip",trackMouse:true,html:lbl_DelToolAgnt});
						}
					}
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			scroll: true,
			id: 'gridRmtDisplay',
			store:new Ext.data.Store({
				fields: ['APMName','monitoring','appName','tierName','compType','offloadMode','CompNickName','hostIP','comPort','agentIP','AssoDissRemAgnt','internalRemAgent','isDisabled'],
				data: []
			}),
			autoScroll: true,
			flex: 1,

			// selModel:mySelectionModel,
			listeners : {
				beforeselect: function(selModel, record, index) {
					if (record.get('isDisabled')) {
						 return false;  
					}
				},
				rowclick : function (in_this, rowIndex, e) {
					var record = in_this.getStore().getAt(rowIndex);
					if (record.get('isDisabled')){
						in_this.getSelectionModel().deselectRow(rowIndex);
					}
				}
			},
			// hidden:true,
			// disabled:true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+'</td></tr></table></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: true,
					resizable: true
				},
				items: [
					{
						text: "APM TYPE",
						dataIndex: 'APMName',
						id: 'DispAPMName',
						flex: 0.5,
					},	
					{
						text: "Component Type",
						dataIndex: 'compType',
						id: 'DispCompType',
						flex: 0.5,
						// hidden:true
					},
					{
						text: "Nick Name",
						dataIndex: 'CompNickName',
						id: 'DispCompNickName',
						flex: 0.7
					},
					{
						text: "Host name/IP",
						dataIndex: 'hostIP',
						id: 'DispHostIP',
						flex: 0.5,
						// width: 200
					},					
					{
						text: 'Host Port',
						dataIndex: 'comPort',
						id: 'DispComPort',
						flex: 0.5,
						// width: 200
					},
					{
						text: "Agent IP",
						dataIndex: 'agentIP',
						id: 'DispAgentIP',
						flex: 0.5,
						// width: 200
					},
					{
						text: "Monitoring",
						dataIndex: 'monitoring',
						id: 'DispMonitoring',
						flex: 0.5,
					},
					{
						text: "Application Name",
						dataIndex: 'appName',
						id: 'DispappName',
						flex: 0.5,
						hidden:true
					},
					{
						text: "Tier Name",
						dataIndex: 'tierName',
						id: 'DispTierName',
						flex: 0.5,
						hidden:true
					},
					{
						hidden:true,
						// header : '<div class="iconHelp3" data-qtip="Optional: Specifiy Application name & Tier name to corresponding components" data-qclass="yellowTip"></div>',
						header : '<div class="iconTooltipHelp" data-qtip="Optional: Specifiy Application name & Tier name to corresponding components" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						// width: 35,
						flex: 0.2,
						id: 'EditRmtOver',
						sortable: false,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
							var hostName = record.get('CompNickName');
							return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconModify'></div>";
						}
					},
					{
						// header : '<div class="iconDeleteAll" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						// width: 200,
						flex: 0.2,
						id: 'download',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appRmtCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Download' data-qclass='yellowTip'";
							return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleDownloadIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDownload'></div>";
						}
					}
				]
			},
			margin: 10
		}
	]

});



