
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "egurkha.EgTestParamBean" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	_user.getUserPreferences();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	EgMappingInfo mapping = new EgMappingInfo(userLanguage);
	
	String printThis = new Date()+" EgDispBtmComponentsJson.jsp - BTM jar download :";
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr!=null && egTitleSearchStr!="");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	JSONArray gridRumCollectors = new JSONArray();
	JSONObject gridObject = new JSONObject();
	
try {
		EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(), (String) session.getAttribute("sess_userid"));
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		egSpecs.checkForUpdate();
		egExternalInfo.checkForUpdate();
		ArrayList<String> btmComponents = egSpecs.getAllComponentTypesForTest("BusinessTransTest");
		for (int b = 0; b < btmComponents.size(); b++) {

			String strServer = btmComponents.get(b);
			if (strServer == null || strServer.equalsIgnoreCase("null"))
				strServer = "";
			String temp = "";
			String[] serversArray = roleInfo.getAllServersOfType(strServer);
			ArrayList servers = serversArray == null ? new ArrayList()
					: new ArrayList(Arrays.asList(serversArray));
			if (servers == null || servers.size() <= 0) {
				//System.out.println(printThis +" No servers found for >>>>"+strServer);
				continue;
			}

			boolean serversFound = false;
			List minusList = new ArrayList();
			for (int j = 0; j < servers.size(); j++) {
				String thisSrv = (String) servers.get(j);
				if (thisSrv.startsWith("Format:") || thisSrv.startsWith("#")) {
					minusList.add(thisSrv);
					continue;
				}
				temp = thisSrv.substring(thisSrv.indexOf(":") + 1);
				if (temp.indexOf(":") != temp.lastIndexOf(":")) {
					temp = temp.substring(0, temp.lastIndexOf(":"));
				}

				String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);
				if (isSearchResult && !doesExist(searchList, ipWithoutPort)) {
					minusList.add(thisSrv);
					continue;
				}
				serversFound = true;
			}
			servers.removeAll(minusList);
			Collections.sort(servers, String.CASE_INSENSITIVE_ORDER);
			Vector vecStore = new Vector();
			String[] extTypes = egSpecs.getAllExternalServerTypes();
			List extCompTypes = new ArrayList();
			if (extTypes != null) {
				extCompTypes = new ArrayList(Arrays.asList(extTypes));
			}
			if (!strServer.equals("null") && servers.size() > 0) {
				IniFile apmIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()
							+ "/manager/config/eg_apm.ini",true);
				for (int j = 0; j < servers.size(); j++) {
					String thisSrv = (String) servers.get(j);
					String serverType = (thisSrv.substring(0, thisSrv.indexOf(":"))).trim();
					temp = thisSrv.substring(thisSrv.indexOf(":") + 1);
					String compIp = egDisc.getComponentIP(strServer, temp);
					String nickAlone = temp.substring(0, temp.indexOf(":"));
					if ((temp.indexOf(":") != temp.lastIndexOf(":"))) {
						temp = temp.substring(0, temp.lastIndexOf(":"));
					}
					if (!vecStore.contains(temp)) {
						vecStore.addElement(temp);
						String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);

						if (isSearchResult && !doesExist(searchList, ipWithoutPort))
							continue;
						serversFound = true;
						String agentType = "Agent-based";
						if (egExternalInfo.isRemoteBased(nickAlone)) {
							agentType = "Agentless";
						} else if (extCompTypes.contains(strServer)) {
							agentType = "External Agent";
						}

						JSONObject obj = new JSONObject();
						String compToShow = ipWithoutPort;
						String[] compNameArr = compToShow.split(":");
						String componentName = "";
						String componentPort = "";
						if(compNameArr.length == 2){
							 componentName = compNameArr[0];
							 componentPort = compNameArr[1];
						}

						String componentType = strServer;
						String componentTypeDesc =  mapping.getComponentTypeDescription(componentType);
						
						gridObject.put("compType", componentTypeDesc);
						gridObject.put("CompNickName", componentName);
						gridObject.put("hostIP", compIp);
						gridObject.put("comPort", componentPort);
						//TODO: Get dynamically
						gridObject.put("APMName", "JAVA");
						gridObject.put("monitoring", agentType);
						
						String testName = "BusinessTransTest";
						//TODO: Read from ini and Add JVM tests also
						String[] offloadTestNames = { "BusinessTransTest", "TransactionFlowTest",
								"KBusinessTransTest" };
						List<String> offloadTestList = (List<String>) Arrays.asList(offloadTestNames);

						prgBean.createFile("eg_agents.ini");
						List listAgents = getAgents(compToShow);
						
						//System.out.println(printThis +" listAgents : "+ listAgents);
						if (testName != null && !testName.equals("")) {
							//fetch the exact agent
							String tempAgentName = getAgentNickName(componentType, testName, listAgents);
							tempAgentName = tempAgentName != null ? tempAgentName : "";
							String[] testVariables = prgBean.getVariables(tempAgentName);
							String agentIp = egExternalInfo.getIpForRemoteAgent(tempAgentName);
							if(agentIp == null){
								 agentIp = egExternalInfo.getIpForAgent(tempAgentName);
							}
							if(agentIp == null){
								agentIp ="localhost";
							}
							
							gridObject.put("agentIP", agentIp);
							
							String var = componentType+":"+componentName+":"+componentPort;
							String value = apmIni.getValue("BTM_PROFILER_APPNAME_MAPPING", var);
							
							String[] arr = value.split(":");
							if(arr.length==2){
								String appName = arr[0];
								String tierName = arr[1];
								if(appName.equalsIgnoreCase("none"))
								{
									appName = "";
								}
								
								if(tierName.equalsIgnoreCase("none"))
								{
									tierName = "";
								}
								
								gridObject.put("tierName", tierName);
								gridObject.put("appName", appName);
							}else 
							{
								//TODO: uncomment this when doing Phase II - App & Tiername adding
								// apmIni.setValue("BTM_PROFILER_APPNAME_MAPPING", var,"none:none");
								gridObject.put("tierName", "");
								gridObject.put("appName", "");
							}
							
							gridRumCollectors.add(gridObject);
						}
					}
					EgConfigFilesSync.releaseInstance(apmIni);
				}
				apmIni.saveFile();
				EgConfigFilesSync.releaseInstance(apmIni);
			}
		}
}
catch(Exception e)
{
	System.out.println(printThis +"  Unable to retrive components details, "+ e);
}
%>

<%!
private boolean doesExist(List searchList, String thisGroup)
{
	Iterator i = searchList.iterator();
	while(i.hasNext())
	{
		String nextStr = (String) i.next();
		if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			return true;
	}
	return false;
}
%>

<%
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgBTMProfilerDownload.jsp?"+request.getQueryString());
	else 
		session.setAttribute("adminLastAccessedURL","/final/admin/EgBTMProfilerDownload.jsp");

	rootJson.put("gridRmtAgents",gridRumCollectors);
	out.println(rootJson.toString());
%>

<%!

	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);

			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String testName,List listAgents)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			if (listAgents != null && listAgents.size() > 0 )
			{
				agentName = (String)listAgents.get(1);
			}
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			if (listAgents != null && listAgents.size() > 0 )
			{
				agentName = (String)listAgents.get(0);
			}
		}

		return agentName;
	}
%>


