Ext.define('CheckForUpdates.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main','HelpCenter'],
    refs: [{
        selector: 'main',
        ref: 'main'
	},
	{
		selector: 'helpcenter',
        ref: 'helpcenter'
    }],
    init: function () {
        this.control({
            'main': {
	    		'boxready': this.loadConfigUpdates
            },
			'button[id="backButton"]': {
				'click': this.goBack
            }           
        });
    },

	goBack:function(){
		window.location.replace("/final/admin/CheckForUpdates.jsp?appType=checkforupdates&from=helpcenter");
	},
	loadConfigUpdates:function() {
		var helpMask;
		var errorMsgTitle;
		if(appType == "checkforupdates"){
			errorMsgTitle = updatesTitle;
			var loadPanel={
				xtype:'container',
				id:'loadupdates',
				width:'100%',
				layout:'fit',
				margin:'50 8 10 60',
				style:{'border':'0px solid red', 'text-align':'center'},
				html:'<img style=\"vertical-align: top\" src=\"/final/images/utility_'+selectedTabTheme+'_loader.gif\"><span style="margin-left:5px;font-size: 13px; ">'+checkingforUpdateMsg+'...</span>'
			}
			var me=Ext.getCmp('checkforupdates');
			me.remove('loadupdates');
			me.remove('updateInfo');
			me.add(loadPanel);
		}
		else{
			errorMsgTitle = helpCenterTitle;
			helpMask = new Ext.LoadMask(Ext.get('helpcenter1'), {
				cls :'windowModal',
				msg: loadingMsg+"..."
			});
			helpMask.show();
		}
		Ext.Ajax.request({
			url : '/final/admin/CheckForUpdatesApp/data/CheckForUpdateJson.jsp?appType='+appType,
			method : 'POST',
			scope : this,
			success : function(response)
			{
				if(response.responseText!=null){
					var jsonDataArchive = Ext.decode(response.responseText);
					if (!Ext.isEmpty(jsonDataArchive))
					{
						var ErrMsgsJson =jsonDataArchive['ErrMsgsJson'];
						if(Ext.isEmpty(ErrMsgsJson))
						{
							if(appType == "checkforupdates"){
								var isManagerUpdated=false;
								var mgrUpdateStatus,agentUpdateStatus;
								
								var latestMgrVersion = jsonDataArchive['latestManagerVersion'];
								var latestAgentVersion = jsonDataArchive['latestAgentVersion'];
								var newFeaturesLink = jsonDataArchive['NewFeaturesLink'];
								if(latestMgrVersion!=null && latestAgentVersion !=null && newFeaturesLink !=null){
									var isMgrUpdated = jsonDataArchive['isManagerUpdated'];
									if(isMgrUpdated == "true"){
										updateMsg = '<span>'+mgrUpdatedMsg+'.</span>';
										mgrUpdateStatus = "uptodate_big";
									}
									else{
										updateMsg = '<span  class="updates_avail">'+updatedVersionMsg+latestMgrVersion+' '+isAvailableMsg+'. <br>  &nbsp;&nbsp;&nbsp;&nbsp; '+toUpgradeMsg+' <a class="mailto_font" href="mailto:support@eginnovations.com" ><u>support@eginnovations.com</u></a>, '+alsoCheckMsg+' <a target="_blank" class="mailto_font" href='+newFeaturesLink+' ><u>'+whatsNewinMsg+' '+latestMgrVersion+'</u></a> '+guideMsg+'.';
										mgrUpdateStatus = "updates_big";
									}
									var totalAgentsCount = jsonDataArchive['totalAgentsCount'];
									var notUpdatedAgentsCount = jsonDataArchive['NotUpdatedAgentsCount'];
									var basicAgentVersion = jsonDataArchive['basicAgentVersion'];
									var basicAgentProcType = jsonDataArchive['basicAgentProcType'];
									
									if(agentConfigExists==true || agentConfigExists == "true"){
										if(notUpdatedAgentsCount>0){
											agentUpdateMsg = '<span class="updates_avail">'+updatedAgentVersionMsg+latestAgentVersion+' '+isAvailableMsg+'. <a  href="'+upgradeAgentLink+'" style="color: #ffffff;background: grey;padding: 2px 3px;border-radius:3px;vertical-align:middle;">'+notUpdatedAgentsCount+'</a> '+outOfMsg+'  '+totalAgentsCount+' '+agentsDeployedMsg+'. <br> &nbsp;&nbsp;&nbsp;&nbsp; '+toUpgradeMsg+' <a href="mailto:support@eginnovations.com" class="mailto_font" ><u>support@eginnovations.com</u></a></span>';
											agentUpdateStatus = "updates_big";
										}
										else{
											agentUpdateMsg = '<span>'+agentUpdatedMsg+'.</span>';
											agentUpdateStatus = "uptodate_big";
										}
									}
									else{
										agentUpdateMsg = '<span class="updates_avail">'+agentsNotConfiguredMsg+'!</span>';
										agentUpdateStatus = "updates_big";
									}
															
									var tmpPanel={
										xtype:'container',
										id:'updateInfo',
										width:800,
										margin:'50 0 0 0',
										items:[
										{
											xtype:'container',
											height:'30%',
											width:'100%',
											ui:'update-container',
											html:'<div class="update-container-title"><img style="vertical-align:middle" class="'+mgrUpdateStatus+'" src="/final/images/spacer.gif"><span style="padding:2px 5px;display:table-cell;vertical-align:middle;font-size:12px;font-weight:500;">'+managerUpdatesMsg+'</span></div><div style="text-align: center;font-size:11px;">'+updateMsg+'</div>',
										},
										{
											xtype:'container',
											height:'30%',
											width:'100%',
											margin:'30 0 0 0',
											ui:'update-container',
											html:'<div class="update-container-title"><img style="vertical-align:middle"  class="'+agentUpdateStatus+'" src="/final/images/spacer.gif"><span style="padding:2px 5px;display:table-cell;vertical-align:middle;font-size:12px;font-weight:500;">'+agentUpdatesMsg+'</span></div><div style="text-align: center;font-size:11px;">'+agentUpdateMsg+'</div>',
										}],
									}
									var me=Ext.getCmp('checkforupdates');
									if(from == "AgentsUpgradeStatus" || from == "helpcenter"){
										me.remove('loadupdates');
										me.add(tmpPanel);
										Ext.getCmp('helpcenter').setDisabled(false);
										Ext.getCmp('reportissue').setDisabled(false);
										Ext.getCmp('reportfeature').setDisabled(false);
						
									}
									else{
										setTimeout(function(){
											me.remove('loadupdates');
											me.add(tmpPanel);
											Ext.getCmp('helpcenter').setDisabled(false);
											Ext.getCmp('reportissue').setDisabled(false);
											Ext.getCmp('reportfeature').setDisabled(false);
										},5000);
									}
								}
							}
							else {
								if(from=="checkforupdates"){
									Ext.getCmp('backButton').show();
								}
								var helpCenterURL = jsonDataArchive['helpCenterURL'];
								if(helpCenterURL!=null){
									Ext.destroy(helpMask);
									delete helpMask;
									var store = Ext.data.JsonP.request({
										url: helpCenterURL,
										crossDomain: true,
										type: "ajax",
										dataType: "json",
										callbackKey: 'callback',
										callbackName:'cbfunc',
										scope: this
									});
								}
							}
						}
						else{
							Ext.defer(function(){
								if(appType=="helpcenter"){
									Ext.destroy(helpMask);
									delete helpMask;
								}
								var msg = Ext.MessageBox.show({
									title : errorMsgTitle,
									modal:true,
									width:420,
									msg : ErrMsgsJson,
									buttons : Ext.MessageBox.OK,
									maskCls :'windowModal',
									icon: 'iconExclamation'
								});
								Ext.WindowManager.bringToFront(msg);
							},1000);
						}
					}
				}
			},
			failure : function() {
				//console.log("Error occured while fetching updates info");
			}
		});
	}
});
function cbfunc(data){
	Ext.getCmp('dataview').store.loadData(data.videos_collec);
}
function sendReportIssue(){
	parent.getReportIssue("issue");
}
function sendReportFeature(){
	parent.getReportIssue("feature");
}
function helpMe(){
	window.location.replace("/final/admin/CheckForUpdates.jsp?appType=helpcenter&from=checkforupdates");
}	






