var elemList,compToDelete;
Ext.define('Component.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Components', 'ChangeIP', 'Component.view.FileUpload', 'Component.view.FileUploadForm', 'Component.view.ASMFileUpload', 'Component.view.ASMFileUploadForm'],
	requires:['Component.view.Components', 'Component.view.ChangeIP', 'Component.view.FileUpload', 'Component.view.FileUploadForm', 'Component.view.ASMFileUpload', 'Component.view.ASMFileUploadForm'],
	refs:[
		{selector:'components', ref:'components'},
		{selector:'changeip', ref:'changeip'},
		{selector:'fileuploadform', ref:'fileuploadform'},
		{selector:'asmfileuploadform', ref:'asmfileuploadform'},
		{selector:'componentsgrid', ref:'componentsgrid'},
		{selector:'componentsgrid #searchBox', ref:'searchBoxField'}

	],
	init:function(){
		ctrler = this;
		this.buildMainData();
		
		this.control({
			'components':
			{
				'afterrender': this.afterMainRender
			},
			'components combo[id="category"]':
			{
				'select':this.categorySelection
			},
			'components combo[id="compTypes"]':
			{
				'select':this.compTypeSelection
			},
			'components checkbox[id="activeCompType"]':
			{
				'change':this.showActiveCompTypes
			},
			'components [id="componentListGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			//'components trigger[id="searchBox"]':
			//{
				//'change': this.searchComponent
			//},
			'components trigger[itemId="searchBox"]':
			{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						var value = Ext.getCmp('searchBox').getValue();
						this.fetchComponents(value);
					}
				}
			},
			'components button[id="addNewButton"]':
			{
				'click':this.addNewComponent
			},
			'components button[id="homeBack"]':
			{
				'click':this.goHome
			},
			'changeip button[id="updateip"]':
			{
				'click':this.changeIPUpdate
			},
			'changeip button[id="cancelipchange"]':
			{
				'click':this.cancelIPChange
			},
			'changeip button[id="backButton"]':
			{
				'click':this.goBack
			},
			'components button[action="openPopupWin"]':
			{
				'click':this.openPopupWin
			},
			'fileupload button[action="bulkComponentAction"]' : {
				'click' : this.bulkComponentAction
			},
			'asmfileupload button[action="uploadAssetInfo"]' : {
				'click' : this.uploadAssetInfo
			}
		});
	},
	buildMainData: function()
	{
		var urlStr = 'Component/data/EgDispServerJson.jsp?';
		if (from == "componentglance_ipchange")
		{
			urlStr = "Component/data/EgChangeIPJson.jsp?servertype="+compTypeChosen+"&selCategory=-1&hostname="+changeIpCompName+"&hostip="+changeIpCompIp+"&port="+changeIpPort;
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					if (from == "componentglance_ipchange")
					{
						jsonDataHolder = Ext.decode( jsonText );
					}
					else
					{
						publicJSON = Ext.decode( jsonText );
					}
				}
			}
		});
	},
	afterMainRender : function()
	{
		if (showAddCtn != null && showAddCtn !== undefined && showAddCtn == 'true')
		{
			Ext.getCmp('comboCont').show();
			Ext.getCmp('resultpanel').show();
			Ext.getCmp('noAgentCont').hide();
		}
		else
		{
			Ext.getCmp('comboCont').hide();
			Ext.getCmp('resultpanel').hide();
			Ext.getCmp('noAgentCont').show();
		}
		if (from == "componentglance_ipchange")
		{
			var viewportObj = Ext.getCmp('components');
			viewportObj.removeAll();
			viewportObj.add({
				xtype : 'changeip'
			});

			if (jsonDataHolder.sameNickCompsAlert)
			{
				var msg = '<table border="0"><tr><td align="center" height="100"><table><tr><td align="center"><div class="iconExclamation"></div></td></tr><tr><td align="center">'+changeIPAlrtMsg2+'<br><b>'+jsonDataHolder.sameNickIPCompTypes+'</b></td></tr></table></td></tr></table>';
				Ext.getCmp('sameNickIPMsg').show();
				Ext.getCmp('sameNickIPMsg').update(msg);
			}
			else
			{
				Ext.getCmp('sameNickIPMsg').hide();
			}
			Ext.getCmp('oldhostip').setValue(jsonDataHolder.hiddenVals.hostip);
			Ext.getCmp('oldhostip').setReadOnly(true);
			Ext.getCmp('nickName').setValue(jsonDataHolder.hiddenVals.hostname);
			Ext.getCmp('nickName').setReadOnly(true);

			if (jsonDataHolder.showGrid)
			{
				Ext.getCmp('changeIPGrid').show();
				Ext.getCmp('changeIPGrid').getStore().loadRawData(jsonDataHolder.gridData);
			}
			else
			{
				Ext.getCmp('changeIPGrid').hide();
			}
		}
		else
		{
			Ext.getCmp('category').getStore().clearFilter(true);
			Ext.getCmp('category').getStore().loadRawData(publicJSON['category']);
			Ext.getCmp('category').setValue(publicJSON['selectedServerGroup']);
			Ext.getCmp('compTypes').getStore().clearFilter(true);
			Ext.getCmp('compTypes').getStore().loadRawData(publicJSON['componentTypes']);
			Ext.getCmp('compTypes').setValue(publicJSON['selectedCompType']);
			Ext.getCmp('activeCompType').setValue(publicJSON['showManagedCompTypes']);
			//Ext.getCmp('componentListGrid').hide();

			if(isLimitedAdmin == 'true')
			{
				Ext.getCmp('addCompsInBulk').hide();
			}
			else
			{
				Ext.getCmp('addCompsInBulk').show();
			}
			
			this.loadComps(categoryChosen,compTypeChosen);
			if (from == 'home' || from == 'userpage')
			{
				Ext.getCmp('homeBack').show();
			}
			else
			{
				Ext.getCmp('homeBack').hide();
			}
		}
	},

	goToAgentDownload : function(agentType)
	{
		if (!Ext.isEmpty(agentType))
		{
			window.location.href="/final/admin/EgDownloadAgentPack.jsp?from="+agentType+"&fromWizard="+fromWizard+"&isCompView=true";
		}
	},

	loadComps: function(selectedCategory,selectedCType)
	{
		Ext.getCmp('category').setValue(selectedCategory);
		Ext.getCmp('compTypes').setValue(selectedCType);
		Ext.getCmp('activeCompType').setValue(activeCompTypes);
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var url = 'Component/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCompTypes;
		//this.getData(url);

		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);

				if (jsonDataHolder.componentTypes != null)
				{
					var comboObj = Ext.getCmp('compTypes');
					comboObj.getStore().removeAll();
					comboObj.getStore().loadRawData(jsonDataHolder.componentTypes);
					comboObj.setValue(jsonDataHolder.selectedCompType);
				}
				var serversFound = jsonDataHolder.serversFound;
				var gridObj = Ext.getCmp('componentListGrid');
				if (serversFound)
				{
					var gridpanel = Ext.widget('componentsgrid',{
						store:new Ext.data.Store({
							fields: ['Compname', 'HostIP', 'Monitoring'],
							data: jsonDataHolder.components,
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 50,
							simpleSortMode: true
						}),
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sortInfo: {
							property: 'Compname',
							direction: 'DESC'
						}
					});

					var resultPanelObj = Ext.getCmp('resultpanel');
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.add(gridpanel);

					//Asset config icon hide/show based on AssetManagement Flag
					if(isAssetMgntEnable == true){
						//Ext.getCmp('iconAssetConfig').show();
					}
					if (selectedCType != '-1')
					{
						Ext.getCmp('searchBox').enable();
					}
					else
					{
						Ext.getCmp('searchBox').disable();
					}
					if(isAssetMgntEnable == false) {
						Ext.getCmp('iconAssetConfig').hide(); //Asset config icon hide/show based on AssetManagement Flag
					}
					if(selectedCType == 'Real_user_monitor')
					{
						gridpanel.columns[1].setText(label_Association);
						gridpanel.columns[9].setVisible(false);
						gridpanel.columns[10].setVisible(false);
					}
					else if (jsonDataHolder.hideHostIPField)
					{
						gridpanel.columns[1].setVisible(false);
						gridpanel.columns[10].setVisible(false);
					}
					else
					{
						gridpanel.columns[1].setText(label_HostIP);
						//Ext.getCmp('componentListGrid').columns[9].setVisible(true);
						if(jsonDataHolder.allowIPModification)
						{
							gridpanel.columns[10].setVisible(true);
						}
						else
						{
							gridpanel.columns[10].setVisible(false);
						}
					}
				}
			},
			failure : function(response)
			{
			}
		});
	},
	categorySelection : function()
	{
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var url = 'Component/data/EgDispServerJson.jsp?selectedServerGroup='+selectedCategory+'&activeCompTypes='+activeCType;//+'&server='+selectedCType;
		this.getData(url);
		var comboObj = Ext.getCmp('compTypes').getStore();
		comboObj.removeAll();
		comboObj.clearFilter(true);
		comboObj.loadRawData(jsonDataHolder.componentTypes);
		Ext.getCmp('compTypes').setValue("-1");
		var gridObj = Ext.getCmp('componentListGrid');
		gridObj.getStore().removeAll();
		gridObj.hide();
	},
	compTypeSelection : function()
	{
		var me = this;

		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var url = 'Component/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCType;
		//this.getData(url);

		Ext.Ajax.request(
		{
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);

				var serversFound = jsonDataHolder.serversFound;
				var gridObj = Ext.getCmp('componentListGrid');

				if (!Ext.isEmpty(jsonDataHolder.components))
				{
					var gridpanel = Ext.widget('componentsgrid',{
						store:new Ext.data.Store({
							fields: ['Compname', 'HostIP', 'Monitoring'],
							data: jsonDataHolder.components,
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 50,
							simpleSortMode: true
						}),
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sortInfo: {
							property: 'Compname',
							direction: 'DESC'
						}
					});

					var resultPanelObj = Ext.getCmp('resultpanel');
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.add(gridpanel);

					if(selectedCType == 'Real_user_monitor')
					{
						Ext.getCmp('componentListGrid').columns[1].setText(label_Association);
						Ext.getCmp('componentListGrid').columns[9].setVisible(false);
						Ext.getCmp('componentListGrid').columns[10].setVisible(false);
					}
					else
					{
						Ext.getCmp('componentListGrid').columns[1].setText(label_HostIP);
						Ext.getCmp('componentListGrid').columns[9].setVisible(true);
						if(jsonDataHolder.allowIPModification)
						{
							Ext.getCmp('componentListGrid').columns[10].setVisible(true);
						}
						else
						{
							Ext.getCmp('componentListGrid').columns[10].setVisible(false);
						}
					}

					if (jsonDataHolder.hideHostIPField)
					{
						Ext.getCmp('componentListGrid').columns[1].setVisible(false);
						Ext.getCmp('componentListGrid').columns[10].setVisible(false);
					}
					else
					{
						Ext.getCmp('componentListGrid').columns[1].setVisible(true);
						Ext.getCmp('componentListGrid').columns[10].setVisible(true);
					}

					if (selectedCType == '-1')
					{
						gridObj.getStore().removeAll();
						gridObj.hide();
					}
					if(isAssetMgntEnable == false) {
						Ext.getCmp('iconAssetConfig').hide();
					}
				}
				else
				{
					var gridpanel = Ext.widget('componentsgrid',{
						store:new Ext.data.Store({
							fields: ['Compname', 'HostIP', 'Monitoring'],
							data: [],
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 50,
							simpleSortMode: true
						}),
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sortInfo: {
							property: 'Compname',
							direction: 'DESC'
						}
					});

					var resultPanelObj = Ext.getCmp('resultpanel');
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.add(gridpanel);

					me.getComponentsgrid().getStore().loadRawData(jsonDataHolder.components);
					me.getComponentsgrid().emptyText = LoadAlert1+".";
				}

				var userSearchObj = Ext.getCmp('searchBox');
				if (!Ext.isEmpty(jsonDataHolder.components))
				{
					me.getSearchBoxField().setDisabled(false);
				}
				else
				{
					me.getSearchBoxField().setDisabled(true);
				}
			},
			failure : function(response)
			{
			}
		});
	},
	showActiveCompTypes : function()
	{
		var me = this;
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var url = 'Component/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCType;
		this.getData(url);
		var comboObj = Ext.getCmp('compTypes').getStore();
		comboObj.removeAll();
		comboObj.clearFilter(true);
		comboObj.loadRawData(jsonDataHolder.componentTypes);
		Ext.getCmp('compTypes').setValue(jsonDataHolder.selectedCompType);

		var comboObj2 = Ext.getCmp('category').getStore();
		comboObj2.removeAll();
		comboObj2.clearFilter(true);
		comboObj2.loadRawData(jsonDataHolder.category);
		Ext.getCmp('category').setValue(jsonDataHolder.selectedServerGroup);

		var serversFound = jsonDataHolder.serversFound;
		if (serversFound)
		{
			var gridpanel = Ext.widget('componentsgrid',{
				store:new Ext.data.Store({
					fields: ['Compname', 'HostIP', 'Monitoring'],
					data: jsonDataHolder.components,
					proxy: {
						type: "pagingmemory",
						reader: {
							type: "json"
						}
					},
					remoteFilter : true,
					remoteSort: true,
					autoLoad: true,
					pageSize : 50,
					simpleSortMode: true
				}),
				viewConfig: {
					forceFit: true,
					stripeRows : true
				},
				sortOnLoad: true,
				sortInfo: {
					property: 'Compname',
					direction: 'DESC'
				}
			});

			var resultPanelObj = Ext.getCmp('resultpanel');
			resultPanelObj.show();
			resultPanelObj.removeAll();
			resultPanelObj.add(gridpanel);

			var userSearchObj = Ext.getCmp('searchBox');
			if (!Ext.isEmpty(jsonDataHolder.components))
			{
				me.getSearchBoxField().setDisabled(false);
			}
			else
			{
				me.getSearchBoxField().setDisabled(true);
			}
		}
		else
		{
			var gridpanel = Ext.widget('componentsgrid',{
				store:new Ext.data.Store({
					fields: ['Compname', 'HostIP', 'Monitoring'],
					data: [],
					proxy: {
						type: "pagingmemory",
						reader: {
							type: "json"
						}
					},
					remoteFilter : true,
					remoteSort: true,
					autoLoad: true,
					pageSize : 50,
					simpleSortMode: true
				}),
				viewConfig: {
					forceFit: true,
					stripeRows : true
				},
				sortOnLoad: true,
				sortInfo: {
					property: 'Compname',
					direction: 'DESC'
				}
			});

			var resultPanelObj = Ext.getCmp('resultpanel');
			resultPanelObj.show();
			resultPanelObj.removeAll();
			resultPanelObj.add(gridpanel);

			me.getComponentsgrid().getStore().loadRawData(jsonDataHolder.components);
			me.getComponentsgrid().emptyText = LoadAlert1+".";
		}
	},
	searchComponent : function()
	{
		var activeCType = Ext.getCmp('activeCompType').getValue();
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		selectedCType = encodeURIComponent(selectedCType);
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var url = 'Component/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType+'&activeCompTypes='+activeCType;
		if (searchStr != '')
		{
			url+='&searchStr='+searchStr;
		}
		if (searchStr == "" || searchStr .length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		this.getData(url);
		var serversFound = jsonDataHolder.serversFound;
		var gridObj = Ext.getCmp('componentListGrid');
		if(serversFound)
		{
			gridObj.show();
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(jsonDataHolder.components);
		}
		else
		{
			gridObj.getStore().removeAll();
			Ext.get('noCompAlrtDiv').update(srcNotFnd);
		}
	},

	fetchComponents : function(value)
	{
		var componentListGrid = Ext.getCmp('componentListGrid');
		if (value == "" || value.length == 0)
		{
			componentListGrid.getStore().clearFilter();
		}
		else
		{
			componentListGrid.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var toSearch = item.get('Compname')+item.get('HostIP');
					var res = value.split(" ");
					for (var i=0; i<res.length; i++)
					{
						if (toSearch.toLowerCase().indexOf(res[i].toLowerCase()) != -1)
						{
							return true
						}
					}					
				}
			});
			componentListGrid.getStore().filter(userFilter);
		}

		//if (componentListGrid.getStore().getCount() == 0)
		{
			componentListGrid.getView().emptyText = '<div class="emptyText"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText" ><table border="0" width="100%" height="250px"><tbody><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noCompAlrtDiv">'+srcNotFnd+'</div></td></tr></tbody></table></div></div>';
			componentListGrid.getView().refresh();
		}
	},
	goHome: function()
	{
		if (from == 'userpage')
		{
			window.location.href = "EgDispUserSites.jsp?expiry=all&fromWizard="+fromWizard;
		}
		else if (from == 'currentpage')
		{
			this.goBack();
		}
		else
		{
			window.location.href = "/final/admin/EgAdminOperations.jsp?fromWizard="+fromWizard;
		}
	},
	getData: function(urlStr)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var countCol = 0;
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
			countCol++;
			if (countCol == 5)
			{
				var temp = hideIcon.get('IsRUM');
				if(temp != null && temp != undefined && temp == 'true')
				{
					Ext.get(icon).addCls('x-hidden');
				}
			}
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	modifyComponent: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		var selectedCType = Ext.getCmp('compTypes').getValue();
		if (selectedCType == 'Oracle_server')
		{
			var tmpCompName = compName.substring(0,compName.lastIndexOf(":"));
			if (tmpCompName.indexOf(':') != -1)
			{
				compName = tmpCompName;
			}
		}
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		compName = encodeURIComponent(compName);
		//var url = "EgNewServer.jsp?isAggregateLink=false&server="+compName+"&serverType="+selectedCType+"&modifyserver=true&siteSupport=false&treeViewSrc=null&serverGategory="+selectedCategory;
		var url = "EgNewServer.jsp?server="+compName+"&serverType="+selectedCType+"&modifyserver=true&serverGategory="+selectedCategory+"&fromWizard="+fromWizard;
		window.location.href = url;
	},
	modifyComponent2: function (compName)
	{
		var selectedCType = Ext.getCmp('compTypes').getValue();
		if (selectedCType == 'Oracle_server')
		{
			var tmpCompName = compName.substring(0,compName.lastIndexOf(":"));
			if (tmpCompName.indexOf(':') != -1)
			{
				compName = tmpCompName;
			}
		}
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		//var url = "EgNewServer.jsp?isAggregateLink=false&server="+compName+"&serverType="+selectedCType+"&modifyserver=true&siteSupport=false&treeViewSrc=null&serverGategory="+selectedCategory;
		var url = "EgNewServer.jsp?server="+compName+"&serverType="+selectedCType+"&modifyserver=true&serverGategory="+selectedCategory+"&fromWizard="+fromWizard;
		window.location.href = url;
	},
	specificTestConfigWindow : function (grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		window.location.href = "/final/admin/EgSpecificTestConfiguration.jsp?reqfrom=compModify&componentType="+selectedCType+"&componentName="+compName;
	},
	specificThresholdConfigWindow : function (grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		window.location.href = "/final/admin/EgSpecificThresh.jsp?reqFrom=compModify&server="+selectedCType+"&compName="+compName;
	},
	gotoMaintenancePolicyPage : function (grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		window.location.href = "/final/admin/QuickMaintenance.jsp?reqFrom=compModify&server="+selectedCType+"&compName="+compName;
	},
	unmanageComponent: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		window.location.href = "/final/admin/EgConfigEnv.jsp?srvtype="+selectedCType+"&component="+compName+"&backButNeed=yes&reqfrom=EgDispServer&fromWizard="+fromWizard;
	},
	deleteComponent: function(grid, rowIndex, colIndex)
	{
		var me= this;
		elemList = "";
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');

		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		compToDelete = compName;
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var compNameWithType = selectedCType +":"+ compName;
		selectedCType = encodeURIComponent(selectedCType);
		var tmpURL = "/final/admin/EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=true&refferalURL=AddComponent";
		tmpURL += "&fmanagewithcomptype="+compNameWithType+",&srvtype="+selectedCType+"&servertypes="+selectedCType+"&fmanage="+compName+",";
		tmpURL += "&componentDetails=&funmanage="+"&fromAction=addmodify";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		Ext.Ajax.request(
		{
			url : tmpURL,
			method: 'POST',
			success: function(response)
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				var resultObj = Ext.decode(jsonText);
				if (resultObj.requestStatus == "success")
				{
					var tmpObj = resultObj.result;
					Ext.Msg.show({
						title: tmpObj.title,
						msg: alertMsg37,
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconInformation'
					});
					me.compTypeSelection();
				}
				else
				{
					var tmpObj = resultObj.errors;
					var errorText = me.getErrorMessageTemplate(tmpObj);
					me.showResultWindow(tmpObj.title,errorText,"delete");
				}
			},
			failure : function(response)
			{
				tmpMask.hide();
			}
		});
	},
	delComponent : function(isProceed)
	{
		var me = this;
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var compNameWithType = selectedCType +":"+ compToDelete;
		var tmpURL = "/final/admin/EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=true&refferalURL=AddComponent";
		tmpURL += "&fmanagewithcomptype="+compNameWithType+",&srvtype="+selectedCType+"&servertypes="+selectedCType+"&fmanage="+compToDelete+",";
		tmpURL += "&componentDetails=&funmanage=";
		if (isProceed != null && isProceed !== undefined && isProceed == true)
		{
			tmpURL += "&isProceed="+isProceed;
		}
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		Ext.Ajax.request({
			url : tmpURL,
			method: 'POST',
			success: function(response)
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				var resultObj = Ext.decode(jsonText);
				if (resultObj.requestStatus == "success")
				{
					var tmpObj = resultObj.result;
					Ext.Msg.show({
						title: tmpObj.title,
						width : 450,
						msg: tmpObj.message1,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					elemList = resultObj.elemList;
					me.compTypeSelection();
				}
			},
			failure : function(response)
			{
				tmpMask.hide();
			}
		});
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var me = this;
		var tmpTable = "";
		if (tmpObj.allow != null && tmpObj.allow !== undefined && tmpObj.allow == true)
		{
			tmpTable = "";
			for (var key in tmpObj)
			{
				if (key == "title" || key == "allow") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + errorMessage;
			}
		}
		else
		{
			tmpTable = '<div class="x-table" style="width:90%"><table cellspacing="0" width="100%" cellpadding="5" border="1" align="center" class="x-grid-table" style="border:1px solid #c3c3c3;"><thead><tr class="x-grid-row"><th class="x-grid-cell"><div class="x-grid-cell-inner">'
			+pageTitle+'</div></th></tr></thead>'
			for (var key in tmpObj)
			{
				if (key == "title") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + '<tr class="x-grid-row"><td class="x-grid-cell x-grid-cell-first "><div class="x-form-display-field"><div class ="x-grid-cell-inner">'+errorMessage+'</div></div></td></tr>';
			}
			tmpTable = tmpTable + '</table></div>';
		}
		return tmpTable;
	},
	showResultWindow : function(title,resultText,action)
	{
		var me = this;
		var isProceed = false;
		Ext.Msg.show({
			title: title,
			msg: resultText,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes') 
				{
					isProceed = true;
					if (action != null && action !== undefined && action == "delete")
					{
						me.delComponent(isProceed);
					}
				}
			}
		});
	},
	viewAssociatedEntities : function(action)
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : associatedEntitiesTitle1,
			id:'assoEntitesWindow',
			width: '68%',
			bodyPadding:'10 10 10 10',
			height: 350,
			modal : true,
			border : false,
			autoScroll:true,
			scroll:true,
			ghost:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					me.updateEntityAssociationPage(action);
				}
			},
			items:[
				{
					xtype: 'container',
					flex:1,
					id: 'entityAssociationContainer',
					margin: 10
				}
			]
		}).show();
	},
	updateEntityAssociationPage : function(action)
	{
		var me = this;
		var servType = Ext.getCmp("compTypes").getValue();
		var urlStr = "EgConfigEnv/data/EgComponentGroupedSummary.jsp?date="+new Date().getTime()+"&fromWizard="+fromWizard+"&action="+action+"&srvtype="+servType+"&comeFrom=addModify";
		if (action != null && action !== undefined && (action == "showMod" || action == "showDel"))
		{
			urlStr += "&elemList=true"+"&hiddenElemList="+encodeURIComponent(elemList);
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle2);
		}
		else if (action != null && action !== undefined && action == "delete")
		{
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle1);
			var selectedCType = Ext.getCmp('compTypes').getValue();
			selectedCType = encodeURIComponent(selectedCType);
			var fmngwithcomptype = selectedCType +":"+ compToDelete;
			urlStr += "&fmanage="+compToDelete+"&fmanagewithcomptype="+fmngwithcomptype;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var resultObj = Ext.decode(jsonText);
				me.updateResultPanel(resultObj);
			},
			failure : function(response)
			{
				myMask.hide();
			}
		});
	},
	updateResultPanel : function(resultObj)
	{
		var me = this;
		var entityAssociationCont = Ext.getCmp('entityAssociationContainer');
		entityAssociationCont.removeAll();

		var isElementsAssociated = resultObj['isElementsAssociated'];
		if (isElementsAssociated != undefined && isElementsAssociated == true)
		{
			var message = "<div>"+resultObj.usersGridArr+"</div>";
			Ext.getCmp('entityAssociationContainer').update(message);
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>No components associated.</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			entityAssociationCont.add(tmpPanel);
		}
	},
	assetMgmt: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		var compIp = obj.get('HostIP');
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		window.location.href = "/final/admin/EgAssetInfo.jsp?serverType="+selectedCType+"&serverName="+compName+"&hostIp="+compIp+"&serverGategory="+selectedCategory+"&fromWizard="+fromWizard;
	},
	addNewComponent: function()
	{
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);
		//if (selectedCType == '-1')
		//{
		//	Ext.Msg.show({
		//		title : pageTitle,
		//		msg : alertMsg36,
		//		buttons : Ext.Msg.OK,
		//		icon : 'iconExclamation'
		//	});
		//	return;
		//}
		var url = "/final/admin/EgNewServer.jsp?server=new&serverType="+selectedCType+"&from=addnew&isAggregateLink=false&treeViewSrc=null&serverGategory="+selectedCategory+"&fromWizard="+fromWizard;
		window.location.href = url;
	},
	openPopupWin: function ()
	{
		Ext.widget('fileupload').show();
	},
	bulkComponentAction: function ()
	{
		var uploadObj = Ext.getCmp('FILE_0').getValue();
		var addOrModify = Ext.getCmp('bulkAddOrModify').getValue().addOrModify;
		var alertWinTitle = addCompsInBulkTitle;
		if(addOrModify == 'modify') {
			alertWinTitle = modifyCompsInBulkTitle;
		}
		if ( uploadObj != null && uploadObj != '' && uploadObj != undefined && uploadObj != 'undefined' )
		{
			var getFileName = uploadObj;
			getFileName = getFileName.substring( getFileName.lastIndexOf('.') + 1 );
			if ( getFileName == 'csv')
			{
				
				var URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=add"; //default URL(action = add)
				
				if(addOrModify == 'modify') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=modify";
					Ext.Msg.show({
						title: alertWinTitle,
						msg: bulkModificationAlrtMsg,
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(response) {
							if(response == 'yes')
							{
								ctrler.doActionForBulk(URL);
							}
						}
					});
				} else {
					
					Ext.Msg.show({
						title: alertWinTitle,
						msg: bulkAddAlrtMsg,
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(response) {
							if(response == 'yes')
							{
								ctrler.doActionForBulk(URL);
							}
						}
					});
				}
				
			} else {
				Ext.Msg.show({
					title:alertWinTitle,
					msg: selectValidFile,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
			}
		} else {
		
			Ext.Msg.show({
			title:alertWinTitle,
			msg: selectCompsListFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	},
	doActionForBulk: function(URL){
		var addOrModify = Ext.getCmp('bulkAddOrModify').getValue().addOrModify;

		var alertWinTitle = addCompsInBulkTitle;
		if(addOrModify == 'modify') {
			alertWinTitle = modifyCompsInBulkTitle;
		}
		var compListForm = this.getFileuploadform().getForm();
		if (compListForm.isValid())
		{
			var tmpMask = new Ext.LoadMask('fileUpload', {msg: 'Please wait...'});
			tmpMask.show();
			compListForm.submit(
			{
				url: URL,
				scope: this,
				async: true,
				//waitMsg: 'Please Wait...',
				method: 'POST',
				enctype: 'multipart/form-data',
				success: function (form, action)
				{
					tmpMask.hide();
					var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
					var errorMsg = jsonText['errorMsg'];
					var errorInfo = jsonText['errorInfo'];

					var resultMsg = jsonText['resultMsg'];
					var tempErrorMsg = jsonText['tempErrorMsg'];
					var ErrMsgsJson = jsonText['ErrMsgsJson'];
					
					if (!Ext.isEmpty(jsonText))
					{
						//tempErrorMsg
						if(Ext.isEmpty(tempErrorMsg))
						{
							if(!Ext.isEmpty(resultMsg))
							{		
								if(addOrModify == 'add' && isAssetMgntEnable == 'yes') {
									Ext.Msg.show({
									title: alertWinTitle,
									msg: resultMsg + '. Do you want to define Asset details for the Component(s)?',
									buttons: Ext.Msg.YESNO,
									icon: 'iconConfirmation',
									fn: function(response) {
											if(response == 'yes') {
												ctrler.openASMPopup();
											}
										}
									}); 
								} else {
									Ext.Msg.show({
									//title: '<span style="text-transform:capitalize;">Bulk Components</span>',
									title: alertWinTitle,
									msg: resultMsg,
									icon: 'iconInformation',
									buttons: Ext.Msg.OK
									});
								}
							} else {

								 if(!Ext.isEmpty(ErrMsgsJson))
								{
									Ext.Msg.show({
										//title:'<span style="text-transform:capitalize;">Bulk Components</span>',
										title:alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
									
								} else if(!Ext.isEmpty(errorInfo)) {
									Ext.Msg.show({
										title:alertWinTitle,
										msg: errorInfo,
										icon: 'iconInformation',
										buttons: Ext.Msg.OK
									});
								} else if(!Ext.isEmpty(errorMsg)) {
									Ext.Msg.show({
										title:alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								}
							}
						} else {
							Ext.Msg.show({
								title:alertWinTitle,
								msg: tempErrorMsg,
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});
						}
					} 
				},
				failure: function (form, action)
				{
					tmpMask.hide();
					Ext.Msg.show({
					title:alertWinTitle,
					msg: 'Failure Notice',
					icon: 'iconExclamation',
					buttons: Ext.Msg.OK
					});
				}
			});
		} else {
			Ext.Msg.show({
				title:alertWinTitle,
				msg: selectValidFile,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});
		}

	},
	openASMPopup : function() {
		
		//Get the active window
		var win = Ext.WindowManager.getActive();
		if(win) {
			win.close();
		}	
		new Ext.widget('asmfileupload').show();	
	},
	uploadAssetInfo: function() {
		
		var uploadAssetObj = Ext.getCmp('FILE_0').getValue();
		if(uploadAssetObj != null && uploadAssetObj != '' && uploadAssetObj != undefined && uploadAssetObj != 'undefined')
		{
			var getFileName = uploadAssetObj;
			getFileName = getFileName.substring(getFileName.lastIndexOf('.') + 1);
		if (getFileName == 'csv' || getFileName == 'xls')
		{
			url = "/final/admin/AssetManagement/data/EgAssetConfigUploadJSON.jsp";
			var assetForm = this.getAsmfileuploadform().getForm();
			
			if (assetForm.isValid())
			{
				assetForm.submit(
				{
					url: "/final/admin/AssetManagement/data/EgAssetConfigUploadJSON.jsp",
					scope:this,
					async: true,
					waitMsg: 'Upload in progress please wait',
					method: 'POST',
					enctype: 'multipart/form-data',
					success: function(form, action) {

						var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
						var alertTextMsg = jsonText['Msg'];
						var alertTextSuccessMsg = jsonText['Success_Msg'];
						var ErrMsgsJson = jsonText['ErrMsgsJson'];
						if (!Ext.isEmpty(jsonText))
						{
							if(!Ext.isEmpty(ErrMsgsJson))
							{
								Ext.Msg.show({
								title: 'Alert',
								msg: 'Error while importing asset data. Please Check the errors listed below',
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});

							this.showErrors(ErrMsgsJson);
							return;
							} else if(!Ext.isEmpty(alertTextSuccessMsg)) {
								Ext.Msg.show({
								title: 'Alert',
								msg: alertTextSuccessMsg,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
								});
								Ext.getCmp('fileUpload').destroy();
							} else if (!Ext.isEmpty(alertTextMsg)) {
								Ext.Msg.show({
								title: 'Alert',
								msg: alertTextMsg,
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK

								});
								return;
							}
						}
					},
					failure:function (form, action)
					{
						alert('Failure Notice');
					}
				});
			}
		} else {
			Ext.Msg.show({
			title: 'Alert',
			msg: selectValidxlsFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation'
			});
		 }
		} else {
			Ext.Msg.show({
			title: 'Alert',
			msg: selectAssetInfoFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	},
	showErrors: function(ErrMsgsJson){
	
		Ext.getCmp('asmfileupload').setHeight(300);
		Ext.getCmp('asmfileupload').setAutoScroll(true);
		Ext.create('Ext.data.Store', {
					storeId: 'storeId',
					fields: ['CmpName','FieldName', 'FieldErrMsg'],
					data: ErrMsgsJson,
					proxy: {
							type: 'memory',
							reader: {
							type: 'json',
							root: 'items'
					}
		}
		});
	var errMsgsGrid = Ext.create('utilities.CustomGrid', {
						title: 'Errors',
						alias: 'widget.ErrWindow2',
						cls: 'gridSkin',
						scroll: true,
						autoScroll: true,
						overflowY: 'auto',
						overflowX: 'auto',

						store: Ext.data.StoreManager.lookup('storeId'),
						columns: [
									{
									text: 'Component Name',
									dataIndex: 'CmpName',
									flex: 1
									},
									{
									text: 'Field Name',
									dataIndex: 'FieldName',
									flex: 1
									},
									{
									text: 'Error',
									dataIndex: 'FieldErrMsg',
									flex: 1
									},
						],
						width: 550,
					});
	var listOfErrorsObj = Ext.getCmp('listOfErrors');
	listOfErrorsObj.removeAll();
	listOfErrorsObj.add(errMsgsGrid);
	listOfErrorsObj.doLayout();
},
	changeIP: function(grid, rowIndex, colIndex)
	{
		if (from == "")
		{
			from = "currentpage";
		}
		
		var obj = grid.getStore().getAt(rowIndex);
		var compName = obj.get('Compname');
		var port = "NULL";
		if (compName.indexOf(":") > 0)
		{
			port = compName.substring(compName.indexOf(":")+1);
			compName = compName.substring(0,compName.indexOf(":"));
		}
		var compIp = obj.get('HostIP');
		compName = encodeURIComponent(compName);
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedCType = encodeURIComponent(selectedCType);
		var selectedCategory =	Ext.getCmp('category').getValue();
		selectedCategory = encodeURIComponent(selectedCategory);

		var viewportObj = Ext.getCmp('components');
		viewportObj.removeAll();
		var urlStr = "Component/data/EgChangeIPJson.jsp?servertype="+selectedCType+"&hostname="+compName+"&hostip="+compIp+"&port="+port+"&selCategory="+selectedCategory;
		this.getData(urlStr);
		viewportObj.add({
			xtype : 'changeip'
		});
		Ext.getCmp('homeBack').show();

		if (jsonDataHolder.sameNickCompsAlert)
		{
			var msg = '<table border="0"><tr><td align="center" height="100"><table><tr><td align="center"><div class="iconExclamation"></div></td></tr><tr><td align="center">'+changeIPAlrtMsg2+'<br><b>'+jsonDataHolder.sameNickIPCompTypes+'</b></td></tr></table></td></tr></table>';
			Ext.getCmp('sameNickIPMsg').show();
			Ext.getCmp('sameNickIPMsg').update(msg);
		}
		else
		{
			Ext.getCmp('sameNickIPMsg').hide();
		}
		Ext.getCmp('oldhostip').setValue(jsonDataHolder.hiddenVals.hostip);
		Ext.getCmp('oldhostip').setReadOnly(true);
		Ext.getCmp('nickName').setValue(jsonDataHolder.hiddenVals.hostname);
		Ext.getCmp('nickName').setReadOnly(true);

		if (jsonDataHolder.showGrid)
		{
			Ext.getCmp('changeIPGrid').show();
			Ext.getCmp('changeIPGrid').getStore().loadRawData(jsonDataHolder.gridData);
		}
		else
		{
			Ext.getCmp('changeIPGrid').hide();
		}
	},
	changeIPUpdate: function()
	{
		var newIP = Ext.getCmp('newhostip').getValue();
		var oldIP = jsonDataHolder.hiddenVals.hostip;
		var isValid = this.validateChangeIP(oldIP,newIP);
		if (!isValid)
		{
			return;
		}
		this.doChangeIP();
	},
	cancelIPChange: function()
	{
		this.goBackFromIPChange(jsonDataHolder.hiddenVals.selCategory,jsonDataHolder.hiddenVals.servertype);
	},
	goBack: function()
	{
		this.goBackFromIPChange(jsonDataHolder.hiddenVals.selCategory,jsonDataHolder.hiddenVals.servertype);
	},
	validateChangeIP: function(oldIP,newIP)
	{
		if(!checkblank(newIP))
		{
			if (isAllowHostName == 'false')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg32,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg33,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			return false;
		}
		else if(isAllowHostName == 'false' && !validateIp(newIP))
		{
			Ext.getCmp('newhostip').focus(true);
			return false;
		}
		else if(isAllowHostName == 'true' && !validateHostField(newIP))
		{
			Ext.getCmp('newhostip').focus(true);
			return false;
		}
		else if (oldIP == newIP)
		{
			if (isAllowHostName == 'false')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg34,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg35,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			Ext.getCmp('newhostip').focus(true);
			return false;
		}
		return true;
	},
	doChangeIP: function()
	{
		var selectedRecords = Ext.getCmp('changeIPGrid').getSelectionModel().getSelection();
		var hostList = '';
		for (var s=0;s < selectedRecords.length; s++)
		{
			var value = selectedRecords[s].get('actualValue');
			hostList += value+ ':';
		}
		var me = Ext.getCmp('hiddenContnrChangeIP');
		me.removeAll();
		var hiddenParams = jsonDataHolder.hiddenVals;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
					xtype: 'hidden',
					name: 'hostlist',
					value: hostList
				});
		var newIP = Ext.getCmp('newhostip').getValue();

		var urlStr = "Component/data/EgchangeippJson.jsp?newhostip="+newIP;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getChangeip().submit({
			url: urlStr,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.AlertType == 'result')
				{
					Ext.Msg.show({
						title:resultJSON.AlertTitle,
						msg:resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
							ctrler.goBackFromIPChange('-1',resultJSON.serverType);
							}
						}
					});
				}
				else if (resultJSON.AlertType == 'error')
				{
					Ext.Msg.show({
						title:resultJSON.AlertTitle,
						msg:resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
							ctrler.goBackFromIPChange('-1',resultJSON.serverType);
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	goBackFromIPChange : function(selectedCategory, selectedCType)
	{
		if (from == "componentglance_ipchange")
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+compTypeChosen;
		}
		else
		{
			from = "";
			Ext.getCmp('changeip').destroy();
			var viewportObj = Ext.getCmp('componentview');
			viewportObj.add({
				xtype : 'components'
			});
			viewportObj.show();

			if (selectedCategory == null || selectedCategory == '')
			{
				selectedCategory = "-1";
			}
			if (selectedCType == null || selectedCType == '')
			{
				selectedCType = "-1";
			}
			Ext.getCmp('category').setValue(selectedCategory);
			Ext.getCmp('compTypes').setValue(selectedCType);
			selectedCategory = encodeURIComponent(selectedCategory);
			selectedCType = encodeURIComponent(selectedCType);
			var url = 'Component/data/EgDispServerJson.jsp?&selectedServerGroup='+selectedCategory+'&server='+selectedCType;
			this.getData(url);
			var serversFound = jsonDataHolder.serversFound;
			var gridObj = Ext.getCmp('componentListGrid');
			if(serversFound)
			{
				gridObj.show();
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(jsonDataHolder.components);
			}
			else
			{
				gridObj.getStore().removeAll();
				gridObj.hide();
			}

			if (selectedCType != '-1')
			{
				Ext.getCmp('searchBox').enable();
			}
			else
			{
				Ext.getCmp('searchBox').disable();
			}
		}
	}
});



