Ext.define('Component.view.Components', {
	extend: 'Ext.form.Panel',
	alias: 'widget.components',

	ui:'simplePanel simplePanelHeaderBorder',
	///cls:'outerpanel',
	margin :'8 8 0 8',
	//frame:true,
	title: homeTitle,
	//header:{cls:'textUpper'},
	id:'components',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	requires:['Component.view.ComponentsGrid'],
	tools: [
		{
			xtype : 'button',
			text : label_Back,
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'homeBack',
			hidden : true
		}
	],
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			id: 'comboCont',
			cls: 'formOuter',
			//border: true,
			padding: 10,
			margin: '10 10 0 10',
			items: [
				{
					xtype: 'scrollcombo',
					fieldLabel: label_Category,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					cls:'dropdown',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					id:'category',
					name:'category',
					//editable:false
				},
				{
					xtype: 'scrollcombo',
					fieldLabel: label_CompTyep,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					cls:'dropdown',
					margin: '0 0 0 20',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					id:'compTypes',
					name:'compTypes',
					//editable:false
				},
				{
					xtype: 'checkbox',
					boxLabel: label_ShowCompTypeOnly,
					checked: false,
					cls:'checkbt',
					id:'activeCompType',
					margin: '20 0 0 20'
				},
				{
					xtype: 'button',
					id:'addNewButton',
					cls:'button20',
					text: addButtonText,
					margin: '20 0 0 20'
				},
				{
					xtype: 'button',
					id:'addCompsInBulk',
					action:'openPopupWin',
					cls:'button20',
					text: addCompsInBulkBtnText,
					margin: '20 0 0 20'
				}
			]
		},
		{
			xtype: 'container',
			id : 'resultpanel',
			ui:'simplePanel simplePanelHeaderBorder',
			closable: true,
			margin: '0 10 0 0',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			flex: 1
		},
	
		/*{
			xtype: 'customgrid',
			id:'componentListGrid',
			store: new Ext.data.Store({
				fields: ['Compname', 'HostIP', 'Monitoring'],
				data : []
			}),
			autoScroll: true,
			flex: 1,
			cls:'gridSkin',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: label_Component,
						dataIndex: 'Compname',
						flex:1,
						renderer : function(val)
						{
							if (val != "" && val.length > 0)
							{
								var tmpTag = '<a id="mouse" href=\'javascript:ctrler.modifyComponent2("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
								return tmpTag;
							}
							else
							{
								return val;
							}
						}
					},
					{
						text: label_HostIP,
						dataIndex: 'HostIP',
						flex:1
					},
					{
						text: label_Monitoring,
						dataIndex: 'Monitoring',
						width: 160
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconModify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.modifyComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+modifyLabel+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconConfigure',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.specificTestConfigWindow(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+confLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconSetThreshold',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.specificThresholdConfigWindow(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+threshLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconMaintenance',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.gotoMaintenancePolicyPage(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+mtnLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconUnmanage',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.unmanageComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+unmgeLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconDelete',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.deleteComponent(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+delLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconAssetConfiguration',
						id:'iconAssetConfig',
						sortable: false,
						hidden:true,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.assetMgmt(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+assetConfigLabel+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconIP',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.changeIP(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+cIPLbl+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						iconCls:'iconDelete',
						//iconCls: 'x-hidden',
						sortable: false,
						hidden:true,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.addComp(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+addLabel+"' data-qclass='yellowTip'";
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					id:'searchBox',
					cls:'whitedropdown_search',
					padding: '2 6 2 0',
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						ctrler.searchComponent();
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					disabled: true
				}
			],
			emptyText: LoadAlert1,
			viewConfig: {
				deferEmptyText: false
			}
		},*/
		{
			xtype: 'container',
			id: 'noAgentCont',
			margin: '0 10 10 0',
			hidden: true,
			flex: 1,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			items: [
				{
					xtype: 'container',
					html: '<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">'+compMsg+'.</div>'
				},
				{
					xtype: 'container',
					margin: '10 10 10 10',
					flex: 1,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					items: [
						{
							xtype: 'container',
							width:685,
							style:{
								overflowY : false
							},
							padding: '0 10 0 10',
							cls:'aCurveOuterBorder',
							html:'<div style="margin:0px 0px 9px 0px;display:inline-table;width:100%;">'+
								'<div class="aNewLineBottom" style="margin:15px 10px 5px 10px;padding:0px 0px 16px 0px;">'+agentStatusMsg+'.</div>'+
								'<img src="/final/images/spacer.gif" class="aIconDownload32" style="margin:13px 15px 5px 10px;vertical-align:baseline;float:left"/>'+
								'<div style="margin:15px 10px 10px 45px;font-weight:500;font-size:15px">'+agentRecommendationMsg+'</div>'+
								
								'<ul class="aDiamondBullet">'+
								'<li>'+agentRecommendation1+'. <a href="javascript:void(0)" class="aInfoMsgLinkText aLinkBottomBorder" id="downloadAgentMsg" onclick="javascript:ctrler.goToAgentDownload(\'Internal\')">'+agentRecommendationMsg1+' <img src="/final/images/spacer.gif" class="aIconDownload" style="vertical-align:baseline"/></a> '+agentRecommendationMsg2+'.</li>'+

								'<li>'+agentRecommendation2+'. <a href="javascript:void(0)" class="aInfoMsgLinkText aLinkBottomBorder" id="downloadAgentMsg" onclick="javascript:ctrler.goToAgentDownload(\'External\')">'+agentRecommendationMsg1+' <img src="/final/images/spacer.gif" class="aIconDownload" style="vertical-align:baseline"/></a> '+agentRecommendationMsg3+'.</li>'+

								'<li>'+agentRecommendation3+'. <a href="javascript:void(0)" class="aInfoMsgLinkText aLinkBottomBorder" id="downloadAgentMsg" onclick="javascript:ctrler.goToAgentDownload(\'Remote\')">'+agentRecommendationMsg1+' <img src="/final/images/spacer.gif" class="aIconDownload" style="vertical-align:baseline"/></a> '+agentRecommendationMsg4+'.</li>'+
								'</ul>'+
								'</div>'
						}
					]
				}
			]
		}
	],
	listeners: {
		close: function() 
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+compTypeChosen;
		},
		beforerender: function()
		{
			if (from == "currentpage" || from == "componentglance_ipchange")
			{
				pageDesc = pageDesc2;
				homeTitle = '<div>'+changeIPTitle+' <img src="/final/images/spacer.gif" id="homeTitle" class="iconInfoCircle" style="vertical-align:text-top;position:relative;top:2px"/></div>';
				Ext.getCmp('components').setTitle(homeTitle);
			}
			else
			{
				pageDesc = pageDesc1;
				homeTitle = '<div>'+pageTitle+' <img src="/final/images/spacer.gif" id="homeTitle" class="iconInfoCircle" style="vertical-align:text-top;position:relative;top:2px"/></div>';
				Ext.getCmp('components').setTitle(homeTitle);
			}
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDesc+'.',
				cls: "adminInfoTooltip"
			});
		}
	}

});



