Ext.define('Component.view.ComponentsGrid', {
	extend:'Ext.grid.Panel',
	alias:'widget.componentsgrid',
	id:'componentListGrid',
	requires : ['Ext.ux.data.PagingMemoryProxy'],
	ui:'newGridPanel',
	emptyText: '<div class="emptyText"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText" id=\"compDeferMessage\">'+LoadAlert1+'</div></div>',
	viewConfig: {
		deferEmptyText: true
	},
	margin:'10 0 10 10',
	flex : 1,
	initComponent : function() {
		this.dockedItems = [{
			xtype: 'pagingtoolbar',
			id:'pagingtoolbarid', 
			store: this.store,
			dock: 'bottom',
			cls:'newPagination',
			displayInfo: true
		},{
			xtype:'toolbar',
			dock:'top',
			ui:'plain',
			style:{
				'display':'flex'
			},
			margin:'0 0 10 0',
			items:[
				{
					xtype:'tbfill'
				},
				{
					xtype: 'trigger',
					labelAlign: 'top',
					labelSeparator: ' ',
					itemId: 'searchBox',
					id: 'searchBox',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls: 'whitedropdown_search',
					emptyText: 'Search',
					disabled: true,
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function()
					{
						this.reset();
					},
					onTrigger2Click: function()
					{
						ctrler.fetchComponents(this.getValue());
					}
				}
				/*{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					//cls: 'aSearch',
					cls:'whitedropdown_search',
					emptyText: 'Search',
					id:'searchBox',
					getTriggerMarkup: function() {
						var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
		
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
		
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						var val = this.getValue();
						appCnt.moreComponentSearch(val);
					},
					listeners:
					{
						change: function()
						{
							var val = this.getValue();
							appCnt.moreComponentSearch(val);
						}
					}
				}*/
			]
		}];
		this.callParent();
	},

	tools: [],
	dockedItems:[],

	columns : [
		{
			text: label_Component,
			dataIndex: 'Compname',
			flex:1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpTag = '<a id="mouse" href=\'javascript:ctrler.modifyComponent2("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		},
		{
			text: label_HostIP,
			dataIndex: 'HostIP',
			flex:1
		},
		{
			text: label_Monitoring,
			dataIndex: 'Monitoring',
			width: 160
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls:'iconModify',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.modifyComponent(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+modifyLabel+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls:'iconConfigure',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.specificTestConfigWindow(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+confLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls:'iconSetThreshold',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.specificThresholdConfigWindow(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+threshLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls:'iconMaintenance',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.gotoMaintenancePolicyPage(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+mtnLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls: 'iconUnmanage',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.unmanageComponent(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+unmgeLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls: 'iconDelete',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.deleteComponent(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+delLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls: 'iconAssetConfiguration',
			id:'iconAssetConfig',
			sortable: false,
			hidden:true,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.assetMgmt(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+assetConfigLabel+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			iconCls: 'iconIP',
			sortable: false,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.changeIP(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+cIPLbl+"' data-qclass='yellowTip'";
			}
		},
		{
			xtype: 'actioncolumn',
			//cls: 'tasks-icon-column-header tasks-delete-column-header',
			width: 36,
			iconCls:'iconDelete',
			//iconCls: 'x-hidden',
			sortable: false,
			hidden:true,
			handler: function(grid, rowIndex, colIndex) {
				ctrler.addComp(grid, rowIndex, colIndex);
			},
			renderer:function(value, metaData, record, row, col, store, gridView){
				metaData.tdAttr = "data-qtip='"+addLabel+"' data-qclass='yellowTip'";
			}
		}
	]
});



