Ext.define('Component.view.FileUploadForm', {
	extend: 'Ext.FormPanel',
	alias: 'widget.fileuploadform',
	id: 'fileUploadForm',
	width:'100%',
	fileUpload : true,
	height: 175,
	resizable: false,
	draggable: false,
	modal: true,

	items: [{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults:{
				labelSeparator: '',
				margin: 5,
				anchor: '100%',
				labelWidth: 220
			},
			margin: 10,
			items:[{
					xtype: 'radiogroup',
					fieldLabel: selActionLabel,
					cls: 'radiobt',
					id: 'bulkAddOrModify',
					name: 'bulkAddOrModify',
					listeners:{
						change:function(grp, newValue, oldValue, eOpts){
							if(oldValue['addOrModify'] === 'modify'){
							Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=AddCSV';
							} else {
							Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=ModifyCSV';

							}
						}
					},
					columns: 2,
					vertical: true,
					items: [
							{ 
							boxLabel: addLabel,
							labelAlign: 'top',
							name: 'addOrModify',
							id:'add',
							inputValue: 'add',
							checked: true
							},
							{ 
							boxLabel: modifyLabel,
							labelAlign: 'top',
							name: 'addOrModify',
							id:'modify',
							inputValue: 'modify'
							
							}
						],
					width: 480,
					labelWidth: 220
				},
				{
					xtype: 'fileuploadfield',
					cls: 'fileupload',

					fieldLabel: ChooseFileLabel,
					//allowBlank: false,
					buttonText: browsebtnLabel,
					name : 'FILE_0',
					id : 'FILE_0',
					width: 480,
					labelWidth: 220
				},
				{
								
					xtype: 'component',
					margin:0,
					id:'chg_href',
					
					autoEl: {
						tag: 'a',
						id:'chg_href',
						href: '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=AddCSV',//Here we are changing url dynamically  
						html: '<span style="padding-left:90px"><b><u>'+downloadlinkLabel+'</u></b></span>',
						
					}
					
				}
				]
			},
			{
			xtype: 'container',
			layout: {
					type: 'hbox',
					pack: 'center'
					},
			margin: 20,
			items: [
				
				{
					xtype: 'button',
					text: uploadbtnLabel,
					id: 'fileUploadBtn',
					action:'bulkComponentAction',
					cls:'button20'
				}]
			}]
});



