Ext.define('CompositeTest.controller.AddTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['CompositeTest.view.AddNewTest','CompositeTest.view.Description','Ext.ux.form.MultiSelectSI'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'},
		{selector:'compositetestgenerate', ref:'compositetestgenerate'},
		{selector:'addhelp', ref:'addhelp'},
		{selector:'defaultthresholds', ref:'defaultthresholds'}
	],
	init:function(){
		addctrler = this;
		this.buildMainData()
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest scrollcombo[id="componentType"]':
			{
				'select': this.componentTypeChanged
			},
//			'addnewtest scrollcombo[id="layerName"]':
//			{
//				'select':this.layerNameChanged
//			},
			'addnewtest scrollcombo[id="weightageName"]':
			{
				'select':this.weightageTypeChanged
			},
			'addnewtest button[id="add"]':
			{
				'click':this.addTest
			},
			'addnewtest button[id="addNewMeasure"]':
			{
				'click':this.showAddMeasure
			},
			'addnewtest button[id="backButton"]':
			{
				'click':this.goBack
			},
			'addnewtest component[id="reporterLogoIMG_enable"]':
			{
				'click':this.showWeightagePopupWindow
			},
			'addnewtest component[id="reporterLogoIMG_disable"]':
			{
				'click':this.showWeightagePopupWindow
			}
		});
	},
	showWeightagePopupWindow: function()
	{
		Ext.widget("description_window").show();
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/EgAddTestJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			}
		});
	},
	tabchange : function(tabPanel)
	{
		previousCompType = null;
		forbiddenMessage = null;
		var selectedTab = tabPanel.getActiveTab().id;
		if(selectedTab=='addtest')
		{
			Ext.Ajax.request({
				url: 'CompositeTest/data/alertJson.jsp?selectTab='+selectedTab,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						tempJson = Ext.decode( jsonText );
						if(!Ext.isEmpty(tempJson.s_compType))
						{
							previousCompType = tempJson.s_compType;
							forbiddenMessage = tempJson.forbiddenMessage;
						}
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		var me = this;
		Ext.getCmp('componentType').getStore().clearFilter(true);
		Ext.getCmp('componentType').getStore().suspendEvents(true);
		Ext.getCmp('componentType').getStore().loadRawData(publicJSON.compTypes);
		Ext.getCmp('componentType').getStore().resumeEvents();
		Ext.getCmp('componentType').select(Ext.getCmp('componentType').getStore().getAt(0));
		Ext.getCmp('allowedId').hide();
		Ext.getCmp('add').hide();
		Ext.getCmp('common_page_desc').update(
		'<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+addPageDesc+'.</center>');
	},
	goBack: function()
	{
		Ext.Ajax.request({
			url: 'CompositeTest/data/LookForChanges.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					tempJson = Ext.decode( jsonText );
					if(tempJson.alertUser)
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: confirmBackBtn,
							closable: false,
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							width: 300,
							fn: function(response) {
									if(response == 'yes') {
										window.location.href= '/final/admin/compositeTest.jsp';
									}
								}
						});
					}
					else
					{
						window.location.href= '/final/admin/compositeTest.jsp';
					}
				}
			}
		});
	},
	componentTypeChanged: function()
	{
		var addObj = Ext.getCmp('add');
		var optionObj = Ext.getCmp('allowedId');
		var stestObj = Ext.getCmp('testForInfos');
		var selVal = Ext.getCmp('componentType').getValue();
		if(selVal == null || selVal=='-1')
		{
			optionObj.hide();
			addObj.hide();
			stestObj.hide();
			return;
		}
		var descriptor_based = Ext.getCmp("allowedId").getValue().is_info_based_test;
		var test_for_infos = Ext.getCmp('testForInfos').getValue();
		var dyna_param_value = {'compType':selVal};
		var test_for_info_url = "testForInfos.jsp";
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+test_for_info_url,
			method: 'POST',
			params : dyna_param_value,
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					test_for_infos_json = Ext.decode( jsonText );
					Ext.getCmp('testForInfos').getStore().clearFilter(true);
					Ext.getCmp('testForInfos').getStore().suspendEvents(true);
					Ext.getCmp('testForInfos').getStore().loadRawData(test_for_infos_json.individual_tests);
					Ext.getCmp('testForInfos').getStore().resumeEvents();
					Ext.getCmp('testForInfos').setValue(test_for_infos_json.selectedTest);
				}
			}
		});
		optionObj.show();
		addObj.show();
		if(descriptor_based=='true')
			stestObj.show();
		else
			stestObj.hide();
	},
	layerNameChanged: function()
	{
		var confContainder = Ext.getCmp('confirmationContainer');
		var generateButtonObj = Ext.getCmp('generateButton');
		var selVal = Ext.getCmp('layerName').getValue();
		if(selVal == null || selVal=='-1')
		{
			confContainder.setVisible(false);
			Ext.getCmp('associated_comptypes').setVisible(false);
			generateButtonObj.hide();
		}
		else
		{
			Ext.Ajax.request(
				{
					url: 'CompositeTest/data/lookForCompTypes.jsp?layer='+selVal+'&lastSelection='+Ext.getCmp('testforId').getValue().testfor,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var compLayerJSON = Ext.decode( response.responseText );
							if(genJSON.is_predefined_test)
							{
								generateButtonObj.hide();
							}
							else
							{
								generateButtonObj.show();
							}
							confContainder.setVisible(true);
							var m_radio_obj = Ext.getCmp('testforId');
							m_radio_obj.setVisible(true);
							if(compLayerJSON.lastSelection=='yes')
							{
								m_radio_obj.items.items[0].setValue(true);
								Ext.getCmp('associated_comptypes').setVisible(true);
							}
							else
							{
								m_radio_obj.items.items[1].setValue(true);
								Ext.getCmp('associated_comptypes').setVisible(false);
							}
							fromAssociatedComponentsFound=false;
							toAssociatedComponentsFound=false;
							Ext.getCmp('associated_comptypes').fromField.store.removeAll();
							Ext.getCmp('associated_comptypes').toField.store.removeAll();
							if(compLayerJSON.associatedComponentsFound)
							{
								fromAssociatedComponentsFound=true;
								var myFromField = Ext.getCmp('associated_comptypes').fromField;
								myFromField.store.add(compLayerJSON['associatedComponents']);
								fromStore = compLayerJSON['associatedComponents'];
							}
							if(compLayerJSON.availableComponentsFound)
							{
								toAssociatedComponentsFound=true;
								var myToField = Ext.getCmp('associated_comptypes').toField;
								myToField.store.add(compLayerJSON['availableComponents']);
								toStore = compLayerJSON['availableComponents'];
							}
						}
					}
				});
		}
	},
	weightageTypeChanged: function()
	{
		var selVal = Ext.getCmp('weightageName').getValue();
		if(selVal == null || selVal=='SystemDefined')
		{
			Ext.getCmp("reporterLogoIMG_enable").show();
			Ext.getCmp("reporterLogoIMG_disable").hide();
			Ext.getCmp("alaramKeyContainer").hide();
			Ext.getCmp("alaramSupportContainer").hide();
		}
		else
		{
			Ext.getCmp("reporterLogoIMG_enable").hide();
			Ext.getCmp("reporterLogoIMG_disable").show();
			Ext.getCmp("alaramKeyContainer").show();
			Ext.getCmp("alaramSupportContainer").show();
		}
	},
	addTest: function()
	{
		var me = this;
		if (!this.validate())
		{
			return;
		}
		isModifyTest = false;
		if (testTabLoad)
		{
			this.testModifyAlone();
			return;
		}
		var display_name = Ext.getCmp('test_display_name').getValue();
		var component_type = Ext.getCmp('componentType').getValue();
		var display_component_type = Ext.getCmp('componentType').getRawValue();
		if(component_type == null || component_type=='-1')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:compTypeAlert,
					buttons: Ext.Msg.OK
				});
			return;
		}
		var selected_master_test = '-1';
		var descriptor_based = Ext.getCmp("allowedId").getValue().is_info_based_test;
		if(descriptor_based=='true')
		{
			selected_master_test = Ext.getCmp('testForInfos').getValue();
			if(selected_master_test == null || selected_master_test=='-1')
			{
				Ext.Msg.show({
						title: pageTitle1,
						msg: message2,
						buttons: Ext.Msg.OK
					});
				return;
			}
		}
		var purpose_of_test = Ext.getCmp('cx_test_description').getValue();
		var dyna_param_value = {'display_name':encodeURIComponent(display_name),'compType':component_type,'operation':'addTest','purpose_of_test':encodeURIComponent(purpose_of_test),'descriptor_based':descriptor_based,'selected_master_test':selected_master_test};
		var urlStr = "EgaddtestpJson.jsp?add=test";
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+urlStr,
			method: 'POST',
			params : dyna_param_value,
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'COULD_NOT_CREATE_TEST')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			// Composite test will not be created correctly if you remove below line.
			Ext.getCmp('test').setValue(publicJSON.newCompTestName);
			if(publicJSON.isNewTestEntry)
			{
				Ext.getCmp('addMeasureTab').enable();
				Ext.getCmp('newtest').setActiveTab(1);
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					closable: false,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					width: 300,
					fn: function(response) {
							if(response == 'ok') {
								Ext.getCmp('addMeasureTab').enable();
								Ext.getCmp('newtest').setActiveTab(1);
							}
						}
				});
			}
		}
	},
	validate:function()
	{
		var testDescObj = Ext.getCmp('cx_test_description');
		var testDispObj = Ext.getCmp('test_display_name');
		if(!checkblank(testDispObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: testDisplayAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDispObj.focus(true);
			return false;
		}
		else if(!checkblank(testDescObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: testDescriptionAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDispObj.focus(true);
			return false;
		}
		else if(!this.checkSpecialChar(testDispObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDispObj.focus(true);
			return false;				
		}
		else if(!this.checkSpecialChar(testDescObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDescObj.focus(true);
			return false;				
		}
		return true;
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	},
	weightageValidation: function()
	{
		key_minor = Ext.getCmp("alarmKeyMin").getValue().toString().toLowerCase();
		key_major = Ext.getCmp("alarmKeyMaj").getValue().toString().toLowerCase();
		if(key_minor == null || key_minor.length==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMin').focus(true);
				}
			});
			return false;
		}
		else if(key_minor.indexOf(" ")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMin').focus(true);
				}
			});
			return false;
		}
		else if(key_major == null || key_major.length==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMaj').focus(true);
				}
			});
			return false;
		}
		else if(key_major.indexOf(" ")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert4,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMaj').focus(true);
				}
			});
			return false;
		}
		else if(key_minor != 'none' && isNaN(key_minor))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert5,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMin').focus(true);
				}
			});
			return false;
		}
		else if(key_minor != 'none' && !isNaN(key_minor) && key_minor.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert6,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMin').focus(true);
				}
			});
			return false;
		}
		else if(key_major !='none' && isNaN(key_major))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert7,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMaj').focus(true);
				}
			});
			return false;
		}
		else if(key_major !='none' && !isNaN(key_major) && key_major.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert8,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmKeyMaj').focus(true);
				}
			});
			return false;
		}
		key_normal = Ext.getCmp("alarmKeyN").getValue().toString().toLowerCase();
		key_critical = Ext.getCmp("alarmKeyCri").getValue().toString().toLowerCase();
		if(key_minor=='none' && key_major=='none')
		{
			if(parseInt(key_critical) >= parseInt(key_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert9,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyCri').focus(true);
					}
				});
				return false;
			}
		}
		else if(key_minor != 'none' && key_major=='none')
		{
			if(parseInt(key_minor)>=parseInt(key_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert10,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyMin').focus();
					}
				});
				return false;
			}
			else if(parseInt(key_critical)>parseInt(key_minor))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyCri').focus();
					}
				});
				return false;
			}
		}
		else if(key_minor=='none' && key_major !='none')
		{
			if(parseInt(key_major)>=parseInt(key_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyMaj').focus(true);
					}
				});
				return false;
			}
			else if(parseInt(key_critical)>parseInt(key_major))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert13,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyCri').focus(true);
					}
				});
				return false;
			}
		}
		else if(key_minor !='none' && key_major !='none')
		{
			if(parseInt(key_normal) > parseInt(key_minor))
			{
				if(parseInt(key_minor) >= parseInt(key_major))
				{
					if(parseInt(key_major) >= parseInt(key_critical))
					{
						// go and check for non-key measures
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: weightageAlert14,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('alarmKeyCri').focus(true);
							}
						});
						return false;
					}
				}
				else
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: weightageAlert15,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('alarmKeyMaj').focus(true);
						}
					});
					return false;
				}
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert16,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmKeyMin').focus(true);
					}
				});
				return false;
			}
		}
		support_minor= Ext.getCmp("alarmSupMin").getValue().toString().toLowerCase();
		support_major = Ext.getCmp("alarmSupMaj").getValue().toString().toLowerCase();
		if(support_minor == null || support_minor.length==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMin').focus(true);
				}
			});
			return false;
		}
		else if(support_minor.indexOf(" ")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMin').focus(true);
				}
			});
			return false;
		}
		else if(support_major == null || support_major.length==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMaj').focus(true);
				}
			});
			return false;
		}
		else if(support_major.indexOf(" ")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMaj').focus(true);
				}
			});
			return false;
		}
		else if(support_minor != 'none' && isNaN(support_minor))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert21,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMin').focus(true);
				}
			});
			return false;
		}
		else if(support_minor != 'none' && !isNaN(support_minor) && support_minor.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert22,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMin').focus(true);
				}
			});
			return false;
		}
		else if(support_major !='none' && isNaN(support_major))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert23,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMaj').focus(true);
				}
			});
			return false;
		}
		else if(support_major !='none' && !isNaN(support_major) && support_major.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert24,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupMaj').focus(true);
				}
			});
			return false;
		}
		support_normal = Ext.getCmp("alarmSupN").getValue().toString().toLowerCase();
		support_critical = Ext.getCmp("alarmSupCri").getValue().toString().toLowerCase();
		if(support_minor=='none' && support_major=='none')
		{
			if(parseInt(support_critical) >= parseInt(support_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert25,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupCri').focus(true);
					}
				});
				return false;
			}
		}
		else if(support_minor != 'none' && support_major=='none')
		{
			if(parseInt(support_minor)>=parseInt(support_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert26,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupMin').focus(true);
					}
				});
				return false;
			}
			else if(parseInt(support_critical)>parseInt(support_minor))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert27,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupCri').focus(true);
					}
				});
				return false;
			}
		}
		else if(support_minor=='none' && support_major !='none')
		{
			if(parseInt(support_major)>=parseInt(support_normal))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert28,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupMaj').focus(true);
					}
				});
				return false;
			}
			else if(parseInt(support_critical)>parseInt(support_major))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert29,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupCri').focus(true);
					}
				});
				return false;
			}
		}
		else if(support_minor !='none' && support_major !='none')
		{
			if(parseInt(support_normal) > parseInt(support_minor))
			{
				if(parseInt(support_minor) >= parseInt(support_major))
				{
					if(parseInt(support_major) >= parseInt(support_critical))
					{
						return true;
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: weightageAlert30,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('alarmSupCri').focus(true);
							}
						});
						return false;
					}
				}
				else
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: weightageAlert31,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('alarmSupMaj').focus(true);
						}
					});
					return false;
				}
			}
			else
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: weightageAlert32,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('alarmSupMin').focus(true);
					}
				});
				return false;
			}
		}
		if(key_normal != support_normal)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: weightageAlert33,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('alarmSupN').focus(true);
				}
			});
			return false;
		}

		return true;
	},
	loadMeasureTab: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var urlStr = 'EgConfigMeasureJson.jsp?test='+test;
		compTestCtrlr = this.getController('CompositeTest.controller.MeasureWindowController');
		compTestCtrlr.init();
		compTestCtrlr.loadAddMeasureTab(urlStr);
	},
	showAddMeasure: function()
	{
		operationCompMeasure='addCompMeasure';
		compTestCtrlr = this.getController('CompositeTest.controller.MeasureWindowController');
		compTestCtrlr.loadPopup();
	},
	loadGenerateTab:function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var predefinedtest = (test.indexOf('_')==test.lastIndexOf('_'));
		var cntnrObj = Ext.getCmp('generateCntnr');
		cntnrObj.removeAll();
		cntnrObj.add(
			{
				xtype: 'container',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				margin: 5,
				items: [
					{
						xtype: 'container',
						id:'dp_container_generate',
						layout: {
							type: 'hbox',
							pack: 'center'
						},
						hidden: false,
						cls: 'formOuter',
						padding: 5,
						defaultType: 'displayfield',
						defaults: {
							labelAlign: 'top',
							labelSeparator: '',
							width: 250,
							margin: 5
						},
						items: [
							{
								fieldLabel: '<b>'+test_name_label+'</b>',
								value: '-',
								id:'dp_testname_generate_tab'
							},
							{
								fieldLabel: '<b>'+compTypeDesc+'</b>',
								value: '-',
								id:'dp_comptype_generate_tab'
							},
							{
								fieldLabel: '<b>'+descbased+'</b>',
								value: '-',
								id:'dp_descriptor_generate_tab'
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				margin: 10,
				items: [
					{
						xtype: 'container',
						layout: {
							type: 'hbox',
							pack: 'center'
						},
						defaults: {
							labelAlign: 'top',
							labelSeparator: '',
							margin: 5,
							width: 250
						},
						items: [
							{
								xtype: 'scrollcombo',
								id:'layerName',
								name:'layerName',
								hidden:false,
								fieldLabel: layerLabel,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField:'displayField',
								valueField:'valueField',
								queryMode : 'local',
								editable: false,
								listeners: {
										select : function()
										{
											me.layerNameChanged();
										}
								}
							},
							{
								xtype: 'fieldcontainer',
								layout: 'column',
								fieldLabel: weightageLabel,
								columnWidth: 0.25,
								items: [
									{
										xtype: 'scrollcombo',
										id:'weightageName',
										name:'weightageName',
										hidden:false,
										store: new Ext.data.Store({
											fields : ['displayField', 'valueField'],
											data : []
										}),
										displayField:'displayField',
										valueField:'valueField',
										queryMode : 'local',
										editable: false,
										columnWidth: .90,
										listeners: {
												select : function()
												{
													me.weightageTypeChanged();
												}
											}
									},
									{
										xtype: 'component',
										id : 'reporterLogoIMG_enable',
										name : 'reporterLogoIMG_enable',
										html: '<center><div class="iconUpload" style="cursor:pointer;margin-top: -3px" border="0" width="20" height="18" title="Click here to see weightage" onclick="addctrler.showWeightagePopupWindow()"></center>',
										columnWidth: 0.10,
										margin: '8 0 0 2',
										hidden:false
									},
									{
										xtype: 'component',
										id : 'reporterLogoIMG_disable',
										name : 'reporterLogoIMG_disable',
										html: '<center><div class="iconUploadDisabled" style="margin-top: -3px" border="0" width="20" height="18"></center>',
										columnWidth: 0.10,
										margin: '8 0 0 2',
										hidden:true
									}
								]
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				margin: 10,
				items: [
					{
						xtype: 'fieldset',
						title: alaramKeyMeasure,
						id:'alaramKeyContainer',
						name:'alaramKeyContainer',
						layout: {
							type: 'hbox',
							pack: 'center'
						},
						defaults: {
							labelSeparator: '',
							labelAlign: 'top',
							margin: 10
						},
						items: [
							{
								xtype: 'numberfield',
								cls:'textbox',
								name: 'alarmKeyN',
								id: 'alarmKeyN',
								fieldLabel: alarmKeyNor,
								allowBlank:false,
								minValue:keyNormal_default,
								value:keyNormal_default,
								allowDecimals:false,
								hideTrigger:true,
								keyNavEnabled:false,
								mouseWheelEnabled:false
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								name: 'alarmKeyMin',
								id: 'alarmKeyMin',
								value:keyMinor_default,
								fieldLabel: alarmKeyMin,
								allowBlank:false
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								name: 'alarmKeyMaj',
								id: 'alarmKeyMaj',
								value:keyMajor_default,
								fieldLabel: alarmKeyMaj,
								allowBlank:false
							},
							{
								xtype: 'numberfield',
								cls:'textbox',
								name: 'alarmKeyCri',
								id: 'alarmKeyCri',
								fieldLabel: alarmKeyCritical,
								allowBlank:false,
								minValue:keyCritical_default,
								value: keyCritical_default,
								allowDecimals:false,
								hideTrigger:true,
								keyNavEnabled:false,
								mouseWheelEnabled:false
							}
						]
					},
					{
						xtype: 'fieldset',
						title: alaramSupportMeasure,
						id:'alaramSupportContainer',
						name:'alaramSupportContainer',
						layout: {
							type: 'hbox',
							pack: 'center'
						},
						defaults: {
							labelSeparator: '',
							labelAlign: 'top',
							margin: 10
						},
						items: [
							{
								xtype : 'numberfield',
								cls:'textbox',
								fieldLabel : alarmKeyNor,
								id : 'alarmSupN',
								allowBlank:false,
								minValue:supportNormal_default,
								value: supportNormal_default,
								allowDecimals:false,
								hideTrigger:true,
								keyNavEnabled:false,
								mouseWheelEnabled:false
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								name: 'alarmSupMin',
								id: 'alarmSupMin',
								fieldLabel: alarmKeyMin,
								allowBlank:false,
								value: supportMinor_default
							},
							{
								xtype: 'textfield',
								cls:'textbox',
								name: 'alarmSupMaj',
								id: 'alarmSupMaj',
								fieldLabel: alarmKeyMaj,
								allowBlank:false,
								value: supportMajor_default
							},
							{
								xtype: 'numberfield',
								cls:'textbox',
								name: 'alarmSupCri',
								id: 'alarmSupCri',
								fieldLabel: alarmKeyCritical,
								allowBlank:false,
								minValue:supportCritical_default,
								value: supportCritical_default,
								allowDecimals:false,
								hideTrigger:true,
								keyNavEnabled:false,
								mouseWheelEnabled:false
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				id: 'confirmationContainer',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: 10,
				items: [
					{
						xtype:'container',
						layout: {
							type: 'vbox',
							pack: 'center',
							align: 'center'
						},
						defaults: {
							labelSeparator: '',
							margin: 5,
							width: 500,
							labelWidth: 350
						},
						items: [
							{
								xtype: 'radiogroup',
								fieldLabel: autoAssociateLabel,
								columns: 2,
								cls:'radiobt',
								id: 'testforId',
								listeners: {
									click: {
										element: 'el',
										fn: function (id) {
											if(Ext.getCmp(this.id).getValue().testfor=='yes') {
												Ext.getCmp('associated_comptypes').setVisible(true);
											}
											else {
												Ext.getCmp('associated_comptypes').setVisible(false);
											}
										}
									}
								},
								items: [
									{
										boxLabel: yes,
										name: 'testfor',
										id:'managedcomponents',
										inputValue: 'yes',
									},
									{
										boxLabel: no,
										name: 'testfor',
										id:'allcomponents',
										inputValue: 'no',
										checked: true
									}
								]
							}
						]
					}
				]
			},
			{
				xtype: 'container',
				id: 'associatedCompTypesContainer',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: '0 10 20 10',
				items: [
					{
						xtype: 'itemselector',
						name: 'associated_comptypes',
						fieldName: 'associated_comptypes',
						id: 'associated_comptypes',
						cls:'multiselect',
						hidden: true,
						buttons: ['add','remove'],
						buttonsText: {
							add: 'Disassociate',
							remove: 'Associate'
						},
						store: new Ext.data.Store(
						{
							fields: ['displayField','valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						msgTarget: 'side',
						height: 250,
						width: 700,
						fromTitle: associatedCompTypesDesc,
						toTitle: availableCompTypesDesc,
						onAddBtnClick : function() {
							var me = this,
							selected = me.getSelections(me.fromField.boundList);
							me.moveRec(true, selected);
							me.toField.boundList.getSelectionModel().select(selected);
						},
						onRemoveBtnClick : function() {
							var me = this,
							selected = me.getSelections(me.toField.boundList);
							me.moveRec(false, selected);
							me.fromField.boundList.getSelectionModel().select(selected);
						},
						onItemDblClick: function(view, rec) {
							this.moveRec(view === this.fromField.boundList, rec);
						},
						syncValue: function() {
							var me = this;
							me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
						}
					},
					{
						xtype: 'multiselectSi',
						title: associatedCompTypesDesc,
						cls:'multiselect',
						id : 'defaultAssociatedComponents',
						name: 'defaultAssociatedComponents',
						displayField: 'displayField',
						valueField: 'valueField',
						autoScroll:true,
						scroll:false,
						hidden:true,
						height: 250,
						width: 420,
						store:new Ext.data.Store({
							fields: ['displayField','valueField'],
							data: []
						})
					}
				]
			},
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: '10 10 20 10',
				items:[
					{
						xtype: 'button',
						id: 'generateButton',
						name: 'generateButton',
						cls : 'button20',
						text: 'Generate Test',
						hidden:predefinedtest?true:false,
						testName: test,
						handler: function() {
							me.generateCompTest(this.testName);
						},
						width: 100
					}
				]
			}
		);
		genJSON = null;
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/generateTestJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					genJSON = Ext.decode( jsonText );
					showModifyTestAlert = genJSON.modifyTestAlert;
					var layerObj=Ext.getCmp('layerName');
					layerObj.getStore().loadRawData(genJSON.layers);
					layerObj.select(genJSON.selectedLayer);
					defaultCompType = genJSON.defaultCompType;
					var confContainer = Ext.getCmp('confirmationContainer');
					confContainer.setVisible(false);
					var generateButtonObj = Ext.getCmp('generateButton');
					generateButtonObj.hide();
					if(genJSON.selectedLayer != '-1')
					{
						confContainer.setVisible(true);
						generateButtonObj.show();
						Ext.getCmp('confirmationContainer').setVisible(true);
						var m_radio_obj = Ext.getCmp('testforId');
						m_radio_obj.setVisible(true);
						if(genJSON.multipleCompTypesAreAssociated)
						{
							m_radio_obj.items.items[0].setValue(true);
							if(genJSON.is_predefined_test)
							{
								Ext.getCmp('defaultAssociatedComponents').setVisible(true);
								Ext.getCmp('associated_comptypes').setVisible(false);
							}
							else
							{
								Ext.getCmp('associated_comptypes').setVisible(true);
								Ext.getCmp('defaultAssociatedComponents').setVisible(false);
							}
						}
						else
						{
							m_radio_obj.items.items[1].setValue(true);
							if(genJSON.is_predefined_test)
							{
								Ext.getCmp('defaultAssociatedComponents').setVisible(true);
							}
							else
							{
								Ext.getCmp('defaultAssociatedComponents').setVisible(false);
							}
							Ext.getCmp('associated_comptypes').setVisible(false);
						}
						if(genJSON.is_predefined_test)
						{
							m_radio_obj.setVisible(false);
							m_radio_obj.items.items[0].setValue(true);
							m_radio_obj.items.items[0].setDisabled(true);
							m_radio_obj.items.items[1].setDisabled(true);
							//Ext.getCmp('associated_comptypes').setVisible(true);
						}
						fromAssociatedComponentsFound=false;
						toAssociatedComponentsFound=false;
						Ext.getCmp('associated_comptypes').fromField.store.removeAll();
						Ext.getCmp('associated_comptypes').toField.store.removeAll();
						if(genJSON.associatedComponentsFound)
						{
							fromAssociatedComponentsFound=true;
							var myFromField = Ext.getCmp('associated_comptypes').fromField;
							myFromField.store.add(genJSON['associatedComponents']);
							fromStore = genJSON['associatedComponents'];
							if(genJSON.is_predefined_test)
							{
								Ext.getCmp("defaultAssociatedComponents").clearValue();
								Ext.getCmp('defaultAssociatedComponents').getStore().loadRawData(genJSON['associatedComponents']);
							}
						}
						if(genJSON.availableComponentsFound)
						{
							toAssociatedComponentsFound=true;
							var myToField = Ext.getCmp('associated_comptypes').toField;
							myToField.store.add(genJSON['availableComponents']);
							toStore = genJSON['availableComponents'];
						}
					}
					Ext.getCmp('dp_testname_generate_tab').setValue(genJSON.test_desc_generate_tab);
					Ext.getCmp('dp_comptype_generate_tab').setValue(genJSON.type_desc_generate_tab);
					Ext.getCmp('dp_descriptor_generate_tab').setValue(genJSON.descriptor_generate_tab);

					var weightageObj=Ext.getCmp('weightageName');
					weightageObj.getStore().loadRawData(genJSON.weightageTypes);
					weightageObj.select(genJSON.selectedWeightageType);
					me.weightageTypeChanged();
					if(genJSON.selectedWeightageType=='CustomDefined')
					{
						Ext.getCmp('alarmKeyN').setValue(genJSON.keyNormal);
						Ext.getCmp('alarmKeyMin').setValue(genJSON.keyMinor);
						Ext.getCmp('alarmKeyMaj').setValue(genJSON.keyMajor);
						Ext.getCmp('alarmKeyCri').setValue(genJSON.keyCritical);
						Ext.getCmp('alarmSupN').setValue(genJSON.supportNormal);
						Ext.getCmp('alarmSupMin').setValue(genJSON.supportMinor);
						Ext.getCmp('alarmSupMaj').setValue(genJSON.supportMajor);
						Ext.getCmp('alarmSupCri').setValue(genJSON.supportCritical);
					}
					if(genJSON.isModifyTest)
					{
						Ext.getCmp('generateButton').setText(update);
					}
					else
					{
						Ext.getCmp('generateButton').setText(generate);
					}
				}
			}
		});
	},
	generateCompTest: function(test)
	{
		var layer = Ext.getCmp("layerName").getValue();
		if(layer== null || layer=='-1')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:layerAlert,
					buttons: Ext.Msg.OK
				});
			return;
		}
		if(!this.weightageValidation())
		{
			return;
		}

		var newly_associated_comp_types='';
		if(Ext.getCmp('testforId').getValue().testfor=='yes')
		{
			var tmpStore = Ext.getCmp('associated_comptypes');
			var associatedComponentsList = tmpStore.fromField.store;
			for(var m=0;m<tmpStore.fromField.store.getCount();m++)
			{
				var s_val = associatedComponentsList.getAt(m).get('valueField');
				newly_associated_comp_types += ','+s_val.trim();
			}
			if(newly_associated_comp_types.length>0)
			{
				newly_associated_comp_types = newly_associated_comp_types.substring(1);
			}
			if(newly_associated_comp_types.length==0)// || (','+newly_associated_comp_types+',').indexOf((','+defaultCompType+','))==-1)
			{
				Ext.Msg.show({
						title: pageTitle1,
						msg:cannotMsg,
						buttons: Ext.Msg.OK
					});
					Ext.getCmp('associated_comptypes').fromField.store.removeAll();
					Ext.getCmp('associated_comptypes').toField.store.removeAll();
					if(fromAssociatedComponentsFound)
					{
						var myFromField = Ext.getCmp('associated_comptypes').fromField;
						myFromField.store.add(fromStore);
					}
					if(toAssociatedComponentsFound)
					{
						var myToField = Ext.getCmp('associated_comptypes').toField;
						myToField.store.add(toStore);
					}
				return;
			}
		}
		if(newly_associated_comp_types.length==0)
		{
			newly_associated_comp_types=defaultCompType;
		}
		var weightage = Ext.getCmp('weightageName').getValue();
		var key_normal=keyNormal_default;
		var key_minor=keyMinor_default;
		var key_major=keyMajor_default;
		var key_critical=keyCritical_default;
		var support_normal=supportNormal_default;
		var support_minor=supportMinor_default;
		var support_major=supportMajor_default;
		var support_critical=supportCritical_default;

		if(weightage=='CustomDefined')
		{
			key_normal = Ext.getCmp('alarmKeyN').getValue();
			key_minor = Ext.getCmp('alarmKeyMin').getValue();
			key_major = Ext.getCmp('alarmKeyMaj').getValue();
			key_critical = Ext.getCmp('alarmKeyCri').getValue();
			support_normal = Ext.getCmp('alarmSupN').getValue();
			support_minor = Ext.getCmp('alarmSupMin').getValue();
			support_major = Ext.getCmp('alarmSupMaj').getValue();
			support_critical = Ext.getCmp('alarmSupCri').getValue();
		}

		var s_alert = generateTest; //generate test message
		if(genJSON.isModifyOperationNow) {
			s_alert = confrmMsg; //simple update test message
			if(genJSON.showModifyTestAlert || (genJSON.selectedLayer!=Ext.getCmp('layerName').getValue())) {
				s_alert=regenerateTest; //regenerate test message
			}
		}

		var weightageStr="Key:"+key_normal+":"+key_minor+":"+key_major+":"+key_critical+"#Sup:"+support_normal+":"+support_minor+":"+support_major+":"+support_critical;
		Ext.Msg.show({
			title: pageTitle1,
			msg:s_alert,
			closable: false,
			icon: 'iconInformation',
			buttons: Ext.Msg.YESNO,
			fn: function(response) {
				if(response == 'yes') {
					Ext.Ajax.request(
					{
						url: 'CompositeTest/data/generateTestp.jsp?compTest='+test,
						method: 'POST',
						params : {'layer':layer,'weightageName':weightage,'weightageStr':weightageStr,'newly_associated_comp_types':newly_associated_comp_types},
						async:false,
						success: function( response )
						{
							if(response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
								Ext.Msg.show({
									title: pageTitle1,
									msg:publicJSON.operationResultMessage,
									closable: false,
									icon: 'iconInformation',
									buttons: Ext.Msg.OK,
									fn: function(response) {

										if(!publicJSON.isFailure && response == 'ok')
										{
											window.location.href= '/final/admin/compositeTest.jsp';
										}
									}
								});
							}
						}
					});
				}
			}
		});
	},
	postURL:function(urlStr)
	{
		Ext.Ajax.request(
			{
				url: 'CompositeTest/data/'+urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
	},
	loadTestTab: function()
	{
		var testObj = Ext.getCmp('test');
		var test = testObj.getValue();
		if (test != null && test != '')
		{
			testTabLoad = true;
			testObj.setReadOnly(true);
			Ext.getCmp('add').setText(updateTooltip);
		}
	},
	testModifyAlone: function()
	{
		var me = this;
		if (!this.validate())
		{
			return;
		}
		var test = Ext.getCmp('test').getValue();
		var display_name = Ext.getCmp('test_display_name').getValue();
		var component_type = Ext.getCmp('componentType').getValue();
		if(component_type == null || component_type=='-1')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:compTypeAlert,
					buttons: Ext.Msg.OK
				});
			return;
		}
		else if(previousCompType != null && previousCompType != component_type)
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:forbiddenMessage,
					buttons: Ext.Msg.OK
				});
			return;
		}
		var purpose_of_test = Ext.getCmp('cx_test_description').getValue();
		var descriptor_based = Ext.getCmp("allowedId").getValue().is_info_based_test;

		var selected_master_test = '-1';
		if(descriptor_based=='true')
		{
			selected_master_test = Ext.getCmp('testForInfos').getValue();
			if(selected_master_test == null || selected_master_test=='-1')
			{
				Ext.Msg.show({
						title: pageTitle1,
						msg: message2,
						buttons: Ext.Msg.OK
					});
				return;
			}
		}

		var dyna_param_value = {'display_name':encodeURIComponent(display_name),'compType':component_type,'operation':'modifyTest','purpose_of_test':encodeURIComponent(purpose_of_test),'descriptor_based':descriptor_based,'selected_master_test':selected_master_test};
		var urlStr = "EgaddtestpJson.jsp?add=test&test="+test;
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+urlStr,
			method: 'POST',
			params : dyna_param_value,
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg:publicJSON.AlertMsg,
				closable: false,
				icon: 'iconInformation',
				buttons: Ext.Msg.OK,
				fn: function(response) {
						if(response == 'ok') {
							Ext.getCmp('addMeasureTab').enable();//to move the measure tab, as asked by boss
							Ext.getCmp('newtest').setActiveTab(1);//to move the measure tab, as asked by boss
						}
					}
			});
		}
	}
});


