Ext.define('CompositeTest.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Tests'],
	requires:['CompositeTest.view.Tests','CompositeTest.view.TestMeasures','CompositeTest.view.CompTypesForTest'],
	refs:[
		{selector:'tests', ref:'tests'},
		{selector:'testmeasures', ref:'testmeasures'},
		{selector:'comptypesfortest', ref:'comptypesfortest'}
	],
	init:function(){
		ctrler = this;
		this.rowBodyTrSelector = '.x-grid-rowbody-tr';
		this.rowBodyHiddenCls = 'x-grid-row-body-hidden';
		this.rowCollapsedCls = 'x-grid-row-collapsed';
		this.recordsExpanded = {};
		this.buildMainData()
		this.control({
			'tests':
			{
				'afterrender': this.afterMainRender
			},
			'tests trigger[id="searchBox"]':
			{
				'change': this.searchTest
			},
			'tests button[id="addTestButton"]':
			{
				'click':this.addNewTest
			},
			'testmeasures button[id="showAll_popup"]':
			{
				'click':this.showHideMeasures
			},
			'comptypesfortest' : {
				'beforeclose': this.thisclose
			},
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/EgTestJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		keyNormal_default = publicJSON.keyNormal;
		keyMinor_default = publicJSON.keyMinor;
		keyMajor_default = publicJSON.keyMajor;
		keyCritical_default = publicJSON.keyCritical;
		supportNormal_default = publicJSON.supportNormal;
		supportMinor_default = publicJSON.supportMinor;
		supportMajor_default = publicJSON.supportMajor;
		supportCritical_default = publicJSON.supportCritical;
		if(keyMinor_default.toLowerCase()=='none' || keyMajor_default.toLowerCase()=='none')
		{
			system_defined_weightage_for_normal=keyNormal_default;
			system_defined_weightage_for_minor=noneWeightageLabel+' ('+commonWeightageLabel+')';
			system_defined_weightage_for_major=noneWeightageLabel+' ('+commonWeightageLabel+')';
			system_defined_weightage_for_critical=keyCritical_default;
		}
		else
		{
			system_defined_weightage_for_normal=keyNormal_default;
			system_defined_weightage_for_minor=keyMinor_default;
			system_defined_weightage_for_major=keyMajor_default;
			system_defined_weightage_for_critical=keyCritical_default;
		}
		if (publicJSON.noUDTestsFound)
		{
			Ext.getCmp('udGrid').getStore().removeAll();
			Ext.getCmp('searchBox').disable();
		}
		else
		{
			Ext.getCmp('searchBox').enable();
			var gridObj = Ext.getCmp('udGrid');
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(publicJSON.testsList);
		}
	},
	searchTest: function()
	{
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'CompositeTest/data/EgTestJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
		if (publicJSON.noSrchItemFound)
		{
			Ext.getCmp('udGrid').getStore().removeAll();
			Ext.get('noUdTestsAlrtDiv').update(noSrcTestFnd+'.');
		}
		else
		{
			var gridObj = Ext.getCmp('udGrid');
			gridObj.getStore().removeAll();
			gridObj.getStore().loadRawData(publicJSON.testsList);
		}
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	addNewTest: function()
	{
		Ext.getCmp('ictestviewport').removeAll();
		this.getController('AddTestCtrlr').init();
		Ext.getCmp('ictestviewport').add(
			{
				xtype: 'addnewtest'
			});
	},
	thisclose: function()
	{
		Ext.getCmp('comptypesfortest').destroy();
	},
//	getAssociatedServersForCompTest : function(comptest)
//	{
//		scompTest=comptest;
//		Ext.widget('comptypesfortest').show();
//	},
	getAssociatedServersForCompTest: function(comptest,grid, rowIndex, colIndex)
	{
		associateDisassociateServers = true;
		scompTest=comptest;
		var obj = grid.getStore().getAt(rowIndex);
		var test = obj.get('test');
		var testType = 'testhomepage';
		addctrler = this.getController('CompositeTest.controller.AddTestCtrlr');
		Ext.getCmp('ictestviewport').removeAll();
		this.getController('ModifyTestCtrlr').init(test, testType);
		Ext.getCmp('ictestviewport').add({
				xtype: 'addnewtest'
		});
		isModifyTest = true;
	},
	deleteTest:function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var testName = obj.get('test');
		Ext.Msg.show({
			title: pageTitle1,
			msg: confrmMsg_delete_test+' \''+obj.get('displayName')+'\'?',
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response === 'yes')
				{
					var urlStr = "CompositeTest/data/EgDelTestJson.jsp?test="+testName;
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
					tmpMask.show();
					Ext.Ajax.request(
					{
						url : urlStr,
						method: 'POST',
						async: false,
						success: function(response)
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							resultJSON = Ext.decode(jsonText);
							if (resultJSON.AlertType=='Result')
							{
								Ext.Msg.show({
									title: resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									width: 300,
									fn:function(response){
										ctrler.buildMainData();
										ctrler.afterMainRender();
									}
								});
							}
							else if(resultJSON.AlertType=='Error')
							{
								Ext.Msg.show({
									title: error+": "+resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconError',
									fn: function(response){
										ctrler.buildMainData();
										ctrler.afterMainRender();
									}
								});
							}
						},
						failure : function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	modifyTest: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var test = obj.get('test');
		var testType = 'testhomepage';
		addctrler = this.getController('CompositeTest.controller.AddTestCtrlr');
		Ext.getCmp('ictestviewport').removeAll();
		this.getController('ModifyTestCtrlr').init(test, testType);
		Ext.getCmp('ictestviewport').add({
				xtype: 'addnewtest'
		});
		isModifyTest = true;
	},
	showTestsAndMeasures : function(rowIndex)
	{
		var s_compType = null;
		var idx = 0;
		var grid = Ext.getCmp('udGrid');
		grid.getStore().each(function(record) {
			record.fields.each(function(field) {
				if(idx==rowIndex) {
					if(field.name=='compType') {
						s_compType = record.get(field.name);
					}
				}
			});
			idx++;
		});

		var me = this;
		testMeasureJson = null;
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/serverTestMapping.jsp?s_compType='+s_compType,
			method: 'POST',
			params : {'s_compType':s_compType},
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					testMeasureJson = Ext.decode( response.responseText );
					Ext.widget("window",{
						extend: 'Ext.panel.Panel',
						title : testMeasureJson.popupTitle,
						id:'userElementsWindow',
						width: 950,
						scroll:false,
						autoScroll:false,
						height: 400,
						padding:'5 10 10 10',
						border : false,
						closeAction: 'destory',
						doClose: function() {
							this.destroy();
						},
						listeners : {
							afterrender : function()
							{
								me.updateTestMeasuresPopup();
							}
						}
					}).show();
				}
			}
		});
	},
	updateTestMeasuresPopup : function()
	{
		var testMeasuresPopupContainerObj = Ext.getCmp('userElementsWindow');
		testMeasuresPopupContainerObj.removeAll();
		if(testMeasureJson.compTypeSelected)
		{
			testMeasuresPopupContainerObj.add({xtype : 'testmeasures'});
			Ext.getCmp('measuresGrid').getStore().loadRawData(testMeasureJson.measuresGridDataList);
			Ext.getCmp('testmeasures').setTitle(testMeasureJson.popupTitle);
			Ext.getCmp('totalAggTests').update('<span class="font_bold">&nbsp;'+testMeasureJson.totalAggTests+'</span>');
		}
		else
		{
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>"+noCompTestsAssociated+"</div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 130,
				style:{'text-align':'center'},
				html : message
			}
			testMeasuresPopupContainerObj.add(tmpPanel);
		}
	},
	showHideMeasures : function(obj)
	{
		var thisGrid = Ext.getCmp('measuresGrid').getStore();
		if (obj.status == 'hidden')
		{
			obj.status = 'shown';
			obj.setText(hideMeasureBtn);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.expandRow(i,Ext.getCmp('measuresGrid'));
			}
		}
		else
		{
			obj.status = 'hidden';
			obj.setText(showMeasureBtn);
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('measuresGrid'));
			}
		}
		this.getTestmeasures().doLayout();
	},
	expandRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (row.hasCls(this.rowCollapsedCls)) {
			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = true;
			thisGrid.view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},
	collapseRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (!row.hasCls(this.rowCollapsedCls)) {
			row.addCls(this.rowCollapsedCls);
			nextBd.addCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = false;
			thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
		}
	}
});



