Ext.define('CompositeTest.controller.MeasureWindowController',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['CompositeTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'}
	],
	init:function(){
		compTestCtrlr = this;
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	testChanged : function()
	{
		var compType = Ext.getCmp('componentType').getValue();
		var compTest = Ext.getCmp('compTest').getValue();
		var compMeasure = Ext.getCmp('compMeasure').getValue();
		var individualTestName = Ext.getCmp('testlist').getValue();
		var predefinedtest = (compTest.indexOf('_')==compTest.lastIndexOf('_'));

		if(individualTestName == null || individualTestName=='-1')
		{
			Ext.getCmp('actionOnDesc').hide();
			Ext.getCmp('excludeDescriptors').hide();
			Ext.getCmp('includeDescriptors').hide();
			Ext.getCmp('measuresContainer').hide();
			Ext.getCmp('associate_button_container').hide();
			Ext.getCmp(associated_test_measures_grid).hide();
			Ext.getCmp('addMeasures').hide();
			return false;
		}
		if(predefinedtest)
		{
			Ext.getCmp('addMeasures').show();
		}
		Ext.getCmp('itemselectHosts').fromField.store.removeAll();
		Ext.getCmp('itemselectHosts').toField.store.removeAll();

		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var grid=Ext.getCmp(associated_test_measures_grid).getSelectionModel().getSelection();
		var added_test_details='';
		var added_measure_details='';
		var tarray = new Array();
		for(var i=0;i<grid.length;i++)
		{
			var values=grid[i];
			var aat = values.get(associated_test_name).trim();
			if(aat==individualTestName)
			{
				added_measure_details+=','+values.get(associated_measure_name);
			}
			if(added_test_details.length==0)
			{
				added_test_details = aat;
			}
			else if((","+added_test_details+",").indexOf(","+aat+",")==-1)
			{
				added_test_details += ","+aat;
			}
		}
		if(added_measure_details.length>0) {
			added_measure_details = added_measure_details.substring(1);
		}
		else {
			added_measure_details='-';
		}
		if(added_test_details.length==0) {
			added_test_details="-1";
		}
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/individualTestInfo.jsp?compType='+compType+'&individualTestName='+individualTestName+'&compMeasure='+compMeasure+'&compTest='+compTest+'&added_measure_details='+added_measure_details+'&added_test_details='+added_test_details,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var individualTestJson = Ext.decode( response.responseText );


					Ext.getCmp('testlist').getStore().clearFilter(true);
					Ext.getCmp('testlist').getStore().suspendEvents(true);
					Ext.getCmp('testlist').getStore().loadRawData(individualTestJson.individual_tests);
					Ext.getCmp('testlist').getStore().resumeEvents();

					Ext.getCmp('actionOnDesc').hide();
					Ext.getCmp('excludeDescriptors').hide();
					Ext.getCmp('includeDescriptors').hide();
					Ext.getCmp('actionOnDesc').getStore().clearFilter(true);
					Ext.getCmp('actionOnDesc').getStore().suspendEvents(true);
					Ext.getCmp('actionOnDesc').getStore().loadRawData(individualTestJson.actionOnDescriptors);
					Ext.getCmp('actionOnDesc').getStore().resumeEvents();
//					if(predefinedtest)
//					{
//						Ext.getCmp('actionOnDesc').hide();
//					}
//					else
//					{
						Ext.getCmp('actionOnDesc').show();
//					}
					if(individualTestJson.showIncludeDescriptor)
					{
						Ext.getCmp('actionOnDesc').select(Ext.getCmp('actionOnDesc').getStore().getAt(0));
						Ext.getCmp('includeDescriptors').setValue(individualTestJson.includeInfoSet);
						Ext.getCmp('excludeDescriptors').setValue(individualTestJson.excludeInfoSet);
//						if(predefinedtest)
//						{
//							Ext.getCmp('includeDescriptors').hide();
//						}
//						else
//						{
							Ext.getCmp('includeDescriptors').show();
//						}
					}
					else
					{
						Ext.getCmp('actionOnDesc').select(Ext.getCmp('actionOnDesc').getStore().getAt(1));
						Ext.getCmp('includeDescriptors').setValue(individualTestJson.includeInfoSet);
						Ext.getCmp('excludeDescriptors').setValue(individualTestJson.excludeInfoSet);
//						if(predefinedtest)
//						{
//							Ext.getCmp('excludeDescriptors').hide();
//						}
//						else
//						{
							Ext.getCmp('excludeDescriptors').show();
//						}
					}
					Ext.getCmp('addMeasures').show();
					if(individualTestJson.associatedComponentsFound)
					{
						var myFromField = Ext.getCmp('itemselectHosts').fromField;
						myFromField.store.add(individualTestJson['associatedComponents']);
					}
					if(individualTestJson.availableComponentsFound)
					{
						var myToField = Ext.getCmp('itemselectHosts').toField;
						myToField.store.add(individualTestJson['availableComponents']);
					}
//					if(predefinedtest)
//					{
//						Ext.getCmp('itemselectHosts').setVisible(false);
//						Ext.getCmp('defaultAssociatedMeasures').setVisible(true);
//						Ext.getCmp("defaultAssociatedMeasures").clearValue();
//						Ext.getCmp('defaultAssociatedMeasures').getStore().loadRawData(individualTestJson['associatedComponents']);
//					}
//					else
//					{
						Ext.getCmp('itemselectHosts').setVisible(true);
//					}
					Ext.getCmp('measuresContainer').show();
//					if(predefinedtest)
//					{
//						Ext.getCmp('associate_button_container').hide();
//					}
//					else
//					{
						Ext.getCmp('associate_button_container').show();
//					}
					Ext.getCmp(associated_test_measures_grid).show();
					Ext.getCmp('compMeasure').setReadOnly(true);
					start_masterInfosTest = individualTestJson.masterInfosTest;
					start_masterInfosTestDisplay = individualTestJson.masterInfosTestDisplay;
					start_descriptorBasedTest =  individualTestJson.start_descriptorBasedTest;
					default_thresholds_Json=individualTestJson.defaultThresholdsObj;
				}
			}
		});
	},
	refreshTests : function()
	{
		var compType = Ext.getCmp('componentType').getValue();
		var compTest = Ext.getCmp('compTest').getValue();
		var compMeasure = Ext.getCmp('compMeasure').getValue();
		var individualTestName = Ext.getCmp('testlist').getValue();

		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var grid=Ext.getCmp(associated_test_measures_grid).getSelectionModel().getSelection();
		var added_test_details='';
		var added_measure_details='';
		var tarray = new Array();
		for(var i=0;i<grid.length;i++)
		{
			var values=grid[i];
			var aat = values.get(associated_test_name).trim();
			if(aat==individualTestName)
			{
				added_measure_details+=','+values.get(associated_measure_name);
			}
			if(added_test_details.length==0)
			{
				added_test_details = aat;
			}
			else if((","+added_test_details+",").indexOf(","+aat+",")==-1)
			{
				added_test_details += ","+aat;
			}
		}
		if(added_measure_details.length>0) {
			added_measure_details = added_measure_details.substring(1);
		}
		else {
			added_measure_details='-';
		}
		if(added_test_details.length==0) {
			added_test_details="-1";
		}
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/refreshIndividualTestInfo.jsp?compType='+compType+'&compTest='+compTest+'&added_measure_details='+added_measure_details+'&added_test_details='+added_test_details,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText))
				{
					var individualTestJson = Ext.decode( response.responseText );
					Ext.getCmp('testlist').getStore().clearFilter(true);
					Ext.getCmp('testlist').getStore().suspendEvents(true);
					Ext.getCmp('testlist').getStore().loadRawData(individualTestJson.individual_tests);
					Ext.getCmp('testlist').getStore().resumeEvents();
					Ext.getCmp('testlist').setValue(individualTestJson.selectedTest);
					compTestCtrlr.testChanged();
				}
			}
		});
	},
	includeExcludeChanged : function()
	{
		var inexval = Ext.getCmp("actionOnDesc").getValue();
		if(inexval=='Exclude')
		{
			Ext.getCmp('excludeDescriptors').show();
			Ext.getCmp('includeDescriptors').hide();
		}
		else
		{
			Ext.getCmp('excludeDescriptors').hide();
			Ext.getCmp('includeDescriptors').show();
		}
	},
	associateNewMeasures: function(obj)
	{
		var include_desc = 'all';
		var exclude_desc = 'none';
		var action_on_desc = Ext.getCmp("actionOnDesc").getValue();
		if(action_on_desc=='Include') {
			include_desc = Ext.getCmp('includeDescriptors').getValue();
			include_desc= include_desc.replace(/^\s+|\s+$/gm,'');
//			if(include_desc.indexOf(' ')>-1)
//			{
//				Ext.Msg.show({
//					title: pageTitle1,
//					msg: includeDescSpaceAlert,
//					buttons: Ext.Msg.OK,
//					icon: 'iconExclamation'
//				});
//				return;
//			}
//			else if(include_desc.indexOf('=')>-1)
			if(Ext.isEmpty(include_desc)) {
				include_desc="all";
			}
			else if(include_desc.indexOf('=')>-1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Descriptors should not contain equals(=) symbol.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
		}
		else if(action_on_desc=='Exclude') {
			exclude_desc = Ext.getCmp('excludeDescriptors').getValue();
			exclude_desc= exclude_desc.replace(/^\s+|\s+$/gm,'');
//			if(exclude_desc.indexOf(' ')>-1)
//			{
//				Ext.Msg.show({
//					title: pageTitle1,
//					msg: excludeDescSpaceAlert,
//					buttons: Ext.Msg.OK,
//					icon: 'iconExclamation'
//				});
//				return;
//			}
//			else if(exclude_desc.indexOf('=')>-1)
			if(Ext.isEmpty(exclude_desc)) {
				exclude_desc="none";
			}
			else if(exclude_desc.indexOf('=')>-1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Descriptors should not contain equals(=) symbol.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
		}
		if (!this.measureValidation())
		{
			return;
		}
		if(Ext.getCmp('itemselectHosts').fromField.store.getCount()==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg:emptyMeasuresAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var alreadyAddedTestMeasures = new Array();
		var selected_associated_test_internal_name = Ext.getCmp('testlist').getValue();
		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var grid=Ext.getCmp(associated_test_measures_grid).getSelectionModel().getSelection();
		for(var i=0; i < grid.length ; i++)
		{
			var values=grid[i];
			var common_raw_test_name = values.get(associated_test_name);
			var common_raw_measure_name = values.get(associated_measure_name);
			var common_raw_test_measure_name = common_raw_test_name+':'+common_raw_measure_name;
			alreadyAddedTestMeasures.push(common_raw_test_measure_name);
		}
		Ext.getCmp(associated_test_measures_grid).getSelectionModel().deselectAll();
		var newRowsAdded = false;
		var selected_associated_test_description = Ext.getCmp('testlist').getRawValue();
		var tmpStore = Ext.getCmp('itemselectHosts');
		var associatedComponentsList = tmpStore.fromField.store;
		for(var m=0;m<tmpStore.fromField.store.getCount();m++)
		{
			var ms = associatedComponentsList.getAt(m).get('valueField');
			var key = selected_associated_test_internal_name+':'+ms;
			if(alreadyAddedTestMeasures.indexOf(key)>-1)
			{
				continue;
			}
			newRowsAdded = true;
			var default_min_threshold = 'None';
			var default_max_threshold = 'None';
			var both_thresholds = default_thresholds_Json[ms];
			if(both_thresholds !=null && both_thresholds.indexOf(":")>0)
			{
				default_min_threshold = both_thresholds.substring(0,both_thresholds.indexOf(":"));
				default_max_threshold = both_thresholds.substring(both_thresholds.indexOf(":")+1);
			}
			Ext.getCmp(associated_test_measures_grid).getStore().add({
				'default_checked': 'true',
				associated_test_name:selected_associated_test_internal_name,
				associated_test_description:selected_associated_test_description,
				associated_measure_name:ms,
				associated_measure_description:associatedComponentsList.getAt(m).get('displayField'),
				associated_measure_min_threshold:default_min_threshold,
				associated_measure_max_threshold:default_max_threshold,
				associated_measure_type:'Key'
			});
		}
//		if(!newRowsAdded)
//		{
//			return;
//		}
		var localEditor = new Ext.form.field.ComboBox({
			cls: 'dropdown',
			sortable: false,
			editable: false,
			displayField : 'displayField',
			valueField : 'valueField',
			queryMode : 'local',
			fields : ['displayField', 'valueField'],
			store: [
				['Key','Key'],
				['Sup','Non-key']
			]
		});
		Ext.getCmp('measureTypeId').setEditor(localEditor);

		var buttonClicked = obj.id;
		var me = this;
		var compTest = Ext.getCmp('compTest').getValue();
		var compMeasure = Ext.getCmp('compMeasure').getValue();
		var compMeasureDisplay = Ext.getCmp('measure_display_name').getValue();
		var alarmDisplayString = Ext.getCmp('alarm_display_string').getValue();
		var test_associated = Ext.getCmp('testlist').getValue();
		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var grid=Ext.getCmp(associated_test_measures_grid).getSelectionModel().getSelection();
		var s_measure_details='';
		for(var i=0; i < grid.length ; i++)
		{
			var values=grid[i];
			var common_raw_test_name = values.get(associated_test_name);
			var common_raw_measure_name = values.get(associated_measure_name);
			var common_raw_test_measure_name = common_raw_test_name+':'+common_raw_measure_name;

			var common_min_thresh = values.get(associated_measure_min_threshold);
			var common_max_thresh = values.get(associated_measure_max_threshold);
			if(common_min_thresh.trim().toLowerCase()=='none')
			{
				common_min_thresh="-1";
			}
			if(common_max_thresh.trim().toLowerCase()=='none')
			{
				common_max_thresh="-1";
			}

			s_measure_details += ','+common_raw_test_measure_name
				+"~"+values.get(associated_measure_type)+"~"+common_min_thresh
				+":"+common_max_thresh;
		}
		if(s_measure_details.length>0)
		{
			s_measure_details=s_measure_details.substring(1);
		}

		var dyna_param_value = {'buttonClicked':buttonClicked,'test':compTest,'displayName':encodeURIComponent(compMeasureDisplay),'alarmDisplayString':encodeURIComponent(alarmDisplayString),'test_associated':test_associated,'include_desc':include_desc,'exclude_desc':exclude_desc,'s_measure_details':s_measure_details};
		var retainedURL = "individualTestInfo.jsp?individualTestName="+test_associated+"&compType="+selectedCompType+"&compTest="+compTest;
		var associateJson;
		var urlStr = 'CompositeTest/data/associateMeasuresp.jsp?operationCompMeasure='+operationCompMeasure;
		if(!Ext.isEmpty(compMeasure))
		{
			urlStr+='&measure='+compMeasure;
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			params : dyna_param_value,
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					associateJson = Ext.decode( response.responseText );
					retainedURL += "&compMeasure="+associateJson.measureName;
					Ext.getCmp('compMeasure').setValue(associateJson.measureName);
				}
			}
		});
		if (associateJson.messageType != null && associateJson.messageType == 'Alert')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg:associateJson.message,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if (associateJson.messageType != null && associateJson.messageType == 'Result')
		{
			Ext.getCmp('compMeasure').hide();
			Ext.getCmp("measure_display_name").setReadOnly(false);
			Ext.getCmp('alarm_display_string').setReadOnly(false);
			var urlToProcess = associateJson.forwardURL;
			me.loadAddMeasureTab(associateJson.forwardURL);
			Ext.getCmp('generateCntnr').enable();
			operationCompMeasure="modifyCompMeasure";
			Ext.Ajax.request(
			{
				url: 'CompositeTest/data/'+retainedURL,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						publicJSONTemp = Ext.decode( response.responseText );

						Ext.getCmp('testlist').getStore().clearFilter(true);
						Ext.getCmp('testlist').getStore().suspendEvents(true);
						Ext.getCmp('testlist').getStore().loadRawData(publicJSONTemp.individual_tests);
						Ext.getCmp('testlist').getStore().resumeEvents();
						Ext.getCmp('testlist').select(test_associated);
						start_masterTestForInfos = publicJSONTemp.masterInfosTest;
						start_masterInfosTestDisplay = publicJSONTemp.masterInfosTestDisplay;
						start_descriptorBasedTest =  publicJSONTemp.start_descriptorBasedTest;
					}
				}
			});
		}
	},
	associateNewMeasures_update: function(obj)
	{
		var buttonClicked = obj.id;
		var me = this;
		var compTest = Ext.getCmp('compTest').getValue();
		var compMeasure = Ext.getCmp('compMeasure').getValue();

		if (!this.measureValidation()) {
			return;
		}
		var compMeasureDisplay = Ext.getCmp('measure_display_name').getValue();
		var alarmDisplayString = Ext.getCmp('alarm_display_string').getValue();
		var test_associated = Ext.getCmp('testlist').getValue();
		var include_desc = 'all';
		var exclude_desc = 'none';
		var action_on_desc = Ext.getCmp("actionOnDesc").getValue();
		if(action_on_desc=='Include') {
			include_desc = Ext.getCmp('includeDescriptors').getValue();
			include_desc= include_desc.replace(/^\s+|\s+$/gm,'');
//			if(include_desc.indexOf(' ')>-1)
//			{
//				Ext.Msg.show({
//					title: pageTitle1,
//					msg: includeDescSpaceAlert,
//					buttons: Ext.Msg.OK,
//					icon: 'iconExclamation'
//				});
//				return;
//			}
//			else if(include_desc.indexOf('=')>-1)
			if(Ext.isEmpty(include_desc)) {
				include_desc="all";
			}
			else if(include_desc.indexOf('=')>-1) {
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Descriptors should not contain equals(=) symbol.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
		}
		else if(action_on_desc=='Exclude') {
			exclude_desc = Ext.getCmp('excludeDescriptors').getValue();
			exclude_desc= exclude_desc.replace(/^\s+|\s+$/gm,'');
//			if(exclude_desc.indexOf(' ')>-1)
//			{
//				Ext.Msg.show({
//					title: pageTitle1,
//					msg: excludeDescSpaceAlert,
//					buttons: Ext.Msg.OK,
//					icon: 'iconExclamation'
//				});
//				return;
//			}
//			else if(exclude_desc.indexOf('=')>-1)
			if(Ext.isEmpty(exclude_desc)) {
				exclude_desc="none";
			}
			else if(exclude_desc.indexOf('=')>-1) {
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Descriptors should not contain equals(=) symbol.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
		}

		if(!this.validateThresholds())
		{
			return;
		}

		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var grid=Ext.getCmp(associated_test_measures_grid).getSelectionModel().getSelection();

		if(grid.length==0)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alert_for_no_associated_measures+ ' ' + compMeasureDisplay,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var masterInfosTestFound = false;
		var allowUpdate = true;
		var s_measure_details='';
		for(var i=0; i < grid.length ; i++)
		{
			var values=grid[i];
			var common_disp_test_name = values.get('associated_test_description');
			var common_disp_measure_name = values.get('associated_measure_description');
			var common_raw_test_name = values.get(associated_test_name).trim();
			if(start_descriptorBasedTest.toLowerCase()=='yes')
			{
				if(start_masterInfosTest==common_raw_test_name)
					masterInfosTestFound=true;
			}
			var common_min_thresh = values.get(associated_measure_min_threshold).trim();
			var common_max_thresh = values.get(associated_measure_max_threshold).trim();
			if(common_min_thresh.trim().toLowerCase()=='none')
			{
				common_min_thresh="-1";
			}
			if(common_max_thresh.trim().toLowerCase()=='none')
			{
				common_max_thresh="-1";
			}
			if(common_min_thresh=='-1' && common_max_thresh=='-1')
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Both minimum and maximum target values cannot be none for '+common_disp_measure_name +' measure of '+common_disp_test_name + ' test',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				allowUpdate=false;
				break;
			}
			s_measure_details += ','+common_raw_test_name+':'+values.get(associated_measure_name)
				+"~"+values.get(associated_measure_type).trim()+"~"+common_min_thresh
				+":"+common_max_thresh;
		}
		if(!allowUpdate)
		{
			return;
		}
		if(start_descriptorBasedTest.toLowerCase()=='yes' && !masterInfosTestFound)
		{
			Ext.Msg.show({
					title: pageTitle1,
					//msg: 'Please associate measures of '+start_masterInfosTestDisplay+' test as this performance rating test uses the descriptors of the ' + start_masterInfosTestDisplay + ' test',
					msg: 'This performance rating test uses the descriptors of the ' + start_masterInfosTestDisplay + ' test. Please associate its measures.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			return;
		}
		if(s_measure_details.length>0)
		{
			s_measure_details=s_measure_details.substring(1);
		}
		var dyna_param_value = {'buttonClicked':buttonClicked,'test':compTest,'displayName':encodeURIComponent(compMeasureDisplay),'alarmDisplayString':encodeURIComponent(alarmDisplayString),'test_associated':test_associated,'include_desc':include_desc,'exclude_desc':exclude_desc,'s_measure_details':s_measure_details};
		var associateJson;
		var urlStr = 'CompositeTest/data/associateMeasuresp.jsp?operationCompMeasure='+operationCompMeasure;
		if(!Ext.isEmpty(compMeasure))
		{
			urlStr+='&measure='+compMeasure;
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			params : dyna_param_value,
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					associateJson = Ext.decode( response.responseText );
					Ext.getCmp('compMeasure').setValue(associateJson.measureName);
				}
			}
		});
		if (associateJson.messageType != null && associateJson.messageType == 'Alert')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg:associateJson.message,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if (associateJson.messageType != null && associateJson.messageType == 'Result')
		{
			Ext.getCmp('compMeasure').hide();
			Ext.getCmp("measure_display_name").setReadOnly(false);
			Ext.getCmp('alarm_display_string').setReadOnly(false);
			var urlToProcess = associateJson.forwardURL;
			me.loadAddMeasureTab(associateJson.forwardURL);

			Ext.getCmp('generateCntnr').enable();
			var win = Ext.WindowManager.getActive();
			if(win)
			{
				win.close();
			}
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('newtest').setActiveTab(2);
		}
	},
	loadAddMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp("addNewMeasure").setVisible(false);
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
		}
		else
		{
			Ext.getCmp('noMeasureFnd').hide();

			cntnrObj.add(
				{
					xtype: 'container',
					id:'dp_container_measure',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					width: 900,
					cls: 'formOuter',
					padding: 5,
					defaultType: 'displayfield',
					defaults: {
						labelAlign: 'top',
						labelSeparator: '',
						width: 250,
						margin: 5
					},
					margin: '5 5 10 5',
					items: [
						{
							fieldLabel: '<b>'+test_name_label+'</b>',
							value: publicJSON.test_desc_measure_panel,
							id:'dp_testname'
						},
						{
							fieldLabel: '<b>'+compTypeDesc+'</b>',
							value: publicJSON.type_desc_measure_panel,
							id:'dp_comptype'
						},
						{
							fieldLabel: '<b>'+descbased+'</b>',
							value: publicJSON.descriptor_measure_panel,
							id:'dp_descriptor'
						}
					]
				}
			);

			for (var p=0; p<existingMeass.length; p++) {
				var measure = existingMeass[p];
				cntnrObj.add(
					{
						xtype: 'customgrid',
						cls:'gridSkin',
						title: '<span class="font_bold12">'+measure.measureDispName+'</span>' + '&nbsp;' + display_for_compmeasure,
						id:'display_associated_measures_grid'+p,
						hidden:false,
						flex:1,
						autoScroll:true,
						scroll:true,
						height: 200,
						width: 900,
						margin: 5,
						columnLines:true,
						sortableColumns:false,
						store:Ext.create('Ext.data.Store',{
							fields:['test_name', 'measure_description'],
							data:measure.display_associated_measures_grid
						}),
						columns: [
							{
								header: testLabelInTable,
								dataIndex: 'test_name',
								flex: 0.25
							},
							{
								header: measureLabelInTable,
								dataIndex: 'measure_description',
								flex: 0.75
							}
						],
						tools: [
							{
								xtype: 'button',
								cls : 'button20',
								text: modifyTooltip,
								modifyURL: measure.modifyURL,
								measureName: measure.measureName,
								handler: function() {
									me.showModifyMeasure(this.modifyURL, this.measureName);
								},
								margin: '2 0 2 0'
							},
							{
								xtype: 'button',
								cls : 'button20',
								text: deleteTooltip,
								deleteURL: measure.deleteURL,
								hidden: measure.deleteURL=='none'?true:false,
								measureName: measure.measureName,
								handler: function() {
									me.deleteMeasure(this.deleteURL, this.measureName,measure.measureDispName);
								},
								margin: '2 0 2 5'
							}
						]
					}
				);
			}
			if(publicJSON.pre_defined_test)
			{
				Ext.getCmp("addNewMeasure").setVisible(false);
			}
			else
			{
				Ext.getCmp("addNewMeasure").setVisible(true);
			}
		}
	},
	loadPopup:function()
	{
		var me = this;
		Ext.widget('measurewindow').show();
		var test = Ext.getCmp('test').getValue();
		var compTest = test;
		var predefinedtest = (compTest.indexOf('_')==compTest.lastIndexOf('_'));
		var compMeasure = null;
		var compType = Ext.getCmp('componentType').getValue();
		var modifyCompMeasure = false;
		var urlStr=null;
		if(modifyCompMeasureURL==null)
		{
			urlStr = 'EgConfigMeasureJson.jsp?test='+test+'&compType='+compType;
			selectedCompType = compType;
		}
		else
		{
			var idx = modifyCompMeasureURL.indexOf('&');
			var params = modifyCompMeasureURL.substring(idx+1);

			idx = params.indexOf('&');
			var compTypeStr = params.substring(0,idx);
			compType = compTypeStr.substring(compTypeStr.indexOf("=")+1);
			selectedCompType = compType;
			params = params.substring(idx+1);

			idx = params.indexOf('&');
			var compTestStr = params.substring(0,idx);
			compTest = compTestStr.substring(compTestStr.indexOf("=")+1);
			params = params.substring(idx+1);

			compMeasure = params.substring(params.indexOf("=")+1);

			modifyCompMeasure=true;
			urlStr=modifyCompMeasureURL+'&firstTime=true';
			modifyCompMeasureURL=null;
		}
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					start_masterInfosTest = publicJSON.masterInfosTest;
					start_masterInfosTestDisplay = publicJSON.masterInfosTestDisplay;
					start_descriptorBasedTest =  publicJSON.start_descriptorBasedTest;
					default_thresholds_Json=publicJSON.defaultThresholdsObj;
				}
			}
		});

		this.getController('CompositeTest.controller.MeasureWindowController').init();
		if(modifyCompMeasure)
		{
			Ext.getCmp('compTest').setValue(compTest);
			Ext.getCmp('compMeasure').setValue(compMeasure);
			Ext.getCmp('compMeasure').hide();
			Ext.getCmp('measure_display_name').setValue(publicJSON.compMeasureDesc);
			Ext.getCmp('alarm_display_string').setValue(publicJSON.alarmDisplayString);
			if(publicJSON.individualTestFound)
			{
				Ext.getCmp('testlist').setFieldLabel(publicJSON.testListLabel);
				Ext.getCmp('testlist').getStore().clearFilter(true);
				Ext.getCmp('testlist').getStore().suspendEvents(true);
				Ext.getCmp('testlist').getStore().loadRawData(publicJSON.individual_tests);
				Ext.getCmp('testlist').getStore().resumeEvents();
				Ext.getCmp('testlist').select(publicJSON.sitn);

				Ext.getCmp('actionOnDesc').getStore().clearFilter(true);
				Ext.getCmp('actionOnDesc').getStore().suspendEvents(true);
				Ext.getCmp('actionOnDesc').getStore().loadRawData(publicJSON.actionOnDescriptors);
				Ext.getCmp('actionOnDesc').getStore().resumeEvents();
				Ext.getCmp('actionOnDesc').select(Ext.getCmp('actionOnDesc').getStore().getAt(0));
			}
//			if(predefinedtest)
//			{
//				Ext.getCmp('actionOnDesc').hide();
//			}
//			else
//			{
				Ext.getCmp('actionOnDesc').show();
//			}
			Ext.getCmp('includeDescriptors').hide();
			Ext.getCmp('excludeDescriptors').hide();

			if(publicJSON.showIncludeDescriptor)
			{
				Ext.getCmp('actionOnDesc').setValue("Include");
				Ext.getCmp('includeDescriptors').setValue(publicJSON.includeInfoSet);
				Ext.getCmp('excludeDescriptors').setValue(publicJSON.excludeInfoSet);
//				if(predefinedtest)
//				{
//					Ext.getCmp('includeDescriptors').hide();
//				}
//				else
//				{
					Ext.getCmp('includeDescriptors').show();
//				}
			}
			else //if(publicJSON.showExcludeDescriptor)
			{
				Ext.getCmp('actionOnDesc').setValue("Exclude");
				Ext.getCmp('includeDescriptors').setValue(publicJSON.includeInfoSet);
				Ext.getCmp('excludeDescriptors').setValue(publicJSON.excludeInfoSet);
//				if(predefinedtest)
//				{
//					Ext.getCmp('excludeDescriptors').hide();
//				}
//				else
//				{
					Ext.getCmp('excludeDescriptors').show();
//				}
			}
			Ext.getCmp('measuresContainer').hide();
			Ext.getCmp('associate_button_container').hide();
			Ext.getCmp(associated_test_measures_grid).hide();
			Ext.getCmp('addMeasures').hide();
			Ext.getCmp('measuresContainer').show();
//			if(predefinedtest)
//			{
//				Ext.getCmp('associate_button_container').hide();
//			}
//			else
//			{
				Ext.getCmp('associate_button_container').show();
//			}
			if(publicJSON.associatedComponentsFound)
			{
				var myFromField = Ext.getCmp('itemselectHosts').fromField;
				myFromField.store.add(publicJSON['associatedComponents']);
//				if(compTest.indexOf('_')==compTest.lastIndexOf('_'))
				{
					Ext.getCmp("defaultAssociatedMeasures").clearValue();
					Ext.getCmp('defaultAssociatedMeasures').getStore().loadRawData(publicJSON['associatedComponents']);
				}
			}
//			if(compTest.indexOf('_')==compTest.lastIndexOf('_'))
//			{
//				Ext.getCmp('itemselectHosts').setVisible(false);
//				Ext.getCmp('defaultAssociatedMeasures').setVisible(true);
//			}
//			else
//			{
				Ext.getCmp('itemselectHosts').setVisible(true);
				Ext.getCmp('defaultAssociatedMeasures').setVisible(false);
//			}
			if(publicJSON.availableComponentsFound)
			{
				var myToField = Ext.getCmp('itemselectHosts').toField;
				myToField.store.add(publicJSON['availableComponents']);
			}
			if(publicJSON.associatedComponentsFound)
			{
				Ext.getCmp(associated_test_measures_grid).headerCt.items.items[0].hidden = true;
//				if(predefinedtest)
//					Ext.getCmp(associated_test_measures_grid).headerCt.items.items[8].hidden = true;
//				else
					Ext.getCmp(associated_test_measures_grid).headerCt.items.items[8].hidden = false;
				Ext.getCmp(associated_test_measures_grid).getStore().removeAll();
				Ext.getCmp(associated_test_measures_grid).getStore().loadRawData(publicJSON['associated_test_measures_grid']);
				var localEditor = new Ext.form.field.ComboBox({
					cls: 'dropdown',
					sortable: false,
					editable: false,
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					fields : ['displayField', 'valueField'],
					store: [
						['Key','Key'],
						['Sup','Non-key']
					]
				});
				Ext.getCmp('measureTypeId').setEditor(localEditor);
				Ext.getCmp(associated_test_measures_grid).show();
//				if(predefinedtest)
//				{
//					Ext.getCmp(associated_test_measures_grid).columns[7].setVisible(false);
//				}
			}
			Ext.getCmp('addMeasures').show();
		}
		else
		{
			Ext.getCmp('compTest').setValue(test);
			if(publicJSON.individualTestFound)
			{
				Ext.getCmp('testlist').getStore().removeAll();
				Ext.getCmp('testlist').setFieldLabel(publicJSON.testListLabel);
				Ext.getCmp('testlist').getStore().clearFilter(true);
				Ext.getCmp('testlist').getStore().suspendEvents(true);
				Ext.getCmp('testlist').getStore().loadRawData(publicJSON.individual_tests);
				Ext.getCmp('testlist').getStore().resumeEvents();
				Ext.getCmp('testlist').select(Ext.getCmp('testlist').getStore().getAt(0));
			}

			Ext.getCmp(associated_test_measures_grid).headerCt.items.items[0].hidden = true;
//			if(predefinedtest)
//					Ext.getCmp(associated_test_measures_grid).headerCt.items.items[8].hidden = true;
//			else
					Ext.getCmp(associated_test_measures_grid).headerCt.items.items[8].hidden = false;
			Ext.getCmp(associated_test_measures_grid).getStore().removeAll();

			Ext.getCmp('actionOnDesc').hide();
			Ext.getCmp('excludeDescriptors').hide();
			Ext.getCmp('includeDescriptors').hide();
			Ext.getCmp('measuresContainer').hide();
			Ext.getCmp('associate_button_container').hide();
			Ext.getCmp(associated_test_measures_grid).hide();
			Ext.getCmp('addMeasures').hide();
			Ext.getCmp('actionOnDesc').setValue("Include");

			var combo = Ext.getCmp('testlist');
			var toselect = null;
			if(publicJSON.masterInfosTest != '-1')
			{
				toselect = publicJSON.masterInfosTest;
			}
			else
			{
				toselect = publicJSON.selectDefaultTest;
			}
			combo.select(toselect);
			var record = combo.getStore().findRecord('name', toselect);
			combo.fireEvent('select', combo, [record]);
		}
		Ext.getCmp('measure_display_name').focus(true,true); 
	},
	measureValidation: function()
	{
		var me=this;
		var mDispObj = Ext.getCmp('measure_display_name');
		var aDispObj = Ext.getCmp('alarm_display_string');
		if(!checkblank(mDispObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: measureDisplayAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			mDispObj.focus(true);
			return false;
		}
		else if(!checkblank(aDispObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alarmDisplayAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			aDispObj.focus(true);
			return false;
		}
		else if(!this.checkSpecialChar(mDispObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			mDispObj.focus(true);
			return false;				
		}
		else if(!this.checkSpecialChar(aDispObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert4,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			aDispObj.focus(true);
			return false;				
		}
		return true;
	},
	deleteMeasure: function(deleteURL, measureName, displayName)
	{
		var me = this;
		Ext.Msg.show({
			title: pageTitle1,
			msg:deleteMeasureAlert+ ' \''+displayName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'CompositeTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	showModifyMeasure: function(modifyURL, measureName)
	{
		operationCompMeasure='modifyCompMeasure';
		modifyCompMeasureURL=modifyURL;
		this.loadPopup();
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	},
	validateThresholds: function()
	{
		var gridObj = Ext.getCmp(associated_test_measures_grid);
		var gridPlugin = gridObj.getPlugin(associated_plugin_id);
		Ext.getCmp(associated_test_measures_grid).getSelectionModel().selectAll();
		var selectedObj = Ext.getCmp(associated_test_measures_grid).getSelectionModel();
		var gridStore = Ext.getCmp(associated_test_measures_grid).getStore();

		for(var i = 0;i<gridStore.getCount();i++)
		{
			var obj = gridStore.getAt(i);
			if(selectedObj.isSelected(gridStore.getAt(i)) )
			{
				var returnCode=null;
				var maximumThres = gridStore.getAt(i).get(associated_measure_max_threshold);
				var minimumThres = gridStore.getAt(i).get(associated_measure_min_threshold);

				if(minimumThres.indexOf(' ')>-1)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert28,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}
				if(maximumThres.indexOf(' ')>-1)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert29,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
				if(minimumThres=='-1')
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert30,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					allowUpdate=false;
					return false;
				}
				if(maximumThres=='-1')
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert31,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					allowUpdate=false;
					return false;
				}
				if(minimumThres.trim().toLowerCase()=="none")
				{
					minimumThres="-1";
				}
				if(maximumThres.trim().toLowerCase()=="none")
				{
					maximumThres="-1";
				}
				if(minimumThres=='-1' && maximumThres=='-1')
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert27,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					allowUpdate=false;
					return false;
				}
				if(minimumThres=='-/-/-' || !correctFormat(minimumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert32,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}
				else if (!checkValidValue(minimumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: minimumValuesAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}
				else if(!checkAscendingOrder(minimumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: maxThreshAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}
				else if((returnCode=validateTargetValues(minimumThres,true))!='0')
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: returnCode,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}
				else if(checkSpecialChars(minimumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: invalid_chars_found,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 5});
						}
					});
					return false;
				}

				
				if(maximumThres=='-/-/-' || !correctFormat(maximumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert33,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
				else if (!checkValidValue(maximumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: maximumValuesAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
				else if(!checkDescendingOrder(maximumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: minThreshAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
				else if((returnCode=validateTargetValues(maximumThres,false))!='0')
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: returnCode,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
				else if(checkSpecialChars(maximumThres))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: invalid_chars_found,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							gridPlugin.startEditByPosition({row: i,column: 6});
						}
					});
					return false;
				}
			}
		}
		return true;
	}
});

function checkAscendingOrder(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}

function checkDescendingOrder(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}
function checkSpecialChars(v)
{
	var val_chars='0123456789-/.';
	for(var i=0;i<v.length;i++)
	{
		if(val_chars.indexOf(v.charAt(i))==-1)
		{
			return true;
		}
	}
	return false;
}
function checkValidValue(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];

	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(Cri);
	if(!ret)
	{
		ret = regExp.test(Maj);
	}
	if(!ret)
	{
		ret = regExp.test(Min);
	}
	return ret;
}
function validateTargetValues(val, min_trgt_val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return '0';//success
	}
	var arr = val.split("/");
	if(arr.length != 3) {
		if(min_trgt_val)
			return alert25;
		else
			return alert26;
	}
	var critical_part = arr[0].trim();
	var major_part = arr[1].trim();
	var minor_part = arr[2].trim();
	var result = null;
	if(critical_part != "-")
	{
		result = privatemethod(critical_part,min_trgt_val,"critical");
		if(result != '0')
			return result;
	}
	if(major_part != "-")
	{
		result = privatemethod(major_part,min_trgt_val,"major");
		if(result != '0')
			return result;
	}
	if(minor_part != "-")
	{
		result = privatemethod(minor_part,min_trgt_val,"minor");
		if(result != '0')
			return result;
	}
	return '0';//success
}
function privatemethod(val,min_trgt_val,state)
{
	var private_result='0';
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	if((val.indexOf('-')!=val.lastIndexOf('-')) || (val.indexOf('.')!=val.lastIndexOf('.')))
	{
		if(min_trgt_val) {
			if(state=='critical')
				private_result = alert1;
			else if(state=='major')
				private_result=alert2;
			else if(state=='minor')
				private_result=alert3;
		}
		else {
			if(state=='critical')
				private_result = alert4;
			else if(state=='major')
				private_result=alert5;
			else if(state=='minor')
				private_result=alert6;
		}
	}
	else if(parseFloat(val) < 0)
	{
		if(min_trgt_val) {
			if(state=='critical')
				private_result = alert19;
			else if(state=='major')
				private_result=alert20;
			else if(state=='minor')
				private_result=alert21;
		}
		else {
			if(state=='critical')
				private_result = alert22;
			else if(state=='major')
				private_result=alert23;
			else if(state=='minor')
				private_result=alert24;
		}
	}
	else if(!regExp.test(val))
	{
		var i_part = val;
		var f_part = '';
		var idx = val.indexOf('.');
		if(idx>-1)
		{
			i_part = val.substring(0,idx);
			f_part = val.substring(idx+1);
		}
		if(i_part.length>10)
		{
			if(min_trgt_val) {
				if(state=='critical')
					private_result = alert7;
				else if(state=='major')
					private_result=alert8;
				else if(state=='minor')
					private_result=alert9;
			}
			else {
				if(state=='critical')
					private_result = alert10;
				else if(state=='major')
					private_result=alert11;
				else if(state=='minor')
					private_result=alert12;
			}
		}
		else if(f_part.length>4)
		{
			if(min_trgt_val) {
				if(state=='critical')
					private_result = alert13;
				else if(state=='major')
					private_result=alert14;
				else if(state=='minor')
					private_result=alert15;
			}
			else {
				if(state=='critical')
					private_result = alert16;
				else if(state=='major')
					private_result=alert17;
				else if(state=='minor')
					private_result=alert18;
			}
		}
	}
	return private_result;
}
function correctFormat(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	if(val.toLowerCase().indexOf('none')>-1)
	{
		return false;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if(Ext.isEmpty(Cri) || Ext.isEmpty(Maj) || Ext.isEmpty(Min))
	{
		return false;
	}
	if(Cri.length==0 || Maj.length==0 || Min.length==0)
	{
		return false;
	}
	return true;
}