Ext.define('CompositeTest.controller.ModifyTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['CompositeTest.view.AddNewTest','CompositeTest.view.Description'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'}
	],
	init:function(test, testType){
		modifyCtrler = this;
		compTestCtrlr = this.getController('CompositeTest.controller.MeasureWindowController');
		this.buildMainData(test, testType,'test');
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest button[id="backButton"]':
			{
				'click':this.goBack
			},
			'addnewtest button[id="add"]':
			{
				'click':this.modifyTest
			},
			'addnewtest button[id="addNewMeasure"]':
			{
				'click':this.showAddMeasure
			},
			'addnewtest scrollcombo[id="weightageName"]':
			{
				'select':this.weightageTypeChanged
			},
			'addnewtest button[id="weightagePopup"]':
			{
				'click':this.showPopup
			}
		});
	},
	showPopup: function()
	{
		Ext.widget("description_window").show();
	},
	weightageTypeChanged: function()
	{
		var selVal = Ext.getCmp('weightageName').getValue();
		if(selVal == null || selVal=='SystemDefined')
		{
			Ext.getCmp("reporterLogoIMG_enable").show();
			Ext.getCmp("reporterLogoIMG_disable").hide();
			Ext.getCmp("alaramKeyContainer").hide();
			Ext.getCmp("alaramSupportContainer").hide();
		}
		else
		{
			Ext.getCmp("reporterLogoIMG_enable").hide();
			Ext.getCmp("reporterLogoIMG_disable").show();
			Ext.getCmp("alaramKeyContainer").show();
			Ext.getCmp("alaramSupportContainer").show();
		}
	},
	buildMainData: function(test, testType,index)
	{
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/EgModifyTestJson.jsp?test='+test+'&testType='+testType,//+'&controller=ModifyTestCtrlr',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					pageDesc2 = modifyPageDesc;
				}
			}
		});
	},
	afterMainRender: function()
	{
		var predefinedtest = (publicJSON.compTest.indexOf('_')==publicJSON.compTest.lastIndexOf('_'));
		Ext.getCmp('test').setValue(publicJSON.compTest);
		Ext.getCmp('test').hide();
		Ext.getCmp('displayCompType').setValue(publicJSON.displayCompType);
		Ext.getCmp('displayCompType').show();
		Ext.getCmp('test_display_name').setValue(publicJSON.testDescription);
		Ext.getCmp('cx_test_description').setValue(publicJSON.purpose_of_test);
		Ext.getCmp('allowedId').setValue({'is_info_based_test': publicJSON.descriptorBasedTest});//newly brought up
		if(predefinedtest)
		{
			Ext.getCmp('allowedId').items.items[0].setDisabled(true);
			Ext.getCmp('allowedId').items.items[1].setDisabled(true);
		}
		Ext.getCmp('componentType').hide();
		Ext.getCmp('allowedId').show();
		Ext.getCmp('testForInfos').hide();

		Ext.getCmp('testForInfos').getStore().clearFilter(true);
		Ext.getCmp('testForInfos').getStore().suspendEvents(true);
		Ext.getCmp('testForInfos').getStore().loadRawData(publicJSON.individual_tests);
		Ext.getCmp('testForInfos').getStore().resumeEvents();
		Ext.getCmp('testForInfos').setValue(publicJSON.selectedMasterInfosTest);
		if(publicJSON.descriptorBasedTest=='true') {
			Ext.getCmp('testForInfos').show();
		}

		Ext.getCmp('addMeasureTab').enable();
		if (publicJSON.showGenerateTab)
		{
			Ext.getCmp('generateCntnr').enable();
		}
		else
		{
			Ext.getCmp('generateCntnr').disable();
		}
		var testObj = Ext.getCmp('test');
		Ext.getCmp('add').setText(updateTooltip);
		Ext.getCmp('add').show();
		Ext.getCmp('common_page_desc').update(
		'<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+modifyPageDesc+'.</center>');

		if(associateDisassociateServers==true)
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('newtest').setActiveTab(2);
			Ext.getCmp('testforId').items.items[0].setValue(true);
			if(!predefinedtest)
				Ext.getCmp('associated_comptypes').setVisible(true);
			associateDisassociateServers=false;
		}
	},
	goBack: function()
	{
		Ext.Ajax.request({
			url: 'CompositeTest/data/LookForChanges.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					tempJson = Ext.decode( jsonText );
					if(tempJson.alertUser)
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: confirmBackBtn,
							closable: false,
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							width: 300,
							fn: function(response) {
									if(response == 'yes') {
										window.location.href= '/final/admin/compositeTest.jsp';
									}
								}
						});
					}
					else
					{
						window.location.href= '/final/admin/compositeTest.jsp';
					}
				}
			}
		});
	},
	modifyTest: function()
	{
		var me = this;
		if (!this.validate())
		{
			return;
		}

		var dpDisplayCompType = Ext.getCmp('displayCompType').getValue();
		var test = Ext.getCmp('test').getValue();
		var display_name = Ext.getCmp('test_display_name').getValue();
		var purposeoftest = Ext.getCmp('cx_test_description').getValue();
		var descriptor_based = Ext.getCmp("allowedId").getValue().is_info_based_test;

		var selected_master_test = '-1';
		if(descriptor_based=='true')
		{
			selected_master_test = Ext.getCmp('testForInfos').getValue();
			if(selected_master_test == null || selected_master_test=='-1')
			{
				Ext.Msg.show({
						title: pageTitle1,
						msg: message1,
						buttons: Ext.Msg.OK
					});
				return;
			}
		}
		var dyna_param_value = {'compType':publicJSON.selectedCompType,'display_name':display_name,'operation':'modifyTest','purpose_of_test':purposeoftest,'descriptor_based':descriptor_based,'selected_master_test':selected_master_test};
		var urlStr = "EgaddtestpJson.jsp?add=test&test="+test;//+'&controller=ModifyTestCtrlr';
		Ext.Ajax.request(
		{
			url: 'CompositeTest/data/'+urlStr,
			method: 'POST',
			params : dyna_param_value,
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'COULD_NOT_CREATE_TEST')
		{
			Ext.Msg.show({
					title: pageTitle1,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{

			Ext.Msg.show({
				title: pageTitle1,
				msg:publicJSON.AlertMsg,
				closable: false,
				icon: 'iconInformation',
				buttons: Ext.Msg.OK,
				fn: function(response) {
						if(response == 'ok') {
							me.buildMainData(test, 'dummy','test');
							me.afterMainRender();
							Ext.getCmp('addMeasureTab').enable();//to move the measure tab, as asked by boss
							Ext.getCmp('newtest').setActiveTab(1);//to move the measure tab, as asked by boss
						}
					}
			});
		}
	},
	showAddMeasure: function()
	{
		operationCompMeasure='addCompMeasure';
		compTestCtrlr = this.getController('CompositeTest.controller.MeasureWindowController');
		compTestCtrlr.loadPopup();
	},
	validate:function()
	{
		var testDescObj = Ext.getCmp('cx_test_description');
		var testDispObj = Ext.getCmp('test_display_name');
		if(!checkblank(testDispObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: testDisplayAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDispObj.focus(true);
			return false;
		}
		else if(!checkblank(testDescObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: testDescriptionAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDescObj.focus(true);
			return false;
		}
		else if(!this.checkSpecialChar(testDispObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDispObj.focus(true);
			return false;
		}
		else if(!this.checkSpecialChar(testDescObj,"~!@#$%^&*()|:,;'<>"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: splCharAlert2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testDescObj.focus(true);
			return false;				
		}
		return true;
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
});



